/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.managers.ClientManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.ModelTest;
import org.keycloak.testsuite.util.RealmBuilder;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class UserModelTest
extends AbstractTestRealmKeycloakTest {
    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(RealmBuilder.create().name("original").build());
        testRealms.add(RealmBuilder.create().name("other").build());
        testRealms.add(RealmBuilder.create().name("realm1").build());
        testRealms.add(RealmBuilder.create().name("realm2").build());
    }

    @Override
    protected boolean isImportAfterEachMethod() {
        return true;
    }

    @Test
    @ModelTest
    public void persistUser(KeycloakSession session) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sesPersistUser -> {
            KeycloakSession currentSession = sesPersistUser;
            RealmModel realm = currentSession.realms().getRealmByName("original");
            UserModel user = currentSession.users().addUser(realm, "user");
            user.setFirstName("first-name");
            user.setLastName("last-name");
            user.setEmail("email");
            Assert.assertNotNull((Object)user.getCreatedTimestamp());
            Assert.assertTrue((System.currentTimeMillis() - user.getCreatedTimestamp() < 10000L ? 1 : 0) != 0);
            user.addRequiredAction(UserModel.RequiredAction.CONFIGURE_TOTP);
            user.addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
            RealmModel searchRealm = currentSession.realms().getRealm(realm.getId());
            UserModel persisted = currentSession.users().getUserByUsername(searchRealm, "user");
            UserModelTest.assertUserModel(user, persisted);
            searchRealm = currentSession.realms().getRealm(realm.getId());
            UserModel persisted2 = currentSession.users().getUserById(searchRealm, user.getId());
            UserModelTest.assertUserModel(user, persisted2);
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("lastName", "last-name");
            List search = currentSession.users().searchForUserStream(realm, attributes).collect(Collectors.toList());
            Assert.assertThat(search, (Matcher)Matchers.hasSize((int)1));
            Assert.assertThat((Object)((UserModel)search.get(0)).getUsername(), (Matcher)Matchers.equalTo((Object)"user"));
            attributes.clear();
            attributes.put("email", "email");
            search = currentSession.users().searchForUserStream(realm, attributes).collect(Collectors.toList());
            Assert.assertThat(search, (Matcher)Matchers.hasSize((int)1));
            Assert.assertThat((Object)((UserModel)search.get(0)).getUsername(), (Matcher)Matchers.equalTo((Object)"user"));
            attributes.clear();
            attributes.put("lastName", "last-name");
            attributes.put("email", "email");
            search = currentSession.users().searchForUserStream(realm, attributes).collect(Collectors.toList());
            Assert.assertThat(search, (Matcher)Matchers.hasSize((int)1));
            Assert.assertThat((Object)((UserModel)search.get(0)).getUsername(), (Matcher)Matchers.equalTo((Object)"user"));
        });
    }

    @Test
    @ModelTest
    public void webOriginSetTest(KeycloakSession session) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sesWebOrigin -> {
            KeycloakSession currentSession = sesWebOrigin;
            RealmModel realm = currentSession.realms().getRealmByName("original");
            ClientModel client = realm.addClient("user");
            Assert.assertThat((Object)client.getWebOrigins(), (Matcher)Matchers.empty());
            client.addWebOrigin("origin-1");
            Assert.assertThat((Object)client.getWebOrigins(), (Matcher)Matchers.hasSize((int)1));
            client.addWebOrigin("origin-2");
            Assert.assertThat((Object)client.getWebOrigins(), (Matcher)Matchers.hasSize((int)2));
            client.removeWebOrigin("origin-2");
            Assert.assertThat((Object)client.getWebOrigins(), (Matcher)Matchers.hasSize((int)1));
            client.removeWebOrigin("origin-1");
            Assert.assertThat((Object)client.getWebOrigins(), (Matcher)Matchers.empty());
            client = realm.addClient("oauthclient2");
            Assert.assertThat((Object)client.getWebOrigins(), (Matcher)Matchers.empty());
            client.addWebOrigin("origin-1");
            Assert.assertThat((Object)client.getWebOrigins(), (Matcher)Matchers.hasSize((int)1));
            client.addWebOrigin("origin-2");
            Assert.assertThat((Object)client.getWebOrigins(), (Matcher)Matchers.hasSize((int)2));
            client.removeWebOrigin("origin-2");
            Assert.assertThat((Object)client.getWebOrigins(), (Matcher)Matchers.hasSize((int)1));
            client.removeWebOrigin("origin-1");
            Assert.assertThat((Object)client.getWebOrigins(), (Matcher)Matchers.empty());
        });
    }

    @Test
    @ModelTest
    public void testUserRequiredActions(KeycloakSession session) throws Exception {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sesUserReqActions -> {
            KeycloakSession currentSession = sesUserReqActions;
            RealmModel realm = currentSession.realms().getRealmByName("original");
            UserModel user = currentSession.users().addUser(realm, "user");
            List requiredActions = user.getRequiredActionsStream().collect(Collectors.toList());
            Assert.assertThat(requiredActions, (Matcher)Matchers.empty());
            user.addRequiredAction(UserModel.RequiredAction.CONFIGURE_TOTP);
            String id = realm.getId();
            realm = currentSession.realms().getRealm(id);
            user = currentSession.users().getUserByUsername(realm, "user");
            requiredActions = user.getRequiredActionsStream().collect(Collectors.toList());
            Assert.assertThat(requiredActions, (Matcher)Matchers.hasSize((int)1));
            Assert.assertThat(requiredActions, (Matcher)Matchers.contains((Object[])new String[]{UserModel.RequiredAction.CONFIGURE_TOTP.name()}));
            user.addRequiredAction(UserModel.RequiredAction.CONFIGURE_TOTP);
            user = currentSession.users().getUserByUsername(realm, "user");
            requiredActions = user.getRequiredActionsStream().collect(Collectors.toList());
            Assert.assertThat(requiredActions, (Matcher)Matchers.hasSize((int)1));
            Assert.assertThat(requiredActions, (Matcher)Matchers.contains((Object[])new String[]{UserModel.RequiredAction.CONFIGURE_TOTP.name()}));
            user.addRequiredAction(UserModel.RequiredAction.VERIFY_EMAIL.name());
            user = currentSession.users().getUserByUsername(realm, "user");
            requiredActions = user.getRequiredActionsStream().collect(Collectors.toList());
            Assert.assertThat(requiredActions, (Matcher)Matchers.hasSize((int)2));
            Assert.assertThat(requiredActions, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{UserModel.RequiredAction.CONFIGURE_TOTP.name(), UserModel.RequiredAction.VERIFY_EMAIL.name()}));
            user.removeRequiredAction(UserModel.RequiredAction.CONFIGURE_TOTP.name());
            user = currentSession.users().getUserByUsername(realm, "user");
            requiredActions = user.getRequiredActionsStream().collect(Collectors.toList());
            Assert.assertThat(requiredActions, (Matcher)Matchers.hasSize((int)1));
            Assert.assertThat(requiredActions, (Matcher)Matchers.contains((Object[])new String[]{UserModel.RequiredAction.VERIFY_EMAIL.name()}));
            user.removeRequiredAction(UserModel.RequiredAction.VERIFY_EMAIL.name());
            user = currentSession.users().getUserByUsername(realm, "user");
            requiredActions = user.getRequiredActionsStream().collect(Collectors.toList());
            Assert.assertThat(requiredActions, (Matcher)Matchers.empty());
        });
    }

    @Test
    @ModelTest
    public void testUserMultipleAttributes(KeycloakSession session) throws Exception {
        AtomicReference attrValsAtomic = new AtomicReference();
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sesMultipleAtr1 -> {
            KeycloakSession currentSession = sesMultipleAtr1;
            RealmModel realm = currentSession.realms().getRealmByName("original");
            UserModel user = currentSession.users().addUser(realm, "user");
            currentSession.users().addUser(realm, "user-noattrs");
            user.setSingleAttribute("key1", "value1");
            ArrayList<String> attrVals = new ArrayList<String>(Arrays.asList("val21", "val22"));
            attrValsAtomic.set(attrVals);
            user.setAttribute("key2", attrVals);
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sesMultipleAtr2 -> {
            KeycloakSession currentSession = sesMultipleAtr2;
            RealmModel realm = currentSession.realms().getRealmByName("original");
            UserModel user = currentSession.users().getUserByUsername(realm, "user");
            List attrVals = user.getAttributeStream("key1").collect(Collectors.toList());
            Assert.assertThat(attrVals, (Matcher)Matchers.hasSize((int)1));
            Assert.assertThat(attrVals, (Matcher)Matchers.contains((Object[])new String[]{"value1"}));
            Assert.assertThat((Object)user.getFirstAttribute("key1"), (Matcher)Matchers.equalTo((Object)"value1"));
            attrVals = user.getAttributeStream("key2").collect(Collectors.toList());
            Assert.assertThat(attrVals, (Matcher)Matchers.hasSize((int)2));
            Assert.assertThat(attrVals, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"val21", "val22"}));
            attrVals = user.getAttributeStream("key3").collect(Collectors.toList());
            Assert.assertThat(attrVals, (Matcher)Matchers.empty());
            Assert.assertThat((Object)user.getFirstAttribute("key3"), (Matcher)Matchers.nullValue());
            Map allAttrVals = user.getAttributes();
            Assert.assertThat(allAttrVals.keySet(), (Matcher)Matchers.hasSize((int)6));
            Assert.assertThat(allAttrVals.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"username", "firstName", "lastName", "email", "key1", "key2"}));
            Assert.assertThat(allAttrVals.get("key1"), (Matcher)Matchers.equalTo(user.getAttributeStream("key1").collect(Collectors.toList())));
            Assert.assertThat(allAttrVals.get("key2"), (Matcher)Matchers.equalTo(user.getAttributeStream("key2").collect(Collectors.toList())));
            user.removeAttribute("key1");
            user.setSingleAttribute("key2", "val23");
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sesMultipleAtr3 -> {
            KeycloakSession currentSession = sesMultipleAtr3;
            RealmModel realm = currentSession.realms().getRealmByName("original");
            UserModel user = currentSession.users().getUserByUsername(realm, "user");
            Assert.assertThat((Object)user.getFirstAttribute("key1"), (Matcher)Matchers.nullValue());
            List attrVals = user.getAttributeStream("key2").collect(Collectors.toList());
            Assert.assertThat(attrVals, (Matcher)Matchers.hasSize((int)1));
            Assert.assertThat(attrVals.get(0), (Matcher)Matchers.equalTo((Object)"val23"));
        });
    }

    @Test
    @ModelTest
    public void testUpdateUserAttribute(KeycloakSession session) throws Exception {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sesUpdateAtr1 -> {
            KeycloakSession currentSession = sesUpdateAtr1;
            RealmModel realm = currentSession.realms().getRealmByName("original");
            UserModel user = currentSession.users().addUser(realm, "user");
            user.setSingleAttribute("key1", "value1");
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sesUpdateAtr2 -> {
            KeycloakSession currentSession = sesUpdateAtr2;
            RealmModel realm = currentSession.realms().getRealmByName("original");
            UserModel user = currentSession.users().getUserByUsername(realm, "user");
            ArrayList<String> attrVals = new ArrayList<String>(Arrays.asList("val2"));
            user.setAttribute("key1", attrVals);
            Map allAttrVals = user.getAttributes();
            Assert.assertThat(allAttrVals.keySet(), (Matcher)Matchers.hasSize((int)5));
            Assert.assertThat(allAttrVals.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"key1", "firstName", "lastName", "email", "username"}));
            Assert.assertThat(allAttrVals.get("key1"), (Matcher)Matchers.contains((Object[])new String[]{"val2"}));
        });
    }

    @Test
    @ModelTest
    public void testUpdateUserSingleAttribute(KeycloakSession session) {
        AtomicReference expectedAtomic = new AtomicReference();
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sesUpdateUserSingleAtr -> {
            KeycloakSession currentSession = sesUpdateUserSingleAtr;
            RealmModel realm = currentSession.realms().getRealmByName("original");
            HashMap<String, List<String>> expected = new HashMap<String, List<String>>();
            expected.put("key1", Collections.singletonList("value3"));
            expected.put("key2", Collections.singletonList("value2"));
            expected.put("firstName", Collections.singletonList(null));
            expected.put("lastName", Collections.singletonList(null));
            expected.put("email", Collections.singletonList(null));
            expected.put("username", Collections.singletonList("user"));
            UserModel user = currentSession.users().addUser(realm, "user");
            user.setSingleAttribute("key1", "value1");
            user.setSingleAttribute("key2", "value2");
            user.setSingleAttribute("key3", null);
            user.setSingleAttribute("key1", "value3");
            Assert.assertThat((Object)user.getAttributes(), (Matcher)Matchers.equalTo(expected));
            expectedAtomic.set(expected);
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sesUpdateUserSingleAtr2 -> {
            KeycloakSession currentSession = sesUpdateUserSingleAtr2;
            RealmModel realm = currentSession.realms().getRealmByName("original");
            Map expected = (Map)expectedAtomic.get();
            Assert.assertThat((Object)currentSession.users().getUserByUsername(realm, "user").getAttributes(), (Matcher)Matchers.equalTo((Object)expected));
        });
    }

    @Test
    @ModelTest
    public void testSearchByString(KeycloakSession session) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sesSearchString1 -> {
            KeycloakSession currentSession = sesSearchString1;
            RealmModel realm = currentSession.realms().getRealmByName("original");
            currentSession.users().addUser(realm, "user1");
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sesSearchString1 -> {
            KeycloakSession currentSession = sesSearchString1;
            RealmModel realm = currentSession.realms().getRealmByName("original");
            UserModel user1 = currentSession.users().getUserByUsername(realm, "user1");
            List users = currentSession.users().searchForUserStream(realm, "user", Integer.valueOf(0), Integer.valueOf(7)).collect(Collectors.toList());
            Assert.assertThat(users, (Matcher)Matchers.hasSize((int)1));
            Assert.assertThat(users, (Matcher)Matchers.contains((Object[])new UserModel[]{user1}));
        });
    }

    @Test
    @ModelTest
    public void testSearchByUserAttribute(KeycloakSession session) throws Exception {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sesSearchAtr1 -> {
            KeycloakSession currentSession = sesSearchAtr1;
            RealmModel realm = currentSession.realms().getRealmByName("original");
            UserModel user1 = currentSession.users().addUser(realm, "user1");
            UserModel user2 = currentSession.users().addUser(realm, "user2");
            UserModel user3 = currentSession.users().addUser(realm, "user3");
            RealmModel otherRealm = currentSession.realms().getRealmByName("other");
            UserModel otherRealmUser = currentSession.users().addUser(otherRealm, "user1");
            user1.setSingleAttribute("key1", "value1");
            user1.setSingleAttribute("key2", "value21");
            user2.setSingleAttribute("key1", "value1");
            user2.setSingleAttribute("key2", "value22");
            user3.setSingleAttribute("key2", "value21");
            otherRealmUser.setSingleAttribute("key2", "value21");
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sesSearchAtr2 -> {
            KeycloakSession currentSession = sesSearchAtr2;
            RealmModel realm = currentSession.realms().getRealmByName("original");
            UserModel user1 = currentSession.users().getUserByUsername(realm, "user1");
            UserModel user2 = currentSession.users().getUserByUsername(realm, "user2");
            UserModel user3 = currentSession.users().getUserByUsername(realm, "user3");
            List users = currentSession.users().searchForUserByUserAttributeStream(realm, "key1", "value1").collect(Collectors.toList());
            Assert.assertThat(users, (Matcher)Matchers.hasSize((int)2));
            Assert.assertThat(users, (Matcher)Matchers.containsInAnyOrder((Object[])new UserModel[]{user1, user2}));
            users = currentSession.users().searchForUserByUserAttributeStream(realm, "key2", "value21").collect(Collectors.toList());
            Assert.assertThat(users, (Matcher)Matchers.hasSize((int)2));
            Assert.assertThat(users, (Matcher)Matchers.containsInAnyOrder((Object[])new UserModel[]{user1, user3}));
            users = currentSession.users().searchForUserByUserAttributeStream(realm, "key2", "value22").collect(Collectors.toList());
            Assert.assertThat(users, (Matcher)Matchers.hasSize((int)1));
            Assert.assertThat(users, (Matcher)Matchers.contains((Object[])new UserModel[]{user2}));
            users = currentSession.users().searchForUserByUserAttributeStream(realm, "key3", "value3").collect(Collectors.toList());
            Assert.assertThat(users, (Matcher)Matchers.empty());
        });
    }

    @Test
    @ModelTest
    public void testServiceAccountLink(KeycloakSession session) throws Exception {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sesServiceLink1 -> {
            KeycloakSession currentSession = sesServiceLink1;
            RealmModel realm = currentSession.realms().getRealmByName("original");
            ClientModel client = realm.addClient("foo");
            UserModel user1 = currentSession.users().addUser(realm, "user1");
            user1.setFirstName("John");
            user1.setLastName("Doe");
            UserModel user2 = currentSession.users().addUser(realm, "user2");
            user2.setFirstName("John");
            user2.setLastName("Doe");
            Assert.assertThat((Object)currentSession.users().getServiceAccount(client), (Matcher)Matchers.nullValue());
            List users = currentSession.users().searchForUserStream(realm, "John Doe").collect(Collectors.toList());
            Assert.assertThat(users, (Matcher)Matchers.hasSize((int)2));
            Assert.assertThat(users, (Matcher)Matchers.containsInAnyOrder((Object[])new UserModel[]{user1, user2}));
            user1.setServiceAccountClientLink(client.getId());
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sesServiceLink2 -> {
            KeycloakSession currentSession = sesServiceLink2;
            RealmModel realm = currentSession.realms().getRealmByName("original");
            UserModel user1 = currentSession.users().getUserByUsername(realm, "user1");
            UserModel user2 = currentSession.users().getUserByUsername(realm, "user2");
            ClientModel client = realm.getClientByClientId("foo");
            UserModel searched = currentSession.users().getServiceAccount(client);
            Assert.assertThat((Object)searched, (Matcher)Matchers.equalTo((Object)user1));
            List users = currentSession.users().searchForUserStream(realm, "John Doe").collect(Collectors.toList());
            Assert.assertThat(users, (Matcher)Matchers.hasSize((int)1));
            Assert.assertThat(users, (Matcher)Matchers.contains((Object[])new UserModel[]{user2}));
            users = currentSession.users().getUsersStream(realm, false).collect(Collectors.toList());
            Assert.assertThat(users, (Matcher)Matchers.hasSize((int)1));
            Assert.assertThat(users, (Matcher)Matchers.contains((Object[])new UserModel[]{user2}));
            users = currentSession.users().getUsersStream(realm, true).collect(Collectors.toList());
            Assert.assertThat(users, (Matcher)Matchers.hasSize((int)2));
            Assert.assertThat(users, (Matcher)Matchers.containsInAnyOrder((Object[])new UserModel[]{user1, user2}));
            Assert.assertThat((Object)currentSession.users().getUsersCount(realm, true), (Matcher)Matchers.equalTo((Object)2));
            Assert.assertThat((Object)currentSession.users().getUsersCount(realm, false), (Matcher)Matchers.equalTo((Object)1));
            RealmManager realmMgr = new RealmManager(currentSession);
            ClientManager clientMgr = new ClientManager(realmMgr);
            clientMgr.removeClient(realm, client);
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sesServiceLink3 -> {
            KeycloakSession currentSession = sesServiceLink3;
            RealmModel realm = currentSession.realms().getRealmByName("original");
            Assert.assertThat((Object)currentSession.users().getUserByUsername(realm, "user1"), (Matcher)Matchers.nullValue());
        });
    }

    @Test
    @ModelTest
    public void testGrantToAll(KeycloakSession session) throws Exception {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sesGrantToAll1 -> {
            KeycloakSession currentSession = sesGrantToAll1;
            RealmModel realm1 = currentSession.realms().getRealmByName("realm1");
            realm1.addRole("role1");
            currentSession.users().addUser(realm1, "user1");
            currentSession.users().addUser(realm1, "user2");
            RealmModel realm2 = currentSession.realms().getRealmByName("realm2");
            currentSession.users().addUser(realm2, "user1");
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sesGrantToAll2 -> {
            KeycloakSession currentSession = sesGrantToAll2;
            RealmModel realm1 = currentSession.realms().getRealmByName("realm1");
            RoleModel role1 = realm1.getRole("role1");
            currentSession.users().grantToAllUsers(realm1, role1);
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sesGrantToAll2 -> {
            KeycloakSession currentSession = sesGrantToAll2;
            RealmModel realm1 = currentSession.realms().getRealmByName("realm1");
            RoleModel role1 = realm1.getRole("role1");
            UserModel user1 = currentSession.users().getUserByUsername(realm1, "user1");
            UserModel user2 = currentSession.users().getUserByUsername(realm1, "user2");
            Assert.assertTrue((boolean)user1.hasRole(role1));
            Assert.assertTrue((boolean)user2.hasRole(role1));
            RealmModel realm2 = currentSession.realms().getRealmByName("realm2");
            UserModel realm2User1 = currentSession.users().getUserByUsername(realm2, "user1");
            Assert.assertFalse((boolean)realm2User1.hasRole(role1));
            currentSession.realms().removeRealm(realm1.getId());
            currentSession.realms().removeRealm(realm2.getId());
        });
    }

    @Test
    @ModelTest
    public void testUserNotBefore(KeycloakSession session) throws Exception {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sesUserNotBefore1 -> {
            KeycloakSession currentSession = sesUserNotBefore1;
            RealmModel realm = currentSession.realms().getRealmByName("original");
            UserModel user1 = currentSession.users().addUser(realm, "user1");
            currentSession.users().setNotBeforeForUser(realm, user1, 10);
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sesUserNotBefore2 -> {
            KeycloakSession currentSession = sesUserNotBefore2;
            RealmModel realm = currentSession.realms().getRealmByName("original");
            UserModel user1 = currentSession.users().getUserByUsername(realm, "user1");
            int notBefore = currentSession.users().getNotBeforeOfUser(realm, user1);
            Assert.assertThat((Object)notBefore, (Matcher)Matchers.equalTo((Object)10));
            currentSession.users().setNotBeforeForUser(realm, user1, 20);
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sesUserNotBefore3 -> {
            KeycloakSession currentSession = sesUserNotBefore3;
            RealmModel realm = currentSession.realms().getRealmByName("original");
            UserModel user1 = currentSession.users().getUserByUsername(realm, "user1");
            int notBefore = currentSession.users().getNotBeforeOfUser(realm, user1);
            Assert.assertThat((Object)notBefore, (Matcher)Matchers.equalTo((Object)20));
        });
    }

    private static void assertUserModel(UserModel expected, UserModel actual) {
        Assert.assertThat((Object)actual.getUsername(), (Matcher)Matchers.equalTo((Object)expected.getUsername()));
        Assert.assertThat((Object)actual.getCreatedTimestamp(), (Matcher)Matchers.equalTo((Object)expected.getCreatedTimestamp()));
        Assert.assertThat((Object)actual.getFirstName(), (Matcher)Matchers.equalTo((Object)expected.getFirstName()));
        Assert.assertThat((Object)actual.getLastName(), (Matcher)Matchers.equalTo((Object)expected.getLastName()));
        Assert.assertThat(actual.getRequiredActionsStream().collect(Collectors.toSet()), (Matcher)Matchers.containsInAnyOrder((Object[])expected.getRequiredActionsStream().toArray()));
    }

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }
}

