/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.common.Profile;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.ProfileAssume;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.runonserver.RunOnServerException;
import org.keycloak.util.JsonSerialization;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class ImportTest
extends AbstractTestRealmKeycloakTest {
    @Test
    public void demoDelete() {
        this.removeRealm("demo-delete");
    }

    @Test
    public void install2() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("demo");
            Assert.assertEquals((long)600L, (long)realm.getAccessCodeLifespanUserAction());
            Assert.assertEquals((long)900L, (long)realm.getAccessTokenLifespanForImplicitFlow());
            Assert.assertEquals((long)2592000L, (long)realm.getOfflineSessionIdleTimeout());
            Assert.assertEquals((long)1L, (long)realm.getRequiredCredentialsStream().count());
            Assert.assertEquals((Object)"password", (Object)((RequiredCredentialModel)realm.getRequiredCredentialsStream().findFirst().get()).getType());
        });
    }

    @Test
    public void importWithoutRequestContext() throws IOException {
        String realmString = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/model/realm-validation.json"), (Charset)StandardCharsets.UTF_8);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            Thread t;
            RealmRepresentation testRealm = (RealmRepresentation)JsonSerialization.readValue((String)realmString, RealmRepresentation.class);
            AtomicReference err = new AtomicReference();
            Thread thread = t = new Thread(() -> {
                try {
                    KeycloakSession ses = session.getKeycloakSessionFactory().create();
                    ses.getContext().setRealm(session.getContext().getRealm());
                    ses.getTransactionManager().begin();
                    RealmModel realmModel = new RealmManager(ses).importRealm(testRealm);
                    ses.getTransactionManager().commit();
                    ses.close();
                    ses = session.getKeycloakSessionFactory().create();
                    ses.getTransactionManager().begin();
                    session.realms().removeRealm(realmModel.getId());
                    ses.getTransactionManager().commit();
                    ses.close();
                }
                catch (Throwable th) {
                    err.set(th);
                }
            });
            synchronized (thread) {
                t.start();
                try {
                    t.wait(10000L);
                }
                catch (InterruptedException e) {
                    throw new RunOnServerException((Throwable)e);
                }
            }
            if (err.get() != null) {
                throw new RunOnServerException((Throwable)err.get());
            }
        });
    }

    @Test
    public void importAuthorizationSettings() throws Exception {
        ProfileAssume.assumeFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION);
        RealmRepresentation testRealm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/model/authz-bug.json"), RealmRepresentation.class);
        this.adminClient.realms().create(testRealm);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("authz-bug");
            AuthorizationProvider authz = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
            ClientModel client = realm.getClientByClientId("appserver");
            ResourceServer resourceServer = authz.getStoreFactory().getResourceServerStore().findById(client.getId());
            Assert.assertEquals((Object)"AFFIRMATIVE", (Object)resourceServer.getDecisionStrategy().name());
        });
    }

    @Override
    public void configureTestRealm(RealmRepresentation testRealmParm) {
        this.log.infof("testrealm2 imported", new Object[0]);
        RealmRepresentation testRealm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/model/testrealm2.json"), RealmRepresentation.class);
        this.adminClient.realms().create(testRealm);
        this.log.infof("testrealm-demo imported", new Object[0]);
        testRealm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/model/testrealm-demo.json"), RealmRepresentation.class);
        testRealm.setRealm("demo");
        testRealm.setId("demo");
        this.adminClient.realms().create(testRealm);
    }
}

