/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.model;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.ModelTest;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class CompositeRolesModelTest
extends AbstractTestRealmKeycloakTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    public static Set<RoleModel> getRequestedRoles(ClientModel application, UserModel user) {
        HashSet<RoleModel> requestedRoles = new HashSet<RoleModel>();
        Set roleMappings = user.getRoleMappingsStream().collect(Collectors.toSet());
        Stream<RoleModel> scopeMappings = Stream.concat(application.getScopeMappingsStream(), application.getRolesStream());
        scopeMappings.forEach(scope -> roleMappings.forEach(role -> {
            if (role.getContainer().equals(application)) {
                requestedRoles.add((RoleModel)role);
            }
            HashSet<RoleModel> visited = new HashSet<RoleModel>();
            CompositeRolesModelTest.applyScope(role, scope, visited, requestedRoles);
        }));
        return requestedRoles;
    }

    private static void applyScope(RoleModel role, RoleModel scope, Set<RoleModel> visited, Set<RoleModel> requested) {
        if (visited.contains(scope)) {
            return;
        }
        visited.add(scope);
        if (role.hasRole(scope)) {
            requested.add(scope);
            return;
        }
        if (!scope.isComposite()) {
            return;
        }
        scope.getCompositesStream().forEach(contained -> CompositeRolesModelTest.applyScope(role, contained, visited, requested));
    }

    private static RoleModel getRole(RealmModel realm, String appName, String roleName) {
        if ("realm".equals(appName)) {
            return realm.getRole(roleName);
        }
        return realm.getClientByClientId(appName).getRole(roleName);
    }

    private static void assertContains(RealmModel realm, String appName, String roleName, Set<RoleModel> requestedRoles) {
        RoleModel expectedRole = CompositeRolesModelTest.getRole(realm, appName, roleName);
        Assert.assertTrue((boolean)requestedRoles.contains(expectedRole));
        for (RoleModel role : requestedRoles) {
            if (!role.equals(expectedRole)) continue;
            Assert.assertEquals((Object)role.getContainer(), (Object)expectedRole.getContainer());
        }
    }

    @Test
    @ModelTest
    public void testNoClientID(KeycloakSession session) {
        this.expectedException.expect(RuntimeException.class);
        this.expectedException.expectMessage("Unknown client specification in scope mappings: some-client");
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), session1 -> {
            try {
                RealmRepresentation rep = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/model/testrealm-noclient-id.json"), RealmRepresentation.class);
                rep.setId("TestNoClientID");
                this.adminClient.realms().create(rep);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        });
    }

    @Test
    @ModelTest
    public void testComposites(KeycloakSession session) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), session5 -> {
            RealmModel realm = session5.realms().getRealm("TestComposites");
            Set<RoleModel> requestedRoles = CompositeRolesModelTest.getRequestedRoles(realm.getClientByClientId("APP_COMPOSITE_APPLICATION"), session.users().getUserByUsername(realm, "APP_COMPOSITE_USER"));
            Assert.assertEquals((long)5L, (long)requestedRoles.size());
            CompositeRolesModelTest.assertContains(realm, "APP_COMPOSITE_APPLICATION", "APP_COMPOSITE_ROLE", requestedRoles);
            CompositeRolesModelTest.assertContains(realm, "APP_COMPOSITE_APPLICATION", "APP_COMPOSITE_CHILD", requestedRoles);
            CompositeRolesModelTest.assertContains(realm, "APP_COMPOSITE_APPLICATION", "APP_ROLE_2", requestedRoles);
            CompositeRolesModelTest.assertContains(realm, "APP_ROLE_APPLICATION", "APP_ROLE_1", requestedRoles);
            CompositeRolesModelTest.assertContains(realm, "realm", "REALM_ROLE_1", requestedRoles);
            Set<RoleModel> requestedRoles2 = CompositeRolesModelTest.getRequestedRoles(realm.getClientByClientId("APP_COMPOSITE_APPLICATION"), session5.users().getUserByUsername(realm, "REALM_APP_COMPOSITE_USER"));
            Assert.assertEquals((long)4L, (long)requestedRoles2.size());
            CompositeRolesModelTest.assertContains(realm, "APP_ROLE_APPLICATION", "APP_ROLE_1", requestedRoles2);
            requestedRoles = CompositeRolesModelTest.getRequestedRoles(realm.getClientByClientId("REALM_COMPOSITE_1_APPLICATION"), session5.users().getUserByUsername(realm, "REALM_COMPOSITE_1_USER"));
            Assert.assertEquals((long)1L, (long)requestedRoles.size());
            CompositeRolesModelTest.assertContains(realm, "realm", "REALM_COMPOSITE_1", requestedRoles);
            requestedRoles = CompositeRolesModelTest.getRequestedRoles(realm.getClientByClientId("REALM_COMPOSITE_2_APPLICATION"), session5.users().getUserByUsername(realm, "REALM_COMPOSITE_1_USER"));
            Assert.assertEquals((long)3L, (long)requestedRoles.size());
            CompositeRolesModelTest.assertContains(realm, "realm", "REALM_COMPOSITE_1", requestedRoles);
            CompositeRolesModelTest.assertContains(realm, "realm", "REALM_COMPOSITE_CHILD", requestedRoles);
            CompositeRolesModelTest.assertContains(realm, "realm", "REALM_ROLE_4", requestedRoles);
            requestedRoles = CompositeRolesModelTest.getRequestedRoles(realm.getClientByClientId("REALM_ROLE_1_APPLICATION"), session5.users().getUserByUsername(realm, "REALM_COMPOSITE_1_USER"));
            Assert.assertEquals((long)1L, (long)requestedRoles.size());
            CompositeRolesModelTest.assertContains(realm, "realm", "REALM_ROLE_1", requestedRoles);
            requestedRoles = CompositeRolesModelTest.getRequestedRoles(realm.getClientByClientId("REALM_COMPOSITE_1_APPLICATION"), session5.users().getUserByUsername(realm, "REALM_ROLE_1_USER"));
            Assert.assertEquals((long)1L, (long)requestedRoles.size());
            CompositeRolesModelTest.assertContains(realm, "realm", "REALM_ROLE_1", requestedRoles);
        });
    }

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        this.log.infof("testcomposites imported", new Object[0]);
        RealmRepresentation newRealm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/model/testcomposites2.json"), RealmRepresentation.class);
        newRealm.setId("TestComposites");
        this.adminClient.realms().create(newRealm);
    }
}

