/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.model;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Test;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.protocol.oidc.mappers.AddressMapper;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.ModelTest;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class ClientModelTest
extends AbstractKeycloakTest {
    private ClientModel client;
    private String roleId;
    private String realmName = "original";
    private KeycloakSession currentSession;

    @Override
    protected boolean isImportAfterEachMethod() {
        return true;
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = new RealmRepresentation();
        realm.setRealm(this.realmName);
        realm.setEnabled(Boolean.valueOf(true));
        testRealms.add(realm);
    }

    public static void assertEquals(ClientModel expected, ClientModel actual) {
        MatcherAssert.assertThat((Object)expected.getClientId(), (Matcher)Is.is((Object)actual.getClientId()));
        MatcherAssert.assertThat((Object)expected.getName(), (Matcher)Is.is((Object)actual.getName()));
        MatcherAssert.assertThat((Object)expected.getDescription(), (Matcher)Is.is((Object)actual.getDescription()));
        MatcherAssert.assertThat((Object)expected.getBaseUrl(), (Matcher)Is.is((Object)actual.getBaseUrl()));
        MatcherAssert.assertThat((Object)expected.getManagementUrl(), (Matcher)Is.is((Object)actual.getManagementUrl()));
        MatcherAssert.assertThat((Object)expected.getRedirectUris().containsAll(actual.getRedirectUris()), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)expected.getWebOrigins().containsAll(actual.getWebOrigins()), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)expected.getRegisteredNodes(), (Matcher)Is.is((Object)actual.getRegisteredNodes()));
    }

    private ClientModel setUpClient(RealmModel realm) {
        ClientModel client = realm.addClient("application");
        client.setName("Application");
        client.setDescription("Description");
        client.setBaseUrl("http://base");
        client.setManagementUrl("http://management");
        client.setClientId("app-name");
        client.setProtocol("openid-connect");
        client.addRole("role-1");
        client.addRole("role-2");
        client.addRole("role-3");
        client.addRedirectUri("redirect-1");
        client.addRedirectUri("redirect-2");
        client.addWebOrigin("origin-1");
        client.addWebOrigin("origin-2");
        client.registerNode("node1", 10);
        client.registerNode("10.20.30.40", 50);
        client.addProtocolMapper(AddressMapper.createAddressMapper());
        client.updateClient();
        return client;
    }

    @Test
    @ModelTest
    public void testClientRoleRemovalAndClientScope(KeycloakSession session) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionClientRoleRemove1 -> {
            this.currentSession = sessionClientRoleRemove1;
            RealmModel realm = this.currentSession.realms().getRealmByName(this.realmName);
            MatcherAssert.assertThat((String)"Realm Model 'original' is NULL !!", (Object)realm, (Matcher)IsNull.notNullValue());
            ClientModel from = realm.addClient("from");
            RoleModel role = from.addRole("clientRole");
            this.roleId = role.getId();
            ClientModel scoped = realm.addClient("scoped");
            scoped.setFullScopeAllowed(false);
            scoped.addScopeMapping(role);
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionClientRoleRemove2 -> {
            this.currentSession = sessionClientRoleRemove2;
            RealmModel realm = this.currentSession.realms().getRealmByName(this.realmName);
            MatcherAssert.assertThat((String)"Realm Model 'original' is NULL !!", (Object)realm, (Matcher)IsNull.notNullValue());
            ClientModel from = realm.getClientByClientId("from");
            RoleModel role = this.currentSession.roles().getRoleById(realm, this.roleId);
            from.removeRole(role);
            this.currentSession.clients().removeClient(realm, from.getId());
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionClientRoleRemove3 -> {
            this.currentSession = sessionClientRoleRemove3;
            RealmModel realm = this.currentSession.realms().getRealmByName(this.realmName);
            MatcherAssert.assertThat((String)"Realm Model 'original' is NULL !!", (Object)realm, (Matcher)IsNull.notNullValue());
            ClientModel scoped = realm.getClientByClientId("scoped");
            MatcherAssert.assertThat((String)"Scope Mappings must be 0", (Object)scoped.getScopeMappingsStream().count(), (Matcher)Is.is((Object)0L));
            this.currentSession.clients().removeClient(realm, scoped.getId());
        });
    }

    @Test
    @ModelTest
    public void testClientRoleRemovalAndClientScopeSameTx(KeycloakSession session) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionClientRoleRemoveTx1 -> {
            this.currentSession = sessionClientRoleRemoveTx1;
            RealmModel realm = this.currentSession.realms().getRealmByName(this.realmName);
            ClientModel from = realm.addClient("from");
            RoleModel role = from.addRole("clientRole");
            this.roleId = role.getId();
            ClientModel scoped = realm.addClient("scoped");
            scoped.setFullScopeAllowed(false);
            scoped.addScopeMapping(role);
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionClientRoleRemoveTx2 -> {
            this.currentSession = sessionClientRoleRemoveTx2;
            RealmModel realm = this.currentSession.realms().getRealmByName(this.realmName);
            ClientModel scoped = realm.getClientByClientId("scoped");
            ClientModel from = realm.getClientByClientId("from");
            RoleModel role = this.currentSession.roles().getRoleById(realm, this.roleId);
            from.removeRole(role);
            MatcherAssert.assertThat((String)"Scope Mappings is not 0", (Object)scoped.getScopeMappingsStream().count(), (Matcher)Is.is((Object)0L));
            this.currentSession.clients().removeClient(realm, scoped.getId());
            this.currentSession.clients().removeClient(realm, from.getId());
        });
    }

    @Test
    @ModelTest
    public void testRealmRoleRemovalAndClientScope(KeycloakSession session) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionRealmRoleRemove1 -> {
            this.currentSession = sessionRealmRoleRemove1;
            RealmModel realm = this.currentSession.realms().getRealmByName(this.realmName);
            RoleModel role = realm.addRole("clientRole");
            this.roleId = role.getId();
            ClientModel scoped = realm.addClient("scoped");
            scoped.setFullScopeAllowed(false);
            scoped.addScopeMapping(role);
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionRealmRoleRemove2 -> {
            this.currentSession = sessionRealmRoleRemove2;
            RealmModel realm = this.currentSession.realms().getRealmByName(this.realmName);
            RoleModel role = this.currentSession.roles().getRoleById(realm, this.roleId);
            realm.removeRole(role);
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionRealmRoleRemove3 -> {
            this.currentSession = sessionRealmRoleRemove3;
            RealmModel realm = this.currentSession.realms().getRealmByName(this.realmName);
            ClientModel scoped = realm.getClientByClientId("scoped");
            MatcherAssert.assertThat((String)"Scope Mappings is not 0", (Object)scoped.getScopeMappingsStream().count(), (Matcher)Is.is((Object)0L));
            this.currentSession.clients().removeClient(realm, scoped.getId());
        });
    }

    @Test
    @ModelTest
    public void testCircularClientScopes(KeycloakSession session) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionCircuilarClient1 -> {
            this.currentSession = sessionCircuilarClient1;
            RealmModel realm = this.currentSession.realms().getRealmByName(this.realmName);
            ClientModel scoped1 = realm.addClient("scoped1");
            RoleModel role1 = scoped1.addRole("role1");
            ClientModel scoped2 = realm.addClient("scoped2");
            RoleModel role2 = scoped2.addRole("role2");
            scoped1.addScopeMapping(role2);
            scoped2.addScopeMapping(role1);
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionCircuilarClient2 -> {
            this.currentSession = sessionCircuilarClient2;
            RealmModel realm = this.currentSession.realms().getRealmByName(this.realmName);
            ClientModel scoped1 = realm.getClientByClientId("scoped1");
            this.currentSession.clients().removeClient(realm, scoped1.getId());
        });
    }

    @Test
    @ModelTest
    public void persist(KeycloakSession session) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionPersist -> {
            this.currentSession = sessionPersist;
            RealmModel realm = this.currentSession.realms().getRealmByName(this.realmName);
            this.client = this.setUpClient(realm);
            ClientModel actual = realm.getClientByClientId("app-name");
            ClientModelTest.assertEquals(this.client, actual);
            this.client.unregisterNode("node1");
            this.client.unregisterNode("10.20.30.40");
            this.currentSession.clients().removeClient(realm, this.client.getId());
        });
    }

    @Test
    @ModelTest
    public void json(KeycloakSession session) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionJson -> {
            this.currentSession = sessionJson;
            RealmModel realm = this.currentSession.realms().getRealmByName(this.realmName);
            this.client = this.setUpClient(realm);
            ClientRepresentation representation = ModelToRepresentation.toRepresentation((ClientModel)this.client, (KeycloakSession)this.currentSession);
            representation.setId(null);
            for (ProtocolMapperRepresentation protocolMapper : representation.getProtocolMappers()) {
                protocolMapper.setId(null);
            }
            realm = this.currentSession.realms().createRealm("copy");
            ClientModel copyClient = RepresentationToModel.createClient((KeycloakSession)this.currentSession, (RealmModel)realm, (ClientRepresentation)representation);
            ClientModelTest.assertEquals(this.client, copyClient);
            this.client.unregisterNode("node1");
            this.client.unregisterNode("10.20.30.40");
            this.currentSession.clients().removeClient(realm, this.client.getId());
            this.currentSession.clients().removeClient(realm, copyClient.getId());
            this.currentSession.realms().removeRealm(realm.getId());
        });
    }

    @Test
    @ModelTest
    public void testAddApplicationWithId(KeycloakSession session) {
        String id = KeycloakModelUtils.generateId();
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionAppWithId1 -> {
            this.currentSession = sessionAppWithId1;
            RealmModel realm = this.currentSession.realms().getRealmByName(this.realmName);
            this.client = realm.addClient(id, "application2");
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionAppWithId2 -> {
            this.currentSession = sessionAppWithId2;
            RealmModel realm = this.currentSession.realms().getRealmByName(this.realmName);
            this.client = this.currentSession.clients().getClientById(realm, id);
            MatcherAssert.assertThat((String)"Client 'app-123' is NULL!!", (Object)this.client, (Matcher)IsNull.notNullValue());
            this.currentSession.clients().removeClient(realm, this.client.getId());
        });
    }

    @Test
    @ModelTest
    public void testClientScopesBinding(KeycloakSession session) {
        AtomicReference scope1Atomic = new AtomicReference();
        AtomicReference scope2Atomic = new AtomicReference();
        AtomicReference scope3Atomic = new AtomicReference();
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionClientScopeBind1 -> {
            this.currentSession = sessionClientScopeBind1;
            RealmModel realm = this.currentSession.realms().getRealmByName(this.realmName);
            this.client = realm.addClient("templatized");
            this.client.setProtocol("openid-connect");
            ClientScopeModel scope1 = realm.addClientScope("scope1");
            scope1.setProtocol("openid-connect");
            scope1Atomic.set(scope1);
            ClientScopeModel scope2 = realm.addClientScope("scope2");
            scope2.setProtocol("openid-connect");
            scope2Atomic.set(scope2);
            ClientScopeModel scope3 = realm.addClientScope("scope3");
            scope3.setProtocol("openid-connect");
            scope3Atomic.set(scope3);
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionClientScopeBind2 -> {
            this.currentSession = sessionClientScopeBind2;
            RealmModel realm = this.currentSession.realms().getRealmByName(this.realmName);
            this.client = realm.getClientByClientId("templatized");
            ClientScopeModel scope1 = (ClientScopeModel)scope1Atomic.get();
            ClientScopeModel scope2 = (ClientScopeModel)scope2Atomic.get();
            ClientScopeModel scope3 = (ClientScopeModel)scope3Atomic.get();
            scope1 = realm.getClientScopeById(scope1.getId());
            scope2 = realm.getClientScopeById(scope2.getId());
            scope3 = realm.getClientScopeById(scope3.getId());
            this.client.addClientScope(scope1, true);
            this.client.addClientScope(scope2, false);
            this.client.addClientScope(scope3, false);
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionClientScopeBind3 -> {
            this.currentSession = sessionClientScopeBind3;
            RealmModel realm = this.currentSession.realms().getRealmByName(this.realmName);
            this.client = realm.getClientByClientId("templatized");
            ClientScopeModel scope1 = (ClientScopeModel)scope1Atomic.get();
            ClientScopeModel scope2 = (ClientScopeModel)scope2Atomic.get();
            Map clientScopes1 = this.client.getClientScopes(true);
            MatcherAssert.assertThat((String)"Client Scope contains 'scope1':", (Object)clientScopes1.containsKey("scope1"), (Matcher)Is.is((Object)true));
            MatcherAssert.assertThat((String)"Client Scope contains 'scope2':", (Object)clientScopes1.containsKey("scope2"), (Matcher)Is.is((Object)false));
            MatcherAssert.assertThat((String)"Client Scope contains 'scope3':", (Object)clientScopes1.containsKey("scope3"), (Matcher)Is.is((Object)false));
            Map clientScopes2 = this.client.getClientScopes(false);
            MatcherAssert.assertThat((String)"Client Scope contains 'scope1':", (Object)clientScopes2.containsKey("scope1"), (Matcher)Is.is((Object)false));
            MatcherAssert.assertThat((String)"Client Scope contains 'scope2':", (Object)clientScopes2.containsKey("scope2"), (Matcher)Is.is((Object)true));
            MatcherAssert.assertThat((String)"Client Scope contains 'scope3':", (Object)clientScopes2.containsKey("scope3"), (Matcher)Is.is((Object)true));
            this.client.removeClientScope(scope1);
            this.client.removeClientScope(scope2);
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionClientScopeBind3 -> {
            this.currentSession = sessionClientScopeBind3;
            RealmModel realm = this.currentSession.realms().getRealmByName(this.realmName);
            this.client = realm.getClientByClientId("templatized");
            ClientScopeModel scope3 = (ClientScopeModel)scope3Atomic.get();
            Map clientScopes1 = this.client.getClientScopes(true);
            MatcherAssert.assertThat((String)"Client Scope contains 'scope1':", (Object)clientScopes1.containsKey("scope1"), (Matcher)Is.is((Object)false));
            MatcherAssert.assertThat((String)"Client Scope contains 'scope2':", (Object)clientScopes1.containsKey("scope2"), (Matcher)Is.is((Object)false));
            MatcherAssert.assertThat((String)"Client Scope contains 'scope3':", (Object)clientScopes1.containsKey("scope3"), (Matcher)Is.is((Object)false));
            Map clientScopes2 = this.client.getClientScopes(false);
            MatcherAssert.assertThat((String)"Client Scope contains 'scope1':", (Object)clientScopes2.containsKey("scope1"), (Matcher)Is.is((Object)false));
            MatcherAssert.assertThat((String)"Client Scope contains 'scope2':", (Object)clientScopes2.containsKey("scope2"), (Matcher)Is.is((Object)false));
            MatcherAssert.assertThat((String)"Client Scope contains 'scope3':", (Object)clientScopes2.containsKey("scope3"), (Matcher)Is.is((Object)true));
            this.currentSession.clients().removeClient(realm, this.client.getId());
            this.client.removeClientScope(scope3);
            realm.removeClientScope(((ClientScopeModel)scope1Atomic.get()).getId());
            realm.removeClientScope(((ClientScopeModel)scope2Atomic.get()).getId());
            realm.removeClientScope(((ClientScopeModel)scope3Atomic.get()).getId());
        });
    }

    @Test
    @ModelTest
    public void testDefaultDefaultClientScopes(KeycloakSession session) {
        AtomicReference scope1Atomic = new AtomicReference();
        AtomicReference scope2Atomic = new AtomicReference();
        AtomicReference scope3Atomic = new AtomicReference();
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionDefaultClientScope1 -> {
            this.currentSession = sessionDefaultClientScope1;
            RealmModel realm = this.currentSession.realms().getRealmByName(this.realmName);
            ClientScopeModel scope1 = realm.addClientScope("scope1");
            scope1.setProtocol("openid-connect");
            scope1Atomic.set(scope1);
            ClientScopeModel scope2 = realm.addClientScope("scope2");
            scope2.setProtocol("openid-connect");
            scope2Atomic.set(scope2);
            ClientScopeModel scope3 = realm.addClientScope("scope3");
            scope3.setProtocol("openid-connect");
            scope3Atomic.set(scope3);
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionDefaultClientScope2 -> {
            this.currentSession = sessionDefaultClientScope2;
            RealmModel realm = this.currentSession.realms().getRealmByName(this.realmName);
            ClientScopeModel scope1 = (ClientScopeModel)scope1Atomic.get();
            ClientScopeModel scope2 = (ClientScopeModel)scope2Atomic.get();
            ClientScopeModel scope3 = (ClientScopeModel)scope3Atomic.get();
            scope1 = realm.getClientScopeById(scope1.getId());
            scope2 = realm.getClientScopeById(scope2.getId());
            scope3 = realm.getClientScopeById(scope3.getId());
            realm.addDefaultClientScope(scope1, true);
            realm.addDefaultClientScope(scope2, false);
            realm.addDefaultClientScope(scope3, false);
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionDefaultClientScope3 -> {
            this.currentSession = sessionDefaultClientScope3;
            RealmModel realm = this.currentSession.realms().getRealmByName(this.realmName);
            this.client = realm.addClient("foo");
            this.client.setProtocol("openid-connect");
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionDefaultClientScope4 -> {
            this.currentSession = sessionDefaultClientScope4;
            RealmModel realm = this.currentSession.realms().getRealmByName(this.realmName);
            this.client = realm.getClientByClientId("foo");
            ClientScopeModel scope1 = (ClientScopeModel)scope1Atomic.get();
            ClientScopeModel scope2 = (ClientScopeModel)scope2Atomic.get();
            Map clientScopes1 = this.client.getClientScopes(true);
            MatcherAssert.assertThat((String)"Client Scope contains 'scope1':", (Object)clientScopes1.containsKey("scope1"), (Matcher)Is.is((Object)true));
            MatcherAssert.assertThat((String)"Client Scope contains 'scope2':", (Object)clientScopes1.containsKey("scope2"), (Matcher)Is.is((Object)false));
            MatcherAssert.assertThat((String)"Client Scope contains 'scope3':", (Object)clientScopes1.containsKey("scope3"), (Matcher)Is.is((Object)false));
            Map clientScopes2 = this.client.getClientScopes(false);
            MatcherAssert.assertThat((String)"Client Scope contains 'scope1':", (Object)clientScopes2.containsKey("scope1"), (Matcher)Is.is((Object)false));
            MatcherAssert.assertThat((String)"Client Scope contains 'scope2':", (Object)clientScopes2.containsKey("scope2"), (Matcher)Is.is((Object)true));
            MatcherAssert.assertThat((String)"Client Scope contains 'scope3':", (Object)clientScopes2.containsKey("scope3"), (Matcher)Is.is((Object)true));
            this.currentSession.clients().removeClient(realm, this.client.getId());
            realm.removeDefaultClientScope(scope1);
            realm.removeDefaultClientScope(scope2);
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionDefaultClientScope5 -> {
            this.currentSession = sessionDefaultClientScope5;
            RealmModel realm = this.currentSession.realms().getRealmByName(this.realmName);
            this.client = realm.addClient("foo2");
            this.client.setProtocol("openid-connect");
        });
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), sessionDefaultClientScope5 -> {
            this.currentSession = sessionDefaultClientScope5;
            RealmModel realm = this.currentSession.realms().getRealmByName(this.realmName);
            this.client = realm.getClientByClientId("foo2");
            Map clientScopes1 = this.client.getClientScopes(true);
            MatcherAssert.assertThat((String)"Client Scope contains 'scope1':", (Object)clientScopes1.containsKey("scope1"), (Matcher)Is.is((Object)false));
            MatcherAssert.assertThat((String)"Client Scope contains 'scope2':", (Object)clientScopes1.containsKey("scope2"), (Matcher)Is.is((Object)false));
            MatcherAssert.assertThat((String)"Client Scope contains 'scope3':", (Object)clientScopes1.containsKey("scope3"), (Matcher)Is.is((Object)false));
            Map clientScopes2 = this.client.getClientScopes(false);
            MatcherAssert.assertThat((String)"Client Scope contains 'scope1':", (Object)clientScopes2.containsKey("scope1"), (Matcher)Is.is((Object)false));
            MatcherAssert.assertThat((String)"Client Scope contains 'scope2':", (Object)clientScopes2.containsKey("scope2"), (Matcher)Is.is((Object)false));
            MatcherAssert.assertThat((String)"Client Scope contains 'scope3':", (Object)clientScopes2.containsKey("scope3"), (Matcher)Is.is((Object)true));
            this.currentSession.clients().removeClient(realm, this.client.getId());
            realm.removeClientScope(((ClientScopeModel)scope1Atomic.get()).getId());
            realm.removeClientScope(((ClientScopeModel)scope2Atomic.get()).getId());
            realm.removeDefaultClientScope((ClientScopeModel)scope3Atomic.get());
            realm.removeClientScope(((ClientScopeModel)scope3Atomic.get()).getId());
        });
    }
}

