/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.migration;

import java.io.Serializable;
import java.util.List;
import javax.ws.rs.NotFoundException;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.migration.Migration;
import org.keycloak.testsuite.migration.AbstractMigrationTest;
import org.keycloak.testsuite.runonserver.RunOnServer;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class MigrationTest
extends AbstractMigrationTest {
    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        this.log.info((Object)"Adding no test realms for migration test. Test realm should be migrated from previous vesrion.");
    }

    @Before
    public void beforeMigrationTest() {
        this.migrationRealm = this.adminClient.realms().realm("Migration");
        this.migrationRealm2 = this.adminClient.realms().realm("Migration2");
        this.masterRealm = this.adminClient.realms().realm("master");
        this.addTestRealmToTestRealmReps(this.migrationRealm);
        this.addTestRealmToTestRealmReps(this.migrationRealm2);
    }

    private void addTestRealmToTestRealmReps(RealmResource realm) {
        try {
            this.testRealmReps.add(realm.toRepresentation());
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    @Migration(versionFrom="9.")
    public void migration9_xTest() throws Exception {
        this.testMigratedData(false);
        this.testMigrationTo12_x(true);
        this.testOfflineTokenLogin();
        this.testExtremelyLongClientAttribute(this.migrationRealm);
    }

    @Test
    @Migration(versionFrom="4.")
    public void migration4_xTest() throws Exception {
        this.testMigratedData();
        this.testMigrationTo5_x();
        this.testMigrationTo6_x();
        this.testMigrationTo7_x(true);
        this.testMigrationTo8_x();
        this.testMigrationTo9_x();
        this.testMigrationTo12_x(true);
        this.testOfflineTokenLogin();
        this.testExtremelyLongClientAttribute(this.migrationRealm);
    }

    @Test
    @Migration(versionFrom="3.")
    public void migration3_xTest() throws Exception {
        this.testMigratedData();
        this.testMigrationTo4_x();
        this.testMigrationTo5_x();
        this.testMigrationTo6_x();
        this.testMigrationTo7_x(true);
        this.testMigrationTo8_x();
        this.testMigrationTo9_x();
        this.testMigrationTo12_x(true);
        this.testOfflineTokenLogin();
    }

    @Test
    @Migration(versionFrom="2.")
    public void migration2_xTest() throws Exception {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealm("test ' and ; and -- and \"");
            new RealmManager(session).removeRealm(realm);
        });
        this.testMigratedData();
        this.testMigrationTo3_x();
        this.testMigrationTo4_x();
        this.testMigrationTo5_x();
        this.testMigrationTo6_x();
        this.testMigrationTo7_x(true);
        this.testMigrationTo8_x();
        this.testMigrationTo9_x();
        this.testMigrationTo12_x(false);
        this.testOfflineTokenLogin();
    }

    @Test
    @Migration(versionFrom="1.")
    public void migration1_xTest() throws Exception {
        this.testMigratedData(false);
        this.testMigrationTo2_x();
        this.testMigrationTo3_x();
        this.testMigrationTo4_x(false, false);
        this.testMigrationTo5_x();
        this.testMigrationTo6_x();
        this.testMigrationTo7_x(false);
        this.testMigrationTo8_x();
        this.testMigrationTo9_x();
        this.testMigrationTo12_x(false);
        this.testOfflineTokenLogin();
    }
}

