/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.login;

import java.io.Serializable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserManager;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.ModelTest;
import org.keycloak.testsuite.runonserver.RunOnServer;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class LoginTimeoutValidationTest
extends AbstractTestRealmKeycloakTest {
    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Before
    public void before() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            realm = session.realms().getRealm("test");
            session.users().addUser(realm, "user1");
        });
    }

    @After
    public void after() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            session.sessions().removeUserSessions(realm);
            UserModel user1 = session.users().getUserByUsername(realm, "user1");
            UserManager um = new UserManager(session);
            if (user1 != null) {
                um.removeUser(realm, user1);
            }
        });
    }

    @Test
    @ModelTest
    public void testIsLoginTimeoutValid(KeycloakSession keycloakSession) {
        RealmModel realm = keycloakSession.realms().getRealmByName("test");
        UserSessionModel userSession = keycloakSession.sessions().createUserSession(realm, keycloakSession.users().getUserByUsername(realm, "user1"), "user1", "127.0.0.1", "form", true, null, null);
        ClientModel client = realm.getClientByClientId("account");
        AuthenticationSessionModel authSession = keycloakSession.authenticationSessions().createRootAuthenticationSession(realm).createAuthenticationSession(client);
        ClientSessionCode clientSessionCode = new ClientSessionCode(keycloakSession, realm, (CommonClientSessionModel)authSession);
        int accessCodeLifespanLoginOrig = realm.getAccessCodeLifespanLogin();
        realm.setAccessCodeLifespanLogin(Integer.MAX_VALUE);
        Assert.assertTrue((String)"Login validataion with large Login Timeout failed", (boolean)clientSessionCode.isActionActive(ClientSessionCode.ActionType.LOGIN));
        realm.setAccessCodeLifespanLogin(accessCodeLifespanLoginOrig);
        int accessCodeLifespanUserActionOrig = realm.getAccessCodeLifespanUserAction();
        realm.setAccessCodeLifespanUserAction(Integer.MAX_VALUE);
        Assert.assertTrue((String)"Login validataion with large Login Action Timeout failed", (boolean)clientSessionCode.isActionActive(ClientSessionCode.ActionType.USER));
        realm.setAccessCodeLifespanUserAction(accessCodeLifespanUserActionOrig);
    }
}

