/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.keys;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.client.registration.Auth;
import org.keycloak.client.registration.ClientRegistration;
import org.keycloak.client.registration.ClientRegistrationException;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.PemUtils;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.keys.KeyProvider;
import org.keycloak.representations.idm.ClientInitialAccessCreatePresentation;
import org.keycloak.representations.idm.ClientInitialAccessPresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.util.AdminClientUtil;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.KeycloakModelUtils;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.UserInfoClientUtil;

public class KeyRotationTest
extends AbstractKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        testRealms.add(realm);
        ClientRepresentation confApp = KeycloakModelUtils.createClient(realm, "confidential-cli");
        confApp.setSecret("secret1");
        confApp.setServiceAccountsEnabled(Boolean.TRUE);
    }

    @Test
    public void testIdentityCookie() throws Exception {
        this.createKeys1();
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.createKeys2();
        this.appPage.open();
        this.oauth.openLoginForm();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.dropKeys1();
        this.appPage.open();
        this.oauth.openLoginForm();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.dropKeys2();
        this.appPage.open();
        this.oauth.openLoginForm();
        Assert.assertTrue((boolean)this.loginPage.isCurrent());
    }

    @Test
    public void testTokens() throws Exception {
        Map<String, String> keys1 = this.createKeys1();
        this.oauth.doLogin("test-user@localhost", "password");
        OAuthClient.AccessTokenResponse response = this.oauth.doAccessTokenRequest((String)this.oauth.getCurrentQuery().get("code"), "password");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        this.assertTokenKid(keys1.get("RS256"), response.getAccessToken());
        this.assertTokenKid(keys1.get("HS256"), response.getRefreshToken());
        ClientInitialAccessCreatePresentation initialToken = new ClientInitialAccessCreatePresentation();
        initialToken.setCount(Integer.valueOf(100));
        initialToken.setExpiration(Integer.valueOf(0));
        ClientInitialAccessPresentation accessRep = this.adminClient.realm("test").clientInitialAccess().create(initialToken);
        String initialAccessToken = accessRep.getToken();
        ClientRegistration reg = ClientRegistration.create().url(this.suiteContext.getAuthServerInfo().getContextRoot() + "/auth", "test").build();
        reg.auth(Auth.token((String)initialAccessToken));
        ClientRepresentation clientRep = reg.create(ClientBuilder.create().clientId("test").build());
        this.assertUserInfo(response.getAccessToken(), 200);
        this.assertTokenIntrospection(response.getAccessToken(), true);
        ClientRepresentation clientRep2 = reg.auth(Auth.token((String)clientRep.getRegistrationAccessToken())).get("test");
        Assert.assertEquals((Object)clientRep.getRegistrationAccessToken(), (Object)clientRep2.getRegistrationAccessToken());
        Map<String, String> keys2 = this.createKeys2();
        Assert.assertNotEquals((Object)keys1.get("RS256"), (Object)keys2.get("RS256"));
        Assert.assertNotEquals((Object)keys1.get("HS256"), (Object)keys2.get("HS512"));
        response = this.oauth.doRefreshTokenRequest(response.getRefreshToken(), "password");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        this.assertTokenKid(keys2.get("RS256"), response.getAccessToken());
        this.assertTokenKid(keys2.get("HS256"), response.getRefreshToken());
        this.assertUserInfo(response.getAccessToken(), 200);
        this.assertTokenIntrospection(response.getAccessToken(), true);
        ClientRepresentation clientRep3 = reg.auth(Auth.token((String)clientRep.getRegistrationAccessToken())).get("test");
        Assert.assertNotEquals((Object)clientRep.getRegistrationAccessToken(), (Object)clientRep3.getRegistrationAccessToken());
        this.dropKeys1();
        response = this.oauth.doRefreshTokenRequest(response.getRefreshToken(), "password");
        this.assertTokenKid(keys2.get("RS256"), response.getAccessToken());
        this.assertTokenKid(keys2.get("HS256"), response.getRefreshToken());
        this.assertUserInfo(response.getAccessToken(), 200);
        this.assertTokenIntrospection(response.getAccessToken(), true);
        try {
            reg.auth(Auth.token((String)clientRep.getRegistrationAccessToken())).get("test");
            Assert.fail((String)"Expected to fail");
        }
        catch (ClientRegistrationException clientRegistrationException) {
            // empty catch block
        }
        ClientRepresentation clientRep4 = reg.auth(Auth.token((String)clientRep3.getRegistrationAccessToken())).get("test");
        Assert.assertNotEquals((Object)clientRep2.getRegistrationAccessToken(), (Object)clientRep4.getRegistrationAccessToken());
        this.dropKeys2();
        this.assertUserInfo(response.getAccessToken(), 401);
        this.assertTokenIntrospection(response.getAccessToken(), false);
        response = this.oauth.doRefreshTokenRequest(response.getRefreshToken(), "password");
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"Invalid refresh token", (Object)response.getErrorDescription());
    }

    @Test
    public void providerOrder() throws Exception {
        Map<String, String> keys1 = this.createKeys1();
        Map<String, String> keys2 = this.createKeys2();
        Assert.assertNotEquals((Object)keys1.get("RS256"), (Object)keys2.get("RS256"));
        Assert.assertNotEquals((Object)keys1.get("HS256"), (Object)keys2.get("HS512"));
        this.dropKeys1();
        this.dropKeys2();
    }

    @Test
    public void rotateKeys() throws InterruptedException {
        for (int i = 0; i < 10; ++i) {
            String activeKid = (String)this.adminClient.realm("test").keys().getKeyMetadata().getActive().get("RS256");
            String realmId = this.adminClient.realm("test").toRepresentation().getId();
            ComponentRepresentation keys = new ComponentRepresentation();
            keys.setName("generated" + i);
            keys.setProviderType(KeyProvider.class.getName());
            keys.setProviderId("rsa-generated");
            keys.setParentId(realmId);
            keys.setConfig(new MultivaluedHashMap());
            keys.getConfig().putSingle((Object)"priority", (Object)("1000" + i));
            Response response = this.adminClient.realm("test").components().add(keys);
            Assert.assertEquals((long)201L, (long)response.getStatus());
            String newId = ApiUtil.getCreatedId((Response)response);
            this.getCleanup().addComponentId(newId);
            response.close();
            String updatedActiveKid = (String)this.adminClient.realm("test").keys().getKeyMetadata().getActive().get("RS256");
            Assert.assertNotEquals((Object)activeKid, (Object)updatedActiveKid);
        }
    }

    private void assertTokenKid(String expectedKid, String token) throws JWSInputException {
        Assert.assertEquals((Object)expectedKid, (Object)new JWSInput(token).getHeader().getKeyId());
    }

    private Map<String, String> createKeys1() throws Exception {
        return this.createKeys("1000");
    }

    private Map<String, String> createKeys2() throws Exception {
        return this.createKeys("2000");
    }

    private Map<String, String> createKeys(String priority) throws Exception {
        KeyPair keyPair = KeyUtils.generateRsaKeyPair((int)1024);
        String privateKeyPem = PemUtils.encodeKey((Key)keyPair.getPrivate());
        PublicKey publicKey = keyPair.getPublic();
        ComponentRepresentation rep = new ComponentRepresentation();
        rep.setName("mycomponent");
        rep.setParentId("test");
        rep.setProviderId("rsa");
        rep.setProviderType(KeyProvider.class.getName());
        MultivaluedHashMap config = new MultivaluedHashMap();
        config.addFirst((Object)"priority", (Object)priority);
        config.addFirst((Object)"privateKey", (Object)privateKeyPem);
        rep.setConfig(config);
        Response response = this.adminClient.realm("test").components().add(rep);
        response.close();
        rep = new ComponentRepresentation();
        rep.setName("mycomponent2");
        rep.setParentId("test");
        rep.setProviderId("hmac-generated");
        rep.setProviderType(KeyProvider.class.getName());
        config = new MultivaluedHashMap();
        config.addFirst((Object)"priority", (Object)priority);
        rep.setConfig(config);
        response = this.adminClient.realm("test").components().add(rep);
        response.close();
        return this.realmsResouce().realm("test").keys().getKeyMetadata().getActive();
    }

    private void dropKeys1() {
        this.dropKeys("1000");
    }

    private void dropKeys2() {
        this.dropKeys("2000");
    }

    private void dropKeys(String priority) {
        int r = 0;
        for (ComponentRepresentation c : this.adminClient.realm("test").components().query("test", KeyProvider.class.getName())) {
            if (!((String)c.getConfig().getFirst((Object)"priority")).equals(priority)) continue;
            this.adminClient.realm("test").components().component(c.getId()).remove();
            ++r;
        }
        if (r != 2) {
            throw new RuntimeException("Failed to find keys1");
        }
    }

    private void assertUserInfo(String token, int expectedStatus) {
        try (Response userInfoResponse = UserInfoClientUtil.executeUserInfoRequest_getMethod((Client)AdminClientUtil.createResteasyClient(), (String)token);){
            Assert.assertEquals((long)expectedStatus, (long)userInfoResponse.getStatus());
        }
    }

    private void assertTokenIntrospection(String token, boolean expectActive) {
        try {
            String tokenResponse = this.oauth.introspectAccessTokenWithClientCredential("confidential-cli", "secret1", token);
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode jsonNode = objectMapper.readTree(tokenResponse);
            Assert.assertEquals((Object)expectActive, (Object)jsonNode.get("active").asBoolean());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private class ActiveKeys {
        private String rsaKid;
        private String hsKid;

        private ActiveKeys() {
        }
    }
}

