/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.keys;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.jose.jws.AlgorithmType;
import org.keycloak.keys.KeyProvider;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.ErrorRepresentation;
import org.keycloak.representations.idm.KeysMetadataRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPage;

public class JavaKeystoreKeyProviderTest
extends AbstractKeycloakTest {
    private static final String PUBLIC_KEY = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAsPAJ/X39oNRkoS+baWVhAghfO86ZPfkSHm4evmMDhbA0KqW1/hg55qUJoT91ytGozIsIxoCLKzQvZTluRpt0AMp7cmfaGWBQ8cBtb8/BL+5FkUucigmOcTrfPq9/xR9g4AMSXRItjLRsJPy2Bnjau64DVQ3N5NVbWAMw7/1XjuobEyPnw0RLqEr/TxWMteuaiV1n8amIAiT91xZ8UFyPv3urCkAz+r+iyVvdJcZwn2tUL6KLM7qX/HSX8SUtPrIMB8EdW1yNt5McO8Ro5GxwiyXimDKbY9ur2WP8/wrdk/0TkoUYeI1UsnFyoJcqqg2+1T+dNAMtJhF7uDhURVQ33QIDAQAB";
    private static final String CERTIFICATE = "MIIDeTCCAmGgAwIBAgIEbhSauDANBgkqhkiG9w0BAQsFADBsMRAwDgYDVQQGEwdVbmtub3duMRAwDgYDVQQIEwdVbmtub3duMRAwDgYDVQQHEwdVbmtub3duMRAwDgYDVQQKEwdVbmtub3duMRAwDgYDVQQLEwdVbmtub3duMRAwDgYDVQQDEwdVbmtub3duMCAXDTE2MTAxMzE4MjUxNFoYDzIyOTAwNzI4MTgyNTE0WjBsMRAwDgYDVQQGEwdVbmtub3duMRAwDgYDVQQIEwdVbmtub3duMRAwDgYDVQQHEwdVbmtub3duMRAwDgYDVQQKEwdVbmtub3duMRAwDgYDVQQLEwdVbmtub3duMRAwDgYDVQQDEwdVbmtub3duMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAsPAJ/X39oNRkoS+baWVhAghfO86ZPfkSHm4evmMDhbA0KqW1/hg55qUJoT91ytGozIsIxoCLKzQvZTluRpt0AMp7cmfaGWBQ8cBtb8/BL+5FkUucigmOcTrfPq9/xR9g4AMSXRItjLRsJPy2Bnjau64DVQ3N5NVbWAMw7/1XjuobEyPnw0RLqEr/TxWMteuaiV1n8amIAiT91xZ8UFyPv3urCkAz+r+iyVvdJcZwn2tUL6KLM7qX/HSX8SUtPrIMB8EdW1yNt5McO8Ro5GxwiyXimDKbY9ur2WP8/wrdk/0TkoUYeI1UsnFyoJcqqg2+1T+dNAMtJhF7uDhURVQ33QIDAQABoyEwHzAdBgNVHQ4EFgQUgz0ABmkImZUEO2/w0shoH4rp6pwwDQYJKoZIhvcNAQELBQADggEBAK+syjqfFXmv7942+ZfmJfb4i/JilhwSyA2G1VvGR39dLW1nPmKMMUY6kKgJ2NZgaCGvJ4jxDhfNJ1jPG7rcO/eQuF3cx9r+nHiTcJ5PNLqG2q4dNNFshJ8aGuIaTQEB7S1OlGsEj0rd0YlJ+LTrFfEHsnsJvpvDRLdVMklib5fPk4W8ziuQ3rr6T/a+be3zfAqmFZx8j6E46jz9QO841uwqdzcR9kfSHS/76TNGZv8OB6jheyHrUdBygR85iizHgMqats/0zWmKEAvSp/DhAfyIFp8zZHvPjmpBl+mfmAqnrYY0oJRb5rRXmL8DKq5plc7jgO1H6aHh5mV6slXQDEw=";
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    private File file;

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        testRealms.add(realm);
    }

    @Override
    public void beforeAbstractKeycloakTest() throws Exception {
        super.beforeAbstractKeycloakTest();
        this.file = this.folder.newFile("keystore.jsk");
        InputStream resourceAsStream = JavaKeystoreKeyProviderTest.class.getResourceAsStream("keystore.jks");
        IOUtils.copy((InputStream)resourceAsStream, (OutputStream)new FileOutputStream(this.file));
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void create() throws Exception {
        long priority = System.currentTimeMillis();
        ComponentRepresentation rep = this.createRep("valid", priority);
        Response response = this.adminClient.realm("test").components().add(rep);
        String id = ApiUtil.getCreatedId((Response)response);
        ComponentRepresentation createdRep = this.adminClient.realm("test").components().component(id).toRepresentation();
        Assert.assertEquals((long)5L, (long)createdRep.getConfig().size());
        Assert.assertEquals((Object)Long.toString(priority), (Object)createdRep.getConfig().getFirst((Object)"priority"));
        Assert.assertEquals((Object)"**********", (Object)createdRep.getConfig().getFirst((Object)"keystorePassword"));
        Assert.assertEquals((Object)"**********", (Object)createdRep.getConfig().getFirst((Object)"keyPassword"));
        KeysMetadataRepresentation keys = this.adminClient.realm("test").keys().getKeyMetadata();
        KeysMetadataRepresentation.KeyMetadataRepresentation key = (KeysMetadataRepresentation.KeyMetadataRepresentation)keys.getKeys().get(0);
        Assert.assertEquals((Object)id, (Object)key.getProviderId());
        Assert.assertEquals((Object)AlgorithmType.RSA.name(), (Object)key.getType());
        Assert.assertEquals((long)priority, (long)key.getProviderPriority());
        Assert.assertEquals((Object)PUBLIC_KEY, (Object)key.getPublicKey());
        Assert.assertEquals((Object)CERTIFICATE, (Object)key.getCertificate());
    }

    @Test
    public void invalidKeystore() throws Exception {
        ComponentRepresentation rep = this.createRep("valid", System.currentTimeMillis());
        rep.getConfig().putSingle((Object)"keystore", (Object)"/nosuchfile");
        Response response = this.adminClient.realm("test").components().add(rep);
        this.assertErrror(response, "Failed to load keys. File not found on server.");
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void invalidKeystorePassword() throws Exception {
        ComponentRepresentation rep = this.createRep("valid", System.currentTimeMillis());
        rep.getConfig().putSingle((Object)"keystore", (Object)"invalid");
        Response response = this.adminClient.realm("test").components().add(rep);
        this.assertErrror(response, "Failed to load keys. File not found on server.");
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void invalidKeyAlias() throws Exception {
        ComponentRepresentation rep = this.createRep("valid", System.currentTimeMillis());
        rep.getConfig().putSingle((Object)"keyAlias", (Object)"invalid");
        Response response = this.adminClient.realm("test").components().add(rep);
        this.assertErrror(response, "Failed to load keys. Error creating X509v1Certificate.");
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void invalidKeyPassword() throws Exception {
        ComponentRepresentation rep = this.createRep("valid", System.currentTimeMillis());
        rep.getConfig().putSingle((Object)"keyPassword", (Object)"invalid");
        Response response = this.adminClient.realm("test").components().add(rep);
        this.assertErrror(response, "Failed to load keys. Keystore on server can not be recovered.");
    }

    protected void assertErrror(Response response, String error) {
        if (!response.hasEntity()) {
            Assert.fail((String)"No error message set");
        }
        ErrorRepresentation errorRepresentation = (ErrorRepresentation)response.readEntity(ErrorRepresentation.class);
        Assert.assertTrue((boolean)errorRepresentation.getErrorMessage().startsWith(error));
        response.close();
    }

    protected ComponentRepresentation createRep(String name, long priority) {
        ComponentRepresentation rep = new ComponentRepresentation();
        rep.setName(name);
        rep.setParentId("test");
        rep.setProviderId("java-keystore");
        rep.setProviderType(KeyProvider.class.getName());
        rep.setConfig(new MultivaluedHashMap());
        rep.getConfig().putSingle((Object)"priority", (Object)Long.toString(priority));
        rep.getConfig().putSingle((Object)"keystore", (Object)this.file.getAbsolutePath());
        rep.getConfig().putSingle((Object)"keystorePassword", (Object)"password");
        rep.getConfig().putSingle((Object)"keyAlias", (Object)"selfsigned");
        rep.getConfig().putSingle((Object)"keyPassword", (Object)"password");
        return rep;
    }
}

