/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.keys;

import java.security.interfaces.RSAPublicKey;
import java.util.List;
import javax.ws.rs.core.Response;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.PemUtils;
import org.keycloak.crypto.KeyUse;
import org.keycloak.jose.jws.AlgorithmType;
import org.keycloak.keys.KeyProvider;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.ErrorRepresentation;
import org.keycloak.representations.idm.KeysMetadataRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPage;

public class GeneratedRsaKeyProviderTest
extends AbstractKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        testRealms.add(realm);
    }

    @Test
    public void defaultKeysizeForSig() throws Exception {
        this.defaultKeysize("rsa-generated", KeyUse.SIG);
    }

    @Test
    public void defaultKeysizeForEnc() throws Exception {
        this.defaultKeysize("rsa-enc-generated", KeyUse.ENC);
    }

    private void defaultKeysize(String providerId, KeyUse keyUse) throws Exception {
        long priority = System.currentTimeMillis();
        ComponentRepresentation rep = this.createRep("valid", providerId);
        rep.setConfig(new MultivaluedHashMap());
        rep.getConfig().putSingle((Object)"priority", (Object)Long.toString(priority));
        Response response = this.adminClient.realm("test").components().add(rep);
        String id = ApiUtil.getCreatedId((Response)response);
        this.getCleanup().addComponentId(id);
        response.close();
        ComponentRepresentation createdRep = this.adminClient.realm("test").components().component(id).toRepresentation();
        Assert.assertEquals((long)1L, (long)createdRep.getConfig().size());
        Assert.assertEquals((Object)Long.toString(priority), (Object)createdRep.getConfig().getFirst((Object)"priority"));
        KeysMetadataRepresentation keys = this.adminClient.realm("test").keys().getKeyMetadata();
        KeysMetadataRepresentation.KeyMetadataRepresentation key = (KeysMetadataRepresentation.KeyMetadataRepresentation)keys.getKeys().get(0);
        Assert.assertEquals((Object)id, (Object)key.getProviderId());
        Assert.assertEquals((Object)AlgorithmType.RSA.name(), (Object)key.getType());
        Assert.assertEquals((long)priority, (long)key.getProviderPriority());
        Assert.assertEquals((long)2048L, (long)((RSAPublicKey)PemUtils.decodePublicKey((String)((KeysMetadataRepresentation.KeyMetadataRepresentation)keys.getKeys().get(0)).getPublicKey())).getModulus().bitLength());
        Assert.assertEquals((Object)keyUse, (Object)key.getUse());
    }

    @Test
    public void largeKeysizeForSig() throws Exception {
        this.largeKeysize("rsa-generated", KeyUse.SIG);
    }

    @Test
    public void largeKeysizeForEnc() throws Exception {
        this.largeKeysize("rsa-enc-generated", KeyUse.ENC);
    }

    private void largeKeysize(String providerId, KeyUse keyUse) throws Exception {
        long priority = System.currentTimeMillis();
        ComponentRepresentation rep = this.createRep("valid", providerId);
        rep.setConfig(new MultivaluedHashMap());
        rep.getConfig().putSingle((Object)"priority", (Object)Long.toString(priority));
        rep.getConfig().putSingle((Object)"keySize", (Object)"4096");
        Response response = this.adminClient.realm("test").components().add(rep);
        String id = ApiUtil.getCreatedId((Response)response);
        this.getCleanup().addComponentId(id);
        response.close();
        ComponentRepresentation createdRep = this.adminClient.realm("test").components().component(id).toRepresentation();
        Assert.assertEquals((long)2L, (long)createdRep.getConfig().size());
        Assert.assertEquals((Object)"4096", (Object)createdRep.getConfig().getFirst((Object)"keySize"));
        KeysMetadataRepresentation keys = this.adminClient.realm("test").keys().getKeyMetadata();
        KeysMetadataRepresentation.KeyMetadataRepresentation key = (KeysMetadataRepresentation.KeyMetadataRepresentation)keys.getKeys().get(0);
        Assert.assertEquals((Object)id, (Object)key.getProviderId());
        Assert.assertEquals((Object)AlgorithmType.RSA.name(), (Object)key.getType());
        Assert.assertEquals((long)priority, (long)key.getProviderPriority());
        Assert.assertEquals((long)4096L, (long)((RSAPublicKey)PemUtils.decodePublicKey((String)((KeysMetadataRepresentation.KeyMetadataRepresentation)keys.getKeys().get(0)).getPublicKey())).getModulus().bitLength());
        Assert.assertEquals((Object)keyUse, (Object)key.getUse());
    }

    @Test
    public void updatePriorityForSig() throws Exception {
        this.updatePriority("rsa-generated", KeyUse.SIG);
    }

    @Test
    public void updatePriorityForEnc() throws Exception {
        this.updatePriority("rsa-enc-generated", KeyUse.ENC);
    }

    private void updatePriority(String providerId, KeyUse keyUse) throws Exception {
        long priority = System.currentTimeMillis();
        ComponentRepresentation rep = this.createRep("valid", providerId);
        rep.setConfig(new MultivaluedHashMap());
        rep.getConfig().putSingle((Object)"priority", (Object)Long.toString(priority));
        Response response = this.adminClient.realm("test").components().add(rep);
        String id = ApiUtil.getCreatedId((Response)response);
        this.getCleanup().addComponentId(id);
        response.close();
        KeysMetadataRepresentation keys = this.adminClient.realm("test").keys().getKeyMetadata();
        String publicKey = ((KeysMetadataRepresentation.KeyMetadataRepresentation)keys.getKeys().get(0)).getPublicKey();
        ComponentRepresentation createdRep = this.adminClient.realm("test").components().component(id).toRepresentation();
        createdRep.getConfig().putSingle((Object)"priority", (Object)Long.toString(priority += 1000L));
        this.adminClient.realm("test").components().component(id).update(createdRep);
        keys = this.adminClient.realm("test").keys().getKeyMetadata();
        String publicKey2 = ((KeysMetadataRepresentation.KeyMetadataRepresentation)keys.getKeys().get(0)).getPublicKey();
        Assert.assertEquals((Object)publicKey, (Object)publicKey2);
        Assert.assertEquals((Object)keyUse, (Object)((KeysMetadataRepresentation.KeyMetadataRepresentation)keys.getKeys().get(0)).getUse());
    }

    @Test
    public void updateKeysizeForSig() throws Exception {
        this.updateKeysize("rsa-generated", KeyUse.SIG);
    }

    @Test
    public void updateKeysizeForEnc() throws Exception {
        this.updateKeysize("rsa-enc-generated", KeyUse.ENC);
    }

    private void updateKeysize(String providerId, KeyUse keyUse) throws Exception {
        long priority = System.currentTimeMillis();
        ComponentRepresentation rep = this.createRep("valid", providerId);
        rep.setConfig(new MultivaluedHashMap());
        rep.getConfig().putSingle((Object)"priority", (Object)Long.toString(priority));
        Response response = this.adminClient.realm("test").components().add(rep);
        String id = ApiUtil.getCreatedId((Response)response);
        this.getCleanup().addComponentId(id);
        response.close();
        KeysMetadataRepresentation keys = this.adminClient.realm("test").keys().getKeyMetadata();
        String publicKey = ((KeysMetadataRepresentation.KeyMetadataRepresentation)keys.getKeys().get(0)).getPublicKey();
        ComponentRepresentation createdRep = this.adminClient.realm("test").components().component(id).toRepresentation();
        createdRep.getConfig().putSingle((Object)"keySize", (Object)"4096");
        this.adminClient.realm("test").components().component(id).update(createdRep);
        keys = this.adminClient.realm("test").keys().getKeyMetadata();
        String publicKey2 = ((KeysMetadataRepresentation.KeyMetadataRepresentation)keys.getKeys().get(0)).getPublicKey();
        Assert.assertNotEquals((Object)publicKey, (Object)publicKey2);
        Assert.assertEquals((long)2048L, (long)((RSAPublicKey)PemUtils.decodePublicKey((String)publicKey)).getModulus().bitLength());
        Assert.assertEquals((long)4096L, (long)((RSAPublicKey)PemUtils.decodePublicKey((String)publicKey2)).getModulus().bitLength());
        Assert.assertEquals((Object)keyUse, (Object)((KeysMetadataRepresentation.KeyMetadataRepresentation)keys.getKeys().get(0)).getUse());
    }

    @Test
    public void invalidKeysizeForSig() throws Exception {
        this.invalidKeysize("rsa-generated");
    }

    @Test
    public void invalidKeysizeForEnd() throws Exception {
        this.invalidKeysize("rsa-enc-generated");
    }

    private void invalidKeysize(String providerId) throws Exception {
        ComponentRepresentation rep = this.createRep("invalid", providerId);
        rep.getConfig().putSingle((Object)"keySize", (Object)"1234");
        Response response = this.adminClient.realm("test").components().add(rep);
        this.assertErrror(response, "'Key size' should be 1024, 2048 or 4096");
    }

    protected void assertErrror(Response response, String error) {
        if (!response.hasEntity()) {
            Assert.fail((String)"No error message set");
        }
        ErrorRepresentation errorRepresentation = (ErrorRepresentation)response.readEntity(ErrorRepresentation.class);
        Assert.assertEquals((Object)error, (Object)errorRepresentation.getErrorMessage());
        response.close();
    }

    protected ComponentRepresentation createRep(String name, String providerId) {
        ComponentRepresentation rep = new ComponentRepresentation();
        rep.setName(name);
        rep.setParentId("test");
        rep.setProviderId(providerId);
        rep.setProviderType(KeyProvider.class.getName());
        rep.setConfig(new MultivaluedHashMap());
        return rep;
    }
}

