/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.javascript;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsMapContaining;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.graphene.wait.StringMatcher;
import org.junit.Before;
import org.junit.BeforeClass;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractAuthTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.auth.page.login.OIDCLogin;
import org.keycloak.testsuite.page.AbstractPage;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.ContainerAssume;
import org.keycloak.testsuite.util.JavascriptBrowser;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.RolesBuilder;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.URLAssert;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.testsuite.util.WaitUtils;
import org.keycloak.testsuite.util.javascript.JavascriptStateValidator;
import org.keycloak.testsuite.util.javascript.ResponseValidator;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public abstract class AbstractJavascriptTest
extends AbstractAuthTest {
    public static final String JS_APP_HOST = ServerURLs.AUTH_SERVER_HOST2;
    public static final String CLIENT_ID = "js-console";
    public static final String REALM_NAME = "test";
    public static final String SPACE_REALM_NAME = "Example realm";
    public static final String JAVASCRIPT_URL = "/auth/realms/test/testing/javascript";
    public static final String JAVASCRIPT_ENCODED_SPACE_URL = "/auth/realms/Example%20realm/testing/javascript";
    public static final String JAVASCRIPT_SPACE_URL = "/auth/realms/Example realm/testing/javascript";
    public static int TOKEN_LIFESPAN_LEEWAY = 3;
    public static final String USER_PASSWORD = "password";
    protected JavascriptExecutor jsExecutor;
    @Drone
    @JavascriptBrowser
    protected WebDriver jsDriver;
    @Page
    @JavascriptBrowser
    protected OIDCLogin jsDriverTestRealmLoginPage;
    @FindBy(id="output")
    @JavascriptBrowser
    protected WebElement outputArea;
    @FindBy(id="events")
    @JavascriptBrowser
    protected WebElement eventsArea;
    public static final UserRepresentation testUser = UserBuilder.create().username("test-user@localhost").password("password").build();
    public static final UserRepresentation unauthorizedUser = UserBuilder.create().username("unauthorized").password("password").build();

    @BeforeClass
    public static void enabledOnlyWithSSL() {
        ContainerAssume.assumeAuthServerSSL();
    }

    @Before
    public void beforeJavascriptTest() {
        this.jsExecutor = (JavascriptExecutor)this.jsDriver;
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        String[] stringArray = new String[2];
        stringArray[0] = OAuthClient.SERVER_ROOT.replace(ServerURLs.AUTH_SERVER_HOST, JS_APP_HOST) + JAVASCRIPT_URL + "/*";
        stringArray[1] = OAuthClient.SERVER_ROOT + JAVASCRIPT_ENCODED_SPACE_URL + "/*";
        testRealms.add(this.updateRealm(RealmBuilder.create().name(REALM_NAME).roles(RolesBuilder.create().realmRole(new RoleRepresentation("user", "", false)).realmRole(new RoleRepresentation("admin", "", false))).user(UserBuilder.create().username("test-user@localhost").password(USER_PASSWORD).addRoles("user").role("realm-management", "view-realm").role("realm-management", "manage-users").role("account", "view-profile").role("account", "manage-account")).user(UserBuilder.create().username("unauthorized").password(USER_PASSWORD)).client(ClientBuilder.create().clientId(CLIENT_ID).redirectUris(stringArray).addWebOrigin(OAuthClient.SERVER_ROOT.replace(ServerURLs.AUTH_SERVER_HOST, JS_APP_HOST)).publicClient()).accessTokenLifespan(30 + TOKEN_LIFESPAN_LEEWAY).testEventListener()));
    }

    protected <T> JavascriptStateValidator buildFunction(QuadFunction<T, WebDriver, Object, WebElement> f, T x) {
        return (JavascriptStateValidator & Serializable)(y, z, w) -> f.apply(x, y, z, w);
    }

    protected void setImplicitFlowForClient() {
        ClientResource clientResource = ApiUtil.findClientResourceByClientId((RealmResource)this.adminClient.realms().realm(REALM_NAME), (String)CLIENT_ID);
        ClientRepresentation client = clientResource.toRepresentation();
        client.setImplicitFlowEnabled(Boolean.valueOf(true));
        client.setStandardFlowEnabled(Boolean.valueOf(false));
        clientResource.update(client);
    }

    protected void setStandardFlowForClient() {
        ClientResource clientResource = ApiUtil.findClientResourceByClientId((RealmResource)this.adminClient.realms().realm(REALM_NAME), (String)CLIENT_ID);
        ClientRepresentation client = clientResource.toRepresentation();
        client.setImplicitFlowEnabled(Boolean.valueOf(false));
        client.setStandardFlowEnabled(Boolean.valueOf(true));
        clientResource.update(client);
    }

    protected abstract RealmRepresentation updateRealm(RealmBuilder var1);

    protected void assertInitAuth(WebDriver driver1, Object output, WebElement events) {
        this.buildFunction(this::assertOutputContains, "Init Success (Authenticated)").validate(driver1, output, events);
        WaitUtils.waitUntilElement((WebElement)events).text().contains("Auth Success");
    }

    protected void assertInitNotAuth(WebDriver driver1, Object output, WebElement events) {
        this.buildFunction(this::assertOutputContains, "Init Success (Not Authenticated)").validate(driver1, output, events);
    }

    protected void assertOnLoginPage(WebDriver driver1, Object output, WebElement events) {
        WaitUtils.waitUntilElement((By)By.tagName((String)"body")).is().present();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.jsDriverTestRealmLoginPage, driver1);
    }

    public void assertOutputWebElementContains(String value, WebDriver driver1, Object output, WebElement events) {
        WaitUtils.waitUntilElement((WebElement)((WebElement)output)).text().contains(value);
    }

    public void assertLocaleCookie(String locale, WebDriver driver1, Object output, WebElement events) {
        WaitUtils.waitForPageToLoad();
        WebDriver.Options ops = driver1.manage();
        Cookie cookie = ops.getCookieNamed("KEYCLOAK_LOCALE");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((Object)locale, (Object)cookie.getValue());
    }

    public JavascriptStateValidator assertLocaleIsSet(String locale) {
        return this.buildFunction(this::assertLocaleCookie, locale);
    }

    public void assertOutputContains(String value, WebDriver driver1, Object output, WebElement events) {
        if (output instanceof WebElement) {
            WaitUtils.waitUntilElement((WebElement)((WebElement)output)).text().contains(value);
        } else {
            Assert.assertThat((Object)((String)output), (Matcher)CoreMatchers.containsString((String)value));
        }
    }

    public void assertEventsWebElementContains(String value, WebDriver driver1, Object output, WebElement events) {
        WaitUtils.waitUntilElement((WebElement)events).text().contains(value);
    }

    public void assertEventsWebElementDoesntContain(String value, WebDriver driver1, Object output, WebElement events) {
        ((StringMatcher)WaitUtils.waitUntilElement((WebElement)events).text().not()).contains(value);
    }

    public ResponseValidator assertResponseStatus(long status) {
        return (ResponseValidator & Serializable)output -> Assert.assertThat((Object)output, (Matcher)IsMapContaining.hasEntry((Object)"status", (Object)status));
    }

    public JavascriptStateValidator assertOutputContains(String text) {
        return this.buildFunction(this::assertOutputContains, text);
    }

    public JavascriptStateValidator assertEventsContains(String text) {
        return this.buildFunction(this::assertEventsWebElementContains, text);
    }

    public JavascriptStateValidator assertEventsDoesntContain(String text) {
        return this.buildFunction(this::assertEventsWebElementDoesntContain, text);
    }

    public void assertErrorResponse(String expectedError, WebDriver drv, Object output, WebElement evt) {
        Assert.assertNotNull((String)"Empty error response", (Object)output);
        Assert.assertTrue((String)"Invalid error response type", (boolean)(output instanceof Map));
        MatcherAssert.assertThat((Object)((Map)output), (Matcher)CoreMatchers.anyOf((Matcher)IsMapContaining.hasEntry((Object)"error", (Object)expectedError), (Matcher)IsMapContaining.hasEntry((Object)"error_description", (Object)expectedError)));
    }

    public JavascriptStateValidator assertErrorResponse(String expectedError) {
        return this.buildFunction(this::assertErrorResponse, expectedError);
    }

    @FunctionalInterface
    static interface QuadFunction<T, U, V, W> {
        public void apply(T var1, U var2, V var3, W var4);
    }
}

