/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.jaas;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.adapters.jaas.BearerTokenLoginModule;
import org.keycloak.adapters.jaas.DirectAccessGrantsLoginModule;
import org.keycloak.adapters.jaas.RolePrincipal;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.utils.io.IOUtil;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class LoginModulesTest
extends AbstractKeycloakTest {
    public static final URI DIRECT_GRANT_CONFIG;
    public static final URI BEARER_CONFIG;
    private static final File DIRECT_GRANT_CONFIG_FILE;
    private static final File BEARER_CONFIG_FILE;

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(IOUtil.loadRealm((String)"/adapter-test/demorealm.json"));
    }

    private static void enabled() {
        Assume.assumeTrue((boolean)ServerURLs.AUTH_SERVER_SSL_REQUIRED);
    }

    @BeforeClass
    public static void createTemporaryFiles() throws Exception {
        LoginModulesTest.enabled();
        LoginModulesTest.copyContentAndReplaceAuthServerAddress(new File(DIRECT_GRANT_CONFIG), DIRECT_GRANT_CONFIG_FILE);
        LoginModulesTest.copyContentAndReplaceAuthServerAddress(new File(BEARER_CONFIG), BEARER_CONFIG_FILE);
    }

    @AfterClass
    public static void removeTemporaryFiles() {
        DIRECT_GRANT_CONFIG_FILE.deleteOnExit();
        BEARER_CONFIG_FILE.deleteOnExit();
    }

    private static void copyContentAndReplaceAuthServerAddress(File input, File output) throws IOException {
        try (InputStream inputStream = LoginModulesTest.httpsAwareConfigurationStream(new FileInputStream(input));
             FileOutputStream outputStream = new FileOutputStream(output);){
            byte[] buffer = new byte[inputStream.available()];
            inputStream.read(buffer);
            outputStream.write(buffer);
        }
    }

    @Before
    public void generateAudienceClientScope() {
        if (ApiUtil.findClientScopeByName((RealmResource)this.adminClient.realm("demo"), (String)"customer-db-audience-required") != null) {
            return;
        }
        String clientScopeId = this.testingClient.testing().generateAudienceClientScope("demo", "customer-db-audience-required");
        ClientResource client = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("demo"), (String)"customer-portal");
        client.addOptionalClientScope(clientScopeId);
    }

    @Test
    public void testDirectAccessGrantLoginModuleLoginFailed() throws Exception {
        LoginContext loginContext = new LoginContext("does-not-matter", null, this.createJaasCallbackHandler("bburke@redhat.com", "bad-password"), this.createJaasConfigurationForDirectGrant(null));
        try {
            loginContext.login();
            Assert.fail((String)"Not expected to successfully login");
        }
        catch (LoginException loginException) {
            // empty catch block
        }
    }

    @Test
    public void testDirectAccessGrantLoginModuleLoginSuccess() throws Exception {
        this.oauth.realm("demo");
        LoginContext loginContext = this.directGrantLogin(null);
        Subject subject = loginContext.getSubject();
        KeycloakPrincipal principal = subject.getPrincipals(KeycloakPrincipal.class).iterator().next();
        Assert.assertEquals((Object)"bburke@redhat.com", (Object)principal.getKeycloakSecurityContext().getToken().getPreferredUsername());
        this.assertToken(principal.getKeycloakSecurityContext().getTokenString(), true);
        Set<RolePrincipal> roles = subject.getPrincipals(RolePrincipal.class);
        Assert.assertEquals((long)1L, (long)roles.size());
        Assert.assertEquals((Object)"user", (Object)roles.iterator().next().getName());
        loginContext.logout();
        this.assertToken(principal.getKeycloakSecurityContext().getTokenString(), false);
    }

    @Test
    public void testBearerLoginFailedLogin() throws Exception {
        this.oauth.realm("demo");
        LoginContext directGrantCtx = this.directGrantLogin(null);
        String accessToken = directGrantCtx.getSubject().getPrincipals(KeycloakPrincipal.class).iterator().next().getKeycloakSecurityContext().getTokenString();
        LoginContext bearerCtx = new LoginContext("does-not-matter", null, this.createJaasCallbackHandler("doesn-not-matter", accessToken), this.createJaasConfigurationForBearer());
        try {
            bearerCtx.login();
            Assert.fail((String)"Not expected to successfully login");
        }
        catch (LoginException loginException) {
            // empty catch block
        }
        directGrantCtx.logout();
    }

    @Test
    public void testBearerLoginSuccess() throws Exception {
        this.oauth.realm("demo");
        LoginContext directGrantCtx = this.directGrantLogin("customer-db-audience-required");
        String accessToken = directGrantCtx.getSubject().getPrincipals(KeycloakPrincipal.class).iterator().next().getKeycloakSecurityContext().getTokenString();
        LoginContext bearerCtx = new LoginContext("does-not-matter", null, this.createJaasCallbackHandler("doesn-not-matter", accessToken), this.createJaasConfigurationForBearer());
        bearerCtx.login();
        Subject subject = bearerCtx.getSubject();
        KeycloakPrincipal principal = subject.getPrincipals(KeycloakPrincipal.class).iterator().next();
        Assert.assertEquals((Object)"bburke@redhat.com", (Object)principal.getKeycloakSecurityContext().getToken().getPreferredUsername());
        this.assertToken(principal.getKeycloakSecurityContext().getTokenString(), true);
        Set<RolePrincipal> roles = subject.getPrincipals(RolePrincipal.class);
        Assert.assertEquals((long)1L, (long)roles.size());
        Assert.assertEquals((Object)"user", (Object)roles.iterator().next().getName());
        bearerCtx.logout();
        directGrantCtx.logout();
    }

    private LoginContext directGrantLogin(String scope) throws LoginException {
        LoginContext loginContext = new LoginContext("does-not-matter", null, this.createJaasCallbackHandler("bburke@redhat.com", "password"), this.createJaasConfigurationForDirectGrant(scope));
        loginContext.login();
        return loginContext;
    }

    private void assertToken(String accessToken, boolean expectActive) throws IOException {
        String introspectionResponse = this.oauth.introspectAccessTokenWithClientCredential("customer-portal", "password", accessToken);
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonNode = objectMapper.readTree(introspectionResponse);
        Assert.assertEquals((Object)expectActive, (Object)jsonNode.get("active").asBoolean());
    }

    private CallbackHandler createJaasCallbackHandler(final String principal, final String password) {
        return new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback callback : callbacks) {
                    if (callback instanceof NameCallback) {
                        NameCallback nameCallback = (NameCallback)callback;
                        nameCallback.setName(principal);
                        continue;
                    }
                    if (callback instanceof PasswordCallback) {
                        PasswordCallback passwordCallback = (PasswordCallback)callback;
                        passwordCallback.setPassword(password.toCharArray());
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback, "Unsupported callback: " + callback.getClass().getCanonicalName());
                }
            }
        };
    }

    private Configuration createJaasConfigurationForDirectGrant(final String scope) {
        return new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("keycloak-config-file", DIRECT_GRANT_CONFIG_FILE.getAbsolutePath());
                if (scope != null) {
                    options.put("scope", scope);
                }
                AppConfigurationEntry LMConfiguration = new AppConfigurationEntry(DirectAccessGrantsLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
                return new AppConfigurationEntry[]{LMConfiguration};
            }
        };
    }

    private Configuration createJaasConfigurationForBearer() {
        return new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("keycloak-config-file", BEARER_CONFIG_FILE.getAbsolutePath());
                AppConfigurationEntry LMConfiguration = new AppConfigurationEntry(BearerTokenLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
                return new AppConfigurationEntry[]{LMConfiguration};
            }
        };
    }

    static {
        try {
            DIRECT_GRANT_CONFIG = MethodHandles.lookup().lookupClass().getResource("/adapter-test/customer-portal/WEB-INF/keycloak.json").toURI();
            BEARER_CONFIG = MethodHandles.lookup().lookupClass().getResource("/adapter-test/customer-db-audience-required/WEB-INF/keycloak.json").toURI();
            DIRECT_GRANT_CONFIG_FILE = File.createTempFile("LoginModulesTest", "testDirectAccessGrantLoginModuleLoginFailed");
            BEARER_CONFIG_FILE = File.createTempFile("LoginModulesTest", "testBearerLoginFailedLogin");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

