/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.i18n;

import java.util.List;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.Profile;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.testsuite.ProfileAssume;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.i18n.AbstractI18NTest;
import org.keycloak.testsuite.pages.AccountUpdateProfilePage;
import org.keycloak.testsuite.pages.LoginPage;

@DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
public class AccountPageTest
extends AbstractI18NTest {
    @Page
    protected AccountUpdateProfilePage accountUpdateProfilePage;
    @Page
    protected LoginPage loginPage;

    @Test
    public void languageDropdown() {
        this.accountUpdateProfilePage.open();
        this.loginPage.login("login@test.com", "password");
        Assert.assertTrue((boolean)this.accountUpdateProfilePage.isCurrent());
        Assert.assertEquals((Object)"English", (Object)this.accountUpdateProfilePage.getLanguageDropdownText());
        this.accountUpdateProfilePage.openLanguage("Deutsch");
        Assert.assertEquals((Object)"Deutsch", (Object)this.accountUpdateProfilePage.getLanguageDropdownText());
        this.accountUpdateProfilePage.openLanguage("English");
        Assert.assertEquals((Object)"English", (Object)this.accountUpdateProfilePage.getLanguageDropdownText());
        this.accountUpdateProfilePage.logout();
    }

    @Test
    public void testLocalizedReferrerLinkContent() {
        ProfileAssume.assumeCommunity();
        RealmResource testRealm = this.testRealm();
        List foundClients = testRealm.clients().findByClientId("var-named-test-app");
        if (foundClients.isEmpty()) {
            Assert.fail((String)"Unable to find var-named-test-app");
        }
        ClientRepresentation namedClient = (ClientRepresentation)foundClients.get(0);
        this.driver.navigate().to(this.accountUpdateProfilePage.getPath() + "?referrer=" + namedClient.getClientId());
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.accountUpdateProfilePage.isCurrent());
        this.accountUpdateProfilePage.openLanguage("Deutsch");
        Assert.assertEquals((Object)"Deutsch", (Object)this.accountUpdateProfilePage.getLanguageDropdownText());
        Assert.assertEquals((Object)"Zur\u00fcck zu Test App Named - Clientkonto", (Object)this.accountUpdateProfilePage.getBackToApplicationLinkText());
        Assert.assertEquals((Object)namedClient.getBaseUrl(), (Object)this.accountUpdateProfilePage.getBackToApplicationLinkHref());
    }
}

