/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import java.io.Serializable;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.FlowUtil;
import org.keycloak.testsuite.util.OAuthClient;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class TransientSessionTest
extends AbstractTestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Test
    public void loginSuccess() throws Exception {
        this.setUpDirectGrantFlowWithSetClientNoteAuthenticator();
        this.oauth.clientId("direct-grant");
        this.oauth.addCustomParameter("note-USER_SESSION_PERSISTENT_STATE", UserSessionModel.SessionPersistenceState.TRANSIENT.toString());
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("password", "test-user@localhost", "password");
        org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AccessToken accessToken = this.oauth.verifyToken(response.getAccessToken());
        RefreshToken refreshToken = this.oauth.parseRefreshToken(response.getRefreshToken());
        org.junit.Assert.assertNotNull((Object)accessToken.getSessionState());
        org.junit.Assert.assertEquals((Object)accessToken.getSessionState(), (Object)refreshToken.getSessionState());
        OAuthClient.AccessTokenResponse refreshedResponse = this.oauth.doRefreshTokenRequest(response.getRefreshToken(), "password");
        Assert.assertNull((Object)refreshedResponse.getAccessToken());
        org.junit.Assert.assertNotNull((Object)refreshedResponse.getError());
        Assert.assertEquals((Object)"Session not active", (Object)refreshedResponse.getErrorDescription());
    }

    private void setUpDirectGrantFlowWithSetClientNoteAuthenticator() {
        String newFlowAlias = "directGrantCustom";
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).copyFlow("direct grant", "directGrantCustom"));
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).selectFlow("directGrantCustom").addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "set-client-note-authenticator").defineAsDirectGrantFlow());
    }
}

