/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.common.Profile;
import org.keycloak.events.EventType;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.representations.idm.AuthenticationExecutionRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.AuthenticatorConfigRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.ProfileAssume;
import org.keycloak.testsuite.arquillian.annotation.EnableFeature;
import org.keycloak.testsuite.forms.AbstractFlowTest;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.util.ExecutionBuilder;
import org.keycloak.testsuite.util.FlowBuilder;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.UserBuilder;

@EnableFeature(value=Profile.Feature.UPLOAD_SCRIPTS, skipRestart=true)
public class ScriptAuthenticatorTest
extends AbstractFlowTest {
    @Page
    protected LoginPage loginPage;
    @Rule
    public AssertEvents events = new AssertEvents(this);
    private AuthenticationFlowRepresentation flow;
    private static final String userId = UUID.randomUUID().toString();
    private static final String failId = UUID.randomUUID().toString();
    public static final String EXECUTION_ID = "scriptAuth";

    @BeforeClass
    public static void enabled() {
        ProfileAssume.assumeFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION);
    }

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        UserRepresentation failUser = UserBuilder.create().id(failId).username("fail").email("fail@test.com").enabled(true).password("password").build();
        UserRepresentation okayUser = UserBuilder.create().id(userId).username("user").email("user@test.com").enabled(true).password("password").build();
        RealmBuilder.edit(testRealm).user(failUser).user(okayUser);
    }

    @Before
    public void configureFlows() throws Exception {
        if (this.testContext.isInitialized()) {
            return;
        }
        String scriptFlow = "scriptBrowser";
        AuthenticationFlowRepresentation scriptBrowserFlow = FlowBuilder.create().alias(scriptFlow).description("dummy pass through registration").providerId("basic-flow").topLevel(true).builtIn(false).build();
        Response createFlowResponse = this.testRealm().flows().createFlow(scriptBrowserFlow);
        Assert.assertEquals((long)201L, (long)createFlowResponse.getStatus());
        RealmRepresentation realm = this.testRealm().toRepresentation();
        realm.setBrowserFlow(scriptFlow);
        realm.setDirectGrantFlow(scriptFlow);
        this.testRealm().update(realm);
        this.flow = this.findFlowByAlias(scriptFlow);
        AuthenticationExecutionRepresentation usernamePasswordFormExecution = ExecutionBuilder.create().id("username password form").parentFlow(this.flow.getId()).requirement(AuthenticationExecutionModel.Requirement.REQUIRED.name()).authenticator("auth-username-password-form").build();
        AuthenticationExecutionRepresentation authScriptExecution = ExecutionBuilder.create().id(EXECUTION_ID).parentFlow(this.flow.getId()).requirement(AuthenticationExecutionModel.Requirement.REQUIRED.name()).authenticator("auth-script-based").build();
        Response addExecutionResponse = this.testRealm().flows().addExecution(usernamePasswordFormExecution);
        Assert.assertEquals((long)201L, (long)addExecutionResponse.getStatus());
        addExecutionResponse.close();
        addExecutionResponse = this.testRealm().flows().addExecution(authScriptExecution);
        Assert.assertEquals((long)201L, (long)addExecutionResponse.getStatus());
        addExecutionResponse.close();
        this.testContext.setInitialized(true);
    }

    @Test
    public void loginShouldWorkWithScriptAuthenticator() {
        this.addConfigFromFile("/scripts/authenticator-example.js");
        this.loginPage.open();
        this.loginPage.login("user", "password");
        this.events.expectLogin().user(userId).detail("username", "user").assertEvent();
    }

    @Test
    public void loginShouldFailWithScriptAuthenticator() {
        this.addConfigFromFile("/scripts/authenticator-example.js");
        this.loginPage.open();
        this.loginPage.login("fail", "password");
        this.events.expect(EventType.LOGIN_ERROR).user((String)null).error("user_not_found").assertEvent();
    }

    @Test
    public void scriptWithClientSession() {
        this.addConfigFromFile("/scripts/client-session-test.js", (Map<String, String>)ImmutableMap.of((Object)"realm", (Object)"test", (Object)"clientId", (Object)"test-app", (Object)"authMethod", (Object)"openid-connect"));
        this.loginPage.open();
        this.loginPage.login("user", "password");
        this.events.expectLogin().user(userId).detail("username", "user").assertEvent();
    }

    private void addConfigFromFile(String filename) {
        this.addConfigFromFile(filename, null);
    }

    private void addConfigFromFile(String filename, Map<String, String> parameters) {
        String alias = filename.substring(filename.lastIndexOf("/") + 1);
        String script = this.loadFile(filename, parameters);
        Response newExecutionConfigResponse = this.testRealm().flows().newExecutionConfig(EXECUTION_ID, this.createScriptAuthConfig(EXECUTION_ID, alias, script, "script based authenticator"));
        newExecutionConfigResponse.close();
        Assert.assertEquals((long)201L, (long)newExecutionConfigResponse.getStatus());
    }

    private String loadFile(String filename, Map<String, String> parameters) {
        String script = null;
        try {
            script = IOUtils.toString((InputStream)this.getClass().getResourceAsStream(filename));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (parameters != null) {
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                script = script.replaceAll("\\$\\{" + entry.getKey() + "}", entry.getValue());
            }
        }
        return script;
    }

    private AuthenticatorConfigRepresentation createScriptAuthConfig(String alias, String scriptName, String script, String scriptDescription) {
        AuthenticatorConfigRepresentation configRep = new AuthenticatorConfigRepresentation();
        configRep.setAlias(alias);
        configRep.getConfig().put("scriptCode", script);
        configRep.getConfig().put("scriptName", scriptName);
        configRep.getConfig().put("scriptDescription", scriptDescription);
        return configRep;
    }
}

