/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.Profile;
import org.keycloak.events.EventType;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.protocol.oidc.utils.RedirectUtils;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.federation.kerberos.AbstractKerberosTest;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.InfoPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginPasswordResetPage;
import org.keycloak.testsuite.pages.LoginPasswordUpdatePage;
import org.keycloak.testsuite.pages.VerifyEmailPage;
import org.keycloak.testsuite.updaters.ClientAttributeUpdater;
import org.keycloak.testsuite.updaters.ServerResourceUpdater;
import org.keycloak.testsuite.util.BrowserTabUtil;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.GreenMailRule;
import org.keycloak.testsuite.util.MailUtils;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.SecondBrowser;
import org.keycloak.testsuite.util.UserActionTokenBuilder;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class ResetPasswordTest
extends AbstractTestRealmKeycloakTest {
    private String userId;
    private UserRepresentation defaultUser;
    @Drone
    @SecondBrowser
    protected WebDriver driver2;
    @Rule
    public GreenMailRule greenMail = new GreenMailRule();
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected ErrorPage errorPage;
    @Page
    protected InfoPage infoPage;
    @Page
    protected VerifyEmailPage verifyEmailPage;
    @Page
    protected LoginPasswordResetPage resetPasswordPage;
    @Page
    protected LoginPasswordUpdatePage updatePasswordPage;
    @Rule
    public AssertEvents events = new AssertEvents(this);
    private int expectedMessagesCount;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        RealmBuilder.edit(testRealm).client(ClientBuilder.create().clientId("client-user").serviceAccount());
    }

    @Before
    public void setup() {
        this.log.info((Object)"Adding login-test user");
        this.defaultUser = UserBuilder.create().username("login-test").email("login@test.com").enabled(true).build();
        this.userId = ApiUtil.createUserAndResetPasswordWithAdminClient((RealmResource)this.testRealm(), (UserRepresentation)this.defaultUser, (String)"password");
        this.defaultUser.setId(this.userId);
        this.expectedMessagesCount = 0;
        this.getCleanup().addUserId(this.userId);
    }

    @Test
    @DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
    public void resetPasswordLink() throws IOException, MessagingException {
        String username = "login-test";
        String resetUri = OAuthClient.AUTH_SERVER_ROOT + "/realms/test/login-actions/reset-credentials";
        this.driver.navigate().to(resetUri);
        this.resetPasswordPage.assertCurrent();
        this.resetPasswordPage.changePassword(username);
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"You should receive an email shortly with further instructions.", (Object)this.loginPage.getSuccessMessage());
        this.events.expectRequiredAction(EventType.SEND_RESET_PASSWORD).user(this.userId).detail("redirect_uri", OAuthClient.AUTH_SERVER_ROOT + "/realms/test/account/").client("account").detail("username", username).detail("email", "login@test.com").session((String)null).assertEvent();
        Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getReceivedMessages()[0];
        String changePasswordUrl = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
        this.driver.navigate().to(changePasswordUrl.trim());
        this.updatePasswordPage.assertCurrent();
        this.updatePasswordPage.changePassword("resetPassword", "resetPassword");
        this.events.expectRequiredAction(EventType.UPDATE_PASSWORD).detail("redirect_uri", OAuthClient.AUTH_SERVER_ROOT + "/realms/test/account/").client("account").user(this.userId).detail("username", username).assertEvent();
        String sessionId = this.events.expectLogin().user(this.userId).detail("username", username).detail("redirect_uri", OAuthClient.AUTH_SERVER_ROOT + "/realms/test/account/").client("account").assertEvent().getSessionId();
        this.oauth.openLogout();
        this.events.expectLogout(sessionId).user(this.userId).session(sessionId).assertEvent();
        this.loginPage.open();
        this.loginPage.login("login-test", "resetPassword");
        this.events.expectLogin().user(this.userId).detail("username", "login-test").assertEvent();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
    }

    @Test
    public void resetPassword() throws IOException, MessagingException {
        this.resetPassword("login-test");
    }

    @Test
    public void resetPasswordTwice() throws IOException, MessagingException {
        String changePasswordUrl = this.resetPassword("login-test");
        this.events.clear();
        this.assertSecondPasswordResetFails(changePasswordUrl, this.oauth.getClientId());
    }

    @Test
    public void resetPasswordTwiceInNewBrowser() throws IOException, MessagingException {
        String changePasswordUrl = this.resetPassword("login-test");
        this.events.clear();
        String resetUri = OAuthClient.AUTH_SERVER_ROOT + "/realms/test/login-actions/reset-credentials";
        this.driver.navigate().to(resetUri);
        this.driver.manage().deleteAllCookies();
        this.assertSecondPasswordResetFails(changePasswordUrl, this.oauth.getClientId());
    }

    public void assertSecondPasswordResetFails(String changePasswordUrl, String clientId) {
        this.driver.navigate().to(changePasswordUrl.trim());
        this.errorPage.assertCurrent();
        Assert.assertEquals((Object)"Action expired. Please continue with login now.", (Object)this.errorPage.getError());
        this.events.expect(EventType.RESET_PASSWORD).client(clientId).session((String)null).user(this.userId).error("expired_code").assertEvent();
    }

    @Test
    public void resetPasswordWithSpacesInUsername() throws IOException, MessagingException {
        this.resetPassword(" login-test ");
    }

    @Test
    public void resetPasswordCancelChangeUser() throws IOException, MessagingException {
        this.initiateResetPasswordFromResetPasswordPage("test-user@localhost");
        this.events.expectRequiredAction(EventType.SEND_RESET_PASSWORD).detail("username", "test-user@localhost").session((String)null).detail("email", "test-user@localhost").assertEvent();
        this.loginPage.login("login@test.com", "password");
        EventRepresentation loginEvent = this.events.expectLogin().user(this.userId).detail("username", "login@test.com").assertEvent();
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertEquals((long)200L, (long)tokenResponse.getStatusCode());
        Assert.assertEquals((Object)this.userId, (Object)this.oauth.verifyToken(tokenResponse.getAccessToken()).getSubject());
        this.events.expectCodeToToken((String)loginEvent.getDetails().get("code_id"), loginEvent.getSessionId()).user(this.userId).assertEvent();
    }

    @Test
    public void resetPasswordByEmail() throws IOException, MessagingException {
        this.resetPassword("login@test.com");
    }

    private String resetPassword(String username) throws IOException, MessagingException {
        return this.resetPassword(username, "resetPassword");
    }

    private String resetPassword(String username, String password) throws IOException, MessagingException {
        this.initiateResetPasswordFromResetPasswordPage(username);
        this.events.expectRequiredAction(EventType.SEND_RESET_PASSWORD).user(this.userId).detail("username", username.trim()).detail("email", "login@test.com").session((String)null).assertEvent();
        Assert.assertEquals((long)this.expectedMessagesCount, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getReceivedMessages()[this.greenMail.getReceivedMessages().length - 1];
        String changePasswordUrl = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
        this.driver.navigate().to(changePasswordUrl.trim());
        this.updatePasswordPage.assertCurrent();
        Assert.assertEquals((Object)"You need to change your password.", (Object)this.updatePasswordPage.getFeedbackMessage());
        this.updatePasswordPage.changePassword(password, password);
        this.events.expectRequiredAction(EventType.UPDATE_PASSWORD).user(this.userId).detail("username", username.trim()).assertEvent();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        String sessionId = this.events.expectLogin().user(this.userId).detail("username", username.trim()).assertEvent().getSessionId();
        this.oauth.openLogout();
        this.events.expectLogout(sessionId).user(this.userId).session(sessionId).assertEvent();
        this.loginPage.open();
        this.loginPage.login("login-test", password);
        sessionId = this.events.expectLogin().user(this.userId).detail("username", "login-test").assertEvent().getSessionId();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.oauth.openLogout();
        this.events.expectLogout(sessionId).user(this.userId).session(sessionId).assertEvent();
        return changePasswordUrl;
    }

    private void resetPasswordInvalidPassword(String username, String password, String error) throws IOException, MessagingException {
        this.initiateResetPasswordFromResetPasswordPage(username);
        this.events.expectRequiredAction(EventType.SEND_RESET_PASSWORD).user(this.userId).session((String)null).detail("username", username).detail("email", "login@test.com").assertEvent();
        Assert.assertEquals((long)this.expectedMessagesCount, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getReceivedMessages()[this.greenMail.getReceivedMessages().length - 1];
        String changePasswordUrl = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
        this.driver.navigate().to(changePasswordUrl.trim());
        this.updatePasswordPage.assertCurrent();
        this.updatePasswordPage.changePassword(password, password);
        this.updatePasswordPage.assertCurrent();
        Assert.assertEquals((Object)error, (Object)this.updatePasswordPage.getError());
        this.events.expectRequiredAction(EventType.UPDATE_PASSWORD_ERROR).error("password_rejected").user(this.userId).detail("username", "login-test").assertEvent().getSessionId();
    }

    private void initiateResetPasswordFromResetPasswordPage(String username) {
        this.loginPage.open();
        this.loginPage.resetPassword();
        this.resetPasswordPage.assertCurrent();
        this.resetPasswordPage.changePassword(username);
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"You should receive an email shortly with further instructions.", (Object)this.loginPage.getSuccessMessage());
        ++this.expectedMessagesCount;
    }

    @Test
    public void resetPasswordWrongEmail() throws IOException, MessagingException, InterruptedException {
        this.initiateResetPasswordFromResetPasswordPage("invalid");
        Assert.assertEquals((long)0L, (long)this.greenMail.getReceivedMessages().length);
        this.events.expectRequiredAction(EventType.RESET_PASSWORD).user((String)null).session((String)null).detail("username", "invalid").removeDetail("email").removeDetail("code_id").error("user_not_found").assertEvent();
    }

    @Test
    public void resetPasswordMissingUsername() throws IOException, MessagingException, InterruptedException {
        this.loginPage.open();
        this.loginPage.resetPassword();
        this.resetPasswordPage.assertCurrent();
        this.resetPasswordPage.changePassword("");
        this.resetPasswordPage.assertCurrent();
        Assert.assertEquals((Object)"Please specify username.", (Object)this.resetPasswordPage.getUsernameError());
        Assert.assertEquals((long)0L, (long)this.greenMail.getReceivedMessages().length);
        this.events.expectRequiredAction(EventType.RESET_PASSWORD).user((String)null).session((String)null).clearDetails().error("username_missing").assertEvent();
    }

    @Test
    public void resetPasswordExpiredCode() throws IOException, MessagingException, InterruptedException {
        this.initiateResetPasswordFromResetPasswordPage("login-test");
        this.events.expectRequiredAction(EventType.SEND_RESET_PASSWORD).session((String)null).user(this.userId).detail("username", "login-test").detail("email", "login@test.com").assertEvent();
        Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getReceivedMessages()[0];
        String changePasswordUrl = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
        try {
            this.setTimeOffset(1823);
            this.driver.navigate().to(changePasswordUrl.trim());
            this.loginPage.assertCurrent();
            Assert.assertEquals((Object)"Action expired. Please start again.", (Object)this.loginPage.getError());
            this.events.expectRequiredAction(EventType.EXECUTE_ACTION_TOKEN_ERROR).error("expired_code").client((String)null).user(this.userId).session((String)null).clearDetails().detail("action", "reset-credentials").assertEvent();
        }
        finally {
            this.setTimeOffset(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void resetPasswordExpiredCodeShort() throws IOException, MessagingException, InterruptedException {
        AtomicInteger originalValue = new AtomicInteger();
        RealmRepresentation realmRep = this.testRealm().toRepresentation();
        originalValue.set(realmRep.getActionTokenGeneratedByUserLifespan());
        realmRep.setActionTokenGeneratedByUserLifespan(Integer.valueOf(60));
        this.testRealm().update(realmRep);
        try {
            this.initiateResetPasswordFromResetPasswordPage("login-test");
            this.events.expectRequiredAction(EventType.SEND_RESET_PASSWORD).session((String)null).user(this.userId).detail("username", "login-test").detail("email", "login@test.com").assertEvent();
            Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
            MimeMessage message = this.greenMail.getReceivedMessages()[0];
            String changePasswordUrl = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
            this.setTimeOffset(70);
            this.driver.navigate().to(changePasswordUrl.trim());
            this.loginPage.assertCurrent();
            Assert.assertEquals((Object)"Action expired. Please start again.", (Object)this.loginPage.getError());
            this.events.expectRequiredAction(EventType.EXECUTE_ACTION_TOKEN_ERROR).error("expired_code").client((String)null).user(this.userId).session((String)null).clearDetails().detail("action", "reset-credentials").assertEvent();
        }
        finally {
            this.setTimeOffset(0);
            realmRep.setActionTokenGeneratedByUserLifespan(Integer.valueOf(originalValue.get()));
            this.testRealm().update(realmRep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void resetPasswordExpiredCodeShortPerActionLifespan() throws IOException, MessagingException, InterruptedException {
        RealmRepresentation realmRep = this.testRealm().toRepresentation();
        Map originalAttributes = Collections.unmodifiableMap(new HashMap(realmRep.getAttributes()));
        realmRep.setAttributes(UserActionTokenBuilder.create().resetCredentialsLifespan(60).build());
        this.testRealm().update(realmRep);
        try {
            this.initiateResetPasswordFromResetPasswordPage("login-test");
            this.events.expectRequiredAction(EventType.SEND_RESET_PASSWORD).session((String)null).user(this.userId).detail("username", "login-test").detail("email", "login@test.com").assertEvent();
            Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
            MimeMessage message = this.greenMail.getReceivedMessages()[0];
            String changePasswordUrl = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
            this.setTimeOffset(70);
            this.driver.navigate().to(changePasswordUrl.trim());
            this.loginPage.assertCurrent();
            Assert.assertEquals((Object)"Action expired. Please start again.", (Object)this.loginPage.getError());
            this.events.expectRequiredAction(EventType.EXECUTE_ACTION_TOKEN_ERROR).error("expired_code").client((String)null).user(this.userId).session((String)null).clearDetails().detail("action", "reset-credentials").assertEvent();
        }
        finally {
            this.setTimeOffset(0);
            realmRep.setAttributes(originalAttributes);
            this.testRealm().update(realmRep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void resetPasswordExpiredCodeShortPerActionMultipleTimeouts() throws IOException, MessagingException, InterruptedException {
        RealmRepresentation realmRep = this.testRealm().toRepresentation();
        Map originalAttributes = Collections.unmodifiableMap(new HashMap(realmRep.getAttributes()));
        realmRep.setAttributes(UserActionTokenBuilder.create().resetCredentialsLifespan(60).verifyEmailLifespan(300).build());
        this.testRealm().update(realmRep);
        try {
            this.initiateResetPasswordFromResetPasswordPage("login-test");
            this.events.expectRequiredAction(EventType.SEND_RESET_PASSWORD).session((String)null).user(this.userId).detail("username", "login-test").detail("email", "login@test.com").assertEvent();
            Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
            MimeMessage message = this.greenMail.getReceivedMessages()[0];
            String changePasswordUrl = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
            this.setTimeOffset(70);
            this.driver.navigate().to(changePasswordUrl.trim());
            this.loginPage.assertCurrent();
            Assert.assertEquals((Object)"Action expired. Please start again.", (Object)this.loginPage.getError());
            this.events.expectRequiredAction(EventType.EXECUTE_ACTION_TOKEN_ERROR).error("expired_code").client((String)null).user(this.userId).session((String)null).clearDetails().detail("action", "reset-credentials").assertEvent();
        }
        finally {
            this.setTimeOffset(0);
            realmRep.setAttributes(originalAttributes);
            this.testRealm().update(realmRep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void resetPasswordExpiredCodeAndAuthSession() throws IOException, MessagingException, InterruptedException {
        AtomicInteger originalValue = new AtomicInteger();
        RealmRepresentation realmRep = this.testRealm().toRepresentation();
        originalValue.set(realmRep.getActionTokenGeneratedByUserLifespan());
        realmRep.setActionTokenGeneratedByUserLifespan(Integer.valueOf(60));
        this.testRealm().update(realmRep);
        try {
            this.initiateResetPasswordFromResetPasswordPage("login-test");
            this.events.expectRequiredAction(EventType.SEND_RESET_PASSWORD).session((String)null).user(this.userId).detail("username", "login-test").detail("email", "login@test.com").assertEvent();
            Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
            MimeMessage message = this.greenMail.getReceivedMessages()[0];
            String changePasswordUrl = MailUtils.getPasswordResetEmailLink((MimeMessage)message).replace("&amp;", "&");
            this.setTimeOffset(70);
            this.log.debug((Object)"Going to reset password URI.");
            this.driver.navigate().to(OAuthClient.AUTH_SERVER_ROOT + "/realms/test/login-actions/reset-credentials");
            this.log.debug((Object)"Removing cookies.");
            this.driver.manage().deleteAllCookies();
            this.driver.navigate().to(changePasswordUrl.trim());
            this.errorPage.assertCurrent();
            Assert.assertEquals((Object)"Action expired.", (Object)this.errorPage.getError());
            String backToAppLink = this.errorPage.getBackToApplicationLink();
            Assert.assertTrue((boolean)backToAppLink.endsWith("/app/auth"));
            this.events.expectRequiredAction(EventType.EXECUTE_ACTION_TOKEN_ERROR).error("expired_code").client((String)null).user(this.userId).session((String)null).clearDetails().detail("action", "reset-credentials").assertEvent();
        }
        finally {
            this.setTimeOffset(0);
            realmRep.setActionTokenGeneratedByUserLifespan(Integer.valueOf(originalValue.get()));
            this.testRealm().update(realmRep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void resetPasswordExpiredCodeAndAuthSessionPerActionLifespan() throws IOException, MessagingException, InterruptedException {
        RealmRepresentation realmRep = this.testRealm().toRepresentation();
        Map originalAttributes = Collections.unmodifiableMap(new HashMap(realmRep.getAttributes()));
        realmRep.setAttributes(UserActionTokenBuilder.create().resetCredentialsLifespan(60).build());
        this.testRealm().update(realmRep);
        try {
            this.initiateResetPasswordFromResetPasswordPage("login-test");
            this.events.expectRequiredAction(EventType.SEND_RESET_PASSWORD).session((String)null).user(this.userId).detail("username", "login-test").detail("email", "login@test.com").assertEvent();
            Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
            MimeMessage message = this.greenMail.getReceivedMessages()[0];
            String changePasswordUrl = MailUtils.getPasswordResetEmailLink((MimeMessage)message).replace("&amp;", "&");
            this.setTimeOffset(70);
            this.log.debug((Object)"Going to reset password URI.");
            this.driver.navigate().to(OAuthClient.AUTH_SERVER_ROOT + "/realms/test/login-actions/reset-credentials");
            this.log.debug((Object)"Removing cookies.");
            this.driver.manage().deleteAllCookies();
            this.driver.navigate().to(changePasswordUrl.trim());
            this.errorPage.assertCurrent();
            Assert.assertEquals((Object)"Action expired.", (Object)this.errorPage.getError());
            String backToAppLink = this.errorPage.getBackToApplicationLink();
            Assert.assertTrue((boolean)backToAppLink.endsWith("/app/auth"));
            this.events.expectRequiredAction(EventType.EXECUTE_ACTION_TOKEN_ERROR).error("expired_code").client((String)null).user(this.userId).session((String)null).clearDetails().detail("action", "reset-credentials").assertEvent();
        }
        finally {
            this.setTimeOffset(0);
            realmRep.setAttributes(originalAttributes);
            this.testRealm().update(realmRep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void resetPasswordExpiredCodeAndAuthSessionPerActionMultipleTimeouts() throws IOException, MessagingException, InterruptedException {
        RealmRepresentation realmRep = this.testRealm().toRepresentation();
        Map originalAttributes = Collections.unmodifiableMap(new HashMap(realmRep.getAttributes()));
        realmRep.setAttributes(UserActionTokenBuilder.create().resetCredentialsLifespan(60).verifyEmailLifespan(300).build());
        this.testRealm().update(realmRep);
        try {
            this.initiateResetPasswordFromResetPasswordPage("login-test");
            this.events.expectRequiredAction(EventType.SEND_RESET_PASSWORD).session((String)null).user(this.userId).detail("username", "login-test").detail("email", "login@test.com").assertEvent();
            Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
            MimeMessage message = this.greenMail.getReceivedMessages()[0];
            String changePasswordUrl = MailUtils.getPasswordResetEmailLink((MimeMessage)message).replace("&amp;", "&");
            this.setTimeOffset(70);
            this.log.debug((Object)"Going to reset password URI.");
            this.driver.navigate().to(OAuthClient.AUTH_SERVER_ROOT + "/realms/test/login-actions/reset-credentials");
            this.log.debug((Object)"Removing cookies.");
            this.driver.manage().deleteAllCookies();
            this.driver.navigate().to(changePasswordUrl.trim());
            this.errorPage.assertCurrent();
            Assert.assertEquals((Object)"Action expired.", (Object)this.errorPage.getError());
            String backToAppLink = this.errorPage.getBackToApplicationLink();
            Assert.assertTrue((boolean)backToAppLink.endsWith("/app/auth"));
            this.events.expectRequiredAction(EventType.EXECUTE_ACTION_TOKEN_ERROR).error("expired_code").client((String)null).user(this.userId).session((String)null).clearDetails().detail("action", "reset-credentials").assertEvent();
        }
        finally {
            this.setTimeOffset(0);
            realmRep.setAttributes(originalAttributes);
            this.testRealm().update(realmRep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void resetPasswordExpiredCodeForgotPasswordFlow() throws IOException, MessagingException, InterruptedException {
        AtomicInteger originalValue = new AtomicInteger();
        RealmRepresentation realmRep = this.testRealm().toRepresentation();
        originalValue.set(realmRep.getActionTokenGeneratedByUserLifespan());
        realmRep.setActionTokenGeneratedByUserLifespan(Integer.valueOf(60));
        this.testRealm().update(realmRep);
        try {
            String loginUrl = this.oauth.getLoginFormUrl();
            String forgotPasswordUrl = loginUrl.replace("/auth?", "/forgot-credentials?");
            this.driver.navigate().to(forgotPasswordUrl);
            this.resetPasswordPage.assertCurrent();
            this.resetPasswordPage.changePassword("login-test");
            this.loginPage.assertCurrent();
            Assert.assertEquals((Object)"You should receive an email shortly with further instructions.", (Object)this.loginPage.getSuccessMessage());
            ++this.expectedMessagesCount;
            this.events.expectRequiredAction(EventType.SEND_RESET_PASSWORD).session((String)null).user(this.userId).detail("username", "login-test").detail("email", "login@test.com").assertEvent();
            Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
            MimeMessage message = this.greenMail.getReceivedMessages()[0];
            String changePasswordUrl = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
            this.setTimeOffset(70);
            this.driver.navigate().to(changePasswordUrl.trim());
            this.resetPasswordPage.assertCurrent();
            Assert.assertEquals((Object)"Action expired. Please start again.", (Object)this.loginPage.getError());
            this.events.expectRequiredAction(EventType.EXECUTE_ACTION_TOKEN_ERROR).error("expired_code").client((String)null).user(this.userId).session((String)null).clearDetails().detail("action", "reset-credentials").assertEvent();
        }
        finally {
            this.setTimeOffset(0);
            realmRep.setActionTokenGeneratedByUserLifespan(Integer.valueOf(originalValue.get()));
            this.testRealm().update(realmRep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void resetPasswordExpiredCodeForgotPasswordFlowPerActionLifespan() throws IOException, MessagingException, InterruptedException {
        RealmRepresentation realmRep = this.testRealm().toRepresentation();
        Map originalAttributes = Collections.unmodifiableMap(new HashMap(realmRep.getAttributes()));
        realmRep.setAttributes(UserActionTokenBuilder.create().resetCredentialsLifespan(60).build());
        this.testRealm().update(realmRep);
        try {
            String loginUrl = this.oauth.getLoginFormUrl();
            String forgotPasswordUrl = loginUrl.replace("/auth?", "/forgot-credentials?");
            this.driver.navigate().to(forgotPasswordUrl);
            this.resetPasswordPage.assertCurrent();
            this.resetPasswordPage.changePassword("login-test");
            this.loginPage.assertCurrent();
            Assert.assertEquals((Object)"You should receive an email shortly with further instructions.", (Object)this.loginPage.getSuccessMessage());
            ++this.expectedMessagesCount;
            this.events.expectRequiredAction(EventType.SEND_RESET_PASSWORD).session((String)null).user(this.userId).detail("username", "login-test").detail("email", "login@test.com").assertEvent();
            Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
            MimeMessage message = this.greenMail.getReceivedMessages()[0];
            String changePasswordUrl = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
            this.setTimeOffset(70);
            this.driver.navigate().to(changePasswordUrl.trim());
            this.resetPasswordPage.assertCurrent();
            Assert.assertEquals((Object)"Action expired. Please start again.", (Object)this.loginPage.getError());
            this.events.expectRequiredAction(EventType.EXECUTE_ACTION_TOKEN_ERROR).error("expired_code").client((String)null).user(this.userId).session((String)null).clearDetails().detail("action", "reset-credentials").assertEvent();
        }
        finally {
            this.setTimeOffset(0);
            realmRep.setAttributes(originalAttributes);
            this.testRealm().update(realmRep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void resetPasswordExpiredCodeForgotPasswordFlowPerActionMultipleTimeouts() throws IOException, MessagingException, InterruptedException {
        RealmRepresentation realmRep = this.testRealm().toRepresentation();
        Map originalAttributes = Collections.unmodifiableMap(new HashMap(realmRep.getAttributes()));
        realmRep.setAttributes(UserActionTokenBuilder.create().resetCredentialsLifespan(60).verifyEmailLifespan(300).build());
        this.testRealm().update(realmRep);
        try {
            String loginUrl = this.oauth.getLoginFormUrl();
            String forgotPasswordUrl = loginUrl.replace("/auth?", "/forgot-credentials?");
            this.driver.navigate().to(forgotPasswordUrl);
            this.resetPasswordPage.assertCurrent();
            this.resetPasswordPage.changePassword("login-test");
            this.loginPage.assertCurrent();
            Assert.assertEquals((Object)"You should receive an email shortly with further instructions.", (Object)this.loginPage.getSuccessMessage());
            ++this.expectedMessagesCount;
            this.events.expectRequiredAction(EventType.SEND_RESET_PASSWORD).session((String)null).user(this.userId).detail("username", "login-test").detail("email", "login@test.com").assertEvent();
            Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
            MimeMessage message = this.greenMail.getReceivedMessages()[0];
            String changePasswordUrl = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
            this.setTimeOffset(70);
            this.driver.navigate().to(changePasswordUrl.trim());
            this.resetPasswordPage.assertCurrent();
            Assert.assertEquals((Object)"Action expired. Please start again.", (Object)this.loginPage.getError());
            this.events.expectRequiredAction(EventType.EXECUTE_ACTION_TOKEN_ERROR).error("expired_code").client((String)null).user(this.userId).session((String)null).clearDetails().detail("action", "reset-credentials").assertEvent();
        }
        finally {
            this.setTimeOffset(0);
            realmRep.setAttributes(originalAttributes);
            this.testRealm().update(realmRep);
        }
    }

    @Test
    public void resetPasswordDisabledUser() throws IOException, MessagingException, InterruptedException {
        UserRepresentation user = this.findUser("login-test");
        try {
            user.setEnabled(Boolean.valueOf(false));
            this.updateUser(user);
            this.initiateResetPasswordFromResetPasswordPage("login-test");
            Assert.assertEquals((long)0L, (long)this.greenMail.getReceivedMessages().length);
            this.events.expectRequiredAction(EventType.RESET_PASSWORD).session((String)null).user(this.userId).detail("username", "login-test").removeDetail("code_id").error("user_disabled").assertEvent();
        }
        finally {
            user.setEnabled(Boolean.valueOf(true));
            this.updateUser(user);
        }
    }

    @Test
    public void resetPasswordNoEmail() throws IOException, MessagingException, InterruptedException {
        UserRepresentation user = this.findUser("login-test");
        String email = user.getEmail();
        try {
            user.setEmail("");
            this.updateUser(user);
            this.initiateResetPasswordFromResetPasswordPage("login-test");
            Assert.assertEquals((long)0L, (long)this.greenMail.getReceivedMessages().length);
            this.events.expectRequiredAction(EventType.RESET_PASSWORD_ERROR).session((String)null).user(this.userId).detail("username", "login-test").removeDetail("code_id").error("invalid_email").assertEvent();
        }
        finally {
            user.setEmail(email);
            this.updateUser(user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void resetPasswordWrongSmtp() throws IOException, MessagingException, InterruptedException {
        String[] host = new String[1];
        HashMap<String, String> smtpConfig = new HashMap<String, String>();
        smtpConfig.putAll(this.testRealm().toRepresentation().getSmtpServer());
        host[0] = (String)smtpConfig.get("host");
        smtpConfig.put("host", "invalid_host");
        RealmRepresentation realmRep = this.testRealm().toRepresentation();
        Map oldSmtp = realmRep.getSmtpServer();
        try {
            realmRep.setSmtpServer(smtpConfig);
            this.testRealm().update(realmRep);
            this.loginPage.open();
            this.loginPage.resetPassword();
            this.resetPasswordPage.assertCurrent();
            this.resetPasswordPage.changePassword("login-test");
            this.errorPage.assertCurrent();
            Assert.assertEquals((Object)"Failed to send email, please try again later.", (Object)this.errorPage.getError());
            Assert.assertEquals((long)0L, (long)this.greenMail.getReceivedMessages().length);
            this.events.expectRequiredAction(EventType.SEND_RESET_PASSWORD_ERROR).user(this.userId).session((String)null).detail("username", "login-test").removeDetail("code_id").error("email_send_failed").assertEvent();
        }
        finally {
            realmRep.setSmtpServer(oldSmtp);
            this.testRealm().update(realmRep);
        }
    }

    private void setPasswordPolicy(String policy) {
        RealmRepresentation realmRep = this.testRealm().toRepresentation();
        realmRep.setPasswordPolicy(policy);
        this.testRealm().update(realmRep);
    }

    @Test
    public void resetPasswordWithLengthPasswordPolicy() throws IOException, MessagingException {
        this.setPasswordPolicy("length");
        this.initiateResetPasswordFromResetPasswordPage("login-test");
        Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getReceivedMessages()[0];
        String changePasswordUrl = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
        this.events.expectRequiredAction(EventType.SEND_RESET_PASSWORD).session((String)null).user(this.userId).detail("username", "login-test").detail("email", "login@test.com").assertEvent();
        this.driver.navigate().to(changePasswordUrl.trim());
        this.updatePasswordPage.assertCurrent();
        this.updatePasswordPage.changePassword("invalid", "invalid");
        Assert.assertEquals((Object)"Invalid password: minimum length 8.", (Object)this.resetPasswordPage.getErrorMessage());
        this.events.expectRequiredAction(EventType.UPDATE_PASSWORD_ERROR).error("password_rejected").user(this.userId).detail("username", "login-test").assertEvent().getSessionId();
        this.updatePasswordPage.changePassword("resetPasswordWithPasswordPolicy", "resetPasswordWithPasswordPolicy");
        this.events.expectRequiredAction(EventType.UPDATE_PASSWORD).user(this.userId).detail("username", "login-test").assertEvent().getSessionId();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        String sessionId = this.events.expectLogin().user(this.userId).detail("username", "login-test").assertEvent().getSessionId();
        this.oauth.openLogout();
        this.events.expectLogout(sessionId).user(this.userId).session(sessionId).assertEvent();
        this.loginPage.open();
        this.loginPage.login("login-test", "resetPasswordWithPasswordPolicy");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().user(this.userId).detail("username", "login-test").assertEvent();
    }

    @Test
    public void resetPasswordWithPasswordHistoryPolicy() throws IOException, MessagingException {
        this.setPasswordPolicy("passwordHistory");
        try {
            this.setTimeOffset(2000000);
            this.resetPassword("login-test", "password1");
            this.resetPasswordInvalidPassword("login-test", "password1", "Invalid password: must not be equal to any of last 3 passwords.");
            this.setTimeOffset(4000000);
            this.resetPassword("login-test", "password2");
            this.resetPasswordInvalidPassword("login-test", "password1", "Invalid password: must not be equal to any of last 3 passwords.");
            this.resetPasswordInvalidPassword("login-test", "password2", "Invalid password: must not be equal to any of last 3 passwords.");
            this.setTimeOffset(6000000);
            this.resetPassword("login-test", "password3");
            this.resetPasswordInvalidPassword("login-test", "password1", "Invalid password: must not be equal to any of last 3 passwords.");
            this.resetPasswordInvalidPassword("login-test", "password2", "Invalid password: must not be equal to any of last 3 passwords.");
            this.resetPasswordInvalidPassword("login-test", "password3", "Invalid password: must not be equal to any of last 3 passwords.");
            this.setTimeOffset(8000000);
            this.resetPassword("login-test", "password");
        }
        finally {
            this.setTimeOffset(0);
        }
    }

    @Test
    public void resetPasswordLinkOpenedInNewBrowser() throws IOException, MessagingException {
        this.resetPasswordLinkOpenedInNewBrowser("account");
    }

    private void resetPasswordLinkOpenedInNewBrowser(String expectedSystemClientId) throws IOException, MessagingException {
        String username = "login-test";
        String resetUri = OAuthClient.AUTH_SERVER_ROOT + "/realms/test/login-actions/reset-credentials";
        this.driver.navigate().to(resetUri);
        this.resetPasswordPage.assertCurrent();
        this.resetPasswordPage.changePassword(username);
        this.log.info((Object)"Should be at login page again.");
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"You should receive an email shortly with further instructions.", (Object)this.loginPage.getSuccessMessage());
        this.events.expectRequiredAction(EventType.SEND_RESET_PASSWORD).user(this.userId).detail("redirect_uri", OAuthClient.AUTH_SERVER_ROOT + "/realms/test/account/").client(expectedSystemClientId).detail("username", username).detail("email", "login@test.com").session((String)null).assertEvent();
        Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getReceivedMessages()[0];
        String changePasswordUrl = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
        this.log.debug((Object)"Going to reset password URI.");
        this.driver.navigate().to(resetUri);
        this.log.debug((Object)"Removing cookies.");
        this.driver.manage().deleteAllCookies();
        this.log.debug((Object)"Going to URI from e-mail.");
        this.driver.navigate().to(changePasswordUrl.trim());
        this.updatePasswordPage.assertCurrent();
        this.updatePasswordPage.changePassword("resetPassword", "resetPassword");
        this.infoPage.assertCurrent();
        Assert.assertEquals((Object)"Your account has been updated.", (Object)this.infoPage.getInfo());
    }

    @Test
    public void resetPasswordLinkOpenedInNewBrowserAndAccountClientRenamed() throws IOException, MessagingException {
        try (ServerResourceUpdater accountClientUpdater = ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"test", (String)"account").setClientId("account-changed").update();){
            this.resetPasswordLinkOpenedInNewBrowser("_system");
        }
    }

    @Test
    public void resetPasswordLinkNewBrowserSessionPreserveClient() throws IOException, MessagingException {
        this.loginPage.open();
        this.loginPage.resetPassword();
        this.resetPasswordPage.assertCurrent();
        this.resetPasswordPage.changePassword("login-test");
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"You should receive an email shortly with further instructions.", (Object)this.loginPage.getSuccessMessage());
        Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getReceivedMessages()[0];
        String changePasswordUrl = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
        this.driver2.navigate().to(changePasswordUrl.trim());
        this.changePasswordOnUpdatePage(this.driver2);
        MatcherAssert.assertThat((Object)this.driver2.getCurrentUrl(), (Matcher)Matchers.containsString((String)"client_id=test-app"));
        MatcherAssert.assertThat((Object)this.driver2.getPageSource(), (Matcher)Matchers.containsString((String)"Your account has been updated."));
    }

    @Test
    public void resetPasswordWithSpnegoEnabled() throws IOException, MessagingException {
        AuthenticationExecutionModel.Requirement origRequirement = AbstractKerberosTest.updateKerberosAuthExecutionRequirement(AuthenticationExecutionModel.Requirement.ALTERNATIVE, this.testRealm());
        try {
            this.resetPassword("login-test");
        }
        finally {
            AbstractKerberosTest.updateKerberosAuthExecutionRequirement(origRequirement, this.testRealm());
        }
    }

    @Test
    public void failResetPasswordServiceAccount() {
        String username = "service-account-client-user";
        UserRepresentation serviceAccount = (UserRepresentation)this.testRealm().users().search(username).get(0);
        serviceAccount.toString();
        UserResource serviceAccount1 = this.testRealm().users().get(serviceAccount.getId());
        serviceAccount = serviceAccount1.toRepresentation();
        serviceAccount.setEmail("client-user@test.com");
        serviceAccount1.update(serviceAccount);
        String resetUri = OAuthClient.AUTH_SERVER_ROOT + "/realms/test/login-actions/reset-credentials";
        this.driver.navigate().to(resetUri);
        this.resetPasswordPage.assertCurrent();
        this.resetPasswordPage.changePassword(username);
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.errorPage.getError());
    }

    @Test
    @DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
    public void resetPasswordLinkNewTabAndProperRedirectAccount() throws IOException {
        String REQUIRED_URI = OAuthClient.AUTH_SERVER_ROOT + "/realms/test/account/applications";
        String REDIRECT_URI = this.getAccountRedirectUrl() + "?path=applications";
        String CLIENT_ID = "account";
        String ACCOUNT_MANAGEMENT_TITLE = this.getProjectName() + " Account Management";
        try (BrowserTabUtil tabUtil = BrowserTabUtil.getInstanceAndSetEnv((WebDriver)this.driver);){
            MatcherAssert.assertThat((Object)tabUtil.getCountOfTabs(), (Matcher)Matchers.is((Object)1));
            this.driver.navigate().to(REQUIRED_URI);
            this.resetPasswordTwiceInNewTab(this.defaultUser, "account", false, REDIRECT_URI, REQUIRED_URI);
            MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)ACCOUNT_MANAGEMENT_TITLE));
            this.oauth.openLogout();
            this.driver.navigate().to(REQUIRED_URI);
            this.resetPasswordTwiceInNewTab(this.defaultUser, "account", true, REDIRECT_URI, REQUIRED_URI);
            MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.equalTo((Object)ACCOUNT_MANAGEMENT_TITLE));
        }
    }

    @Test
    public void resetPasswordLinkNewTabAndProperRedirectClient() throws IOException {
        String REDIRECT_URI = this.getAuthServerRoot() + "realms/master/app/auth";
        String CLIENT_ID = "test-app";
        try (BrowserTabUtil tabUtil = BrowserTabUtil.getInstanceAndSetEnv((WebDriver)this.driver);
             ClientAttributeUpdater cau = (ClientAttributeUpdater)ClientAttributeUpdater.forClient((Keycloak)this.getAdminClient(), (String)"test", (String)"test-app").filterRedirectUris(uri -> uri.contains(REDIRECT_URI)).update();){
            MatcherAssert.assertThat((Object)tabUtil.getCountOfTabs(), (Matcher)Matchers.is((Object)1));
            this.loginPage.open();
            this.resetPasswordTwiceInNewTab(this.defaultUser, "test-app", false, REDIRECT_URI);
            MatcherAssert.assertThat((Object)this.driver.getCurrentUrl(), (Matcher)Matchers.containsString((String)REDIRECT_URI));
            this.oauth.openLogout();
            this.loginPage.open();
            this.resetPasswordTwiceInNewTab(this.defaultUser, "test-app", true, REDIRECT_URI);
            MatcherAssert.assertThat((Object)this.driver.getCurrentUrl(), (Matcher)Matchers.containsString((String)REDIRECT_URI));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void resetPasswordInfoMessageWithDuplicateEmailsAllowed() throws IOException {
        RealmRepresentation realmRep = this.testRealm().toRepresentation();
        Boolean originalLoginWithEmailAllowed = realmRep.isLoginWithEmailAllowed();
        Boolean originalDuplicateEmailsAllowed = realmRep.isDuplicateEmailsAllowed();
        try {
            this.loginPage.open();
            this.loginPage.resetPassword();
            this.resetPasswordPage.assertCurrent();
            Assert.assertEquals((Object)"Enter your username or email address and we will send you instructions on how to create a new password.", (Object)this.resetPasswordPage.getInfoMessage());
            realmRep.setLoginWithEmailAllowed(Boolean.valueOf(false));
            realmRep.setDuplicateEmailsAllowed(Boolean.valueOf(true));
            this.testRealm().update(realmRep);
            this.loginPage.open();
            this.loginPage.resetPassword();
            this.resetPasswordPage.assertCurrent();
            Assert.assertEquals((Object)"Enter your username and we will send you instructions on how to create a new password.", (Object)this.resetPasswordPage.getInfoMessage());
        }
        finally {
            realmRep.setLoginWithEmailAllowed(originalLoginWithEmailAllowed);
            realmRep.setDuplicateEmailsAllowed(originalDuplicateEmailsAllowed);
            this.testRealm().update(realmRep);
        }
    }

    @Test
    public void changeEmailAddressAfterSendingEmail() throws IOException {
        this.initiateResetPasswordFromResetPasswordPage(this.defaultUser.getUsername());
        Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getReceivedMessages()[0];
        String changePasswordUrl = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
        UserResource user = this.testRealm().users().get(this.defaultUser.getId());
        UserRepresentation userRep = user.toRepresentation();
        userRep.setEmail("vmuzikar@redhat.com");
        user.update(userRep);
        this.driver.navigate().to(changePasswordUrl.trim());
        this.errorPage.assertCurrent();
        Assert.assertEquals((Object)"Invalid email address.", (Object)this.errorPage.getError());
    }

    @Test
    public void resetPasswordWithLoginHint() throws IOException {
        String loginUrl = this.oauth.getLoginFormUrl();
        String forgotPasswordUrl = loginUrl.replace("/auth?", "/forgot-credentials?");
        this.driver.navigate().to(forgotPasswordUrl + "&login_hint=test");
        this.resetPasswordPage.assertCurrent();
        Assert.assertEquals((Object)"test", (Object)this.resetPasswordPage.getUsername());
    }

    private void changePasswordOnUpdatePage(WebDriver driver) {
        MatcherAssert.assertThat((Object)driver.getPageSource(), (Matcher)Matchers.containsString((String)"You need to change your password."));
        WebElement newPassword = driver.findElement(By.id((String)"password-new"));
        newPassword.sendKeys(new CharSequence[]{"resetPassword"});
        WebElement confirmPassword = driver.findElement(By.id((String)"password-confirm"));
        confirmPassword.sendKeys(new CharSequence[]{"resetPassword"});
        WebElement submit = driver.findElement(By.cssSelector((String)"input[type=\"submit\"]"));
        submit.click();
    }

    private void resetPasswordTwiceInNewTab(UserRepresentation user, String clientId, boolean shouldLogOut, String redirectUri) throws IOException {
        this.resetPasswordTwiceInNewTab(user, clientId, shouldLogOut, redirectUri, redirectUri);
    }

    private void resetPasswordTwiceInNewTab(UserRepresentation user, String clientId, boolean shouldLogOut, String redirectUri, String requiredUri) throws IOException {
        this.events.clear();
        this.updateForgottenPassword(user, clientId, redirectUri, requiredUri);
        if (shouldLogOut) {
            String sessionId = this.events.expectLogin().user(user.getId()).detail("username", user.getUsername()).detail("redirect_uri", redirectUri).client(clientId).assertEvent().getSessionId();
            this.oauth.openLogout();
            this.events.expectLogout(sessionId).user(user.getId()).session(sessionId).assertEvent();
        }
        BrowserTabUtil util = BrowserTabUtil.getInstanceAndSetEnv((WebDriver)this.driver);
        MatcherAssert.assertThat((Object)util.getCountOfTabs(), (Matcher)Matchers.equalTo((Object)2));
        util.closeTab(1);
        MatcherAssert.assertThat((Object)util.getCountOfTabs(), (Matcher)Matchers.equalTo((Object)1));
        if (shouldLogOut) {
            ClientRepresentation client = this.testRealm().clients().findByClientId(clientId).stream().findFirst().orElse(null);
            MatcherAssert.assertThat((Object)client, (Matcher)Matchers.notNullValue());
            this.updateForgottenPassword(user, clientId, this.getValidRedirectUriWithRootUrl(client.getRootUrl(), client.getRedirectUris()));
        } else {
            this.doForgotPassword(user.getUsername());
        }
    }

    private void updateForgottenPassword(UserRepresentation user, String clientId, String redirectUri) throws IOException {
        this.updateForgottenPassword(user, clientId, redirectUri, redirectUri);
    }

    private void updateForgottenPassword(UserRepresentation user, String clientId, String redirectUri, String requiredUri) throws IOException {
        int emailCount = this.greenMail.getReceivedMessages().length;
        this.doForgotPassword(user.getUsername());
        Assert.assertEquals((Object)"You should receive an email shortly with further instructions.", (Object)this.loginPage.getSuccessMessage());
        this.events.expectRequiredAction(EventType.SEND_RESET_PASSWORD).user(user.getId()).client(clientId).detail("redirect_uri", redirectUri).detail("username", user.getUsername()).detail("email", user.getEmail()).session((String)null).assertEvent();
        Assert.assertEquals((long)(emailCount + 1), (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getReceivedMessages()[emailCount];
        String changePasswordUrl = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
        BrowserTabUtil util = BrowserTabUtil.getInstanceAndSetEnv((WebDriver)this.driver);
        util.newTab(changePasswordUrl.trim());
        this.changePasswordOnUpdatePage(this.driver);
        this.events.expectRequiredAction(EventType.UPDATE_PASSWORD).detail("redirect_uri", redirectUri).client(clientId).user(user.getId()).detail("username", user.getUsername()).assertEvent();
        MatcherAssert.assertThat((Object)this.driver.getCurrentUrl(), (Matcher)Matchers.containsString((String)requiredUri));
    }

    private void doForgotPassword(String username) {
        this.loginPage.assertCurrent();
        this.loginPage.resetPassword();
        this.resetPasswordPage.assertCurrent();
        this.resetPasswordPage.changePassword(username);
        WaitUtils.waitForPageToLoad();
    }

    private String getValidRedirectUriWithRootUrl(String rootUrl, Collection<String> redirectUris) {
        boolean isRootUrlValid = this.isValidUrl(rootUrl);
        return redirectUris.stream().map(uri -> isRootUrlValid && uri.startsWith("/") ? rootUrl + uri : uri).map(uri -> uri.startsWith("/") ? OAuthClient.AUTH_SERVER_ROOT + uri : uri).map(RedirectUtils::validateRedirectUriWildcard).findFirst().orElse(null);
    }

    private boolean isValidUrl(String url) {
        try {
            new URL(url);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }
}

