/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.mail.internet.MimeMessage;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.Profile;
import org.keycloak.models.UserManager;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.admin.authentication.AbstractAuthenticationTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.forms.MultiFactorAuthenticationTest;
import org.keycloak.testsuite.pages.AccountTotpPage;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.LoginConfigTotpPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginPasswordResetPage;
import org.keycloak.testsuite.pages.LoginPasswordUpdatePage;
import org.keycloak.testsuite.pages.LoginTotpPage;
import org.keycloak.testsuite.pages.LoginUsernameOnlyPage;
import org.keycloak.testsuite.pages.PasswordPage;
import org.keycloak.testsuite.pages.RegisterPage;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.FlowUtil;
import org.keycloak.testsuite.util.GreenMailRule;
import org.keycloak.testsuite.util.MailUtils;
import org.keycloak.testsuite.util.URLUtils;
import org.keycloak.testsuite.util.UserBuilder;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class ResetCredentialsAlternativeFlowsTest
extends AbstractTestRealmKeycloakTest {
    private String userId;
    @Rule
    public GreenMailRule greenMail = new GreenMailRule();
    @Page
    protected LoginPage loginPage;
    @Page
    protected LoginUsernameOnlyPage loginUsernameOnlyPage;
    @Page
    protected PasswordPage passwordPage;
    @Page
    protected RegisterPage registerPage;
    @Page
    protected LoginPasswordResetPage resetPasswordPage;
    @Page
    protected LoginPasswordUpdatePage updatePasswordPage;
    @Page
    protected AccountTotpPage accountTotpPage;
    @Page
    protected LoginConfigTotpPage totpPage;
    @Page
    protected LoginTotpPage loginTotpPage;
    @Page
    protected ErrorPage errorPage;
    @Page
    protected AppPage appPage;
    protected TimeBasedOTP totp = new TimeBasedOTP();

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Before
    public void setup() {
        this.log.info((Object)"Adding login-test user");
        UserRepresentation user = UserBuilder.create().username("login-test").email("login@test.com").enabled(true).build();
        this.userId = ApiUtil.createUserAndResetPasswordWithAdminClient((RealmResource)this.testRealm(), (UserRepresentation)user, (String)"password");
        this.getCleanup().addUserId(this.userId);
    }

    @Test
    public void testNotExistingUserProvidedInResetCredentialsFlow() {
        try {
            MultiFactorAuthenticationTest.configureBrowserFlowWithAlternativeCredentials(this.testingClient);
            this.provideUsernameAndClickResetPassword("login-test");
            this.resetPasswordPage.changePassword("non-existent");
            this.loginUsernameOnlyPage.assertCurrent();
            Assert.assertEquals((Object)"You should receive an email shortly with further instructions.", (Object)this.loginUsernameOnlyPage.getSuccessMessage());
            Assert.assertEquals((long)0L, (long)this.greenMail.getReceivedMessages().length);
        }
        finally {
            this.revertFlows();
        }
    }

    @Test
    public void testDifferentUserProvidedInResetCredentialsFlow() {
        try {
            MultiFactorAuthenticationTest.configureBrowserFlowWithAlternativeCredentials(this.testingClient);
            this.provideUsernameAndClickResetPassword("login-test");
            this.resetPasswordPage.changePassword("test-user@localhost");
            this.errorPage.assertCurrent();
            Assert.assertEquals((long)0L, (long)this.greenMail.getReceivedMessages().length);
        }
        finally {
            this.revertFlows();
        }
    }

    @Test
    public void testSameUserProvidedInResetCredentialsFlow() {
        try {
            MultiFactorAuthenticationTest.configureBrowserFlowWithAlternativeCredentials(this.testingClient);
            this.provideUsernameAndClickResetPassword("login-test");
            this.resetPasswordPage.changePassword("login-test");
            this.loginUsernameOnlyPage.assertCurrent();
            Assert.assertEquals((Object)"You should receive an email shortly with further instructions.", (Object)this.loginUsernameOnlyPage.getSuccessMessage());
            Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        }
        finally {
            this.revertFlows();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResetCredentialsFlowWithUsernameProvidedFromBrowserFlow() throws Exception {
        try {
            MultiFactorAuthenticationTest.configureBrowserFlowWithAlternativeCredentials(this.testingClient);
            String newFlowAlias = "resetcred - alternative";
            this.configureResetCredentialsRemoveExecutionsAndBindTheFlow("resetcred - alternative", Arrays.asList("reset-credentials-choose-user"));
            this.loginUsernameOnlyPage.open();
            this.loginUsernameOnlyPage.login("login-test");
            Assert.assertTrue((boolean)this.passwordPage.isCurrent());
            this.passwordPage.clickResetPassword();
            this.loginUsernameOnlyPage.assertCurrent();
            Assert.assertEquals((Object)"You should receive an email shortly with further instructions.", (Object)this.loginUsernameOnlyPage.getSuccessMessage());
            Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
            MimeMessage message = this.greenMail.getReceivedMessages()[0];
            String changePasswordUrl = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
            this.driver.navigate().to(changePasswordUrl.trim());
            this.updatePasswordPage.assertCurrent();
            this.updatePasswordPage.changePassword("resetPassword", "resetPassword");
            Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
            Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        }
        finally {
            this.revertFlows();
        }
    }

    private void provideUsernameAndClickResetPassword(String username) {
        this.loginUsernameOnlyPage.open();
        this.loginUsernameOnlyPage.login(username);
        Assert.assertTrue((boolean)this.passwordPage.isCurrent());
        this.passwordPage.clickResetPassword();
        this.resetPasswordPage.assertCurrent();
        Assert.assertTrue((boolean)URLUtils.currentUrlMatches((String)"/login-actions/reset-credentials"));
    }

    private void revertFlows() {
        List flows = this.testRealm().flows().getFlows();
        RealmRepresentation realm = this.testRealm().toRepresentation();
        realm.setBrowserFlow("browser");
        realm.setResetCredentialsFlow("reset credentials");
        this.testRealm().update(realm);
        List<String> aliasesOfExistingFlows = Arrays.asList("browser - alternative", "resetcred - alternative", "resetcred - KEYCLOAK-11753 - test");
        for (String existingFlowAlias : aliasesOfExistingFlows) {
            AuthenticationFlowRepresentation flowRepresentation = AbstractAuthenticationTest.findFlowByAlias(existingFlowAlias, flows);
            if (flowRepresentation == null) continue;
            this.testRealm().flows().deleteFlow(flowRepresentation.getId());
        }
    }

    private void configureResetCredentialsRemoveExecutionsAndBindTheFlow(String newFlowAlias, List<String> providerIdsToRemove) {
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> {
            if (session.getContext().getRealm().getFlowByAlias(newFlowAlias) == null) {
                FlowUtil.inCurrentRealm(session).copyResetCredentialsFlow(newFlowAlias);
            }
        });
        for (String providerId : providerIdsToRemove) {
            int executionIndex = this.realmsResouce().realm("test").flows().getExecutions(newFlowAlias).stream().filter(e -> e.getProviderId().equals(providerId)).mapToInt(e -> e.getIndex()).findFirst().getAsInt();
            this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).selectFlow(newFlowAlias).removeExecution(executionIndex));
        }
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).selectFlow(newFlowAlias).defineAsResetCredentialsFlow());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
    public void resetCredentialsVerifyCustomOtpLabelSetProperly() {
        try {
            String newFlowAlias = "resetcred - KEYCLOAK-11753 - test";
            this.configureResetCredentialsRemoveExecutionsAndBindTheFlow("resetcred - KEYCLOAK-11753 - test", Arrays.asList("reset-credential-email", "reset-password"));
            this.loginPage.open();
            this.loginPage.login("login@test.com", "password");
            this.accountTotpPage.open();
            Assert.assertTrue((boolean)this.accountTotpPage.isCurrent());
            String customOtpLabel = "my-original-otp-label";
            this.accountTotpPage.configure(this.totp.generateTOTP(this.accountTotpPage.getTotpSecret()), customOtpLabel);
            this.oauth.openLogout();
            this.loginPage.open();
            this.loginPage.resetPassword();
            Assert.assertTrue((boolean)this.resetPasswordPage.isCurrent());
            this.resetPasswordPage.changePassword("login@test.com");
            Assert.assertTrue((boolean)this.totpPage.isCurrent());
            customOtpLabel = "my-reset-otp-label";
            this.totpPage.configure(this.totp.generateTOTP(this.totpPage.getTotpSecret()), customOtpLabel);
            this.accountTotpPage.open();
            Assert.assertTrue((boolean)this.accountTotpPage.isCurrent());
            String pageSource = this.driver.getPageSource();
            Assert.assertTrue((boolean)pageSource.contains(customOtpLabel));
        }
        finally {
            this.revertFlows();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
    public void deviceNameOptionalForFirstOTPCredentialButRequiredForEachNextOne() {
        RequiredActionProviderRepresentation otpRequiredAction = this.testRealm().flows().getRequiredAction("CONFIGURE_TOTP");
        otpRequiredAction.setDefaultAction(true);
        this.testRealm().flows().updateRequiredAction("CONFIGURE_TOTP", otpRequiredAction);
        try {
            String newFlowAlias = "resetcred - KEYCLOAK-12168 - firstOTP - account - test";
            this.configureResetCredentialsRemoveExecutionsAndBindTheFlow("resetcred - KEYCLOAK-12168 - firstOTP - account - test", Arrays.asList("reset-credential-email", "reset-password"));
            this.loginPage.open();
            this.loginPage.login("login@test.com", "password");
            this.accountTotpPage.open();
            Assert.assertTrue((boolean)this.accountTotpPage.isCurrent());
            String pageSource = this.driver.getPageSource();
            String oneTimeCodeLabelFollowedByAsterisk = "(?s)<label for=\"totp\"((?!</span>).)+((?=<span class=\"required\">\\*).)*";
            Assert.assertTrue((boolean)Pattern.compile("(?s)<label for=\"totp\"((?!</span>).)+((?=<span class=\"required\">\\*).)*").matcher(pageSource).find());
            String asteriskPrecededByDeviceNameLabel = "(?s)((?<=<label for=\"userLabel\").)+.*<span class=\"required\">\\s+\\*";
            Assert.assertFalse((boolean)Pattern.compile("(?s)((?<=<label for=\"userLabel\").)+.*<span class=\"required\">\\s+\\*").matcher(pageSource).find());
            String emptyOtpLabel = "";
            this.accountTotpPage.configure(this.totp.generateTOTP(this.accountTotpPage.getTotpSecret()), "");
            pageSource = this.driver.getPageSource();
            Assert.assertThat(this.driver.findElements(By.className((String)"provider")).stream().map(WebElement::getText).collect(Collectors.toList()), (Matcher)Matchers.hasItem((Object)""));
            this.accountTotpPage.removeTotp();
            this.oauth.openLogout();
            this.loginPage.open();
            this.loginPage.clickRegister();
            this.registerPage.assertCurrent();
            this.registerPage.register("Bruce", "Wilson", "bwilson@keycloak.org", "bwilson", "password", "password");
            Assert.assertTrue((boolean)this.totpPage.isCurrent());
            pageSource = this.driver.getPageSource();
            Assert.assertTrue((boolean)Pattern.compile("(?s)<label for=\"totp\"((?!</span>).)+((?=<span class=\"required\">\\*).)*").matcher(pageSource).find());
            Assert.assertFalse((boolean)Pattern.compile("(?s)((?<=<label for=\"userLabel\").)+.*<span class=\"required\">\\s+\\*").matcher(pageSource).find());
            this.totpPage.configure(this.totp.generateTOTP(this.accountTotpPage.getTotpSecret()), "");
            Assert.assertNull((Object)this.totpPage.getAlertError());
            Assert.assertNull((Object)this.totpPage.getInputCodeError());
            Assert.assertNull((Object)this.totpPage.getInputLabelError());
            this.appPage.assertCurrent();
            Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
            Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
            this.accountTotpPage.open();
            Assert.assertTrue((boolean)this.accountTotpPage.isCurrent());
            Assert.assertThat(this.driver.findElements(By.className((String)"provider")).stream().map(WebElement::getText).collect(Collectors.toList()), (Matcher)Matchers.hasItem((Object)""));
            this.oauth.openLogout();
            this.loginPage.open();
            this.loginPage.resetPassword();
            Assert.assertTrue((boolean)this.resetPasswordPage.isCurrent());
            this.resetPasswordPage.changePassword("bwilson@keycloak.org");
            pageSource = this.driver.getPageSource();
            Assert.assertTrue((boolean)Pattern.compile("(?s)<label for=\"totp\"((?!</span>).)+((?=<span class=\"required\">\\*).)*").matcher(pageSource).find());
            String deviceNameLabelFollowedByAsterisk = "(?s)<label for=\"userLabel\"((?!</span>).)+((?=<span class=\"required\">\\*).)*";
            Assert.assertTrue((boolean)Pattern.compile("(?s)<label for=\"userLabel\"((?!</span>).)+((?=<span class=\"required\">\\*).)*").matcher(pageSource).find());
            String deviceNameLabelRequiredErrorMessage = "Please specify device name.";
            this.totpPage.configure(this.totp.generateTOTP(this.accountTotpPage.getTotpSecret()), "");
            Assert.assertTrue((boolean)this.totpPage.getInputLabelError().equals("Please specify device name."));
            String secondOtpLabel = "My 2nd OTP device";
            this.totpPage.configure(this.totp.generateTOTP(this.accountTotpPage.getTotpSecret()), "My 2nd OTP device");
            Assert.assertNull((Object)this.totpPage.getAlertError());
            Assert.assertNull((Object)this.totpPage.getInputCodeError());
            Assert.assertNull((Object)this.totpPage.getInputLabelError());
            this.appPage.assertCurrent();
            Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
            Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
            this.accountTotpPage.open();
            Assert.assertTrue((boolean)this.accountTotpPage.isCurrent());
            pageSource = this.driver.getPageSource();
            Assert.assertTrue((boolean)pageSource.contains("My 2nd OTP device"));
            this.accountTotpPage.removeTotp();
            this.accountTotpPage.removeTotp();
            this.oauth.openLogout();
        }
        finally {
            this.revertFlows();
            otpRequiredAction.setDefaultAction(false);
            this.testRealm().flows().updateRequiredAction("CONFIGURE_TOTP", otpRequiredAction);
            this.testingClient.server("test").run((RunOnServer & Serializable)session -> {
                UserManager um = new UserManager(session);
                UserModel user = session.users().getUserByUsername(session.getContext().getRealm(), "bwilson");
                if (user != null) {
                    um.removeUser(session.getContext().getRealm(), user);
                }
            });
        }
    }
}

