/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.common.Profile;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.EnableFeature;
import org.keycloak.testsuite.forms.RegisterTest;
import org.keycloak.testsuite.forms.VerifyProfileTest;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.util.ClientScopeBuilder;
import org.keycloak.testsuite.util.KeycloakModelUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

@EnableFeature(value=Profile.Feature.DECLARATIVE_USER_PROFILE)
@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class RegisterWithUserProfileTest
extends RegisterTest {
    private static final String SCOPE_LAST_NAME = "lastName";
    private static ClientRepresentation client_scope_default;
    private static ClientRepresentation client_scope_optional;
    public static String UP_CONFIG_BASIC_ATTRIBUTES;
    public static final String UP_CONFIG_PART_INPUT_TYPES = "{\"name\": \"defaultType\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"placeholderAttribute\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"annotations\":{\"inputType\":\"text\",\"inputTypePlaceholder\":\"Example.\"}},{\"name\": \"helperTexts\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"annotations\":{\"inputType\":\"text\",\"inputHelperTextBefore\":\"Example <b>bold text</b> before.\",\"inputHelperTextAfter\":\"Example <i>i text</i> after.\"}},{\"name\": \"textWithBasicAttributes\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"annotations\":{\"inputType\":\"text\",\"inputTypeSize\":\"35\",\"inputTypeMinlength\":\"1\",\"inputTypeMaxlength\":\"10\",\"inputTypePattern\":\".*\"}},{\"name\": \"html5NumberWithAttributes\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"annotations\":{\"inputType\":\"html5-number\",\"inputTypeMin\":\"10\",\"inputTypeMax\":\"20\",\"inputTypeStep\":1}},{\"name\": \"textareaWithAttributes\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"annotations\":{\"inputType\":\"textarea\",\"inputTypeCols\":\"35\",\"inputTypeRows\":\"7\",\"inputTypeMaxlength\":\"10\"}},{\"name\": \"selectWithoutOptions\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"annotations\":{\"inputType\":\"select\",\"inputTypeSize\":\"5\"}},{\"name\": \"selectWithOptionsWithoutLabels\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"validations\":{\"options\":{\"options\":[ \"opt1\",\"opt2\"]}}, \"annotations\":{\"inputType\":\"select\"}},{\"name\": \"multiselectWithOptionsAndSimpleI18nLabels\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"validations\":{\"options\":{ \"options\":[\"totp\",\"opt2\"]}}, \"annotations\":{\"inputType\":\"multiselect\",\"inputOptionLabelsI18nPrefix\": \"loginTotp\"}},{\"name\": \"multiselectWithOptionsAndLabels\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"validations\":{\"options\":{ \"options\":[\"opt1\",\"opt2\",\"opt3\"]}}, \"annotations\":{\"inputType\":\"multiselect\",\"inputOptionLabels\":{\"opt1\": \"Option 1\",\"opt2\":\"${username}\"}}},{\"name\": \"selectWithOptionsFromCustomValidatorAndLabels\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"validations\":{\"dummyOptions\":{\"options\" : [\"vopt1\",\"vopt2\",\"vopt3\"]}} ,\"annotations\":{\"inputType\":\"select\",\"inputOptionsFromValidation\":\"dummyOptions\",\"inputOptionLabels\":{\"vopt1\": \"Option 1\",\"vopt2\":\"${username}\"}}},{\"name\": \"selectRadiobuttons\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"validations\" : {\"options\" : {\"options\":[\"opt1\",\"opt2\",\"opt3\"]}}, \"annotations\":{\"inputType\":\"select-radiobuttons\",\"inputOptionLabels\":{\"opt1\": \"Option 1\",\"opt2\":\"${username}\"}}},{\"name\": \"selectRadiobuttonsWithOptionsFromCustomValidatorAndLabels\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"validations\" : {\"dummyOptions\" : {\"options\" : [\"vopt1\",\"vopt2\",\"vopt3\"]}} ,\"annotations\":{\"inputType\":\"select-radiobuttons\",\"inputOptionsFromValidation\":\"dummyOptions\",\"inputOptionLabels\":{\"vopt1\": \"Option 1\",\"vopt2\":\"${username}\"}}},{\"name\": \"multiselectCheckboxes\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"validations\": {\"options\":{\"options\":[\"opt1\",\"opt2\",\"opt3\"]}}, \"annotations\":{\"inputType\":\"multiselect-checkboxes\",\"inputOptionLabels\":{\"opt1\": \"Option 1\",\"opt2\":\"${username}\"}}}";

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        super.configureTestRealm(testRealm);
        VerifyProfileTest.enableDynamicUserProfile(testRealm);
        testRealm.setClientScopes(new ArrayList());
        testRealm.getClientScopes().add(ClientScopeBuilder.create().name(SCOPE_LAST_NAME).protocol("openid-connect").build());
        testRealm.getClientScopes().add(ClientScopeBuilder.create().name("department").protocol("openid-connect").build());
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add(SCOPE_LAST_NAME);
        scopes.add("department");
        client_scope_default = KeycloakModelUtils.createClient(testRealm, "client-a");
        client_scope_default.setDefaultClientScopes(scopes);
        client_scope_default.setRedirectUris(Collections.singletonList("*"));
        client_scope_optional = KeycloakModelUtils.createClient(testRealm, "client-b");
        client_scope_optional.setOptionalClientScopes(scopes);
        client_scope_optional.setRedirectUris(Collections.singletonList("*"));
    }

    @Before
    public void beforeTest() {
        VerifyProfileTest.setUserProfileConfiguration(this.testRealm(), null);
    }

    @Test
    public void testRegisterUserSuccess_lastNameOptional() {
        this.setUserProfileConfiguration("{\"attributes\": [" + UP_CONFIG_BASIC_ATTRIBUTES + "{\"name\": \"firstName\"," + "\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}" + ", \"required\": {}},{\"name\": \"lastName\"," + "\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}" + "}]}");
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("firstName", "", "registerUserSuccessLastNameOptional@email", "registerUserSuccessLastNameOptional", "password", "password");
        this.appPage.assertCurrent();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        String userId = this.events.expectRegister("registerUserSuccessLastNameOptional", "registerUserSuccessLastNameOptional@email").assertEvent().getUserId();
        this.assertUserRegistered(userId, "registerUserSuccessLastNameOptional", "registerusersuccesslastnameoptional@email", "firstName", "");
    }

    @Test
    public void testRegisterUserSuccess_lastNameRequiredForScope_notRequested() {
        this.setUserProfileConfiguration("{\"attributes\": [" + UP_CONFIG_BASIC_ATTRIBUTES + "{\"name\": \"firstName\"," + "\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}" + ", \"required\": {}},{\"name\": \"lastName\"," + "\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}" + ", \"required\":{\"scopes\":[\"" + SCOPE_LAST_NAME + "\"]}}]}");
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("firstName", "", "registerUserSuccessLastNameRequiredForScope_notRequested@email", "registerUserSuccessLastNameRequiredForScope_notRequested", "password", "password");
        this.appPage.assertCurrent();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        String userId = this.events.expectRegister("registerUserSuccessLastNameRequiredForScope_notRequested", "registerUserSuccessLastNameRequiredForScope_notRequested@email").assertEvent().getUserId();
        this.assertUserRegistered(userId, "registerUserSuccessLastNameRequiredForScope_notRequested", "registerusersuccesslastnamerequiredforscope_notrequested@email", "firstName", "");
    }

    @Test
    public void testRegisterUserSuccess_lastNameRequiredForScope_requested() {
        this.setUserProfileConfiguration("{\"attributes\": [" + UP_CONFIG_BASIC_ATTRIBUTES + "{\"name\": \"firstName\"," + "\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}" + ", \"required\": {}},{\"name\": \"lastName\"," + "\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}" + ", \"required\":{\"scopes\":[\"" + SCOPE_LAST_NAME + "\"]}}]}");
        this.oauth.scope(SCOPE_LAST_NAME).clientId(client_scope_optional.getClientId()).openLoginForm();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("firstName", "", "registerUserSuccessLastNameRequiredForScope_requested@email", "registerUserSuccessLastNameRequiredForScope_requested", "password", "password");
        this.registerPage.assertCurrent();
        Assert.assertEquals((Object)"Please specify this field.", (Object)this.registerPage.getInputAccountErrors().getLastNameError());
        this.registerPage.register("firstName", SCOPE_LAST_NAME, "registerUserSuccessLastNameRequiredForScope_requested@email", "registerUserSuccessLastNameRequiredForScope_requested", "password", "password");
        this.appPage.assertCurrent();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
    }

    @Test
    public void testRegisterUserSuccess_lastNameRequiredForScope_clientDefault() {
        this.setUserProfileConfiguration("{\"attributes\": [" + UP_CONFIG_BASIC_ATTRIBUTES + "{\"name\": \"firstName\"," + "\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}" + ", \"required\": {}},{\"name\": \"lastName\"," + "\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}" + ", \"required\":{\"scopes\":[\"" + SCOPE_LAST_NAME + "\"]}}]}");
        this.oauth.clientId(client_scope_default.getClientId()).openLoginForm();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("firstName", "", "registerUserSuccessLastNameRequiredForScope_clientDefault@email", "registerUserSuccessLastNameRequiredForScope_clientDefault", "password", "password");
        this.registerPage.assertCurrent();
        Assert.assertEquals((Object)"Please specify this field.", (Object)this.registerPage.getInputAccountErrors().getLastNameError());
        this.registerPage.register("firstName", SCOPE_LAST_NAME, "registerUserSuccessLastNameRequiredForScope_clientDefault@email", "registerUserSuccessLastNameRequiredForScope_clientDefault", "password", "password");
        this.appPage.assertCurrent();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
    }

    @Test
    public void testRegisterUserSuccess_lastNameLengthValidation() {
        this.setUserProfileConfiguration("{\"attributes\": [" + UP_CONFIG_BASIC_ATTRIBUTES + "{\"name\": \"firstName\"," + "\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}" + ", \"required\": {}},{\"name\": \"lastName\"," + "\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}" + ", " + VerifyProfileTest.VALIDATIONS_LENGTH + "}]}");
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("firstName", "last", "registerUserSuccessLastNameLengthValidation@email", "registerUserSuccessLastNameLengthValidation", "password", "password");
        this.appPage.assertCurrent();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        String userId = this.events.expectRegister("registerUserSuccessLastNameLengthValidation", "registerUserSuccessLastNameLengthValidation@email").assertEvent().getUserId();
        this.assertUserRegistered(userId, "registerUserSuccessLastNameLengthValidation", "registerusersuccesslastnamelengthvalidation@email", "firstName", "last");
    }

    @Test
    public void testRegisterUserInvalidLastNameLength() {
        this.setUserProfileConfiguration("{\"attributes\": [" + UP_CONFIG_BASIC_ATTRIBUTES + "{\"name\": \"firstName\"," + "\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}" + ", \"required\": {}},{\"name\": \"lastName\"," + "\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}" + ", " + VerifyProfileTest.VALIDATIONS_LENGTH + "}]}");
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("firstName", "L", "registerUserInvalidLastNameLength@email", "registerUserInvalidLastNameLength", "password", "password");
        this.registerPage.assertCurrent();
        Assert.assertEquals((Object)"Length must be between 3 and 255.", (Object)this.registerPage.getInputAccountErrors().getLastNameError());
        this.events.expectRegister("registeruserinvalidlastnamelength", "registerUserInvalidLastNameLength@email").error("invalid_registration").assertEvent();
    }

    @Test
    public void testAttributeDisplayName() {
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"displayName\":\"${firstName}\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"department\", \"displayName\" : \"Department\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\":{}}]}");
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        Assert.assertEquals((Object)"First name", (Object)this.registerPage.getLabelForField("firstName"));
        Assert.assertEquals((Object)SCOPE_LAST_NAME, (Object)this.registerPage.getLabelForField(SCOPE_LAST_NAME));
        Assert.assertEquals((Object)"Department", (Object)this.registerPage.getLabelForField("department"));
    }

    @Test
    public void testAttributeGuiOrder() {
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"department\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\":{}},{\"name\": \"username\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"email\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}}]}");
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)"form#kc-register-form > div:nth-child(1) > div:nth-child(2) > input#lastName")).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)"form#kc-register-form > div:nth-child(2) > div:nth-child(2) > input#department")).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)"form#kc-register-form > div:nth-child(3) > div:nth-child(2) > input#username")).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)"form#kc-register-form > div:nth-child(4) > div:nth-child(2) > input#password")).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)"form#kc-register-form > div:nth-child(5) > div:nth-child(2) > input#password-confirm")).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)"form#kc-register-form > div:nth-child(6) > div:nth-child(2) > input#firstName")).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)"form#kc-register-form > div:nth-child(7) > div:nth-child(2) > input#email")).isDisplayed());
    }

    @Test
    public void testAttributeInputTypes() {
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"defaultType\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"placeholderAttribute\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"annotations\":{\"inputType\":\"text\",\"inputTypePlaceholder\":\"Example.\"}},{\"name\": \"helperTexts\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"annotations\":{\"inputType\":\"text\",\"inputHelperTextBefore\":\"Example <b>bold text</b> before.\",\"inputHelperTextAfter\":\"Example <i>i text</i> after.\"}},{\"name\": \"textWithBasicAttributes\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"annotations\":{\"inputType\":\"text\",\"inputTypeSize\":\"35\",\"inputTypeMinlength\":\"1\",\"inputTypeMaxlength\":\"10\",\"inputTypePattern\":\".*\"}},{\"name\": \"html5NumberWithAttributes\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"annotations\":{\"inputType\":\"html5-number\",\"inputTypeMin\":\"10\",\"inputTypeMax\":\"20\",\"inputTypeStep\":1}},{\"name\": \"textareaWithAttributes\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"annotations\":{\"inputType\":\"textarea\",\"inputTypeCols\":\"35\",\"inputTypeRows\":\"7\",\"inputTypeMaxlength\":\"10\"}},{\"name\": \"selectWithoutOptions\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"annotations\":{\"inputType\":\"select\",\"inputTypeSize\":\"5\"}},{\"name\": \"selectWithOptionsWithoutLabels\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"validations\":{\"options\":{\"options\":[ \"opt1\",\"opt2\"]}}, \"annotations\":{\"inputType\":\"select\"}},{\"name\": \"multiselectWithOptionsAndSimpleI18nLabels\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"validations\":{\"options\":{ \"options\":[\"totp\",\"opt2\"]}}, \"annotations\":{\"inputType\":\"multiselect\",\"inputOptionLabelsI18nPrefix\": \"loginTotp\"}},{\"name\": \"multiselectWithOptionsAndLabels\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"validations\":{\"options\":{ \"options\":[\"opt1\",\"opt2\",\"opt3\"]}}, \"annotations\":{\"inputType\":\"multiselect\",\"inputOptionLabels\":{\"opt1\": \"Option 1\",\"opt2\":\"${username}\"}}},{\"name\": \"selectWithOptionsFromCustomValidatorAndLabels\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"validations\":{\"dummyOptions\":{\"options\" : [\"vopt1\",\"vopt2\",\"vopt3\"]}} ,\"annotations\":{\"inputType\":\"select\",\"inputOptionsFromValidation\":\"dummyOptions\",\"inputOptionLabels\":{\"vopt1\": \"Option 1\",\"vopt2\":\"${username}\"}}},{\"name\": \"selectRadiobuttons\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"validations\" : {\"options\" : {\"options\":[\"opt1\",\"opt2\",\"opt3\"]}}, \"annotations\":{\"inputType\":\"select-radiobuttons\",\"inputOptionLabels\":{\"opt1\": \"Option 1\",\"opt2\":\"${username}\"}}},{\"name\": \"selectRadiobuttonsWithOptionsFromCustomValidatorAndLabels\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"validations\" : {\"dummyOptions\" : {\"options\" : [\"vopt1\",\"vopt2\",\"vopt3\"]}} ,\"annotations\":{\"inputType\":\"select-radiobuttons\",\"inputOptionsFromValidation\":\"dummyOptions\",\"inputOptionLabels\":{\"vopt1\": \"Option 1\",\"vopt2\":\"${username}\"}}},{\"name\": \"multiselectCheckboxes\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"validations\": {\"options\":{\"options\":[\"opt1\",\"opt2\",\"opt3\"]}}, \"annotations\":{\"inputType\":\"multiselect-checkboxes\",\"inputOptionLabels\":{\"opt1\": \"Option 1\",\"opt2\":\"${username}\"}}}]}");
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        RegisterWithUserProfileTest.assertFieldTypes(this.driver);
    }

    public static void assertFieldTypes(WebDriver driver) {
        Assert.assertEquals((Object)"text", (Object)driver.findElement(By.cssSelector((String)"input#defaultType")).getAttribute("type"));
        Assert.assertEquals((Object)"text", (Object)driver.findElement(By.cssSelector((String)"input#placeholderAttribute")).getAttribute("type"));
        Assert.assertEquals((Object)"Example.", (Object)driver.findElement(By.cssSelector((String)"input#placeholderAttribute")).getAttribute("placeholder"));
        Assert.assertEquals((Object)"Example bold text before.", (Object)driver.findElement(By.cssSelector((String)"div#form-help-text-before-helperTexts")).getText());
        Assert.assertEquals((Object)"bold text", (Object)driver.findElement(By.cssSelector((String)"div#form-help-text-before-helperTexts b")).getText());
        Assert.assertEquals((Object)"Example i text after.", (Object)driver.findElement(By.cssSelector((String)"div#form-help-text-after-helperTexts")).getText());
        Assert.assertEquals((Object)"i text", (Object)driver.findElement(By.cssSelector((String)"div#form-help-text-after-helperTexts i")).getText());
        Assert.assertEquals((Object)"text", (Object)driver.findElement(By.cssSelector((String)"input#textWithBasicAttributes")).getAttribute("type"));
        Assert.assertEquals((Object)"35", (Object)driver.findElement(By.cssSelector((String)"input#textWithBasicAttributes")).getAttribute("size"));
        Assert.assertEquals((Object)"1", (Object)driver.findElement(By.cssSelector((String)"input#textWithBasicAttributes")).getAttribute("minlength"));
        Assert.assertEquals((Object)"10", (Object)driver.findElement(By.cssSelector((String)"input#textWithBasicAttributes")).getAttribute("maxlength"));
        Assert.assertEquals((Object)".*", (Object)driver.findElement(By.cssSelector((String)"input#textWithBasicAttributes")).getAttribute("pattern"));
        Assert.assertEquals((Object)"number", (Object)driver.findElement(By.cssSelector((String)"input#html5NumberWithAttributes")).getAttribute("type"));
        Assert.assertEquals((Object)"10", (Object)driver.findElement(By.cssSelector((String)"input#html5NumberWithAttributes")).getAttribute("min"));
        Assert.assertEquals((Object)"20", (Object)driver.findElement(By.cssSelector((String)"input#html5NumberWithAttributes")).getAttribute("max"));
        Assert.assertEquals((Object)"1", (Object)driver.findElement(By.cssSelector((String)"input#html5NumberWithAttributes")).getAttribute("step"));
        Assert.assertEquals((Object)"35", (Object)driver.findElement(By.cssSelector((String)"textarea#textareaWithAttributes")).getAttribute("cols"));
        Assert.assertEquals((Object)"7", (Object)driver.findElement(By.cssSelector((String)"textarea#textareaWithAttributes")).getAttribute("rows"));
        Assert.assertEquals((Object)"10", (Object)driver.findElement(By.cssSelector((String)"textarea#textareaWithAttributes")).getAttribute("maxlength"));
        Assert.assertEquals((Object)"5", (Object)driver.findElement(By.cssSelector((String)"select#selectWithoutOptions")).getAttribute("size"));
        Assert.assertEquals(null, (Object)driver.findElement(By.cssSelector((String)"select#selectWithOptionsWithoutLabels")).getAttribute("multiple"));
        Assert.assertEquals((Object)"opt1", (Object)driver.findElement(By.cssSelector((String)"select#selectWithOptionsWithoutLabels option[value=opt1]")).getText());
        Assert.assertEquals((Object)"opt2", (Object)driver.findElement(By.cssSelector((String)"select#selectWithOptionsWithoutLabels option[value=opt2]")).getText());
        Assert.assertEquals((String)"default empty option is missing in select", (Object)"", (Object)driver.findElement(By.cssSelector((String)"select#selectWithOptionsWithoutLabels option[value='']")).getText());
        Assert.assertEquals((Object)"true", (Object)driver.findElement(By.cssSelector((String)"select#multiselectWithOptionsAndSimpleI18nLabels")).getAttribute("multiple"));
        Assert.assertEquals((Object)"Time-based", (Object)driver.findElement(By.cssSelector((String)"select#multiselectWithOptionsAndSimpleI18nLabels option[value=totp]")).getText());
        Assert.assertEquals((Object)"loginTotp.opt2", (Object)driver.findElement(By.cssSelector((String)"select#multiselectWithOptionsAndSimpleI18nLabels option[value=opt2]")).getText());
        Assert.assertEquals((Object)"true", (Object)driver.findElement(By.cssSelector((String)"select#multiselectWithOptionsAndLabels")).getAttribute("multiple"));
        Assert.assertEquals((Object)"Option 1", (Object)driver.findElement(By.cssSelector((String)"select#multiselectWithOptionsAndLabels option[value=opt1]")).getText());
        Assert.assertEquals((Object)"Username", (Object)driver.findElement(By.cssSelector((String)"select#multiselectWithOptionsAndLabels option[value=opt2]")).getText());
        Assert.assertEquals((Object)"opt3", (Object)driver.findElement(By.cssSelector((String)"select#multiselectWithOptionsAndLabels option[value=opt3]")).getText());
        Assert.assertEquals(null, (Object)driver.findElement(By.cssSelector((String)"select#selectWithOptionsFromCustomValidatorAndLabels")).getAttribute("multiple"));
        Assert.assertEquals((Object)"Option 1", (Object)driver.findElement(By.cssSelector((String)"select#selectWithOptionsFromCustomValidatorAndLabels option[value=vopt1]")).getText());
        Assert.assertEquals((Object)"Username", (Object)driver.findElement(By.cssSelector((String)"select#selectWithOptionsFromCustomValidatorAndLabels option[value=vopt2]")).getText());
        Assert.assertEquals((Object)"vopt3", (Object)driver.findElement(By.cssSelector((String)"select#selectWithOptionsFromCustomValidatorAndLabels option[value=vopt3]")).getText());
        Assert.assertEquals((Object)"radio", (Object)driver.findElement(By.cssSelector((String)"input#selectRadiobuttons-opt1")).getAttribute("type"));
        Assert.assertEquals((Object)"Option 1", (Object)driver.findElement(By.cssSelector((String)"label[for=selectRadiobuttons-opt1]")).getText());
        Assert.assertEquals((Object)"radio", (Object)driver.findElement(By.cssSelector((String)"input#selectRadiobuttons-opt2")).getAttribute("type"));
        Assert.assertEquals((Object)"Username", (Object)driver.findElement(By.cssSelector((String)"label[for=selectRadiobuttons-opt2]")).getText());
        Assert.assertEquals((Object)"radio", (Object)driver.findElement(By.cssSelector((String)"input#selectRadiobuttons-opt3")).getAttribute("type"));
        Assert.assertEquals((Object)"opt3", (Object)driver.findElement(By.cssSelector((String)"label[for=selectRadiobuttons-opt3]")).getText());
        Assert.assertEquals((Object)"radio", (Object)driver.findElement(By.cssSelector((String)"input#selectRadiobuttonsWithOptionsFromCustomValidatorAndLabels-vopt1")).getAttribute("type"));
        Assert.assertEquals((Object)"Option 1", (Object)driver.findElement(By.cssSelector((String)"label[for=selectRadiobuttonsWithOptionsFromCustomValidatorAndLabels-vopt1]")).getText());
        Assert.assertEquals((Object)"radio", (Object)driver.findElement(By.cssSelector((String)"input#selectRadiobuttonsWithOptionsFromCustomValidatorAndLabels-vopt2")).getAttribute("type"));
        Assert.assertEquals((Object)"Username", (Object)driver.findElement(By.cssSelector((String)"label[for=selectRadiobuttonsWithOptionsFromCustomValidatorAndLabels-vopt2]")).getText());
        Assert.assertEquals((Object)"radio", (Object)driver.findElement(By.cssSelector((String)"input#selectRadiobuttonsWithOptionsFromCustomValidatorAndLabels-vopt3")).getAttribute("type"));
        Assert.assertEquals((Object)"vopt3", (Object)driver.findElement(By.cssSelector((String)"label[for=selectRadiobuttonsWithOptionsFromCustomValidatorAndLabels-vopt3]")).getText());
        Assert.assertEquals((Object)"checkbox", (Object)driver.findElement(By.cssSelector((String)"input#multiselectCheckboxes-opt1")).getAttribute("type"));
        Assert.assertEquals((Object)"Option 1", (Object)driver.findElement(By.cssSelector((String)"label[for=multiselectCheckboxes-opt1]")).getText());
        Assert.assertEquals((Object)"checkbox", (Object)driver.findElement(By.cssSelector((String)"input#multiselectCheckboxes-opt2")).getAttribute("type"));
        Assert.assertEquals((Object)"Username", (Object)driver.findElement(By.cssSelector((String)"label[for=multiselectCheckboxes-opt2]")).getText());
        Assert.assertEquals((Object)"checkbox", (Object)driver.findElement(By.cssSelector((String)"input#multiselectCheckboxes-opt3")).getAttribute("type"));
        Assert.assertEquals((Object)"opt3", (Object)driver.findElement(By.cssSelector((String)"label[for=multiselectCheckboxes-opt3]")).getText());
    }

    @Test
    public void testAttributeGrouping() {
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"username\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"department\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\":{}, \"group\": \"company\"},{\"name\": \"email\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"group\": \"contact\"}], \"groups\": [{\"name\": \"company\", \"displayDescription\": \"Company field desc\" },{\"name\": \"contact\" }]}");
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        String htmlFormId = "kc-register-form";
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(1) > div:nth-child(2) > input#lastName"))).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(2) > div:nth-child(2) > input#username"))).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)"form#kc-register-form > div:nth-child(3) > div:nth-child(2) > input#password")).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(4) > div:nth-child(2) > input#password-confirm"))).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(5) > div:nth-child(2) > input#firstName"))).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(6) > div:nth-child(1) > label#header-company"))).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(6) > div:nth-child(2) > label#description-company"))).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(7) > div:nth-child(2) > input#department"))).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(8) > div:nth-child(1) > label#header-contact"))).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(9) > div:nth-child(2) > input#email"))).isDisplayed());
    }

    @Test
    public void testRegisterUserSuccess_requiredReadOnlyAttributeNotRenderedAndNotBlockingRegistration() {
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"displayName\":\"${firstName}\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"department\", \"displayName\" : \"Department\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\"]}, \"required\":{}}]}");
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        Assert.assertFalse((boolean)this.registerPage.isDepartmentPresent());
        this.registerPage.register("FirstName", "LastName", "requiredReadOnlyAttributeNotRenderedAndNotBlockingRegistration@email", "requiredReadOnlyAttributeNotRenderedAndNotBlockingRegistration", "password", "password");
        this.appPage.assertCurrent();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
    }

    @Test
    public void testRegisterUserSuccess_attributeRequiredAndSelectedByScopeMustBeSet() {
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"department\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\":{}, \"selector\":{\"scopes\":[\"department\"]}}]}");
        this.oauth.scope("department").clientId(client_scope_optional.getClientId()).openLoginForm();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("FirstAA", "LastAA", "attributeRequiredAndSelectedByScopeMustBeSet@email", "attributeRequiredAndSelectedByScopeMustBeSet", "password", "password", "");
        this.registerPage.assertCurrent();
        this.registerPage.register("FirstAA", "LastAA", "attributeRequiredAndSelectedByScopeMustBeSet@email", "attributeRequiredAndSelectedByScopeMustBeSet", "password", "password", "DepartmentAA");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        UserRepresentation user = VerifyProfileTest.getUserByUsername(this.testRealm(), "attributeRequiredAndSelectedByScopeMustBeSet");
        Assert.assertEquals((Object)"FirstAA", (Object)user.getFirstName());
        Assert.assertEquals((Object)"LastAA", (Object)user.getLastName());
        Assert.assertEquals((Object)"DepartmentAA", (Object)user.firstAttribute("department"));
    }

    @Test
    public void testRegisterUserSuccess_attributeNotRequiredAndSelectedByScopeCanBeIgnored() {
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"department\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"selector\":{\"scopes\":[\"department\"]}}]}");
        this.oauth.scope("department").clientId(client_scope_optional.getClientId()).openLoginForm();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        Assert.assertTrue((boolean)this.registerPage.isDepartmentPresent());
        this.registerPage.register("FirstAA", "LastAA", "attributeNotRequiredAndSelectedByScopeCanBeIgnored@email", "attributeNotRequiredAndSelectedByScopeCanBeIgnored", "password", "password", null);
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        String userId = this.events.expectRegister("attributeNotRequiredAndSelectedByScopeCanBeIgnored", "attributeNotRequiredAndSelectedByScopeCanBeIgnored@email", client_scope_optional.getClientId()).assertEvent().getUserId();
        UserRepresentation user = this.getUser(userId);
        Assert.assertEquals((Object)"FirstAA", (Object)user.getFirstName());
        Assert.assertEquals((Object)"LastAA", (Object)user.getLastName());
        MatcherAssert.assertThat((Object)StringUtils.isEmpty((CharSequence)user.firstAttribute("department")), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testRegisterUserSuccess_attributeNotRequiredAndSelectedByScopeCanBeSet() {
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"department\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"selector\":{\"scopes\":[\"department\"]}}]}");
        this.oauth.clientId(client_scope_default.getClientId()).openLoginForm();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        Assert.assertTrue((boolean)this.registerPage.isDepartmentPresent());
        this.registerPage.register("FirstAA", "LastAA", "attributeNotRequiredAndSelectedByScopeCanBeSet@email", "attributeNotRequiredAndSelectedByScopeCanBeSet", "password", "password", "Department AA");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        String userId = this.events.expectRegister("attributeNotRequiredAndSelectedByScopeCanBeSet", "attributeNotRequiredAndSelectedByScopeCanBeSet@email", client_scope_default.getClientId()).assertEvent().getUserId();
        UserRepresentation user = this.getUser(userId);
        Assert.assertEquals((Object)"FirstAA", (Object)user.getFirstName());
        Assert.assertEquals((Object)"LastAA", (Object)user.getLastName());
        Assert.assertEquals((Object)"Department AA", (Object)user.firstAttribute("department"));
    }

    @Test
    public void testRegisterUserSuccess_attributeRequiredButNotSelectedByScopeIsNotRenderedAndNotBlockingRegistration() {
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"department\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\":{}, \"selector\":{\"scopes\":[\"department\"]}}]}");
        this.oauth.clientId(client_scope_optional.getClientId()).openLoginForm();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        Assert.assertFalse((boolean)this.registerPage.isDepartmentPresent());
        this.registerPage.register("FirstAA", "LastAA", "attributeRequiredButNotSelectedByScopeIsNotRendered@email", "attributeRequiredButNotSelectedByScopeIsNotRendered", "password", "password");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        String userId = this.events.expectRegister("attributeRequiredButNotSelectedByScopeIsNotRendered", "attributeRequiredButNotSelectedByScopeIsNotRendered@email", client_scope_optional.getClientId()).assertEvent().getUserId();
        UserRepresentation user = this.getUser(userId);
        Assert.assertEquals((Object)"FirstAA", (Object)user.getFirstName());
        Assert.assertEquals((Object)"LastAA", (Object)user.getLastName());
        Assert.assertEquals(null, (Object)user.firstAttribute("department"));
    }

    private void assertUserRegistered(String userId, String username, String email, String firstName, String lastName) {
        this.events.expectLogin().detail("username", username.toLowerCase()).user(userId).assertEvent();
        UserRepresentation user = this.getUser(userId);
        Assert.assertNotNull((Object)user);
        Assert.assertNotNull((Object)user.getCreatedTimestamp());
        Assert.assertTrue((System.currentTimeMillis() - user.getCreatedTimestamp() < 10000L ? 1 : 0) != 0);
        Assert.assertEquals((Object)username.toLowerCase(), (Object)user.getUsername());
        Assert.assertEquals((Object)email.toLowerCase(), (Object)user.getEmail());
        Assert.assertEquals((Object)firstName, (Object)user.getFirstName());
        if (StringUtils.isEmpty((CharSequence)lastName)) {
            MatcherAssert.assertThat((Object)StringUtils.isEmpty((CharSequence)user.getLastName()), (Matcher)CoreMatchers.is((Object)true));
        } else {
            MatcherAssert.assertThat((Object)user.getLastName(), (Matcher)CoreMatchers.is((Object)lastName));
        }
    }

    protected void setUserProfileConfiguration(String configuration) {
        VerifyProfileTest.setUserProfileConfiguration(this.testRealm(), configuration);
    }

    static {
        UP_CONFIG_BASIC_ATTRIBUTES = "{\"name\": \"username\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"email\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},";
    }
}

