/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import org.jboss.arquillian.graphene.page.Page;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.ActionURIUtils;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.InfoPage;
import org.keycloak.testsuite.pages.LoginExpiredPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginPasswordResetPage;
import org.keycloak.testsuite.pages.LoginPasswordUpdatePage;
import org.keycloak.testsuite.pages.LoginUpdateProfilePage;
import org.keycloak.testsuite.pages.OAuthGrantPage;
import org.keycloak.testsuite.pages.RegisterPage;
import org.keycloak.testsuite.pages.VerifyEmailPage;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.GreenMailRule;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.URLAssert;
import org.keycloak.testsuite.util.UserBuilder;
import org.openqa.selenium.NoSuchElementException;

public class MultipleTabsLoginTest
extends AbstractTestRealmKeycloakTest {
    private String userId;
    @Rule
    public GreenMailRule greenMail = new GreenMailRule();
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected ErrorPage errorPage;
    @Page
    protected InfoPage infoPage;
    @Page
    protected VerifyEmailPage verifyEmailPage;
    @Page
    protected LoginPasswordResetPage resetPasswordPage;
    @Page
    protected LoginPasswordUpdatePage updatePasswordPage;
    @Page
    protected LoginUpdateProfilePage updateProfilePage;
    @Page
    protected LoginExpiredPage loginExpiredPage;
    @Page
    protected RegisterPage registerPage;
    @Page
    protected OAuthGrantPage grantPage;
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Override
    protected boolean modifyRealmForSSL() {
        return true;
    }

    @Before
    public void setup() {
        UserRepresentation user = UserBuilder.create().username("login-test").email("login@test.com").enabled(true).requiredAction(UserModel.RequiredAction.UPDATE_PROFILE.toString()).requiredAction(UserModel.RequiredAction.UPDATE_PASSWORD.toString()).build();
        this.userId = ApiUtil.createUserAndResetPasswordWithAdminClient((RealmResource)this.testRealm(), (UserRepresentation)user, (String)"password", (boolean)true);
        this.getCleanup().addUserId(this.userId);
        this.oauth.clientId("test-app");
    }

    @Test
    public void multipleTabsParallelLoginTest() {
        this.oauth.openLoginForm();
        this.loginPage.assertCurrent();
        this.loginPage.login("login-test", "password");
        this.updatePasswordPage.assertCurrent();
        String tab1Url = this.driver.getCurrentUrl();
        this.oauth.openLoginForm();
        this.loginPage.assertCurrent();
        this.loginPage.login("login-test", "password");
        this.updatePasswordPage.assertCurrent();
        this.updatePasswordPage.changePassword("password", "password");
        this.updateProfilePage.update("John", "Doe3", "john@doe3.com");
        this.appPage.assertCurrent();
        this.driver.navigate().to(tab1Url);
        this.infoPage.assertCurrent();
        Assert.assertEquals((Object)"You are already logged in.", (Object)this.infoPage.getInfo());
        this.infoPage.clickBackToApplicationLink();
        this.appPage.assertCurrent();
    }

    @Test
    public void expiredAuthenticationAction_currentCodeExpiredExecution() {
        this.oauth.openLoginForm();
        this.loginPage.assertCurrent();
        String actionUrl1 = ActionURIUtils.getActionURIFromPageSource((String)this.driver.getPageSource());
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.driver.navigate().to(actionUrl1);
        this.loginExpiredPage.assertCurrent();
        this.loginExpiredPage.clickLoginContinueLink();
        this.registerPage.assertCurrent();
        this.registerPage.clickBackToLogin();
        this.loginPage.assertCurrent();
        this.loginPage.login("login-test", "password");
        this.updatePasswordPage.changePassword("password", "password");
        this.updateProfilePage.update("John", "Doe3", "john@doe3.com");
        this.appPage.assertCurrent();
    }

    @Test
    public void expiredAuthenticationAction_expiredCodeCurrentExecution() {
        this.oauth.openLoginForm();
        this.loginPage.assertCurrent();
        String actionUrl1 = ActionURIUtils.getActionURIFromPageSource((String)this.driver.getPageSource());
        this.loginPage.login("invalid", "invalid");
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getInputError());
        this.driver.navigate().to(actionUrl1);
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"Action expired. Please continue with login now.", (Object)this.loginPage.getError());
        this.loginPage.login("login-test", "password");
        this.updatePasswordPage.changePassword("password", "password");
        this.updateProfilePage.update("John", "Doe3", "john@doe3.com");
        this.appPage.assertCurrent();
    }

    @Test
    public void expiredAuthenticationAction_expiredCodeExpiredExecution() {
        this.oauth.openLoginForm();
        this.loginPage.assertCurrent();
        String actionUrl1 = ActionURIUtils.getActionURIFromPageSource((String)this.driver.getPageSource());
        this.loginPage.login("login-test", "password");
        this.updatePasswordPage.assertCurrent();
        this.driver.navigate().to(actionUrl1);
        this.loginExpiredPage.assertCurrent();
        this.loginExpiredPage.clickLoginContinueLink();
        this.updatePasswordPage.assertCurrent();
        this.updatePasswordPage.changePassword("password", "password");
        this.updateProfilePage.update("John", "Doe3", "john@doe3.com");
        this.appPage.assertCurrent();
    }

    @Test
    public void loginActionWithoutExecution() throws Exception {
        this.oauth.openLoginForm();
        String actionUrl = ActionURIUtils.getActionURIFromPageSource((String)this.driver.getPageSource());
        actionUrl = ActionURIUtils.removeQueryParamFromURI((String)actionUrl, (String)"execution");
        this.driver.navigate().to(actionUrl);
        this.loginExpiredPage.assertCurrent();
    }

    @Test
    public void loginActionWithoutExecutionInRequiredActions() throws Exception {
        this.oauth.openLoginForm();
        this.loginPage.assertCurrent();
        this.loginPage.login("login-test", "password");
        this.updatePasswordPage.assertCurrent();
        String actionUrl = ActionURIUtils.getActionURIFromPageSource((String)this.driver.getPageSource());
        actionUrl = ActionURIUtils.removeQueryParamFromURI((String)actionUrl, (String)"execution");
        this.driver.navigate().to(actionUrl);
        this.updatePasswordPage.assertCurrent();
        this.updatePasswordPage.changePassword("password", "password");
        this.updateProfilePage.update("John", "Doe3", "john@doe3.com");
        this.appPage.assertCurrent();
    }

    @Test
    public void loginWithDifferentClients() throws Exception {
        String redirectUri = String.format("%s/foo/bar/baz", ServerURLs.getAuthServerContextRoot());
        this.oauth.openLoginForm();
        this.loginPage.assertCurrent();
        this.loginPage.login("login-test", "bad-password");
        String tab1Url = this.driver.getCurrentUrl();
        this.oauth.clientId("root-url-client");
        this.oauth.redirectUri(redirectUri);
        this.oauth.openLoginForm();
        this.loginPage.assertCurrent();
        String tab2Url = this.driver.getCurrentUrl();
        this.driver.navigate().to(tab1Url);
        this.loginPage.login("login-test", "password");
        this.updatePasswordPage.changePassword("password", "password");
        this.updateProfilePage.update("John", "Doe3", "john@doe3.com");
        this.appPage.assertCurrent();
        this.driver.navigate().to(tab2Url);
        URLAssert.assertCurrentUrlStartsWith(redirectUri);
    }

    @Test
    public void loginWithSameClientDifferentStatesLoginInTab1() throws Exception {
        String redirectUri1 = String.format("%s/auth/realms/master/app/auth/suffix1", ServerURLs.getAuthServerContextRoot());
        String redirectUri2 = String.format("%s/auth/realms/master/app/auth/suffix2", ServerURLs.getAuthServerContextRoot());
        this.oauth.stateParamHardcoded("state1");
        this.oauth.redirectUri(redirectUri1);
        this.oauth.openLoginForm();
        this.loginPage.assertCurrent();
        this.loginPage.login("login-test", "bad-password");
        String tab1Url = this.driver.getCurrentUrl();
        this.oauth.stateParamHardcoded("state2");
        this.oauth.redirectUri(redirectUri2);
        this.oauth.openLoginForm();
        this.loginPage.assertCurrent();
        String tab2Url = this.driver.getCurrentUrl();
        this.driver.navigate().to(tab1Url);
        this.loginPage.login("login-test", "password");
        this.updatePasswordPage.changePassword("password", "password");
        this.updateProfilePage.update("John", "Doe3", "john@doe3.com");
        this.appPage.assertCurrent();
        String currentUrl = this.driver.getCurrentUrl();
        URLAssert.assertCurrentUrlStartsWith(redirectUri1);
        Assert.assertTrue((boolean)currentUrl.contains("state1"));
    }

    @Test
    public void loginWithSameClientDifferentStatesLoginInTab2() throws Exception {
        String redirectUri1 = String.format("%s/auth/realms/master/app/auth/suffix1", ServerURLs.getAuthServerContextRoot());
        String redirectUri2 = String.format("%s/auth/realms/master/app/auth/suffix2", ServerURLs.getAuthServerContextRoot());
        this.oauth.stateParamHardcoded("state1");
        this.oauth.redirectUri(redirectUri1);
        this.oauth.openLoginForm();
        this.loginPage.assertCurrent();
        this.loginPage.login("login-test", "bad-password");
        String tab1Url = this.driver.getCurrentUrl();
        this.oauth.stateParamHardcoded("state2");
        this.oauth.redirectUri(redirectUri2);
        this.oauth.openLoginForm();
        this.loginPage.assertCurrent();
        String tab2Url = this.driver.getCurrentUrl();
        this.loginPage.login("login-test", "password");
        this.updatePasswordPage.changePassword("password", "password");
        this.updateProfilePage.update("John", "Doe3", "john@doe3.com");
        this.appPage.assertCurrent();
        String currentUrl = this.driver.getCurrentUrl();
        URLAssert.assertCurrentUrlStartsWith(redirectUri2);
        Assert.assertTrue((boolean)currentUrl.contains("state2"));
    }

    @Test
    public void testEmptyBaseUrl() throws Exception {
        String clientUuid = KeycloakModelUtils.generateId();
        ClientRepresentation emptyBaseclient = ClientBuilder.create().clientId("empty-baseurl-client").id(clientUuid).enabled(true).baseUrl("").addRedirectUri("*").secret("password").build();
        this.testRealm().clients().create(emptyBaseclient);
        this.getCleanup().addClientUuid(clientUuid);
        this.oauth.clientId("empty-baseurl-client");
        this.oauth.openLoginForm();
        this.loginPage.assertCurrent();
        this.loginPage.login("login-test", "password");
        this.updatePasswordPage.assertCurrent();
        String tab1Url = this.driver.getCurrentUrl();
        this.oauth.openLoginForm();
        this.loginPage.assertCurrent();
        this.loginPage.login("login-test", "password");
        this.updatePasswordPage.assertCurrent();
        this.updatePasswordPage.changePassword("password", "password");
        this.updateProfilePage.update("John", "Doe3", "john@doe3.com");
        this.appPage.assertCurrent();
        this.driver.navigate().to(tab1Url);
        this.infoPage.assertCurrent();
        Assert.assertEquals((Object)"You are already logged in.", (Object)this.infoPage.getInfo());
        try {
            this.infoPage.clickBackToApplicationLink();
            org.junit.Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }
}

