/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import java.io.IOException;
import java.net.MalformedURLException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginTotpPage;
import org.keycloak.testsuite.util.AdminClientUtil;
import org.keycloak.testsuite.util.GreenMailRule;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmRepUtil;
import org.keycloak.testsuite.util.UserBuilder;

public class LoginTotpTest
extends AbstractTestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Rule
    public GreenMailRule greenMail = new GreenMailRule();
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected LoginTotpPage loginTotpPage;
    private TimeBasedOTP totp = new TimeBasedOTP();
    private int lifespan;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        UserRepresentation user = RealmRepUtil.findUser(testRealm, "test-user@localhost");
        UserBuilder.edit(user).totpSecret("totpSecret").otpEnabled();
    }

    @Before
    public void before() throws MalformedURLException {
        this.totp = new TimeBasedOTP();
    }

    @Test
    public void loginWithTotpFailure() throws Exception {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.loginTotpPage.isCurrent());
        this.loginTotpPage.login("123456");
        this.loginTotpPage.assertCurrent();
        Assert.assertEquals((Object)"Invalid authenticator code.", (Object)this.loginTotpPage.getInputError());
        this.events.expectLogin().error("invalid_user_credentials").session((String)null).removeDetail("consent").assertEvent();
    }

    @Test
    public void loginWithMissingTotp() throws Exception {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.loginTotpPage.isCurrent());
        this.loginTotpPage.login(null);
        this.loginTotpPage.assertCurrent();
        Assert.assertEquals((Object)"Invalid authenticator code.", (Object)this.loginTotpPage.getInputError());
        this.events.expectLogin().error("invalid_user_credentials").session((String)null).removeDetail("consent").assertEvent();
    }

    @Test
    public void loginWithTotpSuccess() throws Exception {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.loginTotpPage.isCurrent());
        this.loginTotpPage.login(this.totp.generateTOTP("totpSecret"));
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().assertEvent();
    }

    @Test
    public void loginWithTotpRefreshTotpPage() throws Exception {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.loginTotpPage.isCurrent());
        this.driver.navigate().refresh();
        System.out.println(this.driver.getPageSource());
        this.loginTotpPage.login(this.totp.generateTOTP("totpSecret"));
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().assertEvent();
    }

    @Test
    public void loginWithTotpInvalidPassword() throws Exception {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "invalid");
        Assert.assertTrue((boolean)this.loginPage.isCurrent());
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getInputError());
        this.events.expectLogin().error("invalid_user_credentials").session((String)null).removeDetail("consent").assertEvent();
    }

    @Test
    public void loginWithTotp_testAttemptedUsernameAndResetLogin() throws Exception {
        this.loginPage.open();
        this.loginPage.assertAttemptedUsernameAvailability(false);
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.loginTotpPage.isCurrent());
        this.loginPage.assertAttemptedUsernameAvailability(true);
        Assert.assertEquals((Object)"test-user@localhost", (Object)this.loginPage.getAttemptedUsername());
        this.loginTotpPage.clickResetLogin();
        this.loginPage.assertCurrent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void loginWithTotp_getToken_checkCompatibilityCLI() throws IOException {
        try (ResteasyClient httpClient = AdminClientUtil.createResteasyClient();){
            WebTarget exchangeUrl = httpClient.target(OAuthClient.AUTH_SERVER_ROOT).path("/realms").path("test").path("protocol/openid-connect/token");
            Form form = new Form().param("grant_type", "password").param("username", "test-user@localhost").param("password", "password").param("client_id", "admin-cli");
            Response response = exchangeUrl.request().post(Entity.form((Form)form.param("otp", this.totp.generateTOTP("totpSecret"))));
            Assert.assertEquals((long)200L, (long)response.getStatus());
            response.close();
            response = exchangeUrl.request().post(Entity.form((Form)form.param("totp", this.totp.generateTOTP("totpSecret"))));
            Assert.assertEquals((long)200L, (long)response.getStatus());
            response.close();
        }
    }
}

