/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import java.io.Serializable;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.FlowUtil;
import org.keycloak.testsuite.util.OAuthClient;
import org.openqa.selenium.WebDriver;

public class DirectGrantFlowTest
extends AbstractTestRealmKeycloakTest {
    @ArquillianResource
    protected OAuthClient oauth;
    @Drone
    protected WebDriver driver;
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    private void configureDirectGrantFlowWithOTPForm(String newFlowAlias) {
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).copyDirectGrantFlow(newFlowAlias));
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).selectFlow(newFlowAlias).clear().addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "direct-grant-validate-username").addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "direct-grant-validate-password").addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "auth-otp-form").defineAsDirectGrantFlow());
    }

    @Test
    public void testDirectGrantLoginWithOTPFormShouldFail() throws Exception {
        this.configureDirectGrantFlowWithOTPForm("new-direct-grant");
        String clientId = "direct-grant";
        String login = "test-user@localhost";
        this.oauth.clientId(clientId);
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("password", login, "password", null);
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        Assert.assertEquals((Object)"Account is not fully set up", (Object)response.getErrorDescription());
    }
}

