/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.forms.SerializableApplicationData;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.AdminClientUtil;
import org.keycloak.testsuite.util.OAuthClient;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class ChallengeFlowTest
extends AbstractTestRealmKeycloakTest {
    public static final String TEST_APP_DIRECT_OVERRIDE = "test-app-direct-override";
    public static final String TEST_APP_FLOW = "test-app-flow";
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected ErrorPage errorPage;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Before
    public void setupFlows() {
        SerializableApplicationData serializedApplicationData = new SerializableApplicationData(OAuthClient.APP_AUTH_ROOT, OAuthClient.APP_ROOT + "/admin", OAuthClient.APP_AUTH_ROOT + "/*");
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            ClientModel client = session.clients().getClientByClientId(realm, TEST_APP_FLOW);
            if (client != null) {
                return;
            }
            AuthenticationFlowModel browser = new AuthenticationFlowModel();
            browser.setAlias("cli-challenge");
            browser.setDescription("challenge based authentication");
            browser.setProviderId("basic-flow");
            browser.setTopLevel(true);
            browser.setBuiltIn(true);
            browser = realm.addAuthenticationFlow(browser);
            AuthenticationExecutionModel execution = new AuthenticationExecutionModel();
            execution.setParentFlow(browser.getId());
            execution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED);
            execution.setAuthenticator("console-username-password");
            execution.setPriority(10);
            execution.setAuthenticatorFlow(false);
            realm.addAuthenticatorExecution(execution);
            client = realm.addClient(TEST_APP_FLOW);
            client.setSecret("password");
            client.setBaseUrl(serializedApplicationData.applicationBaseUrl);
            client.setManagementUrl(serializedApplicationData.applicationManagementUrl);
            client.setEnabled(true);
            client.addRedirectUri(serializedApplicationData.applicationRedirectUrl);
            client.addRedirectUri("urn:ietf:wg:oauth:2.0:oob");
            client.setAuthenticationFlowBindingOverride("browser", browser.getId());
            client.setPublicClient(false);
        });
    }

    public void testRunConsole() throws Exception {
        Thread.sleep(10000000L);
    }

    @Test
    public void testChallengeFlow() throws Exception {
        this.oauth.clientId(TEST_APP_FLOW);
        String loginFormUrl = this.oauth.getLoginFormUrl();
        ResteasyClient client = AdminClientUtil.createResteasyClient();
        WebTarget loginTarget = client.target(loginFormUrl);
        Response response = loginTarget.request().get();
        Assert.assertEquals((long)401L, (long)response.getStatus());
        String authenticateHeader = response.getHeaderString("WWW-Authenticate");
        Assert.assertNotNull((Object)authenticateHeader);
        String splash = (String)response.readEntity(String.class);
        response.close();
        client.close();
        client = AdminClientUtil.createResteasyClient();
        authenticateHeader = authenticateHeader.trim();
        Pattern callbackPattern = Pattern.compile("callback\\s*=\\s*\"([^\"]+)\"");
        Pattern paramPattern = Pattern.compile("param=\"([^\"]+)\"\\s+label=\"([^\"]+)\"");
        Matcher m = callbackPattern.matcher(authenticateHeader);
        String callback = null;
        if (m.find()) {
            callback = m.group(1);
        }
        m = paramPattern.matcher(authenticateHeader);
        LinkedList<String> params = new LinkedList<String>();
        LinkedList<String> labels = new LinkedList<String>();
        while (m.find()) {
            String param = m.group(1);
            String label = m.group(2);
            params.add(param);
            labels.add(label);
        }
        Assert.assertEquals((Object)"username", params.get(0));
        Assert.assertEquals((Object)"Username:", (Object)((String)labels.get(0)).trim());
        Assert.assertEquals((Object)"password", params.get(1));
        Assert.assertEquals((Object)"Password:", (Object)((String)labels.get(1)).trim());
        Form form = new Form();
        form.param("username", "test-user@localhost");
        form.param("password", "password");
        response = client.target(callback).request().post(Entity.form((Form)form));
        Assert.assertEquals((long)302L, (long)response.getStatus());
        String redirect = response.getHeaderString("Location");
        System.out.println("------");
        System.out.println(redirect);
        Pattern codePattern = Pattern.compile("code=([^&]+)");
        m = codePattern.matcher(redirect);
        Assert.assertTrue((boolean)m.find());
        String code = m.group(1);
        OAuthClient.AccessTokenResponse oauthResponse = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertNotNull((Object)oauthResponse.getAccessToken());
        client.close();
    }
}

