/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import java.net.MalformedURLException;
import java.util.Collections;
import java.util.Map;
import javax.mail.internet.MimeMessage;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.events.EventType;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginPasswordResetPage;
import org.keycloak.testsuite.pages.LoginPasswordUpdatePage;
import org.keycloak.testsuite.pages.LoginTotpPage;
import org.keycloak.testsuite.pages.RegisterPage;
import org.keycloak.testsuite.util.GreenMailRule;
import org.keycloak.testsuite.util.MailUtils;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmRepUtil;
import org.keycloak.testsuite.util.UserBuilder;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class BruteForceTest
extends AbstractTestRealmKeycloakTest {
    private static String userId;
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Rule
    public GreenMailRule greenMail = new GreenMailRule();
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected LoginPasswordResetPage passwordResetPage;
    @Page
    protected LoginPasswordUpdatePage passwordUpdatePage;
    @Page
    private RegisterPage registerPage;
    @Page
    protected LoginTotpPage loginTotpPage;
    private TimeBasedOTP totp = new TimeBasedOTP();
    private int lifespan;
    private static final Integer failureFactor;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        UserRepresentation user = RealmRepUtil.findUser(testRealm, "test-user@localhost");
        UserBuilder.edit(user).totpSecret("totpSecret");
        testRealm.setBruteForceProtected(Boolean.valueOf(true));
        testRealm.setFailureFactor(failureFactor);
        testRealm.setMaxDeltaTimeSeconds(Integer.valueOf(20));
        testRealm.setMaxFailureWaitSeconds(Integer.valueOf(100));
        testRealm.setWaitIncrementSeconds(Integer.valueOf(5));
        userId = user.getId();
        RealmRepUtil.findClientByClientId(testRealm, "test-app").setDirectAccessGrantsEnabled(Boolean.valueOf(true));
        testRealm.getUsers().add(UserBuilder.create().username("user2").email("user2@localhost").password("password").build());
    }

    @Before
    public void config() {
        try {
            this.clearUserFailures();
            this.clearAllUserFailures();
            RealmRepresentation realm = this.adminClient.realm("test").toRepresentation();
            realm.setFailureFactor(failureFactor);
            realm.setMaxDeltaTimeSeconds(Integer.valueOf(20));
            realm.setMaxFailureWaitSeconds(Integer.valueOf(100));
            realm.setWaitIncrementSeconds(Integer.valueOf(5));
            this.adminClient.realm("test").update(realm);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.events.clear();
    }

    @After
    public void slowItDown() throws Exception {
        try {
            this.clearUserFailures();
            this.clearAllUserFailures();
            RealmRepresentation realm = this.adminClient.realm("test").toRepresentation();
            realm.setMaxFailureWaitSeconds(Integer.valueOf(900));
            realm.setMinimumQuickLoginWaitSeconds(Integer.valueOf(60));
            realm.setWaitIncrementSeconds(Integer.valueOf(60));
            realm.setQuickLoginCheckMilliSeconds(Long.valueOf(1000L));
            realm.setMaxDeltaTimeSeconds(Integer.valueOf(43200));
            realm.setFailureFactor(Integer.valueOf(30));
            this.adminClient.realm("test").update(realm);
            this.testingClient.testing().setTimeOffset(Collections.singletonMap("offset", String.valueOf(0)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.events.clear();
        Thread.sleep(100L);
    }

    @Before
    public void before() throws MalformedURLException {
        this.totp = new TimeBasedOTP();
    }

    public String getAdminToken() throws Exception {
        String clientId = "admin-cli";
        return this.oauth.doGrantAccessTokenRequest("master", "admin", "admin", null, clientId, null).getAccessToken();
    }

    public OAuthClient.AccessTokenResponse getTestToken(String password, String totp) throws Exception {
        return this.oauth.doGrantAccessTokenRequest("test", "test-user@localhost", password, totp, this.oauth.getClientId(), "password");
    }

    protected void clearUserFailures() throws Exception {
        this.adminClient.realm("test").attackDetection().clearBruteForceForUser(this.findUser("test-user@localhost").getId());
    }

    protected void clearAllUserFailures() throws Exception {
        this.adminClient.realm("test").attackDetection().clearAllBruteForce();
    }

    @Test
    public void testGrantInvalidPassword() throws Exception {
        String totpSecret = this.totp.generateTOTP("totpSecret");
        OAuthClient.AccessTokenResponse response = this.getTestToken("password", totpSecret);
        Assert.assertNotNull((Object)response.getAccessToken());
        Assert.assertNull((Object)response.getError());
        this.events.clear();
        totpSecret = this.totp.generateTOTP("totpSecret");
        response = this.getTestToken("invalid", totpSecret);
        Assert.assertNull((Object)response.getAccessToken());
        Assert.assertEquals((Object)response.getError(), (Object)"invalid_grant");
        Assert.assertEquals((Object)response.getErrorDescription(), (Object)"Invalid user credentials");
        this.events.clear();
        totpSecret = this.totp.generateTOTP("totpSecret");
        response = this.getTestToken("invalid", totpSecret);
        Assert.assertNull((Object)response.getAccessToken());
        Assert.assertEquals((Object)response.getError(), (Object)"invalid_grant");
        Assert.assertEquals((Object)response.getErrorDescription(), (Object)"Invalid user credentials");
        this.events.clear();
        totpSecret = this.totp.generateTOTP("totpSecret");
        response = this.getTestToken("password", totpSecret);
        Assert.assertNull((Object)response.getAccessToken());
        Assert.assertNotNull((Object)response.getError());
        Assert.assertEquals((Object)"invalid_grant", (Object)response.getError());
        Assert.assertEquals((Object)"Invalid user credentials", (Object)response.getErrorDescription());
        this.assertUserDisabledEvent();
        this.events.clear();
        this.clearUserFailures();
        totpSecret = this.totp.generateTOTP("totpSecret");
        response = this.getTestToken("password", totpSecret);
        Assert.assertNotNull((Object)response.getAccessToken());
        Assert.assertNull((Object)response.getError());
        this.events.clear();
    }

    @Test
    public void testGrantInvalidOtp() throws Exception {
        String totpSecret = this.totp.generateTOTP("totpSecret");
        OAuthClient.AccessTokenResponse response = this.getTestToken("password", totpSecret);
        Assert.assertNotNull((Object)response.getAccessToken());
        Assert.assertNull((Object)response.getError());
        this.events.clear();
        OAuthClient.AccessTokenResponse response2 = this.getTestToken("password", "shite");
        Assert.assertNull((Object)response2.getAccessToken());
        Assert.assertEquals((Object)response2.getError(), (Object)"invalid_grant");
        Assert.assertEquals((Object)response2.getErrorDescription(), (Object)"Invalid user credentials");
        this.events.clear();
        response2 = this.getTestToken("password", "shite");
        Assert.assertNull((Object)response2.getAccessToken());
        Assert.assertEquals((Object)response2.getError(), (Object)"invalid_grant");
        Assert.assertEquals((Object)response2.getErrorDescription(), (Object)"Invalid user credentials");
        this.events.clear();
        totpSecret = this.totp.generateTOTP("totpSecret");
        response = this.getTestToken("password", totpSecret);
        this.assertTokenNull(response);
        Assert.assertNotNull((Object)response.getError());
        Assert.assertEquals((Object)response.getError(), (Object)"invalid_grant");
        Assert.assertEquals((Object)"Invalid user credentials", (Object)response.getErrorDescription());
        this.assertUserDisabledEvent();
        this.events.clear();
        this.clearUserFailures();
        totpSecret = this.totp.generateTOTP("totpSecret");
        response = this.getTestToken("password", totpSecret);
        Assert.assertNotNull((Object)response.getAccessToken());
        Assert.assertNull((Object)response.getError());
        this.events.clear();
    }

    public void assertTokenNull(OAuthClient.AccessTokenResponse response) {
        Assert.assertNull((Object)response.getAccessToken());
    }

    @Test
    public void testGrantMissingOtp() throws Exception {
        String totpSecret = this.totp.generateTOTP("totpSecret");
        OAuthClient.AccessTokenResponse response = this.getTestToken("password", totpSecret);
        Assert.assertNotNull((Object)response.getAccessToken());
        Assert.assertNull((Object)response.getError());
        this.events.clear();
        OAuthClient.AccessTokenResponse response2 = this.getTestToken("password", null);
        Assert.assertNull((Object)response2.getAccessToken());
        Assert.assertEquals((Object)response2.getError(), (Object)"invalid_grant");
        Assert.assertEquals((Object)response2.getErrorDescription(), (Object)"Invalid user credentials");
        this.events.clear();
        response2 = this.getTestToken("password", null);
        Assert.assertNull((Object)response2.getAccessToken());
        Assert.assertEquals((Object)response2.getError(), (Object)"invalid_grant");
        Assert.assertEquals((Object)response2.getErrorDescription(), (Object)"Invalid user credentials");
        this.events.clear();
        totpSecret = this.totp.generateTOTP("totpSecret");
        response = this.getTestToken("password", totpSecret);
        this.assertTokenNull(response);
        Assert.assertNotNull((Object)response.getError());
        Assert.assertEquals((Object)response.getError(), (Object)"invalid_grant");
        Assert.assertEquals((Object)"Invalid user credentials", (Object)response.getErrorDescription());
        this.assertUserDisabledEvent();
        this.events.clear();
        this.clearUserFailures();
        totpSecret = this.totp.generateTOTP("totpSecret");
        response = this.getTestToken("password", totpSecret);
        Assert.assertNotNull((Object)response.getAccessToken());
        Assert.assertNull((Object)response.getError());
        this.events.clear();
    }

    @Test
    public void testNumberOfFailuresForDisabledUsersWithPasswordGrantType() throws Exception {
        UserRepresentation user;
        try {
            user = (UserRepresentation)this.adminClient.realm("test").users().search("test-user@localhost", Integer.valueOf(0), Integer.valueOf(1)).get(0);
            this.assertUserNumberOfFailures(user.getId(), 0);
            user.setEnabled(Boolean.valueOf(false));
            this.updateUser(user);
            OAuthClient.AccessTokenResponse response = this.getTestToken("invalid", "invalid");
            Assert.assertNull((Object)response.getAccessToken());
            Assert.assertEquals((Object)response.getError(), (Object)"invalid_grant");
            Assert.assertEquals((Object)response.getErrorDescription(), (Object)"Account disabled");
            this.events.clear();
            this.assertUserNumberOfFailures(user.getId(), 0);
        }
        finally {
            user = (UserRepresentation)this.adminClient.realm("test").users().search("test-user@localhost", Integer.valueOf(0), Integer.valueOf(1)).get(0);
            user.setEnabled(Boolean.valueOf(true));
            this.updateUser(user);
            this.events.clear();
        }
    }

    @Test
    public void testNumberOfFailuresForTemporaryDisabledUsersWithPasswordGrantType() throws Exception {
        UserRepresentation user = (UserRepresentation)this.adminClient.realm("test").users().search("test-user@localhost", Integer.valueOf(0), Integer.valueOf(1)).get(0);
        this.lockUserWithPasswordGrant();
        this.assertUserNumberOfFailures(user.getId(), failureFactor);
        this.sendInvalidPasswordPasswordGrant();
        this.assertUserNumberOfFailures(user.getId(), failureFactor);
        this.events.clear();
    }

    @Test
    public void testNumberOfFailuresForPermanentlyDisabledUsersWithPasswordGrantType() throws Exception {
        UserRepresentation user;
        RealmRepresentation realm = this.testRealm().toRepresentation();
        try {
            realm.setPermanentLockout(Boolean.valueOf(true));
            this.testRealm().update(realm);
            user = (UserRepresentation)this.adminClient.realm("test").users().search("test-user@localhost", Integer.valueOf(0), Integer.valueOf(1)).get(0);
            this.lockUserWithPasswordGrant();
            this.assertUserNumberOfFailures(user.getId(), failureFactor);
            this.assertUserDisabledReason("permanentLockout");
            this.sendInvalidPasswordPasswordGrant();
            this.assertUserNumberOfFailures(user.getId(), failureFactor);
            this.events.clear();
        }
        finally {
            realm.setPermanentLockout(Boolean.valueOf(false));
            this.testRealm().update(realm);
            user = (UserRepresentation)this.adminClient.realm("test").users().search("test-user@localhost", Integer.valueOf(0), Integer.valueOf(1)).get(0);
            user.setEnabled(Boolean.valueOf(true));
            this.updateUser(user);
        }
    }

    @Test
    public void testBrowserInvalidPassword() throws Exception {
        this.loginSuccess();
        this.loginInvalidPassword();
        this.loginInvalidPassword();
        this.expectTemporarilyDisabled();
        this.expectTemporarilyDisabled("test-user@localhost", null, "invalid");
        this.clearUserFailures();
        this.loginSuccess();
        this.loginInvalidPassword();
        this.loginInvalidPassword();
        this.expectTemporarilyDisabled();
        this.expectTemporarilyDisabled("test-user@localhost", null, "invalid");
        this.clearAllUserFailures();
        this.loginSuccess();
    }

    @Test
    public void testWait() throws Exception {
        this.loginSuccess();
        this.loginInvalidPassword();
        this.loginInvalidPassword();
        this.expectTemporarilyDisabled();
        this.expectTemporarilyDisabled("test-user@localhost", null, "invalid");
        this.testingClient.testing().setTimeOffset(Collections.singletonMap("offset", String.valueOf(6)));
        this.loginSuccess();
        this.clearUserFailures();
        this.clearAllUserFailures();
        this.loginSuccess();
        this.testingClient.testing().setTimeOffset(Collections.singletonMap("offset", String.valueOf(0)));
    }

    @Test
    public void testBrowserInvalidPasswordDifferentCase() throws Exception {
        this.loginSuccess("test-user@localhost");
        this.loginInvalidPassword("test-User@localhost");
        this.loginInvalidPassword("Test-user@localhost");
        this.expectTemporarilyDisabled();
        this.expectTemporarilyDisabled("test-user@localhost", null, "invalid");
        this.clearAllUserFailures();
    }

    @Test
    public void testEmail() throws Exception {
        String userId = ((UserRepresentation)this.adminClient.realm("test").users().search("user2", null, null, null, Integer.valueOf(0), Integer.valueOf(1)).get(0)).getId();
        this.loginInvalidPassword("user2@localhost");
        this.loginInvalidPassword("user2@localhost");
        this.expectTemporarilyDisabled("user2@localhost", userId);
        this.clearAllUserFailures();
    }

    @Test
    public void testBrowserMissingPassword() throws Exception {
        this.loginSuccess();
        this.loginMissingPassword();
        this.loginMissingPassword();
        this.loginSuccess();
    }

    @Test
    public void testBrowserInvalidTotp() throws Exception {
        this.loginSuccess();
        this.loginInvalidPassword();
        this.loginWithTotpFailure();
        this.continueLoginWithCorrectTotpExpectFailure();
        this.continueLoginWithInvalidTotp();
        this.clearUserFailures();
        this.continueLoginWithTotp();
    }

    @Test
    public void testBrowserMissingTotp() throws Exception {
        this.loginSuccess();
        this.loginWithMissingTotp();
        this.loginWithMissingTotp();
        this.continueLoginWithMissingTotp();
        this.continueLoginWithCorrectTotpExpectFailure();
        this.testingClient.testing().setTimeOffset(Collections.singletonMap("offset", String.valueOf(6)));
        this.continueLoginWithTotp();
        this.testingClient.testing().setTimeOffset(Collections.singletonMap("offset", String.valueOf(0)));
    }

    @Test
    public void testPermanentLockout() throws Exception {
        UserRepresentation user;
        RealmRepresentation realm = this.testRealm().toRepresentation();
        try {
            realm.setPermanentLockout(Boolean.valueOf(true));
            this.testRealm().update(realm);
            this.loginInvalidPassword();
            this.loginInvalidPassword();
            this.expectPermanentlyDisabled();
            user = (UserRepresentation)this.adminClient.realm("test").users().search("test-user@localhost", Integer.valueOf(0), Integer.valueOf(1)).get(0);
            Assert.assertFalse((boolean)user.isEnabled());
            this.assertUserDisabledReason("permanentLockout");
            user.setEnabled(Boolean.valueOf(true));
            this.updateUser(user);
            this.assertUserDisabledReason(null);
        }
        finally {
            realm.setPermanentLockout(Boolean.valueOf(false));
            this.testRealm().update(realm);
            user = (UserRepresentation)this.adminClient.realm("test").users().search("test-user@localhost", Integer.valueOf(0), Integer.valueOf(1)).get(0);
            user.setEnabled(Boolean.valueOf(true));
            this.updateUser(user);
        }
    }

    @Test
    public void testResetLoginFailureCount() throws Exception {
        RealmRepresentation realm = this.testRealm().toRepresentation();
        try {
            realm.setPermanentLockout(Boolean.valueOf(true));
            this.testRealm().update(realm);
            this.loginInvalidPassword();
            this.loginSuccess();
            this.loginInvalidPassword();
            this.loginSuccess();
            Assert.assertTrue((boolean)((UserRepresentation)this.adminClient.realm("test").users().search("test-user@localhost", Integer.valueOf(0), Integer.valueOf(1)).get(0)).isEnabled());
        }
        finally {
            realm.setPermanentLockout(Boolean.valueOf(false));
            this.testRealm().update(realm);
        }
    }

    @Test
    public void testFailureCountResetWithPasswordGrantType() throws Exception {
        String totpSecret = this.totp.generateTOTP("totpSecret");
        OAuthClient.AccessTokenResponse response = this.getTestToken("invalid", totpSecret);
        Assert.assertNull((Object)response.getAccessToken());
        Assert.assertEquals((Object)response.getError(), (Object)"invalid_grant");
        Assert.assertEquals((Object)response.getErrorDescription(), (Object)"Invalid user credentials");
        UserRepresentation user = (UserRepresentation)this.adminClient.realm("test").users().search("test-user@localhost", Integer.valueOf(0), Integer.valueOf(1)).get(0);
        Map userAttackInfo = this.adminClient.realm("test").attackDetection().bruteForceUserStatus(user.getId());
        Assert.assertThat((Object)((Integer)userAttackInfo.get("numFailures")), (Matcher)CoreMatchers.is((Object)1));
        response = this.getTestToken("password", totpSecret);
        Assert.assertNotNull((Object)response.getAccessToken());
        Assert.assertNull((Object)response.getError());
        this.events.clear();
        userAttackInfo = this.adminClient.realm("test").attackDetection().bruteForceUserStatus(user.getId());
        Assert.assertThat((Object)((Integer)userAttackInfo.get("numFailures")), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testNonExistingAccounts() throws Exception {
        this.loginInvalidPassword("non-existent-user");
        this.loginInvalidPassword("non-existent-user");
        this.loginInvalidPassword("non-existent-user");
        this.registerUser("non-existent-user");
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testResetPassword() throws Exception {
        String userId = ((UserRepresentation)this.adminClient.realm("test").users().search("user2", null, null, null, Integer.valueOf(0), Integer.valueOf(1)).get(0)).getId();
        this.loginInvalidPassword("user2");
        this.loginInvalidPassword("user2");
        this.expectTemporarilyDisabled("user2", userId, "invalid");
        this.loginPage.resetPassword();
        this.passwordResetPage.assertCurrent();
        this.passwordResetPage.changePassword("user2");
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"You should receive an email shortly with further instructions.", (Object)this.loginPage.getSuccessMessage());
        this.events.expectRequiredAction(EventType.SEND_RESET_PASSWORD).user(userId).assertEvent();
        MimeMessage message = this.greenMail.getReceivedMessages()[0];
        String passwordResetEmailLink = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
        this.driver.navigate().to(passwordResetEmailLink.trim());
        Assert.assertTrue((boolean)this.passwordUpdatePage.isCurrent());
        UserRepresentation userRepresentation = this.testRealm().users().get(userId).toRepresentation();
        Assert.assertFalse((boolean)userRepresentation.isEnabled());
        this.updatePasswordPage.updatePasswords("password", "password");
        this.events.expectRequiredAction(EventType.UPDATE_PASSWORD).user(userId).assertEvent();
        userRepresentation = this.testRealm().users().get(userId).toRepresentation();
        Assert.assertTrue((boolean)userRepresentation.isEnabled());
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.appPage.logout();
        this.events.clear();
    }

    public void expectTemporarilyDisabled() throws Exception {
        this.expectTemporarilyDisabled("test-user@localhost", null, "password");
    }

    public void expectTemporarilyDisabled(String username, String userId) throws Exception {
        this.expectTemporarilyDisabled(username, userId, "password");
    }

    public void expectTemporarilyDisabled(String username, String userId, String password) throws Exception {
        this.loginPage.open();
        this.loginPage.login(username, password);
        this.loginPage.assertCurrent();
        String src = this.driver.getPageSource();
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getInputError());
        AssertEvents.ExpectedEvent event = this.events.expectLogin().session((String)null).error("user_temporarily_disabled").detail("username", username).removeDetail("consent");
        if (userId != null) {
            event.user(userId);
        }
        event.assertEvent();
    }

    public void expectPermanentlyDisabled() throws Exception {
        this.expectPermanentlyDisabled("test-user@localhost", null);
    }

    public void expectPermanentlyDisabled(String username, String userId) throws Exception {
        this.loginPage.open();
        this.loginPage.login(username, "password");
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getInputError());
        AssertEvents.ExpectedEvent event = this.events.expectLogin().session((String)null).error("user_disabled").detail("username", username).removeDetail("consent");
        if (userId != null) {
            event.user(userId);
        }
        event.assertEvent();
    }

    public void loginSuccess() throws Exception {
        this.loginSuccess("test-user@localhost");
    }

    public void loginSuccess(String username) throws Exception {
        this.loginPage.open();
        this.loginPage.login(username, "password");
        this.loginTotpPage.assertCurrent();
        String totpSecret = this.totp.generateTOTP("totpSecret");
        this.loginTotpPage.login(totpSecret);
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().assertEvent();
        this.appPage.logout();
        this.events.clear();
    }

    public void loginWithTotpFailure() {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.loginTotpPage.assertCurrent();
        this.loginTotpPage.login("123456");
        this.loginTotpPage.assertCurrent();
        Assert.assertEquals((Object)"Invalid authenticator code.", (Object)this.loginTotpPage.getInputError());
        this.events.clear();
    }

    public void continueLoginWithTotp() {
        this.loginTotpPage.assertCurrent();
        String totpSecret = this.totp.generateTOTP("totpSecret");
        this.loginTotpPage.login(totpSecret);
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().assertEvent();
        this.appPage.logout();
        this.events.clear();
    }

    public void continueLoginWithCorrectTotpExpectFailure() {
        this.loginTotpPage.assertCurrent();
        String totpSecret = this.totp.generateTOTP("totpSecret");
        this.loginTotpPage.login(totpSecret);
        this.loginTotpPage.assertCurrent();
        Assert.assertEquals((Object)"Invalid authenticator code.", (Object)this.loginTotpPage.getInputError());
        this.events.clear();
    }

    public void continueLoginWithInvalidTotp() {
        this.loginTotpPage.assertCurrent();
        this.loginTotpPage.login("123456");
        this.loginTotpPage.assertCurrent();
        Assert.assertEquals((Object)"Invalid authenticator code.", (Object)this.loginTotpPage.getInputError());
        this.events.clear();
    }

    public void continueLoginWithMissingTotp() {
        this.loginTotpPage.assertCurrent();
        this.loginTotpPage.login(null);
        this.loginTotpPage.assertCurrent();
        Assert.assertEquals((Object)"Invalid authenticator code.", (Object)this.loginTotpPage.getInputError());
        this.events.clear();
    }

    public void loginWithMissingTotp() throws Exception {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.loginTotpPage.assertCurrent();
        this.loginTotpPage.login(null);
        this.loginTotpPage.assertCurrent();
        Assert.assertEquals((Object)"Invalid authenticator code.", (Object)this.loginTotpPage.getInputError());
        this.events.clear();
    }

    public void loginInvalidPassword() throws Exception {
        this.loginInvalidPassword("test-user@localhost");
    }

    public void loginInvalidPassword(String username) throws Exception {
        this.loginPage.open();
        this.loginPage.login(username, "invalid");
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getInputError());
        this.events.clear();
    }

    public void loginMissingPassword() {
        this.loginPage.open();
        this.loginPage.missingPassword("test-user@localhost");
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getInputError());
        this.events.clear();
    }

    public void registerUser(String username) {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("user", "name", username + "@localhost", username, "password", "password");
        Assert.assertNull((Object)this.registerPage.getInstruction());
        this.events.clear();
    }

    private void assertUserDisabledEvent() {
        this.events.expect(EventType.LOGIN_ERROR).error("user_temporarily_disabled").assertEvent();
    }

    private void assertUserDisabledReason(String expected) {
        String actual = ((UserRepresentation)this.adminClient.realm("test").users().search("test-user@localhost", Integer.valueOf(0), Integer.valueOf(1)).get(0)).firstAttribute("disabledReason");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    private void assertUserNumberOfFailures(String userId, Integer numberOfFailures) {
        Map userAttackInfo = this.adminClient.realm("test").attackDetection().bruteForceUserStatus(userId);
        MatcherAssert.assertThat((Object)((Integer)userAttackInfo.get("numFailures")), (Matcher)CoreMatchers.is((Object)numberOfFailures));
    }

    private void sendInvalidPasswordPasswordGrant() throws Exception {
        String totpSecret = this.totp.generateTOTP("totpSecret");
        OAuthClient.AccessTokenResponse response = this.getTestToken("invalid", totpSecret);
        Assert.assertNull((Object)response.getAccessToken());
        Assert.assertEquals((Object)response.getError(), (Object)"invalid_grant");
        Assert.assertEquals((Object)response.getErrorDescription(), (Object)"Invalid user credentials");
        this.events.clear();
    }

    private void lockUserWithPasswordGrant() throws Exception {
        String totpSecret = this.totp.generateTOTP("totpSecret");
        OAuthClient.AccessTokenResponse response = this.getTestToken("password", totpSecret);
        Assert.assertNotNull((Object)response.getAccessToken());
        Assert.assertNull((Object)response.getError());
        this.events.clear();
        for (int i = 0; i < failureFactor; ++i) {
            this.sendInvalidPasswordPasswordGrant();
        }
    }

    static {
        failureFactor = 2;
    }
}

