/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import java.io.IOException;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.InfoPage;
import org.keycloak.testsuite.pages.LoginExpiredPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginPasswordResetPage;
import org.keycloak.testsuite.pages.LoginPasswordUpdatePage;
import org.keycloak.testsuite.pages.LoginUpdateProfilePage;
import org.keycloak.testsuite.pages.OAuthGrantPage;
import org.keycloak.testsuite.pages.RegisterPage;
import org.keycloak.testsuite.pages.VerifyEmailPage;
import org.keycloak.testsuite.util.GreenMailRule;
import org.keycloak.testsuite.util.MailUtils;
import org.keycloak.testsuite.util.UserBuilder;

public class BrowserButtonsTest
extends AbstractTestRealmKeycloakTest {
    private String userId;
    @Rule
    public GreenMailRule greenMail = new GreenMailRule();
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected ErrorPage errorPage;
    @Page
    protected InfoPage infoPage;
    @Page
    protected VerifyEmailPage verifyEmailPage;
    @Page
    protected LoginPasswordResetPage resetPasswordPage;
    @Page
    protected LoginPasswordUpdatePage updatePasswordPage;
    @Page
    protected LoginUpdateProfilePage updateProfilePage;
    @Page
    protected LoginExpiredPage loginExpiredPage;
    @Page
    protected RegisterPage registerPage;
    @Page
    protected OAuthGrantPage grantPage;
    @Rule
    public AssertEvents events = new AssertEvents(this);
    private int expectedMessagesCount;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Before
    public void setup() {
        UserRepresentation user = UserBuilder.create().username("login-test").email("login@test.com").enabled(true).requiredAction(UserModel.RequiredAction.UPDATE_PROFILE.toString()).requiredAction(UserModel.RequiredAction.UPDATE_PASSWORD.toString()).build();
        this.userId = ApiUtil.createUserAndResetPasswordWithAdminClient((RealmResource)this.testRealm(), (UserRepresentation)user, (String)"password", (boolean)true);
        this.expectedMessagesCount = 0;
        this.getCleanup().addUserId(this.userId);
        this.oauth.clientId("test-app");
    }

    @Test
    public void invalidLoginAndBackButton() throws IOException, MessagingException {
        this.loginPage.open();
        this.loginPage.login("login-test2", "invalid");
        this.loginPage.assertCurrent();
        this.loginPage.login("login-test3", "invalid");
        this.loginPage.assertCurrent();
        this.driver.navigate().back();
        this.loginPage.assertCurrent();
        this.driver.navigate().refresh();
        this.loginPage.assertCurrent();
    }

    @Test
    public void requiredActionsBackForwardTest() throws IOException, MessagingException {
        this.loginPage.open();
        this.loginPage.login("login-test", "password");
        this.updatePasswordPage.assertCurrent();
        this.updatePasswordPage.changePassword("password", "password");
        this.updateProfilePage.assertCurrent();
        this.driver.navigate().back();
        this.loginExpiredPage.assertCurrent();
        this.driver.navigate().forward();
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.update("John", "Doe3", "john@doe3.com");
        this.appPage.assertCurrent();
    }

    @Test
    public void requiredActionsBackAndRefreshTest() throws IOException, MessagingException {
        this.loginPage.open();
        this.loginPage.login("login-test", "password");
        this.updatePasswordPage.assertCurrent();
        this.driver.navigate().refresh();
        this.updatePasswordPage.assertCurrent();
        this.updatePasswordPage.changePassword("password", "password");
        this.updateProfilePage.assertCurrent();
        this.driver.navigate().back();
        this.loginExpiredPage.assertCurrent();
        this.driver.navigate().refresh();
        this.loginExpiredPage.assertCurrent();
        this.loginExpiredPage.clickLoginRestartLink();
        this.loginPage.assertCurrent();
        this.loginPage.login("login-test", "password");
        this.updateProfilePage.assertCurrent();
        this.driver.navigate().back();
        this.loginExpiredPage.assertCurrent();
        this.loginExpiredPage.clickLoginContinueLink();
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.update("John", "Doe3", "john@doe3.com");
        this.appPage.assertCurrent();
    }

    @Test
    public void consentRefresh() {
        this.oauth.clientId("third-party");
        this.loginPage.open();
        this.loginPage.login("login-test", "password");
        this.updatePasswordPage.changePassword("password", "password");
        this.updateProfilePage.update("John", "Doe3", "john@doe3.com");
        this.grantPage.assertCurrent();
        this.driver.navigate().back();
        this.loginExpiredPage.assertCurrent();
        this.loginExpiredPage.clickLoginContinueLink();
        this.grantPage.assertCurrent();
        this.driver.navigate().refresh();
        this.grantPage.assertCurrent();
        this.grantPage.accept();
        this.appPage.assertCurrent();
    }

    @Test
    public void clickBackButtonAfterReturnFromRegister() throws Exception {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.clickBackToLogin();
        this.loginPage.assertCurrent();
        this.driver.navigate().back();
        this.registerPage.assertCurrent();
    }

    @Test
    public void clickBackButtonFromRegisterPage() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.driver.navigate().back();
        this.loginPage.assertCurrent();
    }

    @Test
    public void clickRefreshButtonOnRegisterPage() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.driver.navigate().refresh();
        this.registerPage.assertCurrent();
        this.registerPage.clickBackToLogin();
        this.loginPage.assertCurrent();
        this.driver.navigate().refresh();
        this.loginPage.assertCurrent();
    }

    @Test
    public void backButtonToAuthorizationEndpoint() {
        this.loginPage.open();
        this.loginPage.login("login-test", "password");
        this.updatePasswordPage.assertCurrent();
        this.driver.navigate().back();
        this.loginPage.assertCurrent();
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void backButtonInResetPasswordFlow() throws Exception {
        this.loginPage.open();
        this.loginPage.login("login-test", "bad-username");
        this.loginPage.resetPassword();
        this.resetPasswordPage.assertCurrent();
        this.resetPasswordPage.changePassword("login-test");
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"You should receive an email shortly with further instructions.", (Object)this.loginPage.getSuccessMessage());
        MimeMessage message = this.greenMail.getReceivedMessages()[this.greenMail.getReceivedMessages().length - 1];
        String changePasswordUrl = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
        this.driver.navigate().to(changePasswordUrl.trim());
        this.updatePasswordPage.assertCurrent();
        this.driver.navigate().back();
        this.loginPage.assertCurrent();
        this.driver.navigate().forward();
        this.updatePasswordPage.assertCurrent();
        this.driver.navigate().back();
        this.loginPage.assertCurrent();
        this.loginPage.login("login-test", "password");
        this.updatePasswordPage.assertCurrent();
    }

    @Test
    public void appInitiatedRegistrationWithBackButton() throws Exception {
        String appInitiatedRegisterUrl = this.oauth.getLoginFormUrl();
        appInitiatedRegisterUrl = appInitiatedRegisterUrl.replace("openid-connect/auth", "openid-connect/registrations");
        this.driver.navigate().to(appInitiatedRegisterUrl);
        this.registerPage.assertCurrent();
        this.registerPage.clickBackToLogin();
        this.loginPage.assertCurrent();
        this.loginPage.login("login-test", "password");
        this.updatePasswordPage.assertCurrent();
        this.driver.navigate().back();
        this.loginExpiredPage.assertCurrent();
        this.loginExpiredPage.clickLoginContinueLink();
        this.updatePasswordPage.assertCurrent();
        this.driver.navigate().back();
        this.loginExpiredPage.assertCurrent();
        this.loginExpiredPage.clickLoginRestartLink();
        this.registerPage.assertCurrent();
    }
}

