/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import java.io.Serializable;
import java.util.HashMap;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.openqa.selenium.By;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class AuthenticatorSubflowsTest
extends AbstractTestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected ErrorPage errorPage;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Before
    public void setupFlows() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            if (realm.getBrowserFlow().getAlias().equals("parent-flow")) {
                return;
            }
            AuthenticationFlowModel browser = new AuthenticationFlowModel();
            browser.setAlias("parent-flow");
            browser.setDescription("browser based authentication");
            browser.setProviderId("basic-flow");
            browser.setTopLevel(true);
            browser.setBuiltIn(true);
            browser = realm.addAuthenticationFlow(browser);
            realm.setBrowserFlow(browser);
            AuthenticationFlowModel subflow1 = new AuthenticationFlowModel();
            subflow1.setTopLevel(false);
            subflow1.setBuiltIn(true);
            subflow1.setAlias("subflow-1");
            subflow1.setDescription("Parameter 'foo=bar1' AND username+password");
            subflow1.setProviderId("basic-flow");
            subflow1 = realm.addAuthenticationFlow(subflow1);
            AuthenticationExecutionModel execution = new AuthenticationExecutionModel();
            execution.setParentFlow(browser.getId());
            execution.setRequirement(AuthenticationExecutionModel.Requirement.ALTERNATIVE);
            execution.setFlowId(subflow1.getId());
            execution.setPriority(10);
            execution.setAuthenticatorFlow(true);
            realm.addAuthenticatorExecution(execution);
            execution = new AuthenticationExecutionModel();
            execution.setParentFlow(subflow1.getId());
            execution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED);
            execution.setAuthenticator("expected-param-authenticator");
            execution.setPriority(10);
            execution.setAuthenticatorFlow(false);
            AuthenticatorConfigModel configModel = new AuthenticatorConfigModel();
            configModel.setAlias("bar1");
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("expected_value", "bar1");
            configModel.setConfig(config);
            configModel = realm.addAuthenticatorConfig(configModel);
            execution.setAuthenticatorConfig(configModel.getId());
            realm.addAuthenticatorExecution(execution);
            execution = new AuthenticationExecutionModel();
            execution.setParentFlow(subflow1.getId());
            execution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED);
            execution.setAuthenticator("auth-username-password-form");
            execution.setPriority(20);
            execution.setAuthenticatorFlow(false);
            realm.addAuthenticatorExecution(execution);
            AuthenticationFlowModel subflow2 = new AuthenticationFlowModel();
            subflow2.setTopLevel(false);
            subflow2.setBuiltIn(true);
            subflow2.setAlias("subflow-2");
            subflow2.setDescription("username+password AND pushButton");
            subflow2.setProviderId("basic-flow");
            subflow2 = realm.addAuthenticationFlow(subflow2);
            execution = new AuthenticationExecutionModel();
            execution.setParentFlow(browser.getId());
            execution.setRequirement(AuthenticationExecutionModel.Requirement.ALTERNATIVE);
            execution.setFlowId(subflow2.getId());
            execution.setPriority(20);
            execution.setAuthenticatorFlow(true);
            realm.addAuthenticatorExecution(execution);
            execution = new AuthenticationExecutionModel();
            execution.setParentFlow(subflow2.getId());
            execution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED);
            execution.setAuthenticator("push-button-authenticator");
            execution.setPriority(10);
            execution.setAuthenticatorFlow(false);
            realm.addAuthenticatorExecution(execution);
            execution = new AuthenticationExecutionModel();
            execution.setParentFlow(subflow2.getId());
            execution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED);
            execution.setAuthenticator("auth-username-password-form");
            execution.setPriority(20);
            execution.setAuthenticatorFlow(false);
            realm.addAuthenticatorExecution(execution);
            AuthenticationFlowModel subflow3 = new AuthenticationFlowModel();
            subflow3.setTopLevel(false);
            subflow3.setBuiltIn(true);
            subflow3.setAlias("subflow-3");
            subflow3.setDescription("alternative subflow with child subflows");
            subflow3.setProviderId("basic-flow");
            subflow3 = realm.addAuthenticationFlow(subflow3);
            execution = new AuthenticationExecutionModel();
            execution.setParentFlow(browser.getId());
            execution.setRequirement(AuthenticationExecutionModel.Requirement.ALTERNATIVE);
            execution.setFlowId(subflow3.getId());
            execution.setPriority(30);
            execution.setAuthenticatorFlow(true);
            realm.addAuthenticatorExecution(execution);
            AuthenticationFlowModel subflow31 = new AuthenticationFlowModel();
            subflow31.setTopLevel(false);
            subflow31.setBuiltIn(true);
            subflow31.setAlias("subflow-31");
            subflow31.setDescription("subflow-31");
            subflow31.setProviderId("basic-flow");
            subflow31 = realm.addAuthenticationFlow(subflow31);
            execution = new AuthenticationExecutionModel();
            execution.setParentFlow(subflow3.getId());
            execution.setRequirement(AuthenticationExecutionModel.Requirement.ALTERNATIVE);
            execution.setFlowId(subflow31.getId());
            execution.setPriority(10);
            execution.setAuthenticatorFlow(true);
            realm.addAuthenticatorExecution(execution);
            execution = new AuthenticationExecutionModel();
            execution.setParentFlow(subflow31.getId());
            execution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED);
            execution.setAuthenticator("expected-param-authenticator");
            execution.setPriority(10);
            execution.setAuthenticatorFlow(false);
            configModel = new AuthenticatorConfigModel();
            configModel.setAlias("bar2");
            config = new HashMap();
            config.put("expected_value", "bar2");
            config.put("logged_user", "john-doh@localhost");
            configModel.setConfig(config);
            configModel = realm.addAuthenticatorConfig(configModel);
            execution.setAuthenticatorConfig(configModel.getId());
            realm.addAuthenticatorExecution(execution);
            execution = new AuthenticationExecutionModel();
            execution.setParentFlow(subflow31.getId());
            execution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED);
            execution.setAuthenticator("push-button-authenticator");
            execution.setPriority(20);
            execution.setAuthenticatorFlow(false);
            realm.addAuthenticatorExecution(execution);
            execution = new AuthenticationExecutionModel();
            execution.setParentFlow(subflow3.getId());
            execution.setRequirement(AuthenticationExecutionModel.Requirement.ALTERNATIVE);
            execution.setAuthenticator("expected-param-authenticator");
            execution.setPriority(20);
            execution.setAuthenticatorFlow(false);
            configModel = new AuthenticatorConfigModel();
            configModel.setAlias("bar3");
            config = new HashMap();
            config.put("expected_value", "bar3");
            config.put("logged_user", "keycloak-user@localhost");
            configModel.setConfig(config);
            configModel = realm.addAuthenticatorConfig(configModel);
            execution.setAuthenticatorConfig(configModel.getId());
            realm.addAuthenticatorExecution(execution);
        });
    }

    @Test
    public void testSubflow1() throws Exception {
        String loginFormUrl = this.oauth.getLoginFormUrl();
        loginFormUrl = loginFormUrl + "&foo=bar1";
        this.log.info((Object)("loginFormUrl: " + loginFormUrl));
        this.driver.navigate().to(loginFormUrl);
        this.loginPage.assertCurrent();
        this.oauth.fillLoginForm("test-user@localhost", "password");
        this.appPage.assertCurrent();
        this.events.expectLogin().detail("username", "test-user@localhost").assertEvent();
    }

    @Test
    public void testSubflow2() throws Exception {
        String loginFormUrl = this.oauth.getLoginFormUrl();
        this.log.info((Object)("loginFormUrl: " + loginFormUrl));
        this.driver.navigate().to(loginFormUrl);
        Assert.assertEquals((Object)"PushTheButton", (Object)this.driver.getTitle());
        this.driver.findElement(By.name((String)"submit1")).click();
        this.loginPage.assertCurrent();
        this.oauth.fillLoginForm("test-user@localhost", "password");
        this.appPage.assertCurrent();
        this.events.expectLogin().detail("username", "test-user@localhost").assertEvent();
    }
}

