/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.forms.BrowserFlowTest;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.LoginUsernameOnlyPage;
import org.keycloak.testsuite.pages.PasswordPage;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.FlowUtil;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class AllowDenyAuthenticatorTest
extends AbstractTestRealmKeycloakTest {
    @Page
    protected LoginUsernameOnlyPage loginUsernameOnlyPage;
    @Page
    protected PasswordPage passwordPage;
    @Page
    protected ErrorPage errorPage;
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Test
    public void testDenyAccessWithDefaultMessage() {
        this.testErrorMessageInDenyAccess(null, "Access denied");
    }

    @Test
    public void testDenyAccessWithParticularMessage() {
        String message = "You are not allowed to authenticate.";
        this.testErrorMessageInDenyAccess("You are not allowed to authenticate.", "You are not allowed to authenticate.");
    }

    @Test
    public void testDenyAccessWithProperty() {
        String property = "brokerLinkingSessionExpired";
        String message = "Requested broker account linking, but current session is no longer valid.";
        this.testErrorMessageInDenyAccess("brokerLinkingSessionExpired", "Requested broker account linking, but current session is no longer valid.");
    }

    @Test
    public void testDenyAccessWithNotExistingProperty() {
        String property = "not-existing-property";
        String message = "not-existing-property";
        this.testErrorMessageInDenyAccess("not-existing-property", "not-existing-property");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testErrorMessageInDenyAccess(String setUpMessage, String expectedMessage) {
        String flowAlias = "browser - deny defaultMessage";
        String userWithoutAttribute = "test-user@localhost";
        HashMap<String, String> denyAccessConfigMap = new HashMap<String, String>();
        if (setUpMessage != null) {
            denyAccessConfigMap.put("denyErrorMessage", setUpMessage);
        }
        this.configureBrowserFlowWithDenyAccess("browser - deny defaultMessage", denyAccessConfigMap);
        try {
            this.loginUsernameOnlyPage.open();
            this.loginUsernameOnlyPage.assertCurrent();
            this.loginUsernameOnlyPage.login("test-user@localhost");
            this.errorPage.assertCurrent();
            MatcherAssert.assertThat((Object)this.errorPage.getError(), (Matcher)Matchers.is((Object)expectedMessage));
            this.events.expectLogin().user((String)null).session((String)null).error("access_denied").detail("username", "test-user@localhost").removeDetail("consent").assertEvent();
        }
        finally {
            BrowserFlowTest.revertFlows(this.testRealm(), "browser - deny defaultMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDenyAccessWithNegateUserAttributeCondition() {
        String flowAlias = "browser - user attribute condition";
        String userWithoutAttribute = "test-user@localhost";
        String errorMessage = "You don't have necessary attribute.";
        HashMap<String, String> attributeConfigMap = new HashMap<String, String>();
        attributeConfigMap.put("attribute_name", "attribute");
        attributeConfigMap.put("attribute_expected_value", "value");
        attributeConfigMap.put("not", "true");
        HashMap<String, String> denyAccessConfigMap = new HashMap<String, String>();
        denyAccessConfigMap.put("denyErrorMessage", "You don't have necessary attribute.");
        this.configureBrowserFlowWithDenyAccessInConditionalFlow("browser - user attribute condition", "conditional-user-attribute", attributeConfigMap, denyAccessConfigMap);
        try {
            this.loginUsernameOnlyPage.open();
            this.loginUsernameOnlyPage.assertCurrent();
            this.loginUsernameOnlyPage.login("test-user@localhost");
            this.errorPage.assertCurrent();
            MatcherAssert.assertThat((Object)this.errorPage.getError(), (Matcher)Matchers.is((Object)"You don't have necessary attribute."));
            this.events.expectLogin().user((String)null).session((String)null).error("access_denied").detail("username", "test-user@localhost").removeDetail("consent").assertEvent();
        }
        finally {
            BrowserFlowTest.revertFlows(this.testRealm(), "browser - user attribute condition");
        }
    }

    @Test
    public void testDenyAccessWithRoleCondition() {
        this.denyAccessWithRoleCondition(false);
    }

    @Test
    public void testDenyAccessWithNegateRoleCondition() {
        this.denyAccessWithRoleCondition(true);
    }

    private void denyAccessWithRoleCondition(boolean negateOutput) {
        String flowAlias = "browser-deny";
        String userWithRole = "test-user@localhost";
        String userWithoutRole = "john-doh@localhost";
        String role = "offline_access";
        String errorMessage = "Your account doesn't have the required role";
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("condUserRole", "offline_access");
        config.put("negate", Boolean.toString(negateOutput));
        HashMap<String, String> denyConfig = new HashMap<String, String>();
        denyConfig.put("denyErrorMessage", "Your account doesn't have the required role");
        this.configureBrowserFlowWithDenyAccessInConditionalFlow("browser-deny", "conditional-user-role", config, denyConfig);
        this.denyAccessInConditionalFlow("browser-deny", negateOutput ? "john-doh@localhost" : "test-user@localhost", negateOutput ? "test-user@localhost" : "john-doh@localhost", "Your account doesn't have the required role");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void denyAccessInConditionalFlow(String flowAlias, String userCondMatch, String userCondNotMatch, String errorMessage) {
        try {
            this.loginUsernameOnlyPage.open();
            this.loginUsernameOnlyPage.assertCurrent();
            this.loginUsernameOnlyPage.login(userCondMatch);
            this.errorPage.assertCurrent();
            MatcherAssert.assertThat((Object)this.errorPage.getError(), (Matcher)Matchers.is((Object)errorMessage));
            this.events.expectLogin().user((String)null).session((String)null).error("access_denied").detail("username", userCondMatch).removeDetail("consent").assertEvent();
            String userCondNotMatchId = ((UserRepresentation)this.testRealm().users().search(userCondNotMatch).get(0)).getId();
            this.loginUsernameOnlyPage.open();
            this.loginUsernameOnlyPage.assertCurrent();
            this.loginUsernameOnlyPage.login(userCondNotMatch);
            this.passwordPage.assertCurrent();
            this.passwordPage.login("password");
            this.events.expectLogin().user(userCondNotMatchId).detail("username", userCondNotMatch).removeDetail("consent").assertEvent();
        }
        finally {
            BrowserFlowTest.revertFlows(this.testRealm(), flowAlias);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSkipExecutionUserHasNotRoleCondition() {
        String userWithoutRole = "john-doh@localhost";
        String role = "offline_access";
        String newFlowAlias = "browser - allow skip";
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("condUserRole", "offline_access");
        configMap.put("negate", "false");
        this.configureBrowserFlowWithSkipExecutionInConditionalFlow("browser - allow skip", "conditional-user-role", configMap);
        try {
            this.loginUsernameOnlyPage.open();
            this.loginUsernameOnlyPage.assertCurrent();
            this.loginUsernameOnlyPage.login("john-doh@localhost");
            String testUserWithoutRoleId = ((UserRepresentation)this.testRealm().users().search("john-doh@localhost").get(0)).getId();
            this.passwordPage.assertCurrent();
            this.passwordPage.login("password");
            this.events.expectLogin().user(testUserWithoutRoleId).detail("username", "john-doh@localhost").removeDetail("consent").assertEvent();
        }
        finally {
            BrowserFlowTest.revertFlows(this.testRealm(), "browser - allow skip");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSkipOtherExecutionsIfUserHasRoleCondition() {
        String userWithRole = "test-user@localhost";
        String role = "offline_access";
        String newFlowAlias = "browser - allow skip";
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("condUserRole", "offline_access");
        configMap.put("negate", "false");
        this.configureBrowserFlowWithSkipExecutionInConditionalFlow("browser - allow skip", "conditional-user-role", configMap);
        try {
            this.loginUsernameOnlyPage.open();
            this.loginUsernameOnlyPage.assertCurrent();
            this.loginUsernameOnlyPage.login("test-user@localhost");
            String testUserWithRoleId = ((UserRepresentation)this.testRealm().users().search("test-user@localhost").get(0)).getId();
            this.events.expectLogin().user(testUserWithRoleId).detail("username", "test-user@localhost").removeDetail("consent").assertEvent();
        }
        finally {
            BrowserFlowTest.revertFlows(this.testRealm(), "browser - allow skip");
        }
    }

    private void configureBrowserFlowWithDenyAccessInConditionalFlow(String newFlowAlias, String conditionProviderId, Map<String, String> conditionConfig, Map<String, String> denyConfig) {
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).copyBrowserFlow(newFlowAlias));
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).selectFlow(newFlowAlias).inForms(forms -> forms.clear().addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "auth-username-form").addSubFlowExecution(AuthenticationExecutionModel.Requirement.CONDITIONAL, subflow -> subflow.addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, conditionProviderId, config -> config.setConfig(conditionConfig)).addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "deny-access-authenticator", config -> config.setConfig(denyConfig))).addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "auth-password-form")).defineAsBrowserFlow());
    }

    private void configureBrowserFlowWithDenyAccess(String newFlowAlias, Map<String, String> denyConfig) {
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).copyBrowserFlow(newFlowAlias));
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).selectFlow(newFlowAlias).inForms(forms -> forms.clear().addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "auth-username-form").addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "deny-access-authenticator", config -> config.setConfig(denyConfig))).defineAsBrowserFlow());
    }

    private void configureBrowserFlowWithSkipExecutionInConditionalFlow(String newFlowAlias, String conditionProviderId, Map<String, String> configMap) {
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).copyBrowserFlow(newFlowAlias));
        this.testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).selectFlow(newFlowAlias).inForms(forms -> forms.clear().addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "auth-username-form").addSubFlowExecution(AuthenticationExecutionModel.Requirement.REQUIRED, subflow -> subflow.addSubFlowExecution(AuthenticationExecutionModel.Requirement.ALTERNATIVE, flow -> flow.addSubFlowExecution(AuthenticationExecutionModel.Requirement.CONDITIONAL, condFlow -> condFlow.addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, conditionProviderId, config -> config.setConfig(configMap)).addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "allow-access-authenticator"))).addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.ALTERNATIVE, "auth-password-form"))).defineAsBrowserFlow());
    }
}

