/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.sync;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.services.managers.UserStorageSyncManager;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.user.SynchronizationResult;
import org.keycloak.testsuite.AbstractAuthTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.federation.DummyUserFederationProviderFactory;
import org.keycloak.testsuite.federation.sync.SyncDummyUserFederationProviderFactory;
import org.keycloak.testsuite.runonserver.FetchOnServer;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.timer.TimerProvider;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class SyncFederationTest
extends AbstractAuthTest {
    private static final Logger log = Logger.getLogger(SyncFederationTest.class);

    @Test
    public void test01PeriodicSyncOnCreate() {
        Map state = (Map)this.testingClient.server().fetch((FetchOnServer & Serializable)session -> {
            KeycloakSessionFactory sessionFactory = session.getKeycloakSessionFactory();
            DummyUserFederationProviderFactory dummyFedFactory = (DummyUserFederationProviderFactory)sessionFactory.getProviderFactory(UserStorageProvider.class, "dummy");
            int full = dummyFedFactory.getFullSyncCounter();
            int changed = dummyFedFactory.getChangedSyncCounter();
            HashMap<String, Integer> state1 = new HashMap<String, Integer>();
            state1.put("full", full);
            state1.put("changed", changed);
            return state1;
        }, Map.class);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel appRealm = session.realms().getRealmByName("test");
            UserStorageProviderModel model = new UserStorageProviderModel();
            model.setProviderId("dummy");
            model.setPriority(1);
            model.setName("test-sync-dummy");
            model.setFullSyncPeriod(-1);
            model.setChangedSyncPeriod(1);
            model.setLastSync(0);
            UserStorageProviderModel dummyModel = new UserStorageProviderModel(appRealm.addComponentModel((ComponentModel)model));
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            SynchronizationResult result;
            RealmModel appRealm = session.realms().getRealmByName("test");
            UserStorageProviderModel dummyModel = SyncFederationTest.findDummyProviderModel(appRealm);
            KeycloakSessionFactory sessionFactory = session.getKeycloakSessionFactory();
            DummyUserFederationProviderFactory dummyFedFactory = (DummyUserFederationProviderFactory)sessionFactory.getProviderFactory(UserStorageProvider.class, "dummy");
            UserStorageSyncManager usersSyncManager = new UserStorageSyncManager();
            SyncFederationTest.sleep(1800L);
            usersSyncManager.notifyToRefreshPeriodicSync(session, appRealm, dummyModel, true);
            log.infof("Notified sync manager about cancel periodic sync", new Object[0]);
            while ((result = usersSyncManager.syncChangedUsers(session.getKeycloakSessionFactory(), appRealm.getId(), dummyModel)).isIgnored()) {
                log.infof("Still waiting for lock before periodic sync is finished", (Object)result.toString());
                SyncFederationTest.sleep(1000L);
            }
            int full = (Integer)state.get("full");
            int changed = (Integer)state.get("changed");
            int newChanged = dummyFedFactory.getChangedSyncCounter();
            Assert.assertEquals((long)full, (long)dummyFedFactory.getFullSyncCounter());
            Assert.assertTrue((String)("Assertion failed. newChanged=" + newChanged + ", changed=" + changed), (newChanged > changed + 1 ? 1 : 0) != 0);
            SyncFederationTest.sleep(1800L);
            Assert.assertEquals((long)full, (long)dummyFedFactory.getFullSyncCounter());
            int newestChanged = dummyFedFactory.getChangedSyncCounter();
            Assert.assertEquals((String)("Assertion failed. newChanged=" + newChanged + ", newestChanged=" + newestChanged), (long)newChanged, (long)newestChanged);
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel appRealm = session.realms().getRealmByName("test");
            UserStorageProviderModel dummyModel = SyncFederationTest.findDummyProviderModel(appRealm);
            appRealm.removeComponent((ComponentModel)dummyModel);
        });
    }

    private static final UserStorageProviderModel findDummyProviderModel(RealmModel realm) {
        return realm.getComponentsStream().filter(component -> Objects.equals(component.getName(), "test-sync-dummy")).map(UserStorageProviderModel::new).findFirst().orElse(null);
    }

    @Test
    public void test02PeriodicSyncOnUpdate() {
        Map state = (Map)this.testingClient.server().fetch((FetchOnServer & Serializable)session -> {
            KeycloakSessionFactory sessionFactory = session.getKeycloakSessionFactory();
            DummyUserFederationProviderFactory dummyFedFactory = (DummyUserFederationProviderFactory)sessionFactory.getProviderFactory(UserStorageProvider.class, "dummy");
            int full = dummyFedFactory.getFullSyncCounter();
            int changed = dummyFedFactory.getChangedSyncCounter();
            HashMap<String, Integer> state1 = new HashMap<String, Integer>();
            state1.put("full", full);
            state1.put("changed", changed);
            return state1;
        }, Map.class);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel appRealm = session.realms().getRealmByName("test");
            UserStorageProviderModel model = new UserStorageProviderModel();
            model.setProviderId("dummy");
            model.setPriority(1);
            model.setName("test-sync-dummy");
            model.setFullSyncPeriod(-1);
            model.setChangedSyncPeriod(-1);
            model.setLastSync(0);
            UserStorageProviderModel dummyModel = new UserStorageProviderModel(appRealm.addComponentModel((ComponentModel)model));
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            KeycloakSessionFactory sessionFactory = session.getKeycloakSessionFactory();
            DummyUserFederationProviderFactory dummyFedFactory = (DummyUserFederationProviderFactory)sessionFactory.getProviderFactory(UserStorageProvider.class, "dummy");
            UserStorageSyncManager usersSyncManager = new UserStorageSyncManager();
            SyncFederationTest.sleep(1800L);
            int full = (Integer)state.get("full");
            int changed = (Integer)state.get("changed");
            Assert.assertEquals((long)full, (long)dummyFedFactory.getFullSyncCounter());
            int newChanged = dummyFedFactory.getChangedSyncCounter();
            Assert.assertEquals((String)("Assertion failed. changed=" + changed + ", newChanged=" + newChanged), (long)changed, (long)newChanged);
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel appRealm = session.realms().getRealmByName("test");
            UserStorageProviderModel dummyModel = SyncFederationTest.findDummyProviderModel(appRealm);
            dummyModel.setChangedSyncPeriod(1);
            appRealm.updateComponent((ComponentModel)dummyModel);
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            SynchronizationResult result;
            RealmModel appRealm = session.realms().getRealmByName("test");
            UserStorageProviderModel dummyModel = SyncFederationTest.findDummyProviderModel(appRealm);
            KeycloakSessionFactory sessionFactory = session.getKeycloakSessionFactory();
            DummyUserFederationProviderFactory dummyFedFactory = (DummyUserFederationProviderFactory)sessionFactory.getProviderFactory(UserStorageProvider.class, "dummy");
            UserStorageSyncManager usersSyncManager = new UserStorageSyncManager();
            SyncFederationTest.sleep(1800L);
            usersSyncManager.notifyToRefreshPeriodicSync(session, appRealm, dummyModel, true);
            log.infof("Notified sync manager about cancel periodic sync", new Object[0]);
            while ((result = usersSyncManager.syncChangedUsers(session.getKeycloakSessionFactory(), appRealm.getId(), dummyModel)).isIgnored()) {
                log.infof("Still waiting for lock before periodic sync is finished", (Object)result.toString());
                SyncFederationTest.sleep(1000L);
            }
            int full = (Integer)state.get("full");
            int changed = (Integer)state.get("changed");
            int newChanged = dummyFedFactory.getChangedSyncCounter();
            Assert.assertEquals((long)full, (long)dummyFedFactory.getFullSyncCounter());
            log.info((Object)("Asserting. newChanged=" + newChanged + " > changed=" + changed));
            Assert.assertTrue((String)("Assertion failed. newChanged=" + newChanged + ", changed=" + changed), (newChanged > changed + 1 ? 1 : 0) != 0);
            SyncFederationTest.sleep(1800L);
            Assert.assertEquals((long)full, (long)dummyFedFactory.getFullSyncCounter());
            int newestChanged = dummyFedFactory.getChangedSyncCounter();
            Assert.assertEquals((String)("Assertion failed. newChanged=" + newChanged + ", newestChanged=" + newestChanged), (long)newChanged, (long)newestChanged);
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel appRealm = session.realms().getRealmByName("test");
            UserStorageProviderModel dummyModel = SyncFederationTest.findDummyProviderModel(appRealm);
            appRealm.removeComponent((ComponentModel)dummyModel);
        });
    }

    @Test
    public void test03ConcurrentSync() throws Exception {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            SyncDummyUserFederationProviderFactory.restartLatches();
            RealmModel appRealm = session.realms().getRealmByName("test");
            UserStorageProviderModel model = new UserStorageProviderModel();
            model.setProviderId("sync-dummy");
            model.setPriority(1);
            model.setName("test-sync-dummy");
            model.setFullSyncPeriod(-1);
            model.setChangedSyncPeriod(1);
            model.setLastSync(0);
            model.getConfig().putSingle((Object)"wait-time", (Object)"2000");
            UserStorageProviderModel dummyModel = new UserStorageProviderModel(appRealm.addComponentModel((ComponentModel)model));
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel appRealm = session.realms().getRealmByName("test");
            UserStorageProviderModel dummyModel = SyncFederationTest.findDummyProviderModel(appRealm);
            KeycloakSessionFactory sessionFactory = session.getKeycloakSessionFactory();
            UserStorageSyncManager usersSyncManager = new UserStorageSyncManager();
            usersSyncManager.bootstrapPeriodic(sessionFactory, (TimerProvider)session.getProvider(TimerProvider.class));
            SyncFederationTest.sleep(1800L);
            SynchronizationResult syncResult = usersSyncManager.syncChangedUsers(sessionFactory, appRealm.getId(), dummyModel);
            Assert.assertTrue((boolean)syncResult.isIgnored());
            usersSyncManager.notifyToRefreshPeriodicSync(session, appRealm, dummyModel, true);
            SyncDummyUserFederationProviderFactory.latch1.countDown();
            try {
                SyncDummyUserFederationProviderFactory.latch2.await(20000L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel appRealm = session.realms().getRealmByName("test");
            UserStorageProviderModel dummyModel = SyncFederationTest.findDummyProviderModel(appRealm);
            appRealm.removeComponent((ComponentModel)dummyModel);
        });
    }

    private static void sleep(long ms) {
        try {
            log.infof("Sleeping for %d ms", (Object)ms);
            Thread.sleep(ms);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }
}

