/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.storage;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.federation.storage.UserStorageTest;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginConfigTotpPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginTotpPage;
import org.keycloak.testsuite.util.UserBuilder;

public class UserStorageOTPTest
extends AbstractTestRealmKeycloakTest {
    @Page
    protected LoginPage loginPage;
    @Page
    protected LoginTotpPage loginTotpPage;
    @Page
    protected LoginConfigTotpPage loginConfigTotpPage;
    @Page
    protected AppPage appPage;
    protected TimeBasedOTP totp = new TimeBasedOTP();

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Before
    public void addProvidersBeforeTest() throws URISyntaxException, IOException {
        ComponentRepresentation dummyProvider = new ComponentRepresentation();
        dummyProvider.setName("dummy");
        dummyProvider.setId("dummy");
        dummyProvider.setProviderId("dummy");
        dummyProvider.setProviderType(UserStorageProvider.class.getName());
        dummyProvider.setConfig(new MultivaluedHashMap());
        dummyProvider.getConfig().putSingle((Object)"priority", (Object)Integer.toString(0));
        dummyProvider.getConfig().putSingle((Object)"importEnabled", (Object)Boolean.toString(false));
        UserStorageTest.addComponent(this.testRealm(), this.getCleanup(), dummyProvider);
        UserRepresentation user = UserBuilder.create().username("test-user").email("test-user@something.org").build();
        String testUserId = ApiUtil.createUserWithAdminClient((RealmResource)this.testRealm(), (UserRepresentation)user);
        this.getCleanup().addUserId(testUserId);
    }

    @Test
    public void testCredentialsThroughRESTAPI() {
        UserResource user = ApiUtil.findUserByUsernameId((RealmResource)this.testRealm(), (String)"test-user");
        Assert.assertEquals((Object)"dummy", (Object)user.toRepresentation().getFederationLink());
        List userStorageCredentialTypes = user.getConfiguredUserStorageCredentialTypes();
        Assert.assertNames(userStorageCredentialTypes, "password", "otp");
    }

    @Test
    public void testAuthentication() {
        this.loginPage.open();
        this.loginPage.login("test-user", "secret");
        this.loginTotpPage.assertCurrent();
        this.loginTotpPage.login("654321");
        this.loginTotpPage.assertCurrent();
        Assert.assertEquals((Object)"Invalid authenticator code.", (Object)this.loginTotpPage.getInputError());
        this.loginTotpPage.login("123456");
        this.appPage.assertCurrent();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
    }

    @Test
    public void testUpdateOTP() {
        UserResource user = ApiUtil.findUserByUsernameId((RealmResource)this.testRealm(), (String)"test-user");
        UserRepresentation userRep = user.toRepresentation();
        userRep.setRequiredActions(Collections.singletonList(UserModel.RequiredAction.CONFIGURE_TOTP.toString()));
        user.update(userRep);
        this.loginPage.open();
        this.loginPage.login("test-user", "secret");
        this.loginTotpPage.assertCurrent();
        this.loginTotpPage.login("123456");
        this.loginConfigTotpPage.assertCurrent();
        this.loginConfigTotpPage.configure("123456");
        Assert.assertEquals((Object)"Invalid authenticator code.", (Object)this.loginConfigTotpPage.getInputCodeError());
        String totpSecret = this.loginConfigTotpPage.getTotpSecret();
        this.log.infof("Totp Secret: %s", (Object)totpSecret);
        String totpCode = this.totp.generateTOTP(totpSecret);
        this.loginConfigTotpPage.configure(totpCode);
        this.appPage.assertCurrent();
        this.appPage.logout();
        this.loginPage.open();
        this.loginPage.login("test-user", "secret");
        this.loginTotpPage.assertCurrent();
        this.loginTotpPage.login("123456");
        this.appPage.assertCurrent();
        this.appPage.logout();
        this.loginPage.open();
        this.loginPage.login("test-user", "secret");
        this.loginTotpPage.assertCurrent();
        this.loginTotpPage.login(this.totp.generateTOTP(totpSecret));
        this.appPage.assertCurrent();
        this.appPage.logout();
    }

    @Test
    public void testNormalUser() {
        UserRepresentation user = UserBuilder.create().username("test-user2").email("test-user2@something.org").build();
        String testUserId = ApiUtil.createUserWithAdminClient((RealmResource)this.testRealm(), (UserRepresentation)user);
        this.getCleanup().addUserId(testUserId);
        UserResource userResource = ApiUtil.findUserByUsernameId((RealmResource)this.testRealm(), (String)"test-user2");
        Assert.assertEquals((Object)"dummy", (Object)userResource.toRepresentation().getFederationLink());
        Assert.assertTrue((boolean)userResource.getConfiguredUserStorageCredentialTypes().isEmpty());
        ApiUtil.resetUserPassword((UserResource)userResource, (String)"pass", (boolean)false);
        this.loginPage.open();
        this.loginPage.login("test-user2", "pass");
        this.appPage.assertCurrent();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
    }
}

