/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.storage;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.stream.Stream;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.cache.CachedUserModel;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.federation.FailableHardcodedStorageProvider;
import org.keycloak.testsuite.federation.storage.UserStorageTest;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.ContainerAssume;
import org.keycloak.testsuite.util.OAuthClient;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class UserStorageFailureTest
extends AbstractTestRealmKeycloakTest {
    private static boolean initialized = false;
    private static final String LOCAL_USER = "localUser";
    private String failureProviderId;
    @ArquillianResource
    protected ContainerController controller;
    @Page
    protected LoginPage loginPage;
    @Page
    protected AppPage appPage;
    @Rule
    public AssertEvents events = new AssertEvents(this);

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Before
    public void addProvidersBeforeTest() {
        ComponentRepresentation memProvider = new ComponentRepresentation();
        memProvider.setName("failure");
        memProvider.setProviderId("failable-hardcoded-storage");
        memProvider.setProviderType(UserStorageProvider.class.getName());
        memProvider.setConfig(new MultivaluedHashMap());
        memProvider.getConfig().putSingle((Object)"priority", (Object)Integer.toString(0));
        this.failureProviderId = this.addComponent(memProvider);
        if (initialized) {
            return;
        }
        String authServerRoot = OAuthClient.AUTH_SERVER_ROOT;
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmManager manager = new RealmManager(session);
            RealmModel appRealm = manager.getRealmByName("test");
            ClientModel offlineClient = appRealm.addClient("offline-client");
            offlineClient.setProtocol("openid-connect");
            offlineClient.setEnabled(true);
            offlineClient.setDirectAccessGrantsEnabled(true);
            offlineClient.setSecret("secret");
            HashSet<String> redirects = new HashSet<String>();
            redirects.add(authServerRoot + "/offline-client");
            offlineClient.setRedirectUris(redirects);
            offlineClient.setServiceAccountsEnabled(true);
            offlineClient.setFullScopeAllowed(true);
            UserModel serviceAccount = manager.getSession().users().addUser(appRealm, "service-account-" + offlineClient.getClientId());
            serviceAccount.setEnabled(true);
            RoleModel role = appRealm.getRole("offline_access");
            Assert.assertNotNull((Object)role);
            serviceAccount.grantRole(role);
            serviceAccount.setServiceAccountClientLink(offlineClient.getClientId());
            UserModel localUser = manager.getSession().userLocalStorage().addUser(appRealm, LOCAL_USER);
            localUser.setEnabled(true);
        });
        initialized = true;
    }

    public RealmResource testRealmResource() {
        return this.adminClient.realm("test");
    }

    private String addComponent(ComponentRepresentation component) {
        return UserStorageTest.addComponent(this.testRealmResource(), this.getCleanup(), component);
    }

    @Test
    public void testKeycloak5350() throws Exception {
        ContainerAssume.assumeNotAuthServerRemote();
        this.oauth.scope("offline_access");
        this.oauth.clientId("offline-client");
        this.oauth.redirectUri(OAuthClient.AUTH_SERVER_ROOT + "/offline-client");
        this.oauth.doLogin(FailableHardcodedStorageProvider.username, "password");
        EventRepresentation loginEvent = this.events.expectLogin().user(AssertEvents.isUUID()).client("offline-client").detail("redirect_uri", OAuthClient.AUTH_SERVER_ROOT + "/offline-client").assertEvent();
        String sessionId = loginEvent.getSessionId();
        String codeId = (String)loginEvent.getDetails().get("code_id");
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "secret");
        AccessToken token = this.oauth.verifyToken(tokenResponse.getAccessToken());
        String offlineTokenString = tokenResponse.getRefreshToken();
        RefreshToken offlineToken = this.oauth.parseRefreshToken(offlineTokenString);
        this.events.clear();
        this.evictUser(FailableHardcodedStorageProvider.username);
        this.toggleForceFail(true);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            try {
                UserModel user = session.users().getUserByUsername(realm, FailableHardcodedStorageProvider.username);
                Assert.fail();
            }
            catch (Exception e) {
                Assert.assertEquals((Object)"FORCED FAILURE", (Object)e.getMessage());
            }
        });
        this.controller.stop(this.suiteContext.getAuthServerInfo().getQualifier());
        this.controller.start(this.suiteContext.getAuthServerInfo().getQualifier());
        this.reconnectAdminClient();
        this.toggleForceFail(false);
        tokenResponse = this.oauth.doRefreshTokenRequest(offlineTokenString, "secret");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken());
        token = this.oauth.verifyToken(tokenResponse.getAccessToken());
        offlineTokenString = tokenResponse.getRefreshToken();
        offlineToken = this.oauth.parseRefreshToken(offlineTokenString);
        this.events.clear();
    }

    protected void evictUser(String username) {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            UserModel user = session.users().getUserByUsername(realm, username);
            session.userCache().evict(realm, user);
        });
    }

    protected void toggleForceFail(boolean toggle) {
        String failureProviderId = this.failureProviderId;
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            ComponentModel memoryProvider = realm.getComponent(failureProviderId);
            memoryProvider.getConfig().putSingle((Object)"fail", (Object)Boolean.toString(toggle));
            realm.updateComponent(memoryProvider);
        });
    }

    protected void toggleProviderEnabled(boolean toggle) {
        String failureProviderId = this.failureProviderId;
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            ComponentModel memoryProvider = realm.getComponent(failureProviderId);
            UserStorageProviderModel model = new UserStorageProviderModel(memoryProvider);
            model.setEnabled(toggle);
            realm.updateComponent((ComponentModel)model);
        });
    }

    private void loginSuccessAndLogout(String username, String password) {
        this.loginPage.open();
        this.loginPage.login(username, password);
        System.out.println(this.driver.getCurrentUrl());
        System.out.println(this.driver.getPageSource());
        Assert.assertTrue((boolean)this.appPage.isCurrent());
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        this.oauth.openLogout();
    }

    @Test
    public void testKeycloak5926() {
        this.oauth.clientId("test-app");
        this.oauth.redirectUri(OAuthClient.APP_AUTH_ROOT);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            UserModel user = session.userLocalStorage().getUserByUsername(realm, FailableHardcodedStorageProvider.username);
            if (user != null) {
                session.userLocalStorage().removeUser(realm, user);
            }
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            UserModel user = session.users().getUserByUsername(realm, FailableHardcodedStorageProvider.username);
            Assert.assertNotNull((Object)user);
        });
        this.evictUser(FailableHardcodedStorageProvider.username);
        this.evictUser(LOCAL_USER);
        this.toggleForceFail(true);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            UserModel local = session.users().getUserByUsername(realm, LOCAL_USER);
            Assert.assertNotNull((Object)local);
            try {
                UserModel user = session.users().getUserByUsername(realm, FailableHardcodedStorageProvider.username);
                Assert.fail();
            }
            catch (Exception e) {
                Assert.assertEquals((Object)"FORCED FAILURE", (Object)e.getMessage());
            }
        });
        this.loginSuccessAndLogout("test-user@localhost", "password");
        this.toggleProviderEnabled(false);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            UserModel local = session.users().getUserByUsername(realm, LOCAL_USER);
            Assert.assertNotNull((Object)local);
            Stream result = session.users().searchForUserStream(realm, LOCAL_USER);
            Assert.assertEquals((long)1L, (long)result.count());
            result = session.users().searchForUserStream(realm, FailableHardcodedStorageProvider.username);
            Assert.assertEquals((long)1L, (long)result.count());
            result = session.users().searchForUserStream(realm, LOCAL_USER, Integer.valueOf(0), Integer.valueOf(2));
            Assert.assertEquals((long)1L, (long)result.count());
            result = session.users().searchForUserStream(realm, FailableHardcodedStorageProvider.username, Integer.valueOf(0), Integer.valueOf(2));
            Assert.assertEquals((long)1L, (long)result.count());
            HashMap<String, String> localParam = new HashMap<String, String>();
            localParam.put("username", LOCAL_USER);
            HashMap<String, String> hardcodedParam = new HashMap<String, String>();
            hardcodedParam.put("username", FailableHardcodedStorageProvider.username);
            result = session.users().searchForUserStream(realm, localParam);
            Assert.assertEquals((long)1L, (long)result.count());
            result = session.users().searchForUserStream(realm, hardcodedParam);
            Assert.assertEquals((long)1L, (long)result.count());
            result = session.users().searchForUserStream(realm, localParam, Integer.valueOf(0), Integer.valueOf(2));
            Assert.assertEquals((long)1L, (long)result.count());
            result = session.users().searchForUserStream(realm, hardcodedParam, Integer.valueOf(0), Integer.valueOf(2));
            Assert.assertEquals((long)1L, (long)result.count());
            session.users().getUsersStream(realm).count();
            session.users().getUsersCount(realm);
            UserModel user = session.users().getUserByUsername(realm, FailableHardcodedStorageProvider.username);
            Assert.assertFalse((boolean)(user instanceof CachedUserModel));
            Assert.assertEquals((Object)FailableHardcodedStorageProvider.username, (Object)user.getUsername());
            Assert.assertEquals((Object)FailableHardcodedStorageProvider.email, (Object)user.getEmail());
            Assert.assertFalse((boolean)user.isEnabled());
            try {
                user.setEmail("error@error.com");
                Assert.fail();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            UserModel user = session.users().getUserByUsername(realm, FailableHardcodedStorageProvider.username);
            Assert.assertFalse((boolean)(user instanceof CachedUserModel));
            Assert.assertEquals((Object)FailableHardcodedStorageProvider.username, (Object)user.getUsername());
            Assert.assertEquals((Object)FailableHardcodedStorageProvider.email, (Object)user.getEmail());
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            UserModel user = session.users().getUserByUsername(realm, FailableHardcodedStorageProvider.username);
            Assert.assertFalse((boolean)(user instanceof CachedUserModel));
            Assert.assertEquals((Object)FailableHardcodedStorageProvider.username, (Object)user.getUsername());
            Assert.assertEquals((Object)FailableHardcodedStorageProvider.email, (Object)user.getEmail());
        });
        this.toggleProviderEnabled(true);
        this.toggleForceFail(false);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            UserModel user = session.users().getUserByUsername(realm, FailableHardcodedStorageProvider.username);
            Assert.assertTrue((boolean)(user instanceof CachedUserModel));
            Assert.assertEquals((Object)FailableHardcodedStorageProvider.username, (Object)user.getUsername());
            Assert.assertEquals((Object)FailableHardcodedStorageProvider.email, (Object)user.getEmail());
        });
        this.events.clear();
    }

    public void testIDE() throws Exception {
        Thread.sleep(100000000L);
    }
}

