/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.storage;

import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.group.GroupStorageProvider;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.runonserver.RunOnServer;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class GroupStorageTest
extends AbstractTestRealmKeycloakTest {
    private String providerId;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    protected String addComponent(ComponentRepresentation component) {
        try (Response resp = this.adminClient.realm("test").components().add(component);){
            String id = ApiUtil.getCreatedId((Response)resp);
            this.getCleanup().addComponentId(id);
            String string = id;
            return string;
        }
    }

    @Before
    public void addProvidersBeforeTest() throws URISyntaxException, IOException {
        ComponentRepresentation provider = new ComponentRepresentation();
        provider.setName("group-storage-hardcoded");
        provider.setProviderId("hardcoded-group");
        provider.setProviderType(GroupStorageProvider.class.getName());
        provider.setConfig(new MultivaluedHashMap());
        provider.getConfig().putSingle((Object)"gorup_name", (Object)"hardcoded-group");
        provider.getConfig().putSingle((Object)"delayed_search", (Object)Boolean.toString(false));
        this.providerId = this.addComponent(provider);
    }

    @Test
    public void testGetGroupById() {
        String providerId = this.providerId;
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            StorageId storageId = new StorageId(providerId, "hardcoded-group");
            GroupModel hardcoded = session.groups().getGroupById(realm, storageId.getId());
            Assert.assertNotNull((Object)hardcoded);
        });
    }

    @Test
    public void testSearchTimeout() throws Exception {
        this.runTestWithTimeout(4000L, () -> {
            String hardcodedGroup = "hardcoded-group";
            String delayedSearch = "delayed_search";
            String providerId = this.providerId;
            this.testingClient.server().run((RunOnServer & Serializable)session -> {
                RealmModel realm = session.realms().getRealmByName("test");
                Assert.assertThat(session.groupStorageManager().searchForGroupByName(realm, "group", null, null).stream().map(GroupModel::getName).collect(Collectors.toList()), (Matcher)Matchers.allOf((Matcher)Matchers.hasItem((Object)hardcodedGroup), (Matcher)Matchers.hasItem((Object)"sample-realm-group")));
                ComponentModel memoryProvider = realm.getComponent(providerId);
                memoryProvider.getConfig().putSingle((Object)delayedSearch, (Object)Boolean.toString(true));
                realm.updateComponent(memoryProvider);
            });
            this.testingClient.server().run((RunOnServer & Serializable)session -> {
                RealmModel realm = session.realms().getRealmByName("test");
                Assert.assertThat(session.groupStorageManager().searchForGroupByName(realm, "group", null, null).stream().map(GroupModel::getName).collect(Collectors.toList()), (Matcher)Matchers.allOf((Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)hardcodedGroup)), (Matcher)Matchers.hasItem((Object)"sample-realm-group")));
            });
        });
    }
}

