/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.storage;

import java.io.File;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.NotFoundException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.hash.PasswordHashProvider;
import org.keycloak.exportimport.ExportImportConfig;
import org.keycloak.exportimport.ExportImportManager;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.credential.PasswordCredentialModel;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.testsuite.AbstractAuthTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.federation.storage.ComponentExportImportTest;
import org.keycloak.testsuite.runonserver.RunOnServer;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class FederatedStorageExportImportTest
extends AbstractAuthTest {
    private static final String REALM_NAME = "exported";
    private String exportFileAbsolutePath;
    private String exportDirAbsolutePath;

    @Before
    public void setDirs() {
        File baseDir = new File(System.getProperty("auth.server.config.dir", "target"));
        this.exportFileAbsolutePath = new File(baseDir, "singleFile-full.json").getAbsolutePath();
        this.log.infof("Export file: %s", (Object)this.exportFileAbsolutePath);
        this.exportDirAbsolutePath = baseDir.getAbsolutePath() + File.separator + "dirExport";
        this.log.infof("Export dir: %s", (Object)this.exportDirAbsolutePath);
    }

    @Override
    public RealmResource testRealmResource() {
        return this.adminClient.realm(REALM_NAME);
    }

    @After
    public void cleanup() {
        try {
            this.testRealmResource().remove();
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    public static PasswordHashProvider getHashProvider(KeycloakSession session, PasswordPolicy policy) {
        PasswordHashProvider hash = (PasswordHashProvider)session.getProvider(PasswordHashProvider.class, policy.getHashAlgorithm());
        if (hash == null) {
            return (PasswordHashProvider)session.getProvider(PasswordHashProvider.class, "pbkdf2-sha256");
        }
        return hash;
    }

    @Test
    public void testSingleFile() {
        ComponentExportImportTest.clearExportImportProperties(this.testingClient);
        String userId = "f:1:path";
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = new RealmManager(session).createRealm(REALM_NAME);
            RoleModel role = realm.addRole("test-role");
            GroupModel group = realm.createGroup("test-group");
            LinkedList<String> attrValues = new LinkedList<String>();
            attrValues.add("1");
            attrValues.add("2");
            session.userFederatedStorage().setSingleAttribute(realm, "f:1:path", "single1", "value1");
            session.userFederatedStorage().setAttribute(realm, "f:1:path", "list1", attrValues);
            session.userFederatedStorage().addRequiredAction(realm, "f:1:path", "UPDATE_PASSWORD");
            PasswordCredentialModel credential = FederatedStorageExportImportTest.getHashProvider(session, realm.getPasswordPolicy()).encodedCredential("password", realm.getPasswordPolicy().getHashIterations());
            session.userFederatedStorage().createCredential(realm, "f:1:path", (CredentialModel)credential);
            session.userFederatedStorage().grantRole(realm, "f:1:path", role);
            session.userFederatedStorage().joinGroup(realm, "f:1:path", group);
        });
        String realmId = this.testRealmResource().toRepresentation().getId();
        String groupId = this.testRealmResource().getGroupByPath("/test-group").getId();
        String exportFileAbsolutePath = this.exportFileAbsolutePath;
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            ExportImportConfig.setProvider((String)"singleFile");
            ExportImportConfig.setFile((String)exportFileAbsolutePath);
            ExportImportConfig.setRealmName((String)REALM_NAME);
            ExportImportConfig.setAction((String)"export");
            new ExportImportManager(session).runExport();
            session.realms().removeRealm(realmId);
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            Assert.assertNull((Object)session.realms().getRealmByName(REALM_NAME));
            ExportImportConfig.setAction((String)"import");
            new ExportImportManager(session).runImport();
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName(REALM_NAME);
            Assert.assertNotNull((Object)realm);
            RoleModel role = realm.getRole("test-role");
            GroupModel group = realm.getGroupById(groupId);
            Assert.assertEquals((long)1L, (long)session.userFederatedStorage().getStoredUsersCount(realm));
            MultivaluedHashMap attributes = session.userFederatedStorage().getAttributes(realm, "f:1:path");
            Assert.assertEquals((long)3L, (long)attributes.size());
            Assert.assertEquals((Object)"value1", (Object)attributes.getFirst((Object)"single1"));
            Assert.assertTrue((boolean)attributes.getList((Object)"list1").contains("1"));
            Assert.assertTrue((boolean)attributes.getList((Object)"list1").contains("2"));
            Assert.assertTrue((boolean)session.userFederatedStorage().getRequiredActionsStream(realm, "f:1:path").collect(Collectors.toSet()).contains("UPDATE_PASSWORD"));
            Assert.assertTrue((boolean)session.userFederatedStorage().getRoleMappingsStream(realm, "f:1:path").collect(Collectors.toSet()).contains(role));
            Assert.assertTrue((boolean)session.userFederatedStorage().getGroupsStream(realm, "f:1:path").collect(Collectors.toSet()).contains(group));
            List creds = session.userFederatedStorage().getStoredCredentialsStream(realm, "f:1:path").collect(Collectors.toList());
            Assert.assertEquals((long)1L, (long)creds.size());
            Assert.assertTrue((boolean)FederatedStorageExportImportTest.getHashProvider(session, realm.getPasswordPolicy()).verify("password", PasswordCredentialModel.createFromCredentialModel((CredentialModel)((CredentialModel)creds.get(0)))));
        });
    }

    @Test
    public void testDir() {
        ComponentExportImportTest.clearExportImportProperties(this.testingClient);
        String userId = "f:1:path";
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = new RealmManager(session).createRealm(REALM_NAME);
            RoleModel role = realm.addRole("test-role");
            GroupModel group = realm.createGroup("test-group");
            LinkedList<String> attrValues = new LinkedList<String>();
            attrValues.add("1");
            attrValues.add("2");
            session.userFederatedStorage().setSingleAttribute(realm, "f:1:path", "single1", "value1");
            session.userFederatedStorage().setAttribute(realm, "f:1:path", "list1", attrValues);
            session.userFederatedStorage().addRequiredAction(realm, "f:1:path", "UPDATE_PASSWORD");
            PasswordCredentialModel credential = FederatedStorageExportImportTest.getHashProvider(session, realm.getPasswordPolicy()).encodedCredential("password", realm.getPasswordPolicy().getHashIterations());
            session.userFederatedStorage().createCredential(realm, "f:1:path", (CredentialModel)credential);
            session.userFederatedStorage().grantRole(realm, "f:1:path", role);
            session.userFederatedStorage().joinGroup(realm, "f:1:path", group);
            session.userFederatedStorage().setNotBeforeForUser(realm, "f:1:path", 50);
        });
        String realmId = this.testRealmResource().toRepresentation().getId();
        String groupId = this.testRealmResource().getGroupByPath("/test-group").getId();
        String exportDirAbsolutePath = this.exportDirAbsolutePath;
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            ExportImportConfig.setProvider((String)"dir");
            ExportImportConfig.setDir((String)exportDirAbsolutePath);
            ExportImportConfig.setRealmName((String)REALM_NAME);
            ExportImportConfig.setAction((String)"export");
            new ExportImportManager(session).runExport();
            session.realms().removeRealm(realmId);
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            Assert.assertNull((Object)session.realms().getRealmByName(REALM_NAME));
            ExportImportConfig.setAction((String)"import");
            new ExportImportManager(session).runImport();
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName(REALM_NAME);
            Assert.assertNotNull((Object)realm);
            RoleModel role = realm.getRole("test-role");
            GroupModel group = realm.getGroupById(groupId);
            Assert.assertEquals((long)1L, (long)session.userFederatedStorage().getStoredUsersCount(realm));
            MultivaluedHashMap attributes = session.userFederatedStorage().getAttributes(realm, "f:1:path");
            Assert.assertEquals((long)3L, (long)attributes.size());
            Assert.assertEquals((Object)"value1", (Object)attributes.getFirst((Object)"single1"));
            Assert.assertTrue((boolean)attributes.getList((Object)"list1").contains("1"));
            Assert.assertTrue((boolean)attributes.getList((Object)"list1").contains("2"));
            Assert.assertTrue((boolean)session.userFederatedStorage().getRequiredActionsStream(realm, "f:1:path").collect(Collectors.toSet()).contains("UPDATE_PASSWORD"));
            Assert.assertTrue((boolean)session.userFederatedStorage().getRoleMappingsStream(realm, "f:1:path").collect(Collectors.toSet()).contains(role));
            Assert.assertTrue((boolean)session.userFederatedStorage().getGroupsStream(realm, "f:1:path").collect(Collectors.toSet()).contains(group));
            Assert.assertEquals((long)50L, (long)session.userFederatedStorage().getNotBeforeOfUser(realm, "f:1:path"));
            List creds = session.userFederatedStorage().getStoredCredentialsStream(realm, "f:1:path").collect(Collectors.toList());
            Assert.assertEquals((long)1L, (long)creds.size());
            Assert.assertTrue((boolean)FederatedStorageExportImportTest.getHashProvider(session, realm.getPasswordPolicy()).verify("password", PasswordCredentialModel.createFromCredentialModel((CredentialModel)((CredentialModel)creds.get(0)))));
        });
    }
}

