/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.storage;

import java.io.File;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Properties;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.exportimport.ExportImportConfig;
import org.keycloak.exportimport.ExportImportManager;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.testsuite.AbstractAuthTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.client.KeycloakTestingClient;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.RealmBuilder;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class ComponentExportImportTest
extends AbstractAuthTest {
    private static final String REALM_NAME = "exported-component";
    private File exportFile;

    @Before
    public void setDirs() {
        this.exportFile = new File(new File(System.getProperty("auth.server.config.dir", "target")), "singleFile-full.json");
        this.log.infof("Export file: %s", (Object)this.exportFile);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName(REALM_NAME);
            if (realm != null) {
                session.realms().removeRealm(realm.getId());
            }
        });
    }

    @Override
    public RealmResource testRealmResource() {
        return this.adminClient.realm(REALM_NAME);
    }

    static void clearExportImportProperties(KeycloakTestingClient testingClient) {
        testingClient.server().run((RunOnServer & Serializable)session -> {
            Properties systemProps = System.getProperties();
            HashSet<String> propsToRemove = new HashSet<String>();
            for (Object key : systemProps.keySet()) {
                if (!key.toString().startsWith("keycloak.migration.")) continue;
                propsToRemove.add(key.toString());
            }
            for (String propToRemove : propsToRemove) {
                systemProps.remove(propToRemove);
            }
        });
    }

    protected String addComponent(ComponentRepresentation component) {
        return ApiUtil.getCreatedId((Response)this.testRealmResource().components().add(component));
    }

    @Test
    public void testSingleFile() {
        ComponentExportImportTest.clearExportImportProperties(this.testingClient);
        RealmRepresentation realmRep = RealmBuilder.create().name(REALM_NAME).build();
        this.adminClient.realms().create(realmRep);
        String realmId = this.testRealmResource().toRepresentation().getId();
        ComponentRepresentation parentComponent = new ComponentRepresentation();
        parentComponent.setParentId(realmId);
        parentComponent.setName("parent");
        parentComponent.setSubType("subtype");
        parentComponent.setProviderId("user-password-map-arq");
        parentComponent.setProviderType(UserStorageProvider.class.getName());
        parentComponent.setConfig(new MultivaluedHashMap());
        parentComponent.getConfig().putSingle((Object)"priority", (Object)Integer.toString(0));
        parentComponent.getConfig().putSingle((Object)"attr", (Object)"value");
        parentComponent.getConfig().putSingle((Object)"importEnabled", (Object)Boolean.toString(false));
        String parentComponentId = this.addComponent(parentComponent);
        ComponentRepresentation subcomponent = new ComponentRepresentation();
        subcomponent.setParentId(parentComponentId);
        subcomponent.setName("child");
        subcomponent.setSubType("subtype2");
        subcomponent.setProviderId("user-password-map-arq");
        subcomponent.setProviderType(UserStorageProvider.class.getName());
        subcomponent.setConfig(new MultivaluedHashMap());
        subcomponent.getConfig().putSingle((Object)"priority", (Object)Integer.toString(0));
        subcomponent.getConfig().putSingle((Object)"attr", (Object)"value2");
        subcomponent.getConfig().putSingle((Object)"importEnabled", (Object)Boolean.toString(false));
        String subcomponentId = this.addComponent(subcomponent);
        String exportFilePath = this.exportFile.getAbsolutePath();
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            ExportImportConfig.setProvider((String)"singleFile");
            ExportImportConfig.setFile((String)exportFilePath);
            ExportImportConfig.setRealmName((String)REALM_NAME);
            ExportImportConfig.setAction((String)"export");
            new ExportImportManager(session).runExport();
        });
        this.testRealmResource().remove();
        try {
            this.testRealmResource().toRepresentation();
            Assert.fail((String)"Realm wasn't expected to be found");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            Assert.assertNull((Object)session.realms().getRealmByName(REALM_NAME));
            ExportImportConfig.setAction((String)"import");
            new ExportImportManager(session).runImport();
        });
        Assert.assertNotNull((Object)this.testRealmResource().toRepresentation());
        try {
            parentComponent = this.testRealmResource().components().component(parentComponentId).toRepresentation();
            subcomponent = this.testRealmResource().components().component(subcomponentId).toRepresentation();
        }
        catch (NotFoundException nfe) {
            Assert.fail((String)"Components not found after import.");
        }
        Assert.assertEquals((Object)parentComponent.getParentId(), (Object)realmId);
        Assert.assertEquals((Object)parentComponent.getName(), (Object)"parent");
        Assert.assertEquals((Object)parentComponent.getSubType(), (Object)"subtype");
        Assert.assertEquals((Object)parentComponent.getProviderId(), (Object)"user-password-map-arq");
        Assert.assertEquals((Object)parentComponent.getProviderType(), (Object)UserStorageProvider.class.getName());
        Assert.assertEquals((Object)parentComponent.getConfig().getFirst((Object)"attr"), (Object)"value");
        Assert.assertEquals((Object)subcomponent.getParentId(), (Object)parentComponent.getId());
        Assert.assertEquals((Object)subcomponent.getName(), (Object)"child");
        Assert.assertEquals((Object)subcomponent.getSubType(), (Object)"subtype2");
        Assert.assertEquals((Object)subcomponent.getProviderId(), (Object)"user-password-map-arq");
        Assert.assertEquals((Object)subcomponent.getProviderType(), (Object)UserStorageProvider.class.getName());
        Assert.assertEquals((Object)subcomponent.getConfig().getFirst((Object)"attr"), (Object)"value2");
    }
}

