/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.storage;

import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.cache.infinispan.ClientAdapter;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.storage.CacheableStorageProviderModel;
import org.keycloak.storage.client.ClientStorageProvider;
import org.keycloak.storage.client.ClientStorageProviderModel;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.runonserver.FetchOnServer;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.AdminClientUtil;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.util.BasicAuthHelper;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class ClientStorageTest
extends AbstractTestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected ErrorPage errorPage;
    private String providerId;
    protected String userId;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    protected String addComponent(ComponentRepresentation component) {
        Response resp = this.adminClient.realm("test").components().add(component);
        resp.close();
        String id = ApiUtil.getCreatedId((Response)resp);
        this.getCleanup().addComponentId(id);
        return id;
    }

    @Before
    public void addProvidersBeforeTest() throws URISyntaxException, IOException {
        ComponentRepresentation provider = new ComponentRepresentation();
        provider.setName("client-storage-hardcoded");
        provider.setProviderId("hardcoded-client");
        provider.setProviderType(ClientStorageProvider.class.getName());
        provider.setConfig(new MultivaluedHashMap());
        provider.getConfig().putSingle((Object)"client_id", (Object)"hardcoded-client");
        provider.getConfig().putSingle((Object)"redirect_uri", (Object)this.oauth.getRedirectUri());
        provider.getConfig().putSingle((Object)"delayed_search", (Object)Boolean.toString(false));
        this.providerId = this.addComponent(provider);
    }

    @Before
    public void clientConfiguration() {
        this.userId = ApiUtil.findUserByUsername((RealmResource)this.adminClient.realm("test"), (String)"test-user@localhost").getId();
        this.oauth.clientId("hardcoded-client");
    }

    @Test
    public void testSearchTimeout() throws Exception {
        this.runTestWithTimeout(4000L, () -> {
            String hardcodedClient = "hardcoded-client";
            String delayedSearch = "delayed_search";
            String providerId = this.providerId;
            this.testingClient.server().run((RunOnServer & Serializable)session -> {
                RealmModel realm = session.realms().getRealmByName("test");
                Assert.assertThat(session.clientStorageManager().searchClientsByClientIdStream(realm, "client", null, null).map(ClientModel::getClientId).collect(Collectors.toList()), (Matcher)Matchers.allOf((Matcher)Matchers.hasItem((Object)hardcodedClient), (Matcher)Matchers.hasItem((Object)"root-url-client")));
                Assert.assertThat(session.clientStorageManager().searchClientsByClientIdStream(realm, "client", Integer.valueOf(0), Integer.valueOf(1)).map(ClientModel::getClientId).collect(Collectors.toList()), (Matcher)Matchers.allOf((Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)hardcodedClient)), (Matcher)Matchers.hasItem((Object)"root-url-client")));
                Assert.assertThat(session.clientStorageManager().searchClientsByClientIdStream(realm, "client", Integer.valueOf(1), Integer.valueOf(1)).map(ClientModel::getClientId).collect(Collectors.toList()), (Matcher)Matchers.allOf((Matcher)Matchers.hasItem((Object)hardcodedClient), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)"root-url-client"))));
                ComponentModel memoryProvider = realm.getComponent(providerId);
                memoryProvider.getConfig().putSingle((Object)delayedSearch, (Object)Boolean.toString(true));
                realm.updateComponent(memoryProvider);
            });
            this.testingClient.server().run((RunOnServer & Serializable)session -> Assert.assertThat(session.clientStorageManager().searchClientsByClientIdStream(session.realms().getRealmByName("test"), "client", null, null).map(ClientModel::getClientId).collect(Collectors.toList()), (Matcher)Matchers.allOf((Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)hardcodedClient)), (Matcher)Matchers.hasItem((Object)"root-url-client"))));
        });
    }

    @Test
    public void testClientStats() throws Exception {
        this.testDirectGrant("hardcoded-client");
        this.testDirectGrant("hardcoded-client");
        this.testBrowser("test-app");
        this.offlineTokenDirectGrantFlowNoRefresh();
        List list = this.adminClient.realm("test").getClientSessionStats();
        boolean hardTested = false;
        boolean testAppTested = false;
        for (Map entry : list) {
            if (((String)entry.get("clientId")).equals("hardcoded-client")) {
                Assert.assertEquals((Object)"3", entry.get("active"));
                Assert.assertEquals((Object)"1", entry.get("offline"));
                hardTested = true;
                continue;
            }
            if (!((String)entry.get("clientId")).equals("test-app")) continue;
            Assert.assertEquals((Object)"1", entry.get("active"));
            Assert.assertEquals((Object)"0", entry.get("offline"));
            testAppTested = true;
        }
        Assert.assertTrue((hardTested && testAppTested ? 1 : 0) != 0);
    }

    @Test
    public void testBrowser() throws Exception {
        String clientId = "hardcoded-client";
        this.testBrowser(clientId);
    }

    private void testBrowser(String clientId) {
        this.oauth.clientId(clientId);
        String loginFormUrl = this.oauth.getLoginFormUrl();
        this.driver.navigate().to(loginFormUrl);
        this.loginPage.assertCurrent();
        this.oauth.fillLoginForm("test-user@localhost", "password");
        this.appPage.assertCurrent();
        this.events.expectLogin().client(clientId).detail("username", "test-user@localhost").assertEvent();
        String code = (String)this.oauth.getCurrentQuery().get("code");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(code, "password");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken());
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken());
        this.events.clear();
    }

    @Test
    public void testGrantAccessTokenNoOverride() throws Exception {
        this.testDirectGrant("hardcoded-client");
    }

    private void testDirectGrant(String clientId) {
        ResteasyClient httpClient = AdminClientUtil.createResteasyClient();
        String grantUri = this.oauth.getResourceOwnerPasswordCredentialGrantUrl();
        WebTarget grantTarget = httpClient.target(grantUri);
        String header = BasicAuthHelper.createHeader((String)clientId, (String)"password");
        Form form = new Form();
        form.param("grant_type", "password");
        form.param("username", "test-user@localhost");
        Response response = grantTarget.request().header("Authorization", (Object)header).post(Entity.form((Form)form));
        Assert.assertEquals((long)401L, (long)response.getStatus());
        response.close();
        header = BasicAuthHelper.createHeader((String)clientId, (String)"password");
        form = new Form();
        form.param("grant_type", "password");
        form.param("username", "test-user@localhost");
        form.param("password", "invalid");
        response = grantTarget.request().header("Authorization", (Object)header).post(Entity.form((Form)form));
        Assert.assertEquals((long)401L, (long)response.getStatus());
        response.close();
        header = BasicAuthHelper.createHeader((String)clientId, (String)"password");
        form = new Form();
        form.param("grant_type", "password");
        form.param("username", "test-user@localhost");
        form.param("password", "password");
        response = grantTarget.request().header("Authorization", (Object)header).post(Entity.form((Form)form));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response.close();
        httpClient.close();
        this.events.clear();
    }

    @Test
    public void testDailyEviction() {
        this.testIsCached();
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            ClientStorageProviderModel model = (ClientStorageProviderModel)realm.getClientStorageProvidersStream().findFirst().get();
            Calendar eviction = Calendar.getInstance();
            eviction.add(10, 1);
            model.setCachePolicy(CacheableStorageProviderModel.CachePolicy.EVICT_DAILY);
            model.setEvictionHour(eviction.get(11));
            model.setEvictionMinute(eviction.get(12));
            realm.updateComponent((ComponentModel)model);
        });
        this.testIsCached();
        this.setTimeOffset(7200);
        this.testNotCached();
        this.testIsCached();
        this.setDefaultCachePolicy();
        this.testIsCached();
    }

    @Test
    public void testWeeklyEviction() {
        this.testIsCached();
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            ClientStorageProviderModel model = (ClientStorageProviderModel)realm.getClientStorageProvidersStream().findAny().get();
            Calendar eviction = Calendar.getInstance();
            eviction.add(10, 96);
            model.setCachePolicy(CacheableStorageProviderModel.CachePolicy.EVICT_WEEKLY);
            model.setEvictionDay(eviction.get(7));
            model.setEvictionHour(eviction.get(11));
            model.setEvictionMinute(eviction.get(12));
            realm.updateComponent((ComponentModel)model);
        });
        this.testIsCached();
        this.setTimeOffset(172800);
        this.testIsCached();
        this.setTimeOffset(432000);
        this.testNotCached();
        this.testIsCached();
        this.setDefaultCachePolicy();
        this.testIsCached();
    }

    @Test
    public void testMaxLifespan() {
        this.testIsCached();
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            ClientStorageProviderModel model = (ClientStorageProviderModel)realm.getClientStorageProvidersStream().findFirst().get();
            model.setCachePolicy(CacheableStorageProviderModel.CachePolicy.MAX_LIFESPAN);
            model.setMaxLifespan(3600000L);
            realm.updateComponent((ComponentModel)model);
        });
        this.testIsCached();
        this.setTimeOffset(0);
        this.testIsCached();
        this.setTimeOffset(7200);
        this.testNotCached();
        this.testIsCached();
        this.setDefaultCachePolicy();
        this.testIsCached();
    }

    private void testNotCached() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            ClientModel hardcoded = realm.getClientByClientId("hardcoded-client");
            Assert.assertNotNull((Object)hardcoded);
            Assert.assertFalse((boolean)(hardcoded instanceof ClientAdapter));
        });
    }

    @Test
    public void testIsCached() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            ClientModel hardcoded = realm.getClientByClientId("hardcoded-client");
            Assert.assertNotNull((Object)hardcoded);
            Assert.assertTrue((boolean)(hardcoded instanceof ClientAdapter));
        });
    }

    @Test
    public void testNoCache() {
        this.testIsCached();
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            ClientStorageProviderModel model = (ClientStorageProviderModel)realm.getClientStorageProvidersStream().findFirst().get();
            model.setCachePolicy(CacheableStorageProviderModel.CachePolicy.NO_CACHE);
            realm.updateComponent((ComponentModel)model);
        });
        this.testNotCached();
        this.testNotCached();
        this.setDefaultCachePolicy();
        this.testIsCached();
    }

    private void setDefaultCachePolicy() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            ClientStorageProviderModel model = (ClientStorageProviderModel)realm.getClientStorageProvidersStream().findFirst().get();
            model.setCachePolicy(CacheableStorageProviderModel.CachePolicy.DEFAULT);
            realm.updateComponent((ComponentModel)model);
        });
    }

    @Test
    public void offlineTokenDirectGrantFlow() throws Exception {
        this.oauth.scope("offline_access");
        this.oauth.clientId("hardcoded-client");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doGrantAccessTokenRequest("password", "test-user@localhost", "password");
        Assert.assertNull((Object)tokenResponse.getErrorDescription());
        AccessToken token = this.oauth.verifyToken(tokenResponse.getAccessToken());
        String offlineTokenString = tokenResponse.getRefreshToken();
        RefreshToken offlineToken = this.oauth.parseRefreshToken(offlineTokenString);
        this.events.expectLogin().client("hardcoded-client").user(this.userId).session(token.getSessionState()).detail("grant_type", "password").detail("token_id", token.getId()).detail("refresh_token_id", offlineToken.getId()).detail("refresh_token_type", "Offline").detail("username", "test-user@localhost").removeDetail("code_id").removeDetail("redirect_uri").removeDetail("consent").assertEvent();
        Assert.assertEquals((Object)"Offline", (Object)offlineToken.getType());
        Assert.assertEquals((long)0L, (long)offlineToken.getExpiration());
        this.testRefreshWithOfflineToken(token, offlineToken, offlineTokenString, token.getSessionState(), this.userId);
        this.testRefreshWithOfflineToken(token, offlineToken, offlineTokenString, token.getSessionState(), this.userId);
    }

    public void offlineTokenDirectGrantFlowNoRefresh() throws Exception {
        this.oauth.scope("offline_access");
        this.oauth.clientId("hardcoded-client");
        OAuthClient.AccessTokenResponse tokenResponse = this.oauth.doGrantAccessTokenRequest("password", "test-user@localhost", "password");
        Assert.assertNull((Object)tokenResponse.getErrorDescription());
        AccessToken token = this.oauth.verifyToken(tokenResponse.getAccessToken());
        String offlineTokenString = tokenResponse.getRefreshToken();
        RefreshToken offlineToken = this.oauth.parseRefreshToken(offlineTokenString);
    }

    private String testRefreshWithOfflineToken(AccessToken oldToken, RefreshToken offlineToken, String offlineTokenString, String sessionId, String userId) {
        this.setTimeOffset(99999);
        Assert.assertFalse((boolean)oldToken.isActive());
        Assert.assertTrue((boolean)offlineToken.isActive());
        this.testingClient.testing().removeExpired("test");
        try {
            this.testingClient.testing().removeUserSession("test", sessionId);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        OAuthClient.AccessTokenResponse response = this.oauth.doRefreshTokenRequest(offlineTokenString, "password");
        AccessToken refreshedToken = this.oauth.verifyToken(response.getAccessToken());
        String offlineUserSessionId = (String)this.testingClient.server().fetch((FetchOnServer & Serializable)session -> session.sessions().getOfflineUserSession(session.realms().getRealmByName("test"), offlineToken.getSessionState()).getId(), String.class);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertEquals((Object)offlineUserSessionId, (Object)refreshedToken.getSessionState());
        String newRefreshToken = response.getRefreshToken();
        Assert.assertNotNull((Object)newRefreshToken);
        Assert.assertNotEquals((Object)oldToken.getId(), (Object)refreshedToken.getId());
        Assert.assertEquals((Object)userId, (Object)refreshedToken.getSubject());
        Assert.assertTrue((boolean)refreshedToken.getRealmAccess().isUserInRole("offline_access"));
        EventRepresentation refreshEvent = this.events.expectRefresh(offlineToken.getId(), sessionId).client("hardcoded-client").user(userId).removeDetail("updated_refresh_token_id").detail("refresh_token_type", "Offline").assertEvent();
        Assert.assertNotEquals((Object)oldToken.getId(), refreshEvent.getDetails().get("token_id"));
        this.setTimeOffset(0);
        return newRefreshToken;
    }
}

