/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.storage;

import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.Response;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.Profile;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.testsuite.AbstractAuthTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.federation.BackwardsCompatibilityUserStorageFactory;
import org.keycloak.testsuite.page.AbstractPage;
import org.keycloak.testsuite.pages.AccountTotpPage;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginConfigTotpPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginTotpPage;
import org.keycloak.testsuite.runonserver.FetchOnServer;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.URLAssert;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
@DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
public class BackwardsCompatibilityUserStorageTest
extends AbstractAuthTest {
    private String backwardsCompProviderId;
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected LoginTotpPage loginTotpPage;
    @Page
    protected AccountTotpPage accountTotpSetupPage;
    @Page
    protected LoginConfigTotpPage configureTotpRequiredActionPage;
    private TimeBasedOTP totp = new TimeBasedOTP();

    @Before
    public void addProvidersBeforeTest() throws URISyntaxException, IOException {
        ComponentRepresentation memProvider = new ComponentRepresentation();
        memProvider.setName("backwards-compatibility");
        memProvider.setProviderId("backwards-compatibility-storage");
        memProvider.setProviderType(UserStorageProvider.class.getName());
        memProvider.setConfig(new MultivaluedHashMap());
        memProvider.getConfig().putSingle((Object)"priority", (Object)Integer.toString(0));
        this.backwardsCompProviderId = this.addComponent(memProvider);
    }

    protected String addComponent(ComponentRepresentation component) {
        Response resp = this.testRealmResource().components().add(component);
        String id = ApiUtil.getCreatedId((Response)resp);
        this.getCleanup().addComponentId(id);
        return id;
    }

    private void loginSuccessAndLogout(String username, String password) {
        this.testRealmAccountPage.navigateTo();
        this.loginPage.login(username, password);
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmAccountPage);
        this.testRealmAccountPage.logOut();
    }

    public void loginBadPassword(String username) {
        this.testRealmAccountPage.navigateTo();
        this.testRealmLoginPage.form().login(username, "badpassword");
        URLAssert.assertCurrentUrlDoesntStartWith((AbstractPage)this.testRealmAccountPage);
    }

    @Test
    public void testLoginSuccess() {
        this.addUserAndResetPassword("tbrady", "goat");
        this.addUserAndResetPassword("tbrady2", "goat2");
        this.loginSuccessAndLogout("tbrady", "goat");
        this.loginSuccessAndLogout("tbrady2", "goat2");
        this.loginBadPassword("tbrady");
    }

    private String addUserAndResetPassword(String username, String password) {
        UserRepresentation user = new UserRepresentation();
        user.setEnabled(Boolean.valueOf(true));
        user.setUsername(username);
        Response response = this.testRealmResource().users().create(user);
        String userId = ApiUtil.getCreatedId((Response)response);
        Assert.assertEquals((Object)this.backwardsCompProviderId, (Object)new StorageId(userId).getProviderId());
        CredentialRepresentation passwordRep = new CredentialRepresentation();
        passwordRep.setType("password");
        passwordRep.setValue(password);
        passwordRep.setTemporary(Boolean.valueOf(false));
        this.testRealmResource().users().get(userId).resetPassword(passwordRep);
        return userId;
    }

    @Test
    public void testOTPUpdateAndLogin() {
        String userId = this.addUserAndResetPassword("otp1", "pass");
        this.getCleanup().addUserId(userId);
        String totpSecret = this.setupOTPForUserWithRequiredAction(userId);
        this.assertUserDontHaveDBCredentials();
        this.assertUserHasOTPCredentialInUserStorage(true);
        this.assertUserDontHaveDBCredentials();
        this.assertUserHasOTPCredentialInUserStorage(true);
        this.loginPage.login("otp1", "pass");
        this.loginTotpPage.assertCurrent();
        this.loginTotpPage.login("123456");
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmAccountPage);
        this.testRealmAccountPage.logOut();
        this.loginPage.login("otp1", "pass");
        this.loginTotpPage.assertCurrent();
        this.loginTotpPage.login("7123456");
        URLAssert.assertCurrentUrlDoesntStartWith((AbstractPage)this.testRealmAccountPage);
        Assert.assertNotNull((Object)this.loginTotpPage.getInputError());
        this.loginTotpPage.login(this.totp.generateTOTP(totpSecret));
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmAccountPage);
        this.testRealmAccountPage.logOut();
    }

    @Test
    public void testOTPSetupThroughAccountMgmtAndLogin() {
        String userId = this.addUserAndResetPassword("otp1", "pass");
        this.getCleanup().addUserId(userId);
        this.accountTotpSetupPage.open();
        this.loginPage.login("otp1", "pass");
        String totpSecret = this.accountTotpSetupPage.getTotpSecret();
        this.accountTotpSetupPage.configure(this.totp.generateTOTP(totpSecret));
        this.assertUserDontHaveDBCredentials();
        this.assertUserHasOTPCredentialInUserStorage(true);
        this.accountTotpSetupPage.logout();
        this.loginPage.login("otp1", "pass");
        this.loginTotpPage.login("123456");
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmAccountPage);
        this.accountTotpSetupPage.logout();
        this.loginPage.login("otp1", "pass");
        this.loginTotpPage.login(this.totp.generateTOTP(totpSecret));
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmAccountPage);
        this.accountTotpSetupPage.removeTotp();
        this.accountTotpSetupPage.logout();
        this.assertUserDontHaveDBCredentials();
        this.assertUserHasOTPCredentialInUserStorage(false);
        this.loginSuccessAndLogout("otp1", "pass");
    }

    @Test
    public void testDisableCredentialsInUserStorage() {
        String userId = this.addUserAndResetPassword("otp1", "pass");
        this.getCleanup().addUserId(userId);
        this.setupOTPForUserWithRequiredAction(userId);
        this.assertUserDontHaveDBCredentials();
        this.assertUserHasOTPCredentialInUserStorage(true);
        UserResource user = this.testRealmResource().users().get(userId);
        UserRepresentation userRep = user.toRepresentation();
        Assert.assertNames(userRep.getDisableableCredentialTypes(), "otp");
        user.disableCredentialType(Collections.singletonList("otp"));
        this.assertUserDontHaveDBCredentials();
        this.assertUserHasOTPCredentialInUserStorage(false);
        this.loginSuccessAndLogout("otp1", "pass");
    }

    @Test
    public void testSearchUserStorage() {
        String userId = this.addUserAndResetPassword("searching", "pass");
        this.getCleanup().addUserId(userId);
        List users = this.testRealmResource().users().search("searching", Integer.valueOf(0), Integer.valueOf(20), Boolean.valueOf(true));
        Assert.assertNames(users, "searching");
    }

    private String setupOTPForUserWithRequiredAction(String userId) {
        UserResource user = this.testRealmResource().users().get(userId);
        UserRepresentation userRep = user.toRepresentation();
        userRep.setRequiredActions(Arrays.asList(UserModel.RequiredAction.CONFIGURE_TOTP.toString()));
        user.update(userRep);
        this.testRealmAccountPage.navigateTo();
        this.loginPage.login("otp1", "pass");
        this.configureTotpRequiredActionPage.assertCurrent();
        String totpSecret = this.configureTotpRequiredActionPage.getTotpSecret();
        this.configureTotpRequiredActionPage.configure(this.totp.generateTOTP(totpSecret));
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmAccountPage);
        this.testRealmAccountPage.logOut();
        return totpSecret;
    }

    private void assertUserDontHaveDBCredentials() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm1 = session.realms().getRealmByName("test");
            UserModel user1 = session.users().getUserByUsername(realm1, "otp1");
            Assert.assertEquals((long)0L, (long)session.userCredentialManager().getStoredCredentialsStream(realm1, user1).count());
        });
    }

    private void assertUserHasOTPCredentialInUserStorage(boolean expectedUserHasOTP) {
        boolean hasUserOTP = (Boolean)this.testingClient.server().fetch((FetchOnServer & Serializable)session -> {
            BackwardsCompatibilityUserStorageFactory storageFactory = (BackwardsCompatibilityUserStorageFactory)session.getKeycloakSessionFactory().getProviderFactory(UserStorageProvider.class, "backwards-compatibility-storage");
            return storageFactory.hasUserOTP("otp1");
        }, Boolean.class);
        Assert.assertEquals((Object)expectedUserHasOTP, (Object)hasUserOTP);
    }
}

