/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.storage;

import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.GroupResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.testsuite.admin.concurrency.AbstractConcurrencyTest;
import org.keycloak.testsuite.federation.UserMapStorage;
import org.keycloak.testsuite.federation.storage.UserStorageProvidersTestUtils;
import org.keycloak.testsuite.updaters.Creator;
import org.keycloak.testsuite.util.GroupBuilder;
import org.keycloak.testsuite.util.TestCleanup;
import org.keycloak.testsuite.util.UserBuilder;

public abstract class AbstractUserStorageDirtyDeletionTest
extends AbstractConcurrencyTest {
    private static final int NUM_USERS = 200;
    private static final int REMOVED_USERS_COUNT = 100;
    private List<Creator<UserResource>> createdUsers;

    protected abstract ComponentRepresentation getFederationProvider();

    public static void remove20UsersFromStorageProvider(KeycloakSession session) {
        Assert.assertThat((Object)100, (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(200)));
        RealmModel realm = session.realms().getRealm("test");
        UserStorageProvidersTestUtils.getEnabledStorageProviders(session, realm, UserMapStorage.class).forEachOrdered(userMapStorage -> {
            HashSet users = new HashSet(userMapStorage.getUsernames());
            users.stream().sorted().limit(100L).forEach(arg_0 -> ((UserMapStorage)userMapStorage).removeUserByName(arg_0));
        });
    }

    protected ComponentRepresentation getFederationProvider(UserStorageProvider.EditMode editMode, boolean importEnabled) {
        ComponentRepresentation provider = new ComponentRepresentation();
        provider.setName(this.getClass().getSimpleName());
        provider.setProviderId("user-password-map-arq");
        provider.setProviderType(UserStorageProvider.class.getName());
        provider.setConfig(new MultivaluedHashMap());
        provider.getConfig().putSingle((Object)"priority", (Object)Integer.toString(0));
        provider.getConfig().putSingle((Object)"editMode", (Object)editMode.name());
        provider.getConfig().putSingle((Object)"importEnabled", (Object)Boolean.toString(importEnabled));
        return provider;
    }

    private Creator<UserResource> addFederatedUser(int sequenceId) {
        try {
            Creator creator = Creator.create((RealmResource)this.testRealm(), (UserRepresentation)UserBuilder.create().username("test-user-" + sequenceId).build());
            return creator;
        }
        catch (Throwable ex) {
            throw new RuntimeException("Failed for test-user-" + sequenceId, ex);
        }
    }

    private List<Creator<UserResource>> createUsers() {
        this.log.debugf("Adding users test-user-%d .. test-user-%d", 0, 200);
        return IntStream.range(0, 200).mapToObj(this::addFederatedUser).collect(Collectors.toList());
    }

    @Before
    public void before() {
        this.getCleanup().addCleanup((AutoCloseable)Creator.create((RealmResource)this.testRealm(), (ComponentRepresentation)this.getFederationProvider()));
        this.createdUsers = this.createUsers();
        this.createdUsers.forEach(arg_0 -> ((TestCleanup)this.getCleanup()).addCleanup(arg_0));
    }

    @Test
    public void testConcurrentDelete() {
        ((Stream)this.createdUsers.stream().parallel()).forEach(Creator::close);
    }

    @Test
    public void testConcurrentDeleteCachedUsers() {
        ((Stream)this.createdUsers.stream().parallel()).map(Creator::resource).forEach(UserResource::toRepresentation);
        ((Stream)this.createdUsers.stream().parallel()).forEach(Creator::close);
    }

    @Test
    public void testMembersWhenCachedUsersRemovedFromBackend() {
        try (Creator group = Creator.create((RealmResource)this.testRealm(), (GroupRepresentation)GroupBuilder.create().name("g").build());){
            ((Stream)this.createdUsers.stream().parallel()).map(Creator::resource).forEach(r -> {
                r.joinGroup(group.id());
                r.toRepresentation();
            });
            Assert.assertThat((Object)((GroupResource)group.resource()).members(Integer.valueOf(0), Integer.valueOf(400)), (Matcher)Matchers.hasSize((int)200));
            this.testingClient.server().run(AbstractUserStorageDirtyDeletionTest::remove20UsersFromStorageProvider);
            IntStream.range(0, 7).parallel().mapToObj(i -> ((GroupResource)group.resource()).members(Integer.valueOf(0), Integer.valueOf(400))).forEach(members -> Assert.assertThat((Object)members, (Matcher)Matchers.hasSize((int)100)));
            Assert.assertThat((Object)((GroupResource)group.resource()).members(Integer.valueOf(0), Integer.valueOf(5)), (Matcher)Matchers.hasSize((int)5));
            ((Stream)this.createdUsers.stream().parallel()).forEach(Creator::close);
            Assert.assertThat((Object)((GroupResource)group.resource()).members(Integer.valueOf(0), Integer.valueOf(5)), (Matcher)Matchers.hasSize((int)0));
        }
    }
}

