/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.ldap.noimport;

import java.io.Serializable;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.mappers.membership.LDAPGroupMapperMode;
import org.keycloak.storage.ldap.mappers.membership.role.RoleLDAPStorageMapper;
import org.keycloak.testsuite.federation.ldap.AbstractLDAPTest;
import org.keycloak.testsuite.federation.ldap.LDAPTestContext;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.LDAPRule;
import org.keycloak.testsuite.util.LDAPTestUtils;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class LDAPRoleMappingsNoImportTest
extends AbstractLDAPTest {
    @ClassRule
    public static LDAPRule ldapRule = new LDAPRule();

    @Override
    protected LDAPRule getLDAPRule() {
        return ldapRule;
    }

    @Override
    protected boolean isImportEnabled() {
        return false;
    }

    @Override
    protected void afterImportTestRealm() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            ctx.getLdapModel().put("pagination", "false");
            appRealm.updateComponent((ComponentModel)ctx.getLdapModel());
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserStorageProviderModel ldapModel = ctx.getLdapModel();
            LDAPTestUtils.addLocalUser((KeycloakSession)session, (RealmModel)appRealm, (String)"mary", (String)"mary@test.com", (String)"password-app");
            LDAPStorageProvider ldapFedProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ldapModel);
            LDAPTestUtils.removeAllLDAPUsers((LDAPStorageProvider)ldapFedProvider, (RealmModel)appRealm);
            ClientModel finance = appRealm.addClient("finance");
            LDAPTestUtils.addOrUpdateRoleLDAPMappers((RealmModel)appRealm, (ComponentModel)ldapModel, (LDAPGroupMapperMode)LDAPGroupMapperMode.LDAP_ONLY);
            LDAPTestUtils.removeAllLDAPRoles((KeycloakSession)session, (RealmModel)appRealm, (ComponentModel)ldapModel, (String)"realmRolesMapper");
            LDAPTestUtils.removeAllLDAPRoles((KeycloakSession)session, (RealmModel)appRealm, (ComponentModel)ldapModel, (String)"financeRolesMapper");
            LDAPObject john = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ldapFedProvider, (RealmModel)appRealm, (String)"johnkeycloak", (String)"John", (String)"Doe", (String)"john@email.org", null, (String[])new String[]{"1234"});
            LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ldapFedProvider, (LDAPObject)john, (String)"Password1");
            LDAPObject mary = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ldapFedProvider, (RealmModel)appRealm, (String)"marykeycloak", (String)"Mary", (String)"Kelly", (String)"mary@email.org", null, (String[])new String[]{"5678"});
            LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ldapFedProvider, (LDAPObject)mary, (String)"Password1");
            LDAPObject rob = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ldapFedProvider, (RealmModel)appRealm, (String)"robkeycloak", (String)"Rob", (String)"Brown", (String)"rob@email.org", null, (String[])new String[]{"8910"});
            LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ldapFedProvider, (LDAPObject)rob, (String)"Password1");
            LDAPTestUtils.createLDAPRole((KeycloakSession)session, (RealmModel)appRealm, (ComponentModel)ldapModel, (String)"realmRolesMapper", (String)"realmRole1");
            LDAPTestUtils.createLDAPRole((KeycloakSession)session, (RealmModel)appRealm, (ComponentModel)ldapModel, (String)"realmRolesMapper", (String)"realmRole2");
            LDAPTestUtils.createLDAPRole((KeycloakSession)session, (RealmModel)appRealm, (ComponentModel)ldapModel, (String)"financeRolesMapper", (String)"financeRole1");
            LDAPTestUtils.syncRolesFromLDAP((RealmModel)appRealm, (LDAPStorageProvider)ldapFedProvider, (ComponentModel)ldapModel);
        });
    }

    @Test
    public void test01ReadMappings() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPTestUtils.addOrUpdateRoleLDAPMappers((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (LDAPGroupMapperMode)LDAPGroupMapperMode.LDAP_ONLY);
            ComponentModel roleMapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"realmRolesMapper");
            LDAPStorageProvider ldapProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ctx.getLdapModel());
            RoleLDAPStorageMapper roleMapper = LDAPTestUtils.getRoleMapper((ComponentModel)roleMapperModel, (LDAPStorageProvider)ldapProvider, (RealmModel)appRealm);
            LDAPObject maryLdap = ldapProvider.loadLDAPUserByUsername(appRealm, "marykeycloak");
            roleMapper.addRoleMappingInLDAP("realmRole1", maryLdap);
            roleMapper.addRoleMappingInLDAP("realmRole2", maryLdap);
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            session.userCache().clear();
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel mary = session.users().getUserByUsername(appRealm, "marykeycloak");
            Assert.assertNull((Object)session.userLocalStorage().getUserByUsername(appRealm, "marykeycloak"));
            RoleModel realmRole1 = appRealm.getRole("realmRole1");
            RoleModel realmRole2 = appRealm.getRole("realmRole2");
            Set maryRoles = mary.getRealmRoleMappingsStream().collect(Collectors.toSet());
            Assert.assertTrue((boolean)maryRoles.contains(realmRole1));
            Assert.assertTrue((boolean)maryRoles.contains(realmRole2));
            ComponentModel roleMapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"realmRolesMapper");
            LDAPStorageProvider ldapProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ctx.getLdapModel());
            RoleLDAPStorageMapper roleMapper = LDAPTestUtils.getRoleMapper((ComponentModel)roleMapperModel, (LDAPStorageProvider)ldapProvider, (RealmModel)appRealm);
            LDAPObject maryLdap = ldapProvider.loadLDAPUserByUsername(appRealm, "marykeycloak");
            LDAPRoleMappingsNoImportTest.deleteRoleMappingsInLDAP(roleMapper, maryLdap, "realmRole1");
            LDAPRoleMappingsNoImportTest.deleteRoleMappingsInLDAP(roleMapper, maryLdap, "realmRole2");
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            session.userCache().clear();
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel mary = session.users().getUserByUsername(appRealm, "marykeycloak");
            RoleModel realmRole1 = appRealm.getRole("realmRole1");
            RoleModel realmRole2 = appRealm.getRole("realmRole2");
            Set maryRoles = mary.getRealmRoleMappingsStream().collect(Collectors.toSet());
            Assert.assertFalse((boolean)maryRoles.contains(realmRole1));
            Assert.assertFalse((boolean)maryRoles.contains(realmRole2));
        });
    }

    @Test
    public void test02WriteMappings() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            session.userCache().clear();
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPTestUtils.addOrUpdateRoleLDAPMappers((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (LDAPGroupMapperMode)LDAPGroupMapperMode.LDAP_ONLY);
            UserModel john = session.users().getUserByUsername(appRealm, "johnkeycloak");
            UserModel mary = session.users().getUserByUsername(appRealm, "marykeycloak");
            Assert.assertNull((Object)session.userLocalStorage().getUserByUsername(appRealm, "johnkeycloak"));
            Assert.assertNull((Object)session.userLocalStorage().getUserByUsername(appRealm, "marykeycloak"));
            RoleModel realmRole1 = appRealm.getRole("realmRole1");
            john.grantRole(realmRole1);
            RoleModel realmRole2 = appRealm.getRole("realmRole2");
            mary.grantRole(realmRole2);
            RoleModel realmRole3 = appRealm.getRole("realmRole3");
            if (realmRole3 == null) {
                realmRole3 = appRealm.addRole("realmRole3");
            }
            john.grantRole(realmRole3);
            mary.grantRole(realmRole3);
            ClientModel accountApp = appRealm.getClientByClientId("account");
            ClientModel financeApp = appRealm.getClientByClientId("finance");
            RoleModel manageAccountRole = accountApp.getRole("manage-account");
            RoleModel financeRole1 = financeApp.getRole("financeRole1");
            john.grantRole(financeRole1);
            session.userCache().clear();
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            session.userCache().clear();
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel john = session.users().getUserByUsername(appRealm, "johnkeycloak");
            UserModel mary = session.users().getUserByUsername(appRealm, "marykeycloak");
            Assert.assertNull((Object)session.userLocalStorage().getUserByUsername(appRealm, "johnkeycloak"));
            Assert.assertNull((Object)session.userLocalStorage().getUserByUsername(appRealm, "marykeycloak"));
            RoleModel realmRole1 = appRealm.getRole("realmRole1");
            RoleModel realmRole2 = appRealm.getRole("realmRole2");
            RoleModel realmRole3 = appRealm.getRole("realmRole3");
            ClientModel accountApp = appRealm.getClientByClientId("account");
            ClientModel financeApp = appRealm.getClientByClientId("finance");
            RoleModel financeRole1 = financeApp.getRole("financeRole1");
            Set johnRoles = john.getRoleMappingsStream().collect(Collectors.toSet());
            Assert.assertTrue((boolean)johnRoles.contains(realmRole1));
            Assert.assertFalse((boolean)johnRoles.contains(realmRole2));
            Assert.assertTrue((boolean)johnRoles.contains(realmRole3));
            Assert.assertTrue((boolean)johnRoles.contains(financeRole1));
            Set johnRealmRoles = john.getRealmRoleMappingsStream().collect(Collectors.toSet());
            Assert.assertEquals((long)2L, (long)johnRealmRoles.size());
            Assert.assertTrue((boolean)johnRealmRoles.contains(realmRole1));
            Assert.assertTrue((boolean)johnRealmRoles.contains(realmRole3));
            Set johnFinanceRoles = john.getClientRoleMappingsStream(financeApp).collect(Collectors.toSet());
            Assert.assertEquals((long)1L, (long)johnFinanceRoles.size());
            Assert.assertTrue((boolean)johnFinanceRoles.contains(financeRole1));
            john.deleteRoleMapping(realmRole3);
            john.deleteRoleMapping(realmRole1);
            john.deleteRoleMapping(financeRole1);
            johnRoles = john.getRoleMappingsStream().collect(Collectors.toSet());
            Assert.assertFalse((boolean)johnRoles.contains(realmRole1));
            Assert.assertFalse((boolean)johnRoles.contains(realmRole2));
            Assert.assertFalse((boolean)johnRoles.contains(realmRole3));
            Assert.assertFalse((boolean)johnRoles.contains(financeRole1));
            mary.deleteRoleMapping(realmRole2);
            mary.deleteRoleMapping(realmRole3);
            session.userCache().clear();
        });
    }

    @Test
    public void test03_newUserDefaultRolesNoImportModeTest() throws Exception {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            session.userCache().clear();
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPTestUtils.addOrUpdateRoleLDAPMappers((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (LDAPGroupMapperMode)LDAPGroupMapperMode.LDAP_ONLY);
            UserModel david = session.users().addUser(appRealm, "davidkeycloak");
            Assert.assertNull((Object)session.userLocalStorage().getUserByUsername(appRealm, "davidkeycloak"));
            RoleModel defaultRole = appRealm.getRole("realmRole1");
            RoleModel realmRole2 = appRealm.getRole("realmRole2");
            Assert.assertNotNull((Object)defaultRole);
            Assert.assertNotNull((Object)realmRole2);
            appRealm.addToDefaultRoles(defaultRole);
            Set davidRoles = david.getRealmRoleMappingsStream().collect(Collectors.toSet());
            Assert.assertFalse((boolean)davidRoles.contains(defaultRole));
            Assert.assertFalse((boolean)davidRoles.contains(realmRole2));
            Assert.assertTrue((boolean)david.hasRole(defaultRole));
            Assert.assertFalse((boolean)david.hasRole(realmRole2));
            UserModel john = session.users().getUserByUsername(appRealm, "johnkeycloak");
            Assert.assertFalse((boolean)john.hasRole(defaultRole));
        });
    }

    private static void deleteRoleMappingsInLDAP(RoleLDAPStorageMapper roleMapper, LDAPObject ldapUser, String roleName) {
        LDAPObject ldapRole1 = roleMapper.loadLDAPRoleByName(roleName);
        roleMapper.deleteRoleMappingInLDAP(ldapUser, ldapRole1);
    }
}

