/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.ldap.noimport;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.admin.client.resource.ComponentResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.mappers.LDAPStorageMapper;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.federation.ldap.LDAPProvidersIntegrationTest;
import org.keycloak.testsuite.federation.ldap.LDAPTestAsserts;
import org.keycloak.testsuite.federation.ldap.LDAPTestContext;
import org.keycloak.testsuite.runonserver.FetchOnServer;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.LDAPTestUtils;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class LDAPProvidersIntegrationNoImportTest
extends LDAPProvidersIntegrationTest {
    @Override
    protected boolean isImportEnabled() {
        return false;
    }

    @Override
    protected void assertFederatedUserLink(UserRepresentation user) {
        StorageId storageId = new StorageId(user.getId());
        Assert.assertFalse((boolean)storageId.isLocal());
        Assert.assertEquals((Object)ldapModelId, (Object)storageId.getProviderId());
        Assert.assertEquals((Object)storageId.getExternalId(), (Object)user.getUsername());
        Assert.assertNull((Object)user.getFederationLink());
    }

    @Override
    @Test
    @Ignore
    public void testRemoveImportedUsers() {
    }

    @Override
    @Test
    public void testSearch() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm, (String)"username1", (String)"John1", (String)"Doel1", (String)"user1@email.org", null, (String[])new String[]{"121"});
            LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm, (String)"username2", (String)"John2", (String)"Doel2", (String)"user2@email.org", null, (String[])new String[]{"122"});
            LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm, (String)"username3", (String)"John3", (String)"Doel3", (String)"user3@email.org", null, (String[])new String[]{"123"});
            LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm, (String)"username4", (String)"John4", (String)"Doel4", (String)"user4@email.org", null, (String[])new String[]{"124"});
            UserModel user = (UserModel)session.users().searchForUserStream(appRealm, "username1").findFirst().get();
            LDAPTestAsserts.assertLoaded(user, "username1", "John1", "Doel1", "user1@email.org", "121");
            user = (UserModel)session.users().searchForUserStream(appRealm, "user2@email.org").findFirst().get();
            LDAPTestAsserts.assertLoaded(user, "username2", "John2", "Doel2", "user2@email.org", "122");
            user = (UserModel)session.users().searchForUserStream(appRealm, "Doel3").findFirst().get();
            LDAPTestAsserts.assertLoaded(user, "username3", "John3", "Doel3", "user3@email.org", "123");
            user = (UserModel)session.users().searchForUserStream(appRealm, "John4 Doel4").findFirst().get();
            LDAPTestAsserts.assertLoaded(user, "username4", "John4", "Doel4", "user4@email.org", "124");
        });
    }

    @Override
    @Test
    @Ignore
    public void testSearchByAttributes() {
    }

    @Override
    @Test
    public void testSearchWithCustomLDAPFilter() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            ctx.getLdapModel().getConfig().putSingle((Object)"customUserSearchFilter", (Object)"(|(mail=user5@email.org)(mail=user6@email.org))");
            appRealm.updateComponent((ComponentModel)ctx.getLdapModel());
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm, (String)"username5", (String)"John5", (String)"Doel5", (String)"user5@email.org", null, (String[])new String[]{"125"});
            LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm, (String)"username6", (String)"John6", (String)"Doel6", (String)"user6@email.org", null, (String[])new String[]{"126"});
            LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm, (String)"username7", (String)"John7", (String)"Doel7", (String)"user7@email.org", null, (String[])new String[]{"127"});
            UserModel user = (UserModel)session.users().searchForUserStream(appRealm, "user5@email.org").findFirst().get();
            LDAPTestAsserts.assertLoaded(user, "username5", "John5", "Doel5", "user5@email.org", "125");
            user = (UserModel)session.users().searchForUserStream(appRealm, "John6 Doel6").findFirst().get();
            LDAPTestAsserts.assertLoaded(user, "username6", "John6", "Doel6", "user6@email.org", "126");
            Assert.assertEquals((long)0L, (long)session.users().searchForUserStream(appRealm, "user7@email.org").count());
            Assert.assertEquals((long)0L, (long)session.users().searchForUserStream(appRealm, "John7 Doel7").count());
            ctx.getLdapModel().getConfig().remove((Object)"customUserSearchFilter");
            appRealm.updateComponent((ComponentModel)ctx.getLdapModel());
        });
    }

    @Override
    @Test
    public void testUnsynced() throws Exception {
        ComponentResource ldapProviderResource = this.testRealm().components().component(ldapModelId);
        ComponentRepresentation ldapProviderRep = ldapProviderResource.toRepresentation();
        String currentEditMode = (String)ldapProviderRep.getConfig().getFirst((Object)"editMode");
        Assert.assertEquals((Object)UserStorageProvider.EditMode.WRITABLE.toString(), (Object)currentEditMode);
        ldapProviderRep.getConfig().putSingle((Object)"editMode", (Object)UserStorageProvider.EditMode.UNSYNCED.toString());
        try {
            ldapProviderResource.update(ldapProviderRep);
            Assert.fail((String)"Not expected to successfully update provider");
        }
        catch (BadRequestException badRequestException) {
            // empty catch block
        }
        ldapProviderRep.getConfig().putSingle((Object)"editMode", (Object)currentEditMode);
        ldapProviderResource.update(ldapProviderRep);
    }

    @Override
    @Test
    @Ignore
    public void zzTestUnlinkUsers() {
    }

    @Test
    public void testFullNameMapperWriteOnly() {
        ComponentRepresentation firstNameMapperRep = (ComponentRepresentation)this.testingClient.server().fetch((FetchOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            Assert.assertNull((Object)session.users().getUserByUsername(appRealm, "fullname"));
            ComponentModel ldapModel = LDAPTestUtils.getLdapProviderModel((RealmModel)appRealm);
            LDAPStorageProvider ldapFedProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ldapModel);
            LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ldapFedProvider, (RealmModel)appRealm, (String)"fullname", (String)"James Dee", (String)"Dee", (String)"fullname@email.org", null, (String[])new String[]{"4578"});
            ComponentModel firstNameMapper = LDAPTestUtils.getSubcomponentByName((RealmModel)appRealm, (ComponentModel)ldapModel, (String)"first name");
            String ldapFirstNameAttributeName = (String)firstNameMapper.getConfig().getFirst((Object)"ldap.attribute");
            appRealm.removeComponent(firstNameMapper);
            ComponentRepresentation firstNameMapperRepp = ModelToRepresentation.toRepresentation((KeycloakSession)session, (ComponentModel)firstNameMapper, (boolean)true);
            ComponentModel fullNameMapperModel = KeycloakModelUtils.createComponentModel((String)"full name", (String)ldapModel.getId(), (String)"full-name-ldap-mapper", (String)LDAPStorageMapper.class.getName(), (String[])new String[]{"ldap.full.name.attribute", ldapFirstNameAttributeName, "read.only", "false"});
            appRealm.addComponentModel(fullNameMapperModel);
            return firstNameMapperRepp;
        }, ComponentRepresentation.class);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPTestAsserts.assertUserImported(session.users(), appRealm, "fullname", "James", "Dee", "fullname@email.org", "4578");
            ComponentModel fullNameMapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"full name");
            fullNameMapperModel.getConfig().putSingle((Object)"write.only", (Object)"true");
            appRealm.updateComponent(fullNameMapperModel);
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel fullnameUser = session.users().getUserByUsername(appRealm, "fullname");
            fullnameUser.setFirstName("James2");
            fullnameUser.setLastName("Dee2");
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPTestAsserts.assertUserImported(session.users(), appRealm, "fullname", null, "Dee2", "fullname@email.org", "4578");
            UserModel fullnameUser = session.users().getUserByUsername(appRealm, "fullname");
            session.users().removeUser(appRealm, fullnameUser);
            ComponentModel fullNameMapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"full name");
            appRealm.removeComponent(fullNameMapperModel);
        });
        firstNameMapperRep.setId(null);
        Response response = this.testRealm().components().add(firstNameMapperRep);
        Assert.assertEquals((long)201L, (long)response.getStatus());
        response.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImpossibleToChangeNonLDAPMappedAttributes() {
        UserResource john = ApiUtil.findUserByUsernameId((RealmResource)this.testRealm(), (String)"johnkeycloak");
        UserRepresentation johnRep = john.toRepresentation();
        String firstNameOrig = johnRep.getFirstName();
        String lastNameOrig = johnRep.getLastName();
        String emailOrig = johnRep.getEmail();
        String postalCodeOrig = (String)((List)johnRep.getAttributes().get("postal_code")).get(0);
        try {
            try {
                johnRep.setFirstName("John2");
                johnRep.setLastName("Doe2");
                johnRep.setEnabled(Boolean.valueOf(false));
                john.update(johnRep);
                Assert.fail((String)"Not supposed to successfully update 'enabled' state of the user");
            }
            catch (BadRequestException badRequestException) {
                // empty catch block
            }
            try {
                johnRep = john.toRepresentation();
                johnRep.setRequiredActions(Collections.singletonList(UserModel.RequiredAction.CONFIGURE_TOTP.toString()));
                john.update(johnRep);
                Assert.fail((String)"Not supposed to successfully add requiredAction to the user");
            }
            catch (BadRequestException badRequestException) {
                // empty catch block
            }
            try {
                johnRep = john.toRepresentation();
                johnRep.singleAttribute("foo", "bar");
                john.update(johnRep);
                Assert.fail((String)"Not supposed to successfully add attribute to the user");
            }
            catch (BadRequestException badRequestException) {
                // empty catch block
            }
            johnRep = john.toRepresentation();
            johnRep.setFirstName("John2");
            johnRep.setLastName("Doe2");
            johnRep.singleAttribute("postal_code", "654321");
            john.update(johnRep);
            johnRep = john.toRepresentation();
            Assert.assertEquals((Object)"John2", (Object)johnRep.getFirstName());
            Assert.assertEquals((Object)"Doe2", (Object)johnRep.getLastName());
            Assert.assertEquals((Object)"654321", ((List)johnRep.getAttributes().get("postal_code")).get(0));
        }
        finally {
            johnRep.setFirstName(firstNameOrig);
            johnRep.setLastName(lastNameOrig);
            johnRep.singleAttribute("postal_code", postalCodeOrig);
            john.update(johnRep);
            Assert.assertEquals((Object)firstNameOrig, (Object)johnRep.getFirstName());
            Assert.assertEquals((Object)lastNameOrig, (Object)johnRep.getLastName());
            Assert.assertEquals((Object)emailOrig, (Object)johnRep.getEmail());
            Assert.assertEquals((Object)postalCodeOrig, ((List)johnRep.getAttributes().get("postal_code")).get(0));
        }
    }

    @Override
    @Test
    @Ignore
    public void updateLDAPUsernameTest() {
    }
}

