/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.ldap.noimport;

import java.io.Serializable;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.testsuite.federation.ldap.LDAPMultipleAttributesTest;
import org.keycloak.testsuite.federation.ldap.LDAPTestAsserts;
import org.keycloak.testsuite.federation.ldap.LDAPTestContext;
import org.keycloak.testsuite.runonserver.RunOnServer;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class LDAPMultipleAttributesNoImportTest
extends LDAPMultipleAttributesTest {
    @Override
    protected boolean isImportEnabled() {
        return false;
    }

    @Override
    @Test
    public void testUserImport() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            session.userCache().clear();
            RealmModel appRealm = ctx.getRealm();
            UserModel user = session.users().getUserByUsername(appRealm, "jbrown");
            Assert.assertNotNull((Object)user);
            Assert.assertNull((Object)session.userLocalStorage().getUserById(appRealm, user.getId()));
            LDAPTestAsserts.assertUserImported(session.users(), appRealm, "jbrown", "James", "Brown", "jbrown@keycloak.org", "88441");
        });
    }
}

