/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.ldap;

import java.io.Serializable;
import java.util.Arrays;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.credential.CredentialModel;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.credential.OTPCredentialModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.testsuite.arquillian.annotation.EnableVault;
import org.keycloak.testsuite.client.KeycloakTestingClient;
import org.keycloak.testsuite.federation.ldap.AbstractLDAPTest;
import org.keycloak.testsuite.federation.ldap.LDAPTestContext;
import org.keycloak.testsuite.pages.LoginTotpPage;
import org.keycloak.testsuite.pages.LoginUsernameOnlyPage;
import org.keycloak.testsuite.pages.PasswordPage;
import org.keycloak.testsuite.pages.SelectAuthenticatorPage;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.FlowUtil;
import org.keycloak.testsuite.util.LDAPRule;
import org.keycloak.testsuite.util.LDAPTestConfiguration;
import org.keycloak.testsuite.util.LDAPTestUtils;

@EnableVault
@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class LDAPUserMultipleCredentialTest
extends AbstractLDAPTest {
    @Page
    protected LoginUsernameOnlyPage loginUsernameOnlyPage;
    @Page
    protected PasswordPage passwordPage;
    @Page
    protected SelectAuthenticatorPage selectAuthenticatorPage;
    @Page
    protected LoginTotpPage loginTotpPage;
    @Rule
    public LDAPRule ldapRule = new LDAPRule().assumeTrue(LDAPTestConfiguration::isStartEmbeddedLdapServer);

    @Override
    protected LDAPRule getLDAPRule() {
        return this.ldapRule;
    }

    @Override
    protected void afterImportTestRealm() {
        this.getTestingClient().server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPTestUtils.removeAllLDAPUsers((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm);
            LDAPObject user1 = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm, (String)"test-user", (String)"John", (String)"Doe", (String)"test-user@something.org", (String)"some street", (String[])new String[]{"00000"});
            LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ctx.getLdapProvider(), (LDAPObject)user1, (String)"some-password");
            LDAPObject user2 = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm, (String)"test-user-with-otp", (String)"John", (String)"Doe", (String)"test-user-with-otp@something.org", (String)"some street", (String[])new String[]{"00000"});
            LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ctx.getLdapProvider(), (LDAPObject)user2, (String)"some-other-password");
            UserModel userWithOtp = session.users().getUserByUsername(appRealm, "test-user-with-otp");
            OTPCredentialModel otpCredential = OTPCredentialModel.createHOTP((String)"DJmQfC73VGFhw7D4QJ8A", (int)6, (int)0, (String)"HmacSHA1");
            session.userCredentialManager().createCredential(appRealm, userWithOtp, (CredentialModel)otpCredential);
        });
    }

    @Test
    public void testUserCredentialsAvailable() {
        LDAPUserMultipleCredentialTest.configureBrowserFlowWithAlternativeCredentials(this.testingClient);
        try {
            this.log.info((Object)"Trying login as user without OTP");
            this.loginUsernameOnlyPage.open();
            this.loginUsernameOnlyPage.login("test-user");
            this.passwordPage.assertCurrent();
            this.passwordPage.assertTryAnotherWayLinkAvailability(false);
            this.log.info((Object)"Trying login as user with OTP");
            this.loginUsernameOnlyPage.open();
            this.loginUsernameOnlyPage.login("test-user-with-otp");
            this.loginTotpPage.assertCurrent();
            this.loginTotpPage.assertTryAnotherWayLinkAvailability(true);
            this.loginTotpPage.clickTryAnotherWayLink();
            this.selectAuthenticatorPage.assertCurrent();
            Assert.assertEquals(Arrays.asList("Authenticator Application", "Password"), (Object)this.selectAuthenticatorPage.getAvailableLoginMethods());
        }
        finally {
            LDAPUserMultipleCredentialTest.resetDefaultBrowserFlow(this.testRealm());
        }
    }

    static void resetDefaultBrowserFlow(RealmResource realm) {
        RealmRepresentation realmRep = realm.toRepresentation();
        realmRep.setBrowserFlow("browser");
        realm.update(realmRep);
        realm.flows().getFlows().stream().filter(flowRep -> flowRep.getAlias().equals("browser - alternative")).findFirst().ifPresent(authenticationFlowRepresentation -> realm.flows().deleteFlow(authenticationFlowRepresentation.getId()));
    }

    static void configureBrowserFlowWithAlternativeCredentials(KeycloakTestingClient testingClient) {
        String newFlowAlias = "browser - alternative";
        testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).copyBrowserFlow("browser - alternative"));
        testingClient.server("test").run((RunOnServer & Serializable)session -> FlowUtil.inCurrentRealm(session).selectFlow("browser - alternative").inForms(forms -> forms.clear().addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.REQUIRED, "auth-username-form").addSubFlowExecution(AuthenticationExecutionModel.Requirement.REQUIRED, altSubFlow -> altSubFlow.addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.ALTERNATIVE, "auth-password-form").addAuthenticatorExecution(AuthenticationExecutionModel.Requirement.ALTERNATIVE, "auth-otp-form"))).defineAsBrowserFlow());
    }
}

