/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.ldap;

import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.testsuite.util.LDAPTestUtils;

public class LDAPTestContext {
    private final RealmModel realm;
    private final UserStorageProviderModel ldapModel;
    private final LDAPStorageProvider ldapProvider;

    public static LDAPTestContext init(KeycloakSession session) {
        RealmModel testRealm = session.realms().getRealm("test");
        ComponentModel ldapCompModel = LDAPTestUtils.getLdapProviderModel((RealmModel)testRealm);
        UserStorageProviderModel ldapModel = new UserStorageProviderModel(ldapCompModel);
        LDAPStorageProvider ldapProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ldapModel);
        return new LDAPTestContext(testRealm, ldapModel, ldapProvider);
    }

    private LDAPTestContext(RealmModel realm, UserStorageProviderModel ldapModel, LDAPStorageProvider ldapProvider) {
        this.realm = realm;
        this.ldapModel = ldapModel;
        this.ldapProvider = ldapProvider;
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public UserStorageProviderModel getLdapModel() {
        return this.ldapModel;
    }

    public LDAPStorageProvider getLdapProvider() {
        return this.ldapProvider;
    }
}

