/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.ldap;

import org.junit.Assert;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.representations.idm.SynchronizationResultRepresentation;
import org.keycloak.storage.user.SynchronizationResult;

public class LDAPTestAsserts {
    public static UserModel assertUserImported(UserProvider userProvider, RealmModel realm, String username, String expectedFirstName, String expectedLastName, String expectedEmail, String expectedPostalCode) {
        UserModel user = userProvider.getUserByUsername(realm, username);
        LDAPTestAsserts.assertLoaded(user, username, expectedFirstName, expectedLastName, expectedEmail, expectedPostalCode);
        return user;
    }

    public static void assertLoaded(UserModel user, String username, String expectedFirstName, String expectedLastName, String expectedEmail, String expectedPostalCode) {
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)expectedFirstName, (Object)user.getFirstName());
        Assert.assertEquals((Object)expectedLastName, (Object)user.getLastName());
        Assert.assertEquals((Object)expectedEmail, (Object)user.getEmail());
        Assert.assertEquals((Object)expectedPostalCode, (Object)user.getFirstAttribute("postal_code"));
    }

    public static void assertSyncEquals(SynchronizationResult syncResult, int expectedAdded, int expectedUpdated, int expectedRemoved, int expectedFailed) {
        Assert.assertEquals((long)expectedAdded, (long)syncResult.getAdded());
        Assert.assertEquals((long)expectedUpdated, (long)syncResult.getUpdated());
        Assert.assertEquals((long)expectedRemoved, (long)syncResult.getRemoved());
        Assert.assertEquals((long)expectedFailed, (long)syncResult.getFailed());
    }

    public static void assertSyncEquals(SynchronizationResultRepresentation syncResult, int expectedAdded, int expectedUpdated, int expectedRemoved, int expectedFailed) {
        Assert.assertEquals((long)expectedAdded, (long)syncResult.getAdded());
        Assert.assertEquals((long)expectedUpdated, (long)syncResult.getUpdated());
        Assert.assertEquals((long)expectedRemoved, (long)syncResult.getRemoved());
        Assert.assertEquals((long)expectedFailed, (long)syncResult.getFailed());
    }
}

