/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.ldap;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.cache.UserCache;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.SynchronizationResultRepresentation;
import org.keycloak.services.managers.UserStorageSyncManager;
import org.keycloak.storage.ldap.LDAPConfig;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.LDAPUtils;
import org.keycloak.storage.ldap.idm.model.LDAPDn;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.mappers.membership.LDAPGroupMapperMode;
import org.keycloak.storage.ldap.mappers.membership.MembershipType;
import org.keycloak.storage.ldap.mappers.membership.group.GroupLDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.membership.group.GroupLDAPStorageMapperFactory;
import org.keycloak.storage.user.SynchronizationResult;
import org.keycloak.testsuite.federation.ldap.AbstractLDAPTest;
import org.keycloak.testsuite.federation.ldap.LDAPTestAsserts;
import org.keycloak.testsuite.federation.ldap.LDAPTestContext;
import org.keycloak.testsuite.runonserver.FetchOnServer;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.LDAPRule;
import org.keycloak.testsuite.util.LDAPTestUtils;
import org.keycloak.testsuite.util.WaitUtils;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class LDAPSyncTest
extends AbstractLDAPTest {
    @ClassRule
    public static LDAPRule ldapRule = new LDAPRule();

    @Override
    protected LDAPRule getLDAPRule() {
        return ldapRule;
    }

    @Override
    protected void afterImportTestRealm() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            String descriptionAttrName = LDAPTestUtils.getGroupDescriptionLDAPAttrName((LDAPStorageProvider)ctx.getLdapProvider());
            LDAPTestUtils.addOrUpdateGroupMapper((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (LDAPGroupMapperMode)LDAPGroupMapperMode.LDAP_ONLY, (String)descriptionAttrName, (String[])new String[0]);
            LDAPTestUtils.removeAllLDAPGroups((KeycloakSession)session, (RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"groupsMapper");
            ComponentModel ldapModel = LDAPTestUtils.getLdapProviderModel((RealmModel)appRealm);
            ldapModel.put("syncRegistrations", "false");
            appRealm.updateComponent(ldapModel);
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPTestUtils.addLocalUser((KeycloakSession)session, (RealmModel)appRealm, (String)"marykeycloak", (String)"mary@test.com", (String)"password-app");
            ComponentModel ldapModel = LDAPTestUtils.getLdapProviderModel((RealmModel)appRealm);
            LDAPTestUtils.addZipCodeLDAPMapper((RealmModel)appRealm, (ComponentModel)ldapModel);
            LDAPStorageProvider ldapFedProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ldapModel);
            LDAPTestUtils.removeAllLDAPUsers((LDAPStorageProvider)ldapFedProvider, (RealmModel)appRealm);
            for (int i = 1; i <= 5; ++i) {
                LDAPObject ldapUser = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ldapFedProvider, (RealmModel)appRealm, (String)("user" + i), (String)("User" + i + "FN"), (String)("User" + i + "LN"), (String)("user" + i + "@email.org"), null, (String[])new String[]{"12" + i});
                LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ldapFedProvider, (LDAPObject)ldapUser, (String)"Password1");
            }
        });
    }

    @Test
    public void test01LDAPSync() {
        WaitUtils.pause((long)this.getLDAPRule().getSleepTime());
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            UserStorageSyncManager usersSyncManager = new UserStorageSyncManager();
            KeycloakSessionFactory sessionFactory = session.getKeycloakSessionFactory();
            SynchronizationResult syncResult = usersSyncManager.syncAllUsers(sessionFactory, "test", ctx.getLdapModel());
            LDAPTestAsserts.assertSyncEquals(syncResult, 5, 0, 0, 0);
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel testRealm = ctx.getRealm();
            UserProvider userProvider = session.userLocalStorage();
            LDAPTestAsserts.assertUserImported(userProvider, testRealm, "user1", "User1FN", "User1LN", "user1@email.org", "121");
            LDAPTestAsserts.assertUserImported(userProvider, testRealm, "user2", "User2FN", "User2LN", "user2@email.org", "122");
            LDAPTestAsserts.assertUserImported(userProvider, testRealm, "user3", "User3FN", "User3LN", "user3@email.org", "123");
            LDAPTestAsserts.assertUserImported(userProvider, testRealm, "user4", "User4FN", "User4LN", "user4@email.org", "124");
            LDAPTestAsserts.assertUserImported(userProvider, testRealm, "user5", "User5FN", "User5LN", "user5@email.org", "125");
            Assert.assertTrue((ctx.getLdapModel().getLastSync() > 0 ? 1 : 0) != 0);
            testRealm.getUserStorageProvidersStream().forEachOrdered(persistentFedModel -> {
                if ("ldap".equals(persistentFedModel.getProviderId())) {
                    Assert.assertTrue((persistentFedModel.getLastSync() > 0 ? 1 : 0) != 0);
                } else {
                    Assert.assertEquals((long)0L, (long)persistentFedModel.getLastSync());
                }
            });
        });
        WaitUtils.pause((long)this.getLDAPRule().getSleepTime());
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel testRealm = ctx.getRealm();
            UserProvider userProvider = session.userLocalStorage();
            UserStorageSyncManager usersSyncManager = new UserStorageSyncManager();
            LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)testRealm, (String)"user6", (String)"User6FN", (String)"User6LN", (String)"user6@email.org", null, (String[])new String[]{"126"});
            LDAPObject ldapUser5 = ctx.getLdapProvider().loadLDAPUserByUsername(testRealm, "user5");
            ldapUser5.setSingleAttribute("mail", "user5Updated@email.org");
            ldapUser5.setSingleAttribute("postalCode", "521");
            ctx.getLdapProvider().getLdapIdentityStore().update(ldapUser5);
            LDAPTestAsserts.assertUserImported(userProvider, testRealm, "user5", "User5FN", "User5LN", "user5@email.org", "125");
            Assert.assertNull((Object)userProvider.getUserByUsername(testRealm, "user6"));
            KeycloakSessionFactory sessionFactory = session.getKeycloakSessionFactory();
            SynchronizationResult syncResult = usersSyncManager.syncChangedUsers(sessionFactory, "test", ctx.getLdapModel());
            LDAPTestAsserts.assertSyncEquals(syncResult, 1, 1, 0, 0);
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel testRealm = session.realms().getRealm("test");
            UserProvider userProvider = session.userLocalStorage();
            LDAPTestAsserts.assertUserImported(userProvider, testRealm, "user5", "User5FN", "User5LN", "user5updated@email.org", "521");
            LDAPTestAsserts.assertUserImported(userProvider, testRealm, "user6", "User6FN", "User6LN", "user6@email.org", "126");
        });
    }

    @Test
    public void test02duplicateUsernameAndEmailSync() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            LDAPTestUtils.addLocalUser((KeycloakSession)session, (RealmModel)ctx.getRealm(), (String)"user7", (String)"user7@email.org", (String)"password");
            LDAPObject duplicatedLdapUser = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)ctx.getRealm(), (String)"user7", (String)"User7FN", (String)"User7LN", (String)"user7-something@email.org", null, (String[])new String[]{"126"});
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            SynchronizationResult result = new UserStorageSyncManager().syncAllUsers(session.getKeycloakSessionFactory(), "test", ctx.getLdapModel());
            Assert.assertEquals((long)1L, (long)result.getFailed());
            LDAPObject duplicatedLdapUser = ctx.getLdapProvider().loadLDAPUserByUsername(ctx.getRealm(), "user7");
            ctx.getLdapProvider().getLdapIdentityStore().remove(duplicatedLdapUser);
            duplicatedLdapUser = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)ctx.getRealm(), (String)"user7-something", (String)"User7FNN", (String)"User7LNL", (String)"user7@email.org", null, (String[])new String[]{"126"});
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            SynchronizationResult result = new UserStorageSyncManager().syncAllUsers(session.getKeycloakSessionFactory(), "test", ctx.getLdapModel());
            Assert.assertEquals((long)1L, (long)result.getFailed());
            Assert.assertNull((Object)session.userLocalStorage().getUserByUsername(ctx.getRealm(), "user7-something"));
            LDAPObject duplicatedLdapUser = ctx.getLdapProvider().loadLDAPUserByUsername(ctx.getRealm(), "user7-something");
            duplicatedLdapUser.setSingleAttribute("mail", "user7-changed@email.org");
            ctx.getLdapProvider().getLdapIdentityStore().update(duplicatedLdapUser);
            result = new UserStorageSyncManager().syncAllUsers(session.getKeycloakSessionFactory(), "test", ctx.getLdapModel());
            Assert.assertEquals((long)0L, (long)result.getFailed());
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel testRealm = session.realms().getRealm("test");
            LDAPTestAsserts.assertUserImported(session.userLocalStorage(), testRealm, "user7-something", "User7FNN", "User7LNL", "user7-changed@email.org", "126");
        });
    }

    @Test
    public void test03LDAPSyncWhenUsernameChanged() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            KeycloakSessionFactory sessionFactory = session.getKeycloakSessionFactory();
            LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)ctx.getRealm(), (String)"beckybecks", (String)"Becky", (String)"Becks", (String)"becky-becks@email.org", null, (String[])new String[]{"123"});
            SynchronizationResult syncResult = new UserStorageSyncManager().syncAllUsers(sessionFactory, "test", ctx.getLdapModel());
            Assert.assertEquals((long)0L, (long)syncResult.getFailed());
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel testRealm = ctx.getRealm();
            UserStorageSyncManager usersSyncManager = new UserStorageSyncManager();
            LDAPObject ldapUser = ctx.getLdapProvider().loadLDAPUserByUsername(testRealm, "beckybecks");
            String userNameLdapAttributeName = ctx.getLdapProvider().getLdapIdentityStore().getConfig().getUsernameLdapAttribute();
            ldapUser.setSingleAttribute(userNameLdapAttributeName, "beckyupdated");
            ldapUser.setSingleAttribute("mail", "becky-updated@email.org");
            ctx.getLdapProvider().getLdapIdentityStore().update(ldapUser);
            LDAPTestAsserts.assertUserImported(session.userLocalStorage(), testRealm, "beckybecks", "Becky", "Becks", "becky-becks@email.org", "123");
            KeycloakSessionFactory sessionFactory = session.getKeycloakSessionFactory();
            SynchronizationResult syncResult = usersSyncManager.syncChangedUsers(sessionFactory, "test", ctx.getLdapModel());
            Assert.assertEquals((long)0L, (long)syncResult.getFailed());
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel testRealm = session.realms().getRealm("test");
            UserProvider userProvider = session.userLocalStorage();
            LDAPTestAsserts.assertUserImported(session.users(), testRealm, "beckyupdated", "Becky", "Becks", "becky-updated@email.org", "123");
            UserModel updatedLocalUser = userProvider.getUserByUsername(testRealm, "beckyupdated");
            LDAPObject ldapUser = ctx.getLdapProvider().loadLDAPUserByUsername(testRealm, "beckyupdated");
            Assert.assertNull((Object)userProvider.getUserByUsername(testRealm, "beckybecks"));
            Assert.assertEquals(updatedLocalUser.getAttributeStream("LDAP_ID").findFirst().get(), (Object)ldapUser.getUuid());
        });
    }

    @Test
    public void test04SameUUIDAndUsernameSync() {
        String origUuidAttrName = (String)this.testingClient.server().fetch((FetchOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            session.userLocalStorage().getUsersStream(ctx.getRealm(), true).collect(Collectors.toList()).forEach(user -> session.userLocalStorage().removeUser(ctx.getRealm(), user));
            String uidAttrName = ctx.getLdapProvider().getLdapIdentityStore().getConfig().getUsernameLdapAttribute();
            String origUuidAttrNamee = ctx.getLdapModel().get("uuidLDAPAttribute");
            ctx.getLdapModel().put("uuidLDAPAttribute", uidAttrName);
            ctx.getLdapModel().put("batchSizeForSync", "10");
            ctx.getRealm().updateComponent((ComponentModel)ctx.getLdapModel());
            return origUuidAttrNamee;
        }, String.class);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            KeycloakSessionFactory sessionFactory = session.getKeycloakSessionFactory();
            SynchronizationResult syncResult = new UserStorageSyncManager().syncAllUsers(sessionFactory, "test", ctx.getLdapModel());
            Assert.assertEquals((long)0L, (long)syncResult.getFailed());
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            LDAPTestAsserts.assertUserImported(session.users(), ctx.getRealm(), "user1", "User1FN", "User1LN", "user1@email.org", "121");
            LDAPTestAsserts.assertUserImported(session.users(), ctx.getRealm(), "user2", "User2FN", "User2LN", "user2@email.org", "122");
            UserModel user1 = session.users().getUserByUsername(ctx.getRealm(), "user1");
            Assert.assertEquals((Object)"user1", (Object)user1.getFirstAttribute("LDAP_ID"));
        });
        ComponentRepresentation ldapRep = this.testRealm().components().component(ldapModelId).toRepresentation();
        ldapRep.getConfig().putSingle((Object)"uuidLDAPAttribute", (Object)origUuidAttrName);
        this.testRealm().components().component(ldapModelId).update(ldapRep);
    }

    @Test
    public void test05MissingLDAPUsernameSync() {
        String origUsernameAttrName = (String)this.testingClient.server().fetch((FetchOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            session.userLocalStorage().getUsersStream(ctx.getRealm(), true).peek(user -> System.out.println("trying to delete user: " + user.getUsername())).collect(Collectors.toList()).forEach(user -> {
                UserCache userCache = session.userCache();
                if (userCache != null) {
                    userCache.evict(ctx.getRealm(), user);
                }
                session.userLocalStorage().removeUser(ctx.getRealm(), user);
            });
            ComponentModel streetMapper = LDAPTestUtils.addUserAttributeMapper((RealmModel)ctx.getRealm(), (ComponentModel)ctx.getLdapModel(), (String)"streetMapper", (String)"street", (String)"street");
            LDAPObject streetUser = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)ctx.getRealm(), (String)"user8", (String)"User8FN", (String)"User8LN", (String)"user8@email.org", (String)"user8street", (String[])new String[]{"126"});
            String origUsernameAttrNamee = ctx.getLdapModel().get("usernameLDAPAttribute");
            ctx.getLdapModel().getConfig().putSingle((Object)"usernameLDAPAttribute", (Object)"street");
            ctx.getLdapModel().put("batchSizeForSync", "10");
            ctx.getRealm().updateComponent((ComponentModel)ctx.getLdapModel());
            return origUsernameAttrNamee;
        }, String.class);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            KeycloakSessionFactory sessionFactory = session.getKeycloakSessionFactory();
            SynchronizationResult syncResult = new UserStorageSyncManager().syncAllUsers(sessionFactory, "test", ctx.getLdapModel());
            Assert.assertEquals((long)1L, (long)syncResult.getAdded());
            Assert.assertTrue((syncResult.getFailed() > 0 ? 1 : 0) != 0);
        });
        ComponentRepresentation ldapRep = this.testRealm().components().component(ldapModelId).toRepresentation();
        if (origUsernameAttrName == null) {
            ldapRep.getConfig().remove((Object)"usernameLDAPAttribute");
        } else {
            ldapRep.getConfig().putSingle((Object)"usernameLDAPAttribute", (Object)origUsernameAttrName);
        }
        this.testRealm().components().component(ldapModelId).update(ldapRep);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            ComponentModel streetMapper = LDAPTestUtils.getSubcomponentByName((RealmModel)ctx.getRealm(), (ComponentModel)ctx.getLdapModel(), (String)"streetMapper");
            ctx.getRealm().removeComponent(streetMapper);
        });
    }

    @Test
    public void test06SyncRestAPIMissingAction() {
        ComponentRepresentation ldapRep = this.testRealm().components().component(ldapModelId).toRepresentation();
        try {
            SynchronizationResultRepresentation syncResultRep = this.adminClient.realm("test").userStorage().syncUsers(ldapModelId, null);
            Assert.fail((String)"Should throw 400");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof BadRequestException));
        }
    }

    @Test
    public void test07SyncRestAPIWrongAction() {
        ComponentRepresentation ldapRep = this.testRealm().components().component(ldapModelId).toRepresentation();
        try {
            SynchronizationResultRepresentation syncResultRep = this.adminClient.realm("test").userStorage().syncUsers(ldapModelId, "wrong action");
            Assert.fail((String)"Should throw 400");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof BadRequestException));
        }
    }

    @Test
    public void test08LDAPGroupSyncAfterGroupRename() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            String descriptionAttrName = LDAPTestUtils.getGroupDescriptionLDAPAttrName((LDAPStorageProvider)ctx.getLdapProvider());
            LDAPTestUtils.addOrUpdateGroupMapper((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (LDAPGroupMapperMode)LDAPGroupMapperMode.READ_ONLY, (String)descriptionAttrName, (String[])new String[0]);
            LDAPObject group1 = LDAPTestUtils.createLDAPGroup((KeycloakSession)session, (RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"group1", (String[])new String[]{descriptionAttrName, "group1 - description"});
            LDAPObject group2 = LDAPTestUtils.createLDAPGroup((KeycloakSession)session, (RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"group2", (String[])new String[]{descriptionAttrName, "group2 - description"});
            LDAPUtils.addMember((LDAPStorageProvider)ctx.getLdapProvider(), (MembershipType)MembershipType.DN, (String)"member", (String)"not-used", (LDAPObject)group2, (LDAPObject)group1);
            ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"groupsMapper");
            LDAPTestUtils.updateGroupMapperConfigOptions((ComponentModel)mapperModel, (String[])new String[]{"preserve.group.inheritance", "false"});
            ctx.getRealm().updateComponent(mapperModel);
            new GroupLDAPStorageMapperFactory().create(session, mapperModel).syncDataFromFederationProviderToKeycloak(appRealm);
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            GroupModel kcGroup1 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group1");
            String descriptionAttrName = LDAPTestUtils.getGroupDescriptionLDAPAttrName((LDAPStorageProvider)ctx.getLdapProvider());
            Assert.assertEquals((Object)"group1 - description", (Object)kcGroup1.getFirstAttribute(descriptionAttrName));
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            String descriptionAttrName = LDAPTestUtils.getGroupDescriptionLDAPAttrName((LDAPStorageProvider)ctx.getLdapProvider());
            LDAPTestUtils.addOrUpdateGroupMapper((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (LDAPGroupMapperMode)LDAPGroupMapperMode.LDAP_ONLY, (String)descriptionAttrName, (String[])new String[0]);
            ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"groupsMapper");
            LDAPStorageProvider ldapProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ctx.getLdapModel());
            GroupLDAPStorageMapper groupMapper = LDAPTestUtils.getGroupMapper((ComponentModel)mapperModel, (LDAPStorageProvider)ldapProvider, (RealmModel)appRealm);
            LDAPObject group1Loaded = groupMapper.loadLDAPGroupByName("group1");
            group1Loaded.setSingleAttribute((String)group1Loaded.getRdnAttributeNames().get(0), "group5");
            group1Loaded.setSingleAttribute(descriptionAttrName, "group5 - description");
            LDAPTestUtils.updateLDAPGroup((KeycloakSession)session, (RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (LDAPObject)group1Loaded);
            SynchronizationResult syncResult = new GroupLDAPStorageMapperFactory().create(session, mapperModel).syncDataFromFederationProviderToKeycloak(appRealm);
            Assert.assertThat((Object)syncResult.getFailed(), (Matcher)Matchers.is((Object)0));
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            GroupModel kcGroup5 = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group5");
            String descriptionAttrName = LDAPTestUtils.getGroupDescriptionLDAPAttrName((LDAPStorageProvider)ctx.getLdapProvider());
            Assert.assertEquals((Object)"group5 - description", (Object)kcGroup5.getFirstAttribute(descriptionAttrName));
        });
    }

    @Test
    public void test09MembershipUsingDifferentAttributes() throws Exception {
        Map previousConf = (Map)this.testingClient.server().fetch((FetchOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            session.userLocalStorage().getUsersStream(ctx.getRealm(), true).peek(user -> System.out.println("trying to delete user: " + user.getUsername())).collect(Collectors.toList()).forEach(user -> {
                UserCache userCache = session.userCache();
                if (userCache != null) {
                    userCache.evict(ctx.getRealm(), user);
                }
                session.userLocalStorage().removeUser(ctx.getRealm(), user);
            });
            HashMap<String, Object> orig = new HashMap<String, Object>();
            orig.put("rdnLDAPAttribute", ctx.getLdapModel().getConfig().getFirst((Object)"rdnLDAPAttribute"));
            orig.put("usersDn", ctx.getLdapModel().getConfig().getFirst((Object)"usersDn"));
            orig.put("usernameLDAPAttribute", ctx.getLdapModel().getConfig().getFirst((Object)"usernameLDAPAttribute"));
            LDAPTestUtils.addLdapOU((LDAPStorageProvider)ctx.getLdapProvider(), (String)"KC14696");
            ctx.getLdapModel().getConfig().putSingle((Object)"usersDn", (Object)("ou=KC14696," + (String)orig.get("usersDn")));
            ctx.getLdapModel().getConfig().putSingle((Object)"rdnLDAPAttribute", (Object)"cn");
            ctx.getLdapModel().getConfig().putSingle((Object)"usernameLDAPAttribute", (Object)(ctx.getLdapProvider().getLdapIdentityStore().getConfig().isActiveDirectory() ? "sAMAccountName" : "uid"));
            ctx.getRealm().updateComponent((ComponentModel)ctx.getLdapModel());
            ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"username");
            mapperModel.getConfig().putSingle((Object)"ldap.attribute", (Object)(ctx.getLdapProvider().getLdapIdentityStore().getConfig().isActiveDirectory() ? "sAMAccountName" : "uid"));
            ctx.getRealm().updateComponent(mapperModel);
            LDAPTestUtils.addUserAttributeMapper((RealmModel)appRealm, (ComponentModel)LDAPTestUtils.getLdapProviderModel((RealmModel)appRealm), (String)"cnMapper", (String)"firstName", (String)"cn");
            return orig;
        }, Map.class);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPObject user8 = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)ctx.getRealm(), (String)"user8", (String)"User8FN", (String)"User8LN", (String)"user8@email.org", (String)"user8street", (String[])new String[]{"126"});
            LDAPTestUtils.addLdapOU((LDAPStorageProvider)ctx.getLdapProvider(), (String)"sample-org");
            String usersDn = ctx.getLdapModel().get("usersDn");
            ctx.getLdapModel().getConfig().putSingle((Object)"usersDn", (Object)("ou=sample-org," + usersDn));
            ctx.getRealm().updateComponent((ComponentModel)ctx.getLdapModel());
            LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)ctx.getRealm(), (String)"user8bis", (String)"User8FN", (String)"User8LN", (String)"user8bis@email.org", (String)"user8street", (String[])new String[]{"126"});
            ctx.getLdapModel().getConfig().putSingle((Object)"usersDn", (Object)usersDn);
            ctx.getRealm().updateComponent((ComponentModel)ctx.getLdapModel());
            String descriptionAttrName = LDAPTestUtils.getGroupDescriptionLDAPAttrName((LDAPStorageProvider)ctx.getLdapProvider());
            LDAPObject user8Group = LDAPTestUtils.createLDAPGroup((KeycloakSession)session, (RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"user8group", (String[])new String[]{descriptionAttrName, "user8group - description"});
            LDAPUtils.addMember((LDAPStorageProvider)ctx.getLdapProvider(), (MembershipType)MembershipType.DN, (String)"member", (String)"not-used", (LDAPObject)user8Group, (LDAPObject)user8);
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            KeycloakSessionFactory sessionFactory = session.getKeycloakSessionFactory();
            SynchronizationResult syncResult = new UserStorageSyncManager().syncAllUsers(sessionFactory, "test", ctx.getLdapModel());
            Assert.assertEquals((long)2L, (long)syncResult.getAdded());
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            GroupModel user8Group = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/user8group");
            Assert.assertNotNull((Object)user8Group);
            UserModel user8 = session.users().getUserByUsername(appRealm, "user8");
            Assert.assertNotNull((Object)user8);
            UserModel user8Bis = session.users().getUserByUsername(appRealm, "user8bis");
            Assert.assertNotNull((Object)user8Bis);
            Assert.assertTrue((String)"User user8 contains the group", (boolean)user8.getGroupsStream().collect(Collectors.toSet()).contains(user8Group));
            Assert.assertFalse((String)"User user8bis does not contain the group", (boolean)user8Bis.getGroupsStream().collect(Collectors.toSet()).contains(user8Group));
            List members = session.users().getGroupMembersStream(appRealm, user8Group).map(u -> u.getUsername()).collect(Collectors.toList());
            Assert.assertEquals((String)"Group contains only user8", members, Collections.singletonList("user8"));
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            session.users().removeImportedUsers(appRealm, ldapModelId);
            LDAPTestUtils.removeLDAPUserByUsername((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm, (LDAPConfig)ctx.getLdapProvider().getLdapIdentityStore().getConfig(), (String)"user8");
            LDAPTestUtils.removeLDAPUserByUsername((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm, (LDAPConfig)ctx.getLdapProvider().getLdapIdentityStore().getConfig(), (String)"user8bis");
            LDAPObject ou = new LDAPObject();
            ou.setDn(LDAPDn.fromString((String)("ou=sample-org,ou=KC14696," + (String)previousConf.get("usersDn"))));
            ctx.getLdapProvider().getLdapIdentityStore().remove(ou);
            ou.setDn(LDAPDn.fromString((String)("ou=KC14696," + (String)previousConf.get("usersDn"))));
            ctx.getLdapProvider().getLdapIdentityStore().remove(ou);
            for (Map.Entry e : previousConf.entrySet()) {
                if (e.getValue() == null) {
                    ctx.getLdapModel().getConfig().remove(e.getKey());
                    continue;
                }
                ctx.getLdapModel().getConfig().putSingle(e.getKey(), e.getValue());
            }
            ctx.getRealm().updateComponent((ComponentModel)ctx.getLdapModel());
            ComponentModel cnMapper = LDAPTestUtils.getSubcomponentByName((RealmModel)ctx.getRealm(), (ComponentModel)ctx.getLdapModel(), (String)"cnMapper");
            ctx.getRealm().removeComponent(cnMapper);
            ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"username");
            mapperModel.getConfig().putSingle((Object)"ldap.attribute", (Object)ctx.getLdapProvider().getLdapIdentityStore().getConfig().getUsernameLdapAttribute());
            ctx.getRealm().updateComponent(mapperModel);
        });
    }
}

