/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.ldap;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.mappers.membership.LDAPGroupMapperMode;
import org.keycloak.storage.ldap.mappers.membership.group.GroupLDAPStorageMapperFactory;
import org.keycloak.testsuite.federation.ldap.AbstractLDAPTest;
import org.keycloak.testsuite.federation.ldap.LDAPTestContext;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.LDAPRule;
import org.keycloak.testsuite.util.LDAPTestUtils;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class LDAPSpecialCharsTest
extends AbstractLDAPTest {
    @ClassRule
    public static LDAPRule ldapRule = new LDAPRule().assumeTrue(ldapConfig -> {
        String vendor = (String)ldapConfig.getLDAPConfig().get("vendor");
        String usernameAttr = (String)ldapConfig.getLDAPConfig().get("usernameLDAPAttribute");
        boolean skip = vendor.equals("ad") && usernameAttr.equalsIgnoreCase("sAMAccountName");
        return !skip;
    });

    @Override
    protected LDAPRule getLDAPRule() {
        return ldapRule;
    }

    @Override
    protected void afterImportTestRealm() {
        this.testingClient.testing().ldap("test").prepareGroupsLDAPTest();
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            String descriptionAttrName = LDAPTestUtils.getGroupDescriptionLDAPAttrName((LDAPStorageProvider)ctx.getLdapProvider());
            LDAPTestUtils.createLDAPGroup((KeycloakSession)session, (RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"group-spec,ia*l_charac\u017eter)s", (String[])new String[]{descriptionAttrName, "group-special-characters"});
            LDAPTestUtils.createLDAPGroup((KeycloakSession)session, (RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"group/with/three/slashes", (String[])new String[]{descriptionAttrName, "group-with-three-slashes"});
            ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"groupsMapper");
            new GroupLDAPStorageMapperFactory().create(session, mapperModel).syncDataFromFederationProviderToKeycloak(appRealm);
            LDAPObject james2 = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm, (String)"jamees,key*clo\u017eak)ppp", (String)"James2", (String)"Brown2", (String)"james2@email.org", null, (String[])new String[]{"89102"});
            LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ctx.getLdapProvider(), (LDAPObject)james2, (String)"Password1");
        });
    }

    @Test
    public void test01_userSearch() {
        List users = this.adminClient.realm("test").users().search("j*", Integer.valueOf(0), Integer.valueOf(10));
        this.assertContainsUsername(users, "jamees,key*clo\u017eak)ppp");
        this.assertContainsUsername(users, "jameskeycloak");
        this.assertContainsUsername(users, "johnkeycloak");
    }

    private void assertContainsUsername(List<UserRepresentation> users, String username) {
        boolean found = users.stream().filter(user -> username.equals(user.getUsername())).findFirst().isPresent();
        if (!found) {
            Assert.fail((String)("Username " + username + " not found in the list"));
        }
    }

    @Test
    public void test02_loginWithSpecialCharacter() {
        this.loginPage.open();
        this.loginPage.login("john*", "Password1");
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getInputError());
        this.loginPage.login("j*", "Password1");
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getInputError());
        this.loginPage.login("jamees,key*clo\u017eak)ppp", "Password1");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
    }

    @Test
    public void test03_specialCharUserJoiningSpecialCharGroup() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"groupsMapper");
            LDAPTestUtils.updateGroupMapperConfigOptions((ComponentModel)mapperModel, (String[])new String[]{"mode", LDAPGroupMapperMode.LDAP_ONLY.toString()});
            appRealm.updateComponent(mapperModel);
            UserModel specialUser = session.users().getUserByUsername(appRealm, "jamees,key*clo\u017eak)ppp");
            Assert.assertNotNull((Object)specialUser);
            GroupModel specialGroup = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group-spec,ia*l_charac\u017eter)s");
            Assert.assertNotNull((Object)specialGroup);
            specialUser.joinGroup(specialGroup);
            GroupModel groupWithSlashes = KeycloakModelUtils.findGroupByPath((RealmModel)appRealm, (String)"/group/with/three/slashes");
            Assert.assertNotNull((Object)groupWithSlashes);
            specialUser.joinGroup(groupWithSlashes);
            Set userGroups = specialUser.getGroupsStream().collect(Collectors.toSet());
            Assert.assertEquals((long)2L, (long)userGroups.size());
            Assert.assertTrue((boolean)userGroups.contains(specialGroup));
            List groupMembers = session.users().getGroupMembersStream(appRealm, specialGroup, Integer.valueOf(0), Integer.valueOf(10)).collect(Collectors.toList());
            Assert.assertEquals((long)1L, (long)groupMembers.size());
            Assert.assertEquals((Object)"jamees,key*clo\u017eak)ppp", (Object)((UserModel)groupMembers.get(0)).getUsername());
            groupMembers = session.users().getGroupMembersStream(appRealm, groupWithSlashes, Integer.valueOf(0), Integer.valueOf(10)).collect(Collectors.toList());
            Assert.assertEquals((long)1L, (long)groupMembers.size());
            Assert.assertEquals((Object)"jamees,key*clo\u017eak)ppp", (Object)((UserModel)groupMembers.get(0)).getUsername());
            specialUser.leaveGroup(specialGroup);
            specialUser.leaveGroup(groupWithSlashes);
            Assert.assertEquals((long)0L, (long)specialUser.getGroupsStream().count());
        });
    }
}

