/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.ldap;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.broker.saml.mappers.UsernameTemplateMapper;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.dom.saml.v2.SAML2Object;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.AuthenticationExecutionInfoRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.saml.SAML2LoginResponseBuilder;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.broker.KcSamlBrokerConfiguration;
import org.keycloak.testsuite.federation.ldap.AbstractLDAPTest;
import org.keycloak.testsuite.federation.ldap.LDAPTestContext;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.updaters.Creator;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.LDAPRule;
import org.keycloak.testsuite.util.LDAPTestUtils;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.keycloak.testsuite.util.saml.ModifySamlResponseStepBuilder;

public class LDAPSamlIdPInitiatedVaryingLetterCaseTest
extends AbstractLDAPTest {
    @ClassRule
    public static LDAPRule ldapRule = new LDAPRule();
    private static final String USER_NAME_LDAP = "JdOe";
    private static final String USER_NAME_LOWERCASE = "JdOe".toLowerCase();
    private static final String USER_NAME_UPPERCASE = "JdOe".toUpperCase();
    private static final String USER_FIRST_NAME = "Joe";
    private static final String USER_LAST_NAME = "Doe";
    private static final String USER_PASSWORD = "P@ssw0rd!";
    private static final String USER_EMAIL = "jdoe@keycloak.org";
    private static final String USER_STREET = "Street";
    private static final String USER_POSTAL_CODE = "Post code";
    private static final String MY_APP = "myapp";
    private static final String EXT_SSO = "sso";
    private static final String EXT_SSO_URL = "http://localhost-sso.127.0.0.1.nip.io";
    private static final String DUMMY_URL = "http://localhost-sso-dummy.127.0.0.1.nip.io";
    private static final String FLOW_AUTO_LINK = "AutoLink";
    private String idpAlias;

    @Override
    protected LDAPRule getLDAPRule() {
        return ldapRule;
    }

    @Override
    protected void afterImportTestRealm() {
        this.getTestingClient().server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPTestUtils.removeAllLDAPUsers((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm);
            LDAPObject user = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm, (String)USER_NAME_LDAP, (String)USER_FIRST_NAME, (String)USER_LAST_NAME, (String)USER_EMAIL, (String)USER_STREET, (String[])new String[]{USER_POSTAL_CODE});
            LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ctx.getLdapProvider(), (LDAPObject)user, (String)USER_PASSWORD);
        });
        ComponentRepresentation ldap = (ComponentRepresentation)this.testRealm().components().query(null, "org.keycloak.storage.UserStorageProvider").get(0);
        ComponentRepresentation ldapMapper = new ComponentRepresentation();
        ldapMapper.setName("uid-to-user-attr-mapper");
        ldapMapper.setProviderId("user-attribute-ldap-mapper");
        ldapMapper.setProviderType("org.keycloak.storage.ldap.mappers.LDAPStorageMapper");
        ldapMapper.setParentId(ldap.getId());
        MultivaluedHashMap config = new MultivaluedHashMap();
        config.add((Object)"user.model.attribute", (Object)"ldapUid");
        config.add((Object)"ldap.attribute", (Object)"uid");
        config.add((Object)"read.only", (Object)"true");
        config.add((Object)"is.mandatory.in.ldap", (Object)"true");
        ldapMapper.setConfig(config);
        this.testRealm().components().add(ldapMapper);
    }

    @Before
    public void setupIdentityProvider() {
        AuthenticationFlowRepresentation newFlow = new AuthenticationFlowRepresentation();
        newFlow.setAlias(FLOW_AUTO_LINK);
        newFlow.setDescription("Auto-link flow");
        newFlow.setProviderId("basic-flow");
        newFlow.setBuiltIn(false);
        newFlow.setTopLevel(true);
        Creator.Flow amr = Creator.create((RealmResource)this.testRealm(), (AuthenticationFlowRepresentation)newFlow);
        AuthenticationExecutionInfoRepresentation exCreateUser = amr.addExecution("idp-create-user-if-unique");
        exCreateUser.setRequirement(AuthenticationExecutionModel.Requirement.ALTERNATIVE.name());
        this.testRealm().flows().updateExecutions(FLOW_AUTO_LINK, exCreateUser);
        AuthenticationExecutionInfoRepresentation exAutoLink = amr.addExecution("idp-auto-link");
        exAutoLink.setRequirement(AuthenticationExecutionModel.Requirement.ALTERNATIVE.name());
        this.testRealm().flows().updateExecutions(FLOW_AUTO_LINK, exAutoLink);
        this.getCleanup().addCleanup((AutoCloseable)amr);
        IdentityProviderRepresentation idp = KcSamlBrokerConfiguration.INSTANCE.setUpIdentityProvider();
        idp.getConfig().put("nameIDPolicyFormat", JBossSAMLURIConstants.NAMEID_FORMAT_UNSPECIFIED.get());
        idp.setFirstBrokerLoginFlowAlias(FLOW_AUTO_LINK);
        Creator idpCreator = Creator.create((RealmResource)this.testRealm(), (IdentityProviderRepresentation)idp);
        IdentityProviderMapperRepresentation samlNameIdMapper = new IdentityProviderMapperRepresentation();
        samlNameIdMapper.setName("username-nameid-mapper");
        this.idpAlias = idp.getAlias();
        samlNameIdMapper.setIdentityProviderAlias(this.idpAlias);
        samlNameIdMapper.setIdentityProviderMapper("saml-username-idp-mapper");
        samlNameIdMapper.setConfig((Map)ImmutableMap.builder().put((Object)"syncMode", (Object)"IMPORT").put((Object)"template", (Object)"${NAMEID | lowercase}").put((Object)"target", (Object)UsernameTemplateMapper.Target.BROKER_ID.name()).build());
        ((IdentityProviderResource)idpCreator.resource()).addMapper(samlNameIdMapper);
        this.getCleanup().addCleanup((AutoCloseable)idpCreator);
    }

    @Before
    public void setupClients() {
        this.getCleanup().addCleanup((AutoCloseable)Creator.create((RealmResource)this.testRealm(), (ClientRepresentation)ClientBuilder.create().protocol("saml").clientId(EXT_SSO_URL).baseUrl(EXT_SSO_URL).attribute("saml_idp_initiated_sso_url_name", EXT_SSO).attribute("saml_name_id_format", JBossSAMLURIConstants.NAMEID_FORMAT_PERSISTENT.get()).attribute("saml_assertion_consumer_url_post", DUMMY_URL).build()));
        this.getCleanup().addCleanup((AutoCloseable)Creator.create((RealmResource)this.testRealm(), (ClientRepresentation)ClientBuilder.create().clientId(MY_APP).protocol("openid-connect").baseUrl(OAuthClient.APP_AUTH_ROOT).build()));
    }

    @After
    public void cleanupUsers() {
        this.testRealm().userStorage().removeImportedUsers(ldapModelId);
    }

    @Test
    public void loginLDAPTest() {
        this.loginPage.open();
        this.loginPage.login(USER_NAME_LDAP, USER_PASSWORD);
        this.appPage.assertCurrent();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        this.appPage.logout();
    }

    protected URI getAuthServerBrokerSamlEndpoint(String realm, String identityProviderAlias, String samlClientId) throws IllegalArgumentException, UriBuilderException {
        return RealmsResource.realmBaseUrl((UriBuilder)UriBuilder.fromUri((URI)this.getAuthServerRoot())).path("broker/{idp-name}/endpoint/clients/{client-id}").build(new Object[]{realm, identityProviderAlias, samlClientId});
    }

    @Test
    public void idpInitiatedMatchCaseLDAPTest() throws Exception {
        this.testIdpInitiated(USER_NAME_LDAP, true);
    }

    @Test
    public void idpInitiatedUpperCaseLDAPTest() throws Exception {
        this.testIdpInitiated(USER_NAME_UPPERCASE, true);
    }

    @Test
    public void idpInitiatedLowerCaseLDAPTest() throws Exception {
        this.testIdpInitiated(USER_NAME_LOWERCASE, true);
    }

    @Test
    public void idpInitiatedVaryingLetterCasesLDAPTest() throws Exception {
        this.testIdpInitiated(USER_NAME_LDAP, true);
        this.testIdpInitiated(USER_NAME_UPPERCASE, false);
        this.testIdpInitiated(USER_NAME_LOWERCASE, false);
    }

    private void testIdpInitiated(String userName, boolean isFirstBrokerLogin) throws Exception {
        URI destination = this.getAuthServerBrokerSamlEndpoint("test", "kc-saml-idp", EXT_SSO);
        ResponseType response = this.prepareResponseForIdPInitiatedFlow(destination, userName);
        SamlClientBuilder builder = new SamlClientBuilder().submitSamlDocument(destination, (SAML2Object)response, SamlClient.Binding.POST).targetAttributeSamlResponse().build();
        if (isFirstBrokerLogin) {
            builder.followOneRedirect().followOneRedirect();
        }
        ((ModifySamlResponseStepBuilder)builder.processSamlResponse(SamlClient.Binding.POST).transformObject(so -> {
            org.junit.Assert.assertThat((Object)so, (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
            return null;
        })).build().navigateTo(this.oauth.getLoginFormUrl()).assertResponse(Matchers.bodyHC((Matcher)org.hamcrest.Matchers.containsString((String)"AUTH_RESPONSE"))).execute();
        org.junit.Assert.assertThat((Object)this.testRealm().users().search(USER_NAME_LDAP, Boolean.TRUE), (Matcher)org.hamcrest.Matchers.hasSize((int)1));
    }

    private ResponseType prepareResponseForIdPInitiatedFlow(URI destination, String userName) throws ConfigurationException, ProcessingException {
        return new SAML2LoginResponseBuilder().requestID(UUID.randomUUID().toString()).destination(destination.toString()).issuer(EXT_SSO_URL).requestIssuer(destination.toString()).assertionExpiration(1000000).subjectExpiration(1000000).sessionIndex("idp:" + UUID.randomUUID()).nameIdentifier(JBossSAMLURIConstants.NAMEID_FORMAT_PERSISTENT.get(), userName).buildModel();
    }
}

