/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.ldap;

import java.io.Serializable;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.services.managers.UserStorageSyncManager;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.mappers.membership.LDAPGroupMapperMode;
import org.keycloak.storage.ldap.mappers.membership.role.RoleLDAPStorageMapper;
import org.keycloak.storage.user.SynchronizationResult;
import org.keycloak.testsuite.federation.ldap.AbstractLDAPTest;
import org.keycloak.testsuite.federation.ldap.LDAPTestContext;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.LDAPRule;
import org.keycloak.testsuite.util.LDAPTestUtils;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class LDAPRoleMappingsTest
extends AbstractLDAPTest {
    @ClassRule
    public static LDAPRule ldapRule = new LDAPRule();

    @Override
    protected LDAPRule getLDAPRule() {
        return ldapRule;
    }

    @Override
    protected void afterImportTestRealm() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            ctx.getLdapModel().put("pagination", "false");
            appRealm.updateComponent((ComponentModel)ctx.getLdapModel());
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserStorageProviderModel ldapModel = ctx.getLdapModel();
            LDAPTestUtils.addLocalUser((KeycloakSession)session, (RealmModel)appRealm, (String)"mary", (String)"mary@test.com", (String)"password-app");
            LDAPStorageProvider ldapFedProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ldapModel);
            LDAPTestUtils.removeAllLDAPUsers((LDAPStorageProvider)ldapFedProvider, (RealmModel)appRealm);
            ClientModel finance = appRealm.addClient("finance");
            LDAPTestUtils.addOrUpdateRoleLDAPMappers((RealmModel)appRealm, (ComponentModel)ldapModel, (LDAPGroupMapperMode)LDAPGroupMapperMode.LDAP_ONLY);
            LDAPTestUtils.removeAllLDAPRoles((KeycloakSession)session, (RealmModel)appRealm, (ComponentModel)ldapModel, (String)"realmRolesMapper");
            LDAPTestUtils.removeAllLDAPRoles((KeycloakSession)session, (RealmModel)appRealm, (ComponentModel)ldapModel, (String)"financeRolesMapper");
            LDAPObject john = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ldapFedProvider, (RealmModel)appRealm, (String)"johnkeycloak", (String)"John", (String)"Doe", (String)"john@email.org", null, (String[])new String[]{"1234"});
            LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ldapFedProvider, (LDAPObject)john, (String)"Password1");
            LDAPObject mary = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ldapFedProvider, (RealmModel)appRealm, (String)"marykeycloak", (String)"Mary", (String)"Kelly", (String)"mary@email.org", null, (String[])new String[]{"5678"});
            LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ldapFedProvider, (LDAPObject)mary, (String)"Password1");
            LDAPObject rob = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ldapFedProvider, (RealmModel)appRealm, (String)"robkeycloak", (String)"Rob", (String)"Brown", (String)"rob@email.org", null, (String[])new String[]{"8910"});
            LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ldapFedProvider, (LDAPObject)rob, (String)"Password1");
            LDAPTestUtils.createLDAPRole((KeycloakSession)session, (RealmModel)appRealm, (ComponentModel)ldapModel, (String)"realmRolesMapper", (String)"realmRole1");
            LDAPTestUtils.createLDAPRole((KeycloakSession)session, (RealmModel)appRealm, (ComponentModel)ldapModel, (String)"realmRolesMapper", (String)"realmRole2");
            LDAPTestUtils.createLDAPRole((KeycloakSession)session, (RealmModel)appRealm, (ComponentModel)ldapModel, (String)"financeRolesMapper", (String)"financeRole1");
            LDAPTestUtils.syncRolesFromLDAP((RealmModel)appRealm, (LDAPStorageProvider)ldapFedProvider, (ComponentModel)ldapModel);
        });
    }

    @Test
    public void test01_ldapOnlyRoleMappings() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPTestUtils.addOrUpdateRoleLDAPMappers((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (LDAPGroupMapperMode)LDAPGroupMapperMode.LDAP_ONLY);
            UserModel john = session.users().getUserByUsername(appRealm, "johnkeycloak");
            UserModel mary = session.users().getUserByUsername(appRealm, "marykeycloak");
            RoleModel realmRole1 = appRealm.getRole("realmRole1");
            john.grantRole(realmRole1);
            RoleModel realmRole2 = appRealm.getRole("realmRole2");
            mary.grantRole(realmRole2);
            RoleModel realmRole3 = appRealm.getRole("realmRole3");
            if (realmRole3 == null) {
                realmRole3 = appRealm.addRole("realmRole3");
            }
            john.grantRole(realmRole3);
            mary.grantRole(realmRole3);
            ClientModel accountApp = appRealm.getClientByClientId("account");
            ClientModel financeApp = appRealm.getClientByClientId("finance");
            RoleModel financeRole1 = financeApp.getRole("financeRole1");
            john.grantRole(financeRole1);
            UserModel johnDb = session.userLocalStorage().getUserByUsername(appRealm, "johnkeycloak");
            Set johnDbRoles = johnDb.getRoleMappingsStream().collect(Collectors.toSet());
            Assert.assertFalse((boolean)johnDbRoles.contains(realmRole1));
            Assert.assertFalse((boolean)johnDbRoles.contains(realmRole2));
            Assert.assertFalse((boolean)johnDbRoles.contains(realmRole3));
            Assert.assertFalse((boolean)johnDbRoles.contains(financeRole1));
            Set johnRoles = john.getRoleMappingsStream().collect(Collectors.toSet());
            Assert.assertTrue((boolean)johnRoles.contains(realmRole1));
            Assert.assertFalse((boolean)johnRoles.contains(realmRole2));
            Assert.assertTrue((boolean)johnRoles.contains(realmRole3));
            Assert.assertTrue((boolean)johnRoles.contains(financeRole1));
            Set johnRealmRoles = john.getRealmRoleMappingsStream().collect(Collectors.toSet());
            Assert.assertEquals((long)2L, (long)johnRealmRoles.size());
            Assert.assertTrue((boolean)johnRealmRoles.contains(realmRole1));
            Assert.assertTrue((boolean)johnRealmRoles.contains(realmRole3));
            Set johnFinanceRoles = john.getClientRoleMappingsStream(financeApp).collect(Collectors.toSet());
            Assert.assertEquals((long)1L, (long)johnFinanceRoles.size());
            Assert.assertTrue((boolean)johnFinanceRoles.contains(financeRole1));
            john.deleteRoleMapping(realmRole3);
            john.deleteRoleMapping(realmRole1);
            john.deleteRoleMapping(financeRole1);
            johnRoles = john.getRoleMappingsStream().collect(Collectors.toSet());
            Assert.assertFalse((boolean)johnRoles.contains(realmRole1));
            Assert.assertFalse((boolean)johnRoles.contains(realmRole2));
            Assert.assertFalse((boolean)johnRoles.contains(realmRole3));
            Assert.assertFalse((boolean)johnRoles.contains(financeRole1));
            mary.deleteRoleMapping(realmRole2);
            mary.deleteRoleMapping(realmRole3);
        });
    }

    @Test
    public void test02_readOnlyRoleMappings() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPTestUtils.addOrUpdateRoleLDAPMappers((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (LDAPGroupMapperMode)LDAPGroupMapperMode.READ_ONLY);
            UserModel mary = session.users().getUserByUsername(appRealm, "marykeycloak");
            RoleModel realmRole1 = appRealm.getRole("realmRole1");
            RoleModel realmRole2 = appRealm.getRole("realmRole2");
            RoleModel realmRole3 = appRealm.getRole("realmRole3");
            if (realmRole3 == null) {
                realmRole3 = appRealm.addRole("realmRole3");
            }
            ComponentModel roleMapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"realmRolesMapper");
            LDAPStorageProvider ldapProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ctx.getLdapModel());
            RoleLDAPStorageMapper roleMapper = LDAPTestUtils.getRoleMapper((ComponentModel)roleMapperModel, (LDAPStorageProvider)ldapProvider, (RealmModel)appRealm);
            LDAPObject maryLdap = ldapProvider.loadLDAPUserByUsername(appRealm, "marykeycloak");
            roleMapper.addRoleMappingInLDAP("realmRole1", maryLdap);
            roleMapper.addRoleMappingInLDAP("realmRole2", maryLdap);
            mary.grantRole(realmRole3);
            Set maryRoles = mary.getRealmRoleMappingsStream().collect(Collectors.toSet());
            Assert.assertTrue((boolean)maryRoles.contains(realmRole1));
            Assert.assertTrue((boolean)maryRoles.contains(realmRole2));
            Assert.assertTrue((boolean)maryRoles.contains(realmRole3));
            UserModel maryDB = session.userLocalStorage().getUserByUsername(appRealm, "marykeycloak");
            Set maryDBRoles = maryDB.getRealmRoleMappingsStream().collect(Collectors.toSet());
            Assert.assertFalse((boolean)maryDBRoles.contains(realmRole1));
            Assert.assertFalse((boolean)maryDBRoles.contains(realmRole2));
            Assert.assertTrue((boolean)maryDBRoles.contains(realmRole3));
            mary.deleteRoleMapping(realmRole3);
            try {
                mary.deleteRoleMapping(realmRole1);
                Assert.fail((String)"It wasn't expected to successfully delete LDAP role mappings in READ_ONLY mode");
            }
            catch (ModelException modelException) {
                // empty catch block
            }
            LDAPRoleMappingsTest.deleteRoleMappingsInLDAP(roleMapper, maryLdap, "realmRole1");
            LDAPRoleMappingsTest.deleteRoleMappingsInLDAP(roleMapper, maryLdap, "realmRole2");
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel mary = session.users().getUserByUsername(appRealm, "marykeycloak");
            Set maryRoles = mary.getRealmRoleMappingsStream().collect(Collectors.toSet());
            Assert.assertFalse((boolean)maryRoles.contains(appRealm.getRole("realmRole1")));
            Assert.assertFalse((boolean)maryRoles.contains(appRealm.getRole("realmRole2")));
            Assert.assertFalse((boolean)maryRoles.contains(appRealm.getRole("realmRole3")));
        });
    }

    @Test
    public void test03_importRoleMappings() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPTestUtils.addOrUpdateRoleLDAPMappers((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (LDAPGroupMapperMode)LDAPGroupMapperMode.IMPORT);
            ComponentModel roleMapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"realmRolesMapper");
            LDAPStorageProvider ldapProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ctx.getLdapModel());
            RoleLDAPStorageMapper roleMapper = LDAPTestUtils.getRoleMapper((ComponentModel)roleMapperModel, (LDAPStorageProvider)ldapProvider, (RealmModel)appRealm);
            LDAPObject robLdap = ldapProvider.loadLDAPUserByUsername(appRealm, "robkeycloak");
            roleMapper.addRoleMappingInLDAP("realmRole1", robLdap);
            roleMapper.addRoleMappingInLDAP("realmRole2", robLdap);
            UserModel rob = session.users().getUserByUsername(appRealm, "robkeycloak");
            RoleModel realmRole1 = appRealm.getRole("realmRole1");
            RoleModel realmRole2 = appRealm.getRole("realmRole2");
            RoleModel realmRole3 = appRealm.getRole("realmRole3");
            if (realmRole3 == null) {
                realmRole3 = appRealm.addRole("realmRole3");
            }
            Set robRoles = rob.getRealmRoleMappingsStream().collect(Collectors.toSet());
            Assert.assertTrue((boolean)robRoles.contains(realmRole1));
            Assert.assertTrue((boolean)robRoles.contains(realmRole2));
            Assert.assertFalse((boolean)robRoles.contains(realmRole3));
            rob.grantRole(realmRole3);
            robRoles = rob.getRealmRoleMappingsStream().collect(Collectors.toSet());
            Assert.assertTrue((boolean)robRoles.contains(realmRole3));
            LDAPRoleMappingsTest.deleteRoleMappingsInLDAP(roleMapper, robLdap, "realmRole1");
            LDAPRoleMappingsTest.deleteRoleMappingsInLDAP(roleMapper, robLdap, "realmRole2");
            robRoles = rob.getRealmRoleMappingsStream().collect(Collectors.toSet());
            Assert.assertTrue((boolean)robRoles.contains(realmRole1));
            Assert.assertTrue((boolean)robRoles.contains(realmRole2));
            rob.deleteRoleMapping(realmRole1);
            rob.deleteRoleMapping(realmRole2);
            rob.deleteRoleMapping(realmRole3);
            robRoles = rob.getRealmRoleMappingsStream().collect(Collectors.toSet());
            Assert.assertFalse((boolean)robRoles.contains(realmRole1));
            Assert.assertFalse((boolean)robRoles.contains(realmRole2));
            Assert.assertFalse((boolean)robRoles.contains(realmRole3));
        });
    }

    private static void deleteRoleMappingsInLDAP(RoleLDAPStorageMapper roleMapper, LDAPObject ldapUser, String roleName) {
        LDAPObject ldapRole1 = roleMapper.loadLDAPRoleByName(roleName);
        roleMapper.deleteRoleMappingInLDAP(ldapUser, ldapRole1);
    }

    @Test
    public void test04_syncRoleMappings() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPStorageProvider ldapProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ctx.getLdapModel());
            LDAPObject john = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ldapProvider, (RealmModel)appRealm, (String)"johnrolemapper", (String)"John", (String)"RoleMapper", (String)"johnrolemapper@email.org", null, (String[])new String[]{"1234"});
            LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ldapProvider, (LDAPObject)john, (String)"Password1");
            LDAPTestUtils.addOrUpdateRoleLDAPMappers((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (LDAPGroupMapperMode)LDAPGroupMapperMode.LDAP_ONLY);
            UserStorageSyncManager usersSyncManager = new UserStorageSyncManager();
            SynchronizationResult syncResult = usersSyncManager.syncChangedUsers(session.getKeycloakSessionFactory(), appRealm.getId(), new UserStorageProviderModel((ComponentModel)ctx.getLdapModel()));
            syncResult.getAdded();
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel johnRoleMapper = session.users().getUserByUsername(appRealm, "johnrolemapper");
            Assert.assertNotNull((Object)johnRoleMapper);
            Assert.assertEquals((long)0L, (long)johnRoleMapper.getRealmRoleMappingsStream().count());
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPStorageProvider ldapProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ctx.getLdapModel());
            ComponentModel roleMapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"realmRolesMapper");
            RoleLDAPStorageMapper roleMapper = LDAPTestUtils.getRoleMapper((ComponentModel)roleMapperModel, (LDAPStorageProvider)ldapProvider, (RealmModel)appRealm);
            LDAPObject johnLdap = ldapProvider.loadLDAPUserByUsername(appRealm, "johnrolemapper");
            roleMapper.addRoleMappingInLDAP("realmRole1", johnLdap);
            roleMapper.addRoleMappingInLDAP("realmRole2", johnLdap);
            UserModel johnRoleMapper = session.users().getUserByUsername(appRealm, "johnrolemapper");
            RoleModel realmRole1 = appRealm.getRole("realmRole1");
            RoleModel realmRole2 = appRealm.getRole("realmRole2");
            Set johnRoles = johnRoleMapper.getRealmRoleMappingsStream().collect(Collectors.toSet());
            Assert.assertFalse((boolean)johnRoles.contains(realmRole1));
            Assert.assertFalse((boolean)johnRoles.contains(realmRole2));
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPStorageProvider ldapProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ctx.getLdapModel());
            ComponentModel roleMapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"realmRolesMapper");
            RoleLDAPStorageMapper roleMapper = LDAPTestUtils.getRoleMapper((ComponentModel)roleMapperModel, (LDAPStorageProvider)ldapProvider, (RealmModel)appRealm);
            LDAPObject johnLdap = ldapProvider.loadLDAPUserByUsername(appRealm, "johnrolemapper");
            if (!ctx.getLdapProvider().getLdapIdentityStore().getConfig().isActiveDirectory()) {
                roleMapper.addRoleMappingInLDAP("realmRole1", johnLdap);
                roleMapper.addRoleMappingInLDAP("realmRole2", johnLdap);
            }
            UserStorageSyncManager usersSyncManager = new UserStorageSyncManager();
            SynchronizationResult syncResult = usersSyncManager.syncChangedUsers(session.getKeycloakSessionFactory(), appRealm.getId(), new UserStorageProviderModel((ComponentModel)ctx.getLdapModel()));
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel johnRoleMapper = session.users().getUserByUsername(appRealm, "johnrolemapper");
            RoleModel realmRole1 = appRealm.getRole("realmRole1");
            RoleModel realmRole2 = appRealm.getRole("realmRole2");
            Set johnRoles = johnRoleMapper.getRealmRoleMappingsStream().collect(Collectors.toSet());
            Assert.assertTrue((boolean)johnRoles.contains(realmRole1));
            Assert.assertTrue((boolean)johnRoles.contains(realmRole2));
        });
    }

    @Test
    public void test05_getRolesFromUserMemberOfStrategyTest() throws Exception {
        ComponentRepresentation realmRoleMapper = this.findMapperRepByName("realmRolesMapper");
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPTestUtils.addUserAttributeMapper((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"streetMapper", (String)"street", (String)"street");
            ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"realmRolesMapper");
            RoleLDAPStorageMapper roleMapper = LDAPTestUtils.getRoleMapper((ComponentModel)mapperModel, (LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm);
            LDAPObject ldapRole = roleMapper.loadLDAPRoleByName("realmRole1");
            String ldapRoleDN = ldapRole.getDn().toString();
            LDAPObject carlos = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm, (String)"carloskeycloak", (String)"Carlos", (String)"Doel", (String)"carlos.doel@email.org", (String)ldapRoleDN, (String[])new String[]{"1234"});
            LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ctx.getLdapProvider(), (LDAPObject)carlos, (String)"Password1");
            LDAPTestUtils.updateGroupMapperConfigOptions((ComponentModel)mapperModel, (String[])new String[]{"user.roles.retrieve.strategy", "GET_ROLES_FROM_USER_MEMBEROF_ATTRIBUTE", "memberof.ldap.attribute", "street"});
            appRealm.updateComponent(mapperModel);
        });
        ComponentRepresentation streetMapper = this.findMapperRepByName("streetMapper");
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel carlos = session.users().getUserByUsername(appRealm, "carloskeycloak");
            Set carlosRoles = carlos.getRealmRoleMappingsStream().collect(Collectors.toSet());
            RoleModel realmRole1 = appRealm.getRole("realmRole1");
            RoleModel realmRole2 = appRealm.getRole("realmRole2");
            Assert.assertTrue((boolean)carlosRoles.contains(realmRole1));
            Assert.assertFalse((boolean)carlosRoles.contains(realmRole2));
        });
        this.testRealm().components().component(streetMapper.getId()).remove();
        this.testRealm().components().component(realmRoleMapper.getId()).remove();
        realmRoleMapper.setId(null);
        this.testRealm().components().add(realmRoleMapper);
    }

    @Test
    public void test06_newUserDefaultRolesImportModeTest() throws Exception {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel david = session.users().addUser(appRealm, "davidkeycloak");
            RoleModel defaultRole = appRealm.getRole("realmRole1");
            RoleModel realmRole2 = appRealm.getRole("realmRole2");
            Assert.assertNotNull((Object)defaultRole);
            Assert.assertNotNull((Object)realmRole2);
            appRealm.addToDefaultRoles(defaultRole);
            Set davidRoles = david.getRealmRoleMappingsStream().collect(Collectors.toSet());
            Assert.assertFalse((boolean)davidRoles.contains(defaultRole));
            Assert.assertFalse((boolean)davidRoles.contains(realmRole2));
            Assert.assertTrue((boolean)david.hasRole(defaultRole));
            Assert.assertFalse((boolean)david.hasRole(realmRole2));
        });
    }
}

