/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.ldap;

import java.io.Serializable;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.storage.ldap.mappers.membership.role.RoleLDAPStorageMapperFactory;
import org.keycloak.testsuite.federation.ldap.AbstractLDAPTest;
import org.keycloak.testsuite.federation.ldap.LDAPTestContext;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.LDAPRule;
import org.keycloak.testsuite.util.LDAPTestUtils;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class LDAPRoleMapperTest
extends AbstractLDAPTest {
    @ClassRule
    public static LDAPRule ldapRule = new LDAPRule();

    @Override
    protected LDAPRule getLDAPRule() {
        return ldapRule;
    }

    @Override
    protected void afterImportTestRealm() {
        this.testingClient.testing().ldap("test").prepareRolesLDAPTest();
    }

    @Test
    public void test01RoleMapperRealmRoles() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel john = session.users().getUserByUsername(appRealm, "johnkeycloak");
            Assert.assertNotNull((Object)john);
            Assert.assertThat(john.getRealmRoleMappingsStream().map(RoleModel::getName).collect(Collectors.toSet()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"group1", "group2"}));
            UserModel mary = session.users().getUserByUsername(appRealm, "marykeycloak");
            Assert.assertNotNull((Object)mary);
            Assert.assertThat(mary.getRealmRoleMappingsStream().map(RoleModel::getName).collect(Collectors.toSet()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"group1", "group2"}));
            UserModel rob = session.users().getUserByUsername(appRealm, "robkeycloak");
            Assert.assertNotNull((Object)rob);
            Assert.assertThat(rob.getRealmRoleMappingsStream().map(RoleModel::getName).collect(Collectors.toSet()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"group1"}));
            UserModel james = session.users().getUserByUsername(appRealm, "jameskeycloak");
            Assert.assertNotNull((Object)james);
            Assert.assertThat(james.getRealmRoleMappingsStream().collect(Collectors.toSet()), (Matcher)Matchers.empty());
            RoleModel group1 = appRealm.getRole("group1");
            Assert.assertNotNull((Object)group1);
            Assert.assertThat(session.users().getRoleMembersStream(appRealm, group1).map(UserModel::getUsername).collect(Collectors.toSet()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"johnkeycloak", "marykeycloak", "robkeycloak"}));
            RoleModel group2 = appRealm.getRole("group2");
            Assert.assertNotNull((Object)group2);
            Assert.assertThat(session.users().getRoleMembersStream(appRealm, group2).map(UserModel::getUsername).collect(Collectors.toSet()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"johnkeycloak", "marykeycloak"}));
            RoleModel group3 = appRealm.getRole("group3");
            Assert.assertNotNull((Object)group3);
            Assert.assertThat(session.users().getRoleMembersStream(appRealm, group3).collect(Collectors.toSet()), (Matcher)Matchers.empty());
        });
    }

    @Test
    public void test02RoleMapperClientRoles() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            ClientModel rolesClient = session.clients().addClient(appRealm, "role-mapper-client");
            try {
                ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"rolesMapper");
                LDAPTestUtils.updateGroupMapperConfigOptions((ComponentModel)mapperModel, (String[])new String[]{"use.realm.roles.mapping", "false", "client.id", rolesClient.getClientId()});
                appRealm.updateComponent(mapperModel);
                new RoleLDAPStorageMapperFactory().create(session, mapperModel).syncDataFromFederationProviderToKeycloak(appRealm);
                UserModel john = session.users().getUserByUsername(appRealm, "johnkeycloak");
                Assert.assertNotNull((Object)john);
                Assert.assertThat(john.getClientRoleMappingsStream(rolesClient).map(RoleModel::getName).collect(Collectors.toSet()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"group1", "group2"}));
                UserModel mary = session.users().getUserByUsername(appRealm, "marykeycloak");
                Assert.assertNotNull((Object)mary);
                Assert.assertThat(mary.getClientRoleMappingsStream(rolesClient).map(RoleModel::getName).collect(Collectors.toSet()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"group1", "group2"}));
                UserModel rob = session.users().getUserByUsername(appRealm, "robkeycloak");
                Assert.assertNotNull((Object)rob);
                Assert.assertThat(rob.getClientRoleMappingsStream(rolesClient).map(RoleModel::getName).collect(Collectors.toSet()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"group1"}));
                UserModel james = session.users().getUserByUsername(appRealm, "jameskeycloak");
                Assert.assertNotNull((Object)james);
                Assert.assertThat(james.getClientRoleMappingsStream(rolesClient).map(RoleModel::getName).collect(Collectors.toSet()), (Matcher)Matchers.empty());
                RoleModel group1 = rolesClient.getRole("group1");
                Assert.assertNotNull((Object)group1);
                Assert.assertThat(session.users().getRoleMembersStream(appRealm, group1).map(UserModel::getUsername).collect(Collectors.toSet()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"johnkeycloak", "marykeycloak", "robkeycloak"}));
                RoleModel group2 = rolesClient.getRole("group2");
                Assert.assertNotNull((Object)group2);
                Assert.assertThat(session.users().getRoleMembersStream(appRealm, group2).map(UserModel::getUsername).collect(Collectors.toSet()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"johnkeycloak", "marykeycloak"}));
                RoleModel group3 = rolesClient.getRole("group3");
                Assert.assertNotNull((Object)group3);
                Assert.assertThat(session.users().getRoleMembersStream(appRealm, group3).collect(Collectors.toSet()), (Matcher)Matchers.empty());
            }
            finally {
                appRealm.removeClient(rolesClient.getId());
            }
        });
    }
}

