/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.ldap;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.naming.AuthenticationException;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.Profile;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.cache.CachedUserModel;
import org.keycloak.models.credential.PasswordUserCredentialModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.storage.CacheableStorageProviderModel;
import org.keycloak.storage.ReadOnlyException;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.ldap.LDAPConfig;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.mappers.LDAPStorageMapper;
import org.keycloak.testsuite.AbstractAuthTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.federation.ldap.AbstractLDAPTest;
import org.keycloak.testsuite.federation.ldap.LDAPTestAsserts;
import org.keycloak.testsuite.federation.ldap.LDAPTestContext;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.runonserver.FetchOnServer;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.LDAPRule;
import org.keycloak.testsuite.util.LDAPTestUtils;
import org.keycloak.testsuite.util.OAuthClient;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class LDAPProvidersIntegrationTest
extends AbstractLDAPTest {
    @ClassRule
    public static LDAPRule ldapRule = new LDAPRule();

    @Override
    protected LDAPRule getLDAPRule() {
        return ldapRule;
    }

    @Override
    protected void afterImportTestRealm() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPTestUtils.addLocalUser((KeycloakSession)session, (RealmModel)appRealm, (String)"marykeycloak", (String)"mary@test.com", (String)"password-app");
            LDAPTestUtils.addZipCodeLDAPMapper((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel());
            LDAPTestUtils.removeAllLDAPUsers((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm);
            LDAPObject john = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm, (String)"johnkeycloak", (String)"John", (String)"Doe", (String)"john@email.org", null, (String[])new String[]{"1234"});
            LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ctx.getLdapProvider(), (LDAPObject)john, (String)"Password1");
            LDAPObject existing = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm, (String)"existing", (String)"Existing", (String)"Foo", (String)"existing@email.org", null, (String[])new String[]{"5678"});
            appRealm.getClientByClientId("test-app").setDirectAccessGrantsEnabled(true);
        });
    }

    @Test
    public void testSyncRegistrationOff() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            ctx.getLdapModel().put("syncRegistrations", "false");
            ctx.getRealm().updateComponent((ComponentModel)ctx.getLdapModel());
        });
        UserRepresentation newUser1 = AbstractAuthTest.createUserRepresentation("newUser1", "newUser1@email.cz", null, null, true);
        Response resp = this.testRealm().users().create(newUser1);
        String userId = ApiUtil.getCreatedId((Response)resp);
        resp.close();
        this.testRealm().users().get(userId).toRepresentation();
        Assert.assertTrue((boolean)StorageId.isLocalStorage((String)userId));
        Assert.assertNull((Object)newUser1.getFederationLink());
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            ctx.getLdapModel().getConfig().putSingle((Object)"syncRegistrations", (Object)"true");
            ctx.getRealm().updateComponent((ComponentModel)ctx.getLdapModel());
        });
    }

    @Test
    public void testRemoveImportedUsers() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            UserModel user = session.users().getUserByUsername(ctx.getRealm(), "johnkeycloak");
            Assert.assertEquals((Object)ctx.getLdapModel().getId(), (Object)user.getFederationLink());
        });
        this.adminClient.realm("test").userStorage().removeImportedUsers(ldapModelId);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmManager manager = new RealmManager(session);
            RealmModel appRealm = manager.getRealm("test");
            UserModel user = session.userLocalStorage().getUserByUsername(appRealm, "johnkeycloak");
            Assert.assertNull((Object)user);
        });
    }

    @Test
    public void zzTestUnlinkUsers() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            UserModel user = session.users().getUserByUsername(ctx.getRealm(), "johnkeycloak");
            Assert.assertEquals((Object)ctx.getLdapModel().getId(), (Object)user.getFederationLink());
        });
        this.adminClient.realm("test").userStorage().unlink(ldapModelId);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            UserModel user = session.users().getUserByUsername(ctx.getRealm(), "johnkeycloak");
            Assert.assertNotNull((Object)user);
            Assert.assertNull((Object)user.getFederationLink());
        });
    }

    @Test
    public void caseInSensitiveImport() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            LDAPObject jbrown2 = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)ctx.getRealm(), (String)"JBrown2", (String)"John", (String)"Brown2", (String)"jbrown2@email.org", null, (String[])new String[]{"1234"});
            LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ctx.getLdapProvider(), (LDAPObject)jbrown2, (String)"Password1");
            LDAPObject jbrown3 = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)ctx.getRealm(), (String)"jbrown3", (String)"John", (String)"Brown3", (String)"JBrown3@email.org", null, (String[])new String[]{"1234"});
            LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ctx.getLdapProvider(), (LDAPObject)jbrown3, (String)"Password1");
        });
        this.loginSuccessAndLogout("jbrown2", "Password1");
        this.loginSuccessAndLogout("JBrown2", "Password1");
        this.loginSuccessAndLogout("jbrown2@email.org", "Password1");
        this.loginSuccessAndLogout("JBrown2@email.org", "Password1");
        this.loginSuccessAndLogout("jbrown3", "Password1");
        this.loginSuccessAndLogout("JBrown3", "Password1");
        this.loginSuccessAndLogout("jbrown3@email.org", "Password1");
        this.loginSuccessAndLogout("JBrown3@email.org", "Password1");
    }

    private void loginSuccessAndLogout(String username, String password) {
        this.loginPage.open();
        this.loginPage.login(username, password);
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        this.oauth.openLogout();
    }

    @Test
    public void caseInsensitiveSearch() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            LDAPObject jbrown4 = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)ctx.getRealm(), (String)"JBrown4", (String)"John", (String)"Brown4", (String)"jbrown4@email.org", null, (String[])new String[]{"1234"});
            LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ctx.getLdapProvider(), (LDAPObject)jbrown4, (String)"Password1");
            LDAPObject jbrown5 = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)ctx.getRealm(), (String)"jbrown5", (String)"John", (String)"Brown5", (String)"JBrown5@Email.org", null, (String[])new String[]{"1234"});
            LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ctx.getLdapProvider(), (LDAPObject)jbrown5, (String)"Password1");
        });
        List users = this.testRealm().users().search("JBROwn4", Integer.valueOf(0), Integer.valueOf(10));
        UserRepresentation user4 = (UserRepresentation)users.get(0);
        Assert.assertEquals((Object)"jbrown4", (Object)user4.getUsername());
        Assert.assertEquals((Object)"jbrown4@email.org", (Object)user4.getEmail());
        users = this.testRealm().users().search("JBROwn5@eMAil.org", Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertEquals((long)1L, (long)users.size());
        UserRepresentation user5 = (UserRepresentation)users.get(0);
        Assert.assertEquals((Object)"jbrown5", (Object)user5.getUsername());
        Assert.assertEquals((Object)"jbrown5@email.org", (Object)user5.getEmail());
    }

    @Test
    @DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
    public void deleteFederationLink() throws Exception {
        this.oauth.clientId("third-party");
        this.loginPage.open();
        this.loginPage.login("johnkeycloak", "Password1");
        this.grantPage.assertCurrent();
        this.grantPage.accept();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        ComponentRepresentation ldapRep = this.testRealm().components().component(ldapModelId).toRepresentation();
        this.testRealm().components().component(ldapModelId).remove();
        this.loginPage.open();
        this.loginPage.login("johnkeycloak", "Password1");
        this.loginPage.assertCurrent();
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getInputError());
        Map cfg = this.getLDAPRule().getConfig();
        ldapModelId = this.testingClient.testing().ldap("test").createLDAPProvider(cfg, this.isImportEnabled());
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            LDAPTestUtils.addZipCodeLDAPMapper((RealmModel)ctx.getRealm(), (ComponentModel)ctx.getLdapModel());
        });
        this.oauth.clientId("test-app");
        this.loginLdap();
    }

    @Test
    public void loginClassic() {
        this.loginPage.open();
        this.loginPage.login("marykeycloak", "password-app");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
    }

    @Test
    @DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
    public void loginLdap() {
        this.loginPage.open();
        this.loginPage.login("johnkeycloak", "Password1");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        this.profilePage.open();
        Assert.assertEquals((Object)"John", (Object)this.profilePage.getFirstName());
        Assert.assertEquals((Object)"Doe", (Object)this.profilePage.getLastName());
        Assert.assertEquals((Object)"john@email.org", (Object)this.profilePage.getEmail());
    }

    @Test
    public void loginLdapWithDirectGrant() throws Exception {
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("password", "johnkeycloak", "Password1");
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        AccessToken accessToken = this.oauth.verifyToken(response.getAccessToken());
        response = this.oauth.doGrantAccessTokenRequest("password", "johnkeycloak", "");
        Assert.assertEquals((long)401L, (long)response.getStatusCode());
    }

    @Test
    public void loginLdapWithEmail() {
        this.loginPage.open();
        this.loginPage.login("john@email.org", "Password1");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
    }

    @Test
    public void loginLdapWithoutPassword() {
        this.loginPage.open();
        this.loginPage.login("john@email.org", "");
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getInputError());
    }

    @Test
    @DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
    public void ldapPasswordChangeWithAccountConsole() throws Exception {
        this.changePasswordPage.open();
        this.loginPage.login("johnkeycloak", "Password1");
        this.changePasswordPage.changePassword("Password1", "New-password1", "New-password1");
        Assert.assertEquals((Object)"Your password has been updated.", (Object)this.profilePage.getSuccess());
        this.changePasswordPage.logout();
        this.loginPage.open();
        this.loginPage.login("johnkeycloak", "Bad-password1");
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getInputError());
        this.loginPage.open();
        this.loginPage.login("johnkeycloak", "New-password1");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.changePasswordPage.open();
        this.changePasswordPage.changePassword("New-password1", "Password1", "Password1");
        Assert.assertEquals((Object)"Your password has been updated.", (Object)this.profilePage.getSuccess());
    }

    @Test
    public void ldapPasswordChangeWithAdminEndpointAndRequiredAction() throws Exception {
        String username = "adminEndpointReqAct";
        String email = username + "@email.cz";
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("firstName", "lastName", email, username, "Password1", "Password1");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.appPage.logout();
        UserResource user = ApiUtil.findUserByUsernameId((RealmResource)this.testRealm(), (String)username);
        this.assertPasswordConfiguredThroughLDAPOnly(user);
        ApiUtil.resetUserPassword((UserResource)user, (String)"Password1-updated1", (boolean)false);
        this.loginPage.open();
        this.loginSuccessAndLogout(username, "Password1-updated1");
        this.assertPasswordConfiguredThroughLDAPOnly(user);
        if (this.isImportEnabled()) {
            UserRepresentation user2 = user.toRepresentation();
            user2.setRequiredActions(Arrays.asList(UserModel.RequiredAction.UPDATE_PASSWORD.toString()));
            user.update(user2);
            this.loginPage.open();
            this.loginPage.login(username, "Password1-updated1");
            this.requiredActionChangePasswordPage.assertCurrent();
            this.requiredActionChangePasswordPage.changePassword("Password1-updated2", "Password1-updated2");
            this.appPage.assertCurrent();
            this.appPage.logout();
            this.loginSuccessAndLogout(username, "Password1-updated2");
            this.assertPasswordConfiguredThroughLDAPOnly(user);
        }
    }

    private void assertPasswordConfiguredThroughLDAPOnly(UserResource user) {
        List storedCredentials = user.credentials();
        for (CredentialRepresentation credential : storedCredentials) {
            Assert.assertFalse((boolean)"password".equals(credential.getType()));
        }
        List userStorageCredentials = user.getConfiguredUserStorageCredentialTypes();
        Assert.assertTrue((boolean)userStorageCredentials.contains("password"));
    }

    @Test
    public void registerExistingLdapUser() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("firstName", "lastName", "email@mail.cz", "existing", "Password1", "Password1");
        this.registerPage.assertCurrent();
        Assert.assertEquals((Object)"Username already exists.", (Object)this.registerPage.getInputAccountErrors().getUsernameError());
        this.registerPage.register("firstName", "lastName", "existing@email.org", "nonExisting", "Password1", "Password1");
        this.registerPage.assertCurrent();
        Assert.assertEquals((Object)"Email already exists.", (Object)this.registerPage.getInputAccountErrors().getEmailError());
    }

    @Test
    public void testLDAPUserDeletionImport() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            LDAPConfig config = ctx.getLdapProvider().getLdapIdentityStore().getConfig();
            LDAPTestUtils.removeLDAPUserByUsername((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)ctx.getRealm(), (LDAPConfig)config, (String)"maryjane");
            LDAPObject mary = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)ctx.getRealm(), (String)"maryjane", (String)"mary", (String)"yram", (String)"mj@testing.redhat.cz", null, (String[])new String[]{"12398"});
            LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ctx.getLdapProvider(), (LDAPObject)mary, (String)"Password1");
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            LDAPConfig config = ctx.getLdapProvider().getLdapIdentityStore().getConfig();
            LDAPTestUtils.removeLDAPUserByUsername((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)ctx.getRealm(), (LDAPConfig)config, (String)"maryjane");
            Assert.assertEquals((long)0L, (long)session.users().searchForUserStream(ctx.getRealm(), "mary yram").count());
        });
    }

    @Test
    public void registerUserLdapSuccess() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("firstName", "lastName", "email2@check.cz", "registerUserSuccess2", "Password1", "Password1");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        UserRepresentation user = ApiUtil.findUserByUsername((RealmResource)this.testRealm(), (String)"registerUserSuccess2");
        Assert.assertNotNull((Object)user);
        this.assertFederatedUserLink(user);
        Assert.assertEquals((Object)"registerusersuccess2", (Object)user.getUsername());
        Assert.assertEquals((Object)"firstName", (Object)user.getFirstName());
        Assert.assertEquals((Object)"lastName", (Object)user.getLastName());
        Assert.assertTrue((boolean)user.isEnabled());
    }

    protected void assertFederatedUserLink(UserRepresentation user) {
        Assert.assertTrue((boolean)StorageId.isLocalStorage((String)user.getId()));
        Assert.assertNotNull((Object)user.getFederationLink());
        Assert.assertEquals((Object)user.getFederationLink(), (Object)ldapModelId);
    }

    @Test
    public void testCaseSensitiveAttributeName() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            ComponentModel ldapModel = LDAPTestUtils.getLdapProviderModel((RealmModel)appRealm);
            LDAPStorageProvider ldapFedProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ldapModel);
            LDAPObject johnZip = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ldapFedProvider, (RealmModel)appRealm, (String)"johnzip", (String)"John", (String)"Zip", (String)"johnzip@email.org", null, (String[])new String[]{"12398"});
            ComponentModel currentZipMapper = LDAPTestUtils.getSubcomponentByName((RealmModel)appRealm, (ComponentModel)ldapModel, (String)"zipCodeMapper");
            appRealm.removeComponent(currentZipMapper);
            LDAPTestUtils.addUserAttributeMapper((RealmModel)appRealm, (ComponentModel)ldapModel, (String)"zipCodeMapper-cs", (String)"postal_code", (String)"POstalCode");
            UserModel user = session.users().getUserByUsername(appRealm, "johnzip");
            String postalCode = user.getFirstAttribute("postal_code");
            Assert.assertEquals((Object)"12398", (Object)postalCode);
        });
    }

    @Test
    public void testCommaInUsername() {
        Boolean skipTest = (Boolean)this.testingClient.server().fetch((FetchOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            boolean skip = false;
            LDAPConfig config = ctx.getLdapProvider().getLdapIdentityStore().getConfig();
            if (config.isActiveDirectory() && config.getUsernameLdapAttribute().equals("sAMAccountName")) {
                skip = true;
            }
            if (!skip) {
                LDAPObject johnComma = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)ctx.getRealm(), (String)"john,comma", (String)"John", (String)"Comma", (String)"johncomma@email.org", null, (String[])new String[]{"12387"});
                LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ctx.getLdapProvider(), (LDAPObject)johnComma, (String)"Password1");
                LDAPObject johnPlus = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)ctx.getRealm(), (String)"john+plus,comma", (String)"John", (String)"Plus", (String)"johnplus@email.org", null, (String[])new String[]{"12387"});
                LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ctx.getLdapProvider(), (LDAPObject)johnPlus, (String)"Password1");
            }
            return skip;
        }, Boolean.class);
        if (!skipTest.booleanValue()) {
            this.loginSuccessAndLogout("john,comma", "Password1");
            this.loginSuccessAndLogout("john+plus,comma", "Password1");
        }
    }

    @Test
    public void testHardcodedAttributeMapperTest() throws Exception {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            ComponentModel hardcodedMapperModel = KeycloakModelUtils.createComponentModel((String)"hardcodedAttr-description", (String)ctx.getLdapModel().getId(), (String)"hardcoded-ldap-attribute-mapper", (String)LDAPStorageMapper.class.getName(), (String[])new String[]{"ldap.attribute.name", "description", "ldap.attribute.value", "some-${RANDOM}"});
            ctx.getRealm().addComponentModel(hardcodedMapperModel);
        });
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("firstName", "lastName", "email34@check.cz", "register123", "Password1", "Password1");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel user = LDAPTestAsserts.assertUserImported(session.users(), appRealm, "register123", "firstName", "lastName", "email34@check.cz", null);
            Assert.assertNull((Object)user.getFirstAttribute("desc"));
            Assert.assertNull((Object)user.getFirstAttribute("description"));
            ComponentModel hardcodedMapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"hardcodedAttr-description");
            appRealm.removeComponent(hardcodedMapperModel);
            ComponentModel userAttrMapper = LDAPTestUtils.addUserAttributeMapper((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"desc-attribute-mapper", (String)"desc", (String)"description");
            userAttrMapper.put("always.read.value.from.ldap", "true");
            appRealm.updateComponent(userAttrMapper);
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            session.userCache().evict(appRealm, session.users().getUserByUsername(appRealm, "register123"));
            UserModel user = session.users().getUserByUsername(appRealm, "register123");
            Assert.assertNull((Object)user.getFirstAttribute("description"));
            Assert.assertNotNull((Object)user.getFirstAttribute("desc"));
            String desc = user.getFirstAttribute("desc");
            Assert.assertTrue((boolean)desc.startsWith("some-"));
            Assert.assertEquals((long)35L, (long)desc.length());
            ComponentModel userAttrMapper = LDAPTestUtils.getSubcomponentByName((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"desc-attribute-mapper");
            appRealm.removeComponent(userAttrMapper);
        });
    }

    @Test
    public void testHardcodedRoleMapper() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            RoleModel hardcodedRole = appRealm.addRole("hardcoded-role");
            UserModel john = session.users().getUserByUsername(appRealm, "johnkeycloak");
            Assert.assertFalse((boolean)john.hasRole(hardcodedRole));
            ComponentModel hardcodedMapperModel = KeycloakModelUtils.createComponentModel((String)"hardcoded role", (String)ctx.getLdapModel().getId(), (String)"hardcoded-ldap-role-mapper", (String)LDAPStorageMapper.class.getName(), (String[])new String[]{"role", "hardcoded-role"});
            appRealm.addComponentModel(hardcodedMapperModel);
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            RoleModel hardcodedRole = appRealm.getRole("hardcoded-role");
            UserModel john = session.users().getUserByUsername(appRealm, "johnkeycloak");
            Assert.assertTrue((boolean)john.hasRole(hardcodedRole));
            try {
                john.deleteRoleMapping(hardcodedRole);
                Assert.fail((String)"Didn't expected to remove role mapping");
            }
            catch (ModelException modelException) {
                // empty catch block
            }
            ComponentModel hardcodedMapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"hardcoded role");
            appRealm.removeComponent(hardcodedMapperModel);
        });
    }

    @Test
    public void testHardcodedGroupMapper() {
        String uuid = UUID.randomUUID().toString();
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            GroupModel hardcodedGroup = appRealm.createGroup(uuid, "hardcoded-group");
            UserModel john = session.users().getUserByUsername(appRealm, "johnkeycloak");
            Assert.assertFalse((boolean)john.isMemberOf(hardcodedGroup));
            ComponentModel hardcodedMapperModel = KeycloakModelUtils.createComponentModel((String)"hardcoded group", (String)ctx.getLdapModel().getId(), (String)"hardcoded-ldap-group-mapper", (String)LDAPStorageMapper.class.getName(), (String[])new String[]{"group", "hardcoded-group"});
            appRealm.addComponentModel(hardcodedMapperModel);
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            GroupModel hardcodedGroup = appRealm.getGroupById(uuid);
            UserModel john = session.users().getUserByUsername(appRealm, "johnkeycloak");
            Assert.assertTrue((boolean)john.isMemberOf(hardcodedGroup));
            try {
                john.leaveGroup(hardcodedGroup);
                Assert.fail((String)"Didn't expected to leave group");
            }
            catch (ModelException modelException) {
                // empty catch block
            }
            ComponentModel hardcodedMapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"hardcoded group");
            appRealm.removeComponent(hardcodedMapperModel);
        });
    }

    @Test
    public void testImportExistingUserFromLDAP() throws Exception {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm, (String)"marykeycloak", (String)"Mary1", (String)"Kelly1", (String)"mary1@email.org", null, (String[])new String[]{"123"});
            LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm, (String)"mary-duplicatemail", (String)"Mary2", (String)"Kelly2", (String)"mary@test.com", null, (String[])new String[]{"123"});
            LDAPObject marynoemail = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm, (String)"marynoemail", (String)"Mary1", (String)"Kelly1", null, null, (String[])new String[]{"123"});
            LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ctx.getLdapProvider(), (LDAPObject)marynoemail, (String)"Password1");
        });
        this.loginPage.open();
        this.loginPage.login("mary-duplicatemail", "password");
        Assert.assertEquals((Object)"Email already exists.", (Object)this.loginPage.getError());
        this.loginPage.login("mary1@email.org", "password");
        Assert.assertEquals((Object)"Username already exists.", (Object)this.loginPage.getError());
        this.loginSuccessAndLogout("marynoemail", "Password1");
    }

    @Test
    public void testReadonly() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            ctx.getLdapModel().getConfig().putSingle((Object)"editMode", (Object)UserStorageProvider.EditMode.READ_ONLY.toString());
            appRealm.updateComponent((ComponentModel)ctx.getLdapModel());
        });
        UserRepresentation userRep = ApiUtil.findUserByUsername((RealmResource)this.testRealm(), (String)"johnkeycloak");
        this.assertFederatedUserLink(userRep);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel user = session.users().getUserByUsername(appRealm, "johnkeycloak");
            Assert.assertNotNull((Object)user);
            try {
                user.setEmail("error@error.com");
                Assert.fail((String)"should fail");
            }
            catch (ReadOnlyException readOnlyException) {
                // empty catch block
            }
            try {
                user.setLastName("Berk");
                Assert.fail((String)"should fail");
            }
            catch (ReadOnlyException readOnlyException) {
                // empty catch block
            }
            try {
                user.setFirstName("Bilbo");
                Assert.fail((String)"should fail");
            }
            catch (ReadOnlyException readOnlyException) {
                // empty catch block
            }
            try {
                PasswordUserCredentialModel cred = UserCredentialModel.password((String)"PoopyPoop1", (boolean)true);
                session.userCredentialManager().updateCredential(appRealm, user, (CredentialInput)cred);
                Assert.fail((String)"should fail");
            }
            catch (ReadOnlyException readOnlyException) {
                // empty catch block
            }
            Assert.assertTrue((boolean)session.users().removeUser(appRealm, user));
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            ctx.getLdapModel().put("editMode", UserStorageProvider.EditMode.WRITABLE.toString());
            appRealm.updateComponent((ComponentModel)ctx.getLdapModel());
            Assert.assertEquals((Object)UserStorageProvider.EditMode.WRITABLE.toString(), (Object)appRealm.getComponent(ctx.getLdapModel().getId()).getConfig().getFirst((Object)"editMode"));
        });
    }

    @Test
    public void testRemoveFederatedUser() {
        UserRepresentation user = ApiUtil.findUserByUsername((RealmResource)this.testRealm(), (String)"registerusersuccess2");
        if (user == null) {
            this.registerUserLdapSuccess();
            user = ApiUtil.findUserByUsername((RealmResource)this.testRealm(), (String)"registerusersuccess2");
        }
        this.assertFederatedUserLink(user);
        this.testRealm().users().get(user.getId()).remove();
        user = ApiUtil.findUserByUsername((RealmResource)this.testRealm(), (String)"registerusersuccess2");
        Assert.assertNull((Object)user);
    }

    @Test
    public void testSearch() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm, (String)"username1", (String)"John1", (String)"Doel1", (String)"user1@email.org", null, (String[])new String[]{"121"});
            LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm, (String)"username2", (String)"John2", (String)"Doel2", (String)"user2@email.org", null, (String[])new String[]{"122"});
            LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm, (String)"username3", (String)"John3", (String)"Doel3", (String)"user3@email.org", null, (String[])new String[]{"123"});
            LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm, (String)"username4", (String)"John4", (String)"Doel4", (String)"user4@email.org", null, (String[])new String[]{"124"});
            Assert.assertNull((Object)session.userLocalStorage().getUserByUsername(appRealm, "username1"));
            Assert.assertNull((Object)session.userLocalStorage().getUserByUsername(appRealm, "username2"));
            Assert.assertNull((Object)session.userLocalStorage().getUserByUsername(appRealm, "username3"));
            Assert.assertNull((Object)session.userLocalStorage().getUserByUsername(appRealm, "username4"));
            session.users().searchForUserStream(appRealm, "username1").count();
            LDAPTestAsserts.assertUserImported(session.userLocalStorage(), appRealm, "username1", "John1", "Doel1", "user1@email.org", "121");
            session.users().searchForUserStream(appRealm, "user2@email.org").count();
            LDAPTestAsserts.assertUserImported(session.userLocalStorage(), appRealm, "username2", "John2", "Doel2", "user2@email.org", "122");
            session.users().searchForUserStream(appRealm, "Doel3").count();
            LDAPTestAsserts.assertUserImported(session.userLocalStorage(), appRealm, "username3", "John3", "Doel3", "user3@email.org", "123");
            session.users().searchForUserStream(appRealm, "John4 Doel4").count();
            LDAPTestAsserts.assertUserImported(session.userLocalStorage(), appRealm, "username4", "John4", "Doel4", "user4@email.org", "124");
        });
    }

    @Test
    public void testSearchWithCustomLDAPFilter() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            ctx.getLdapModel().getConfig().putSingle((Object)"customUserSearchFilter", (Object)"(|(mail=user5@email.org)(mail=user6@email.org))");
            appRealm.updateComponent((ComponentModel)ctx.getLdapModel());
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm, (String)"username5", (String)"John5", (String)"Doel5", (String)"user5@email.org", null, (String[])new String[]{"125"});
            LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm, (String)"username6", (String)"John6", (String)"Doel6", (String)"user6@email.org", null, (String[])new String[]{"126"});
            LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm, (String)"username7", (String)"John7", (String)"Doel7", (String)"user7@email.org", null, (String[])new String[]{"127"});
            session.users().searchForUserStream(appRealm, "user5@email.org").count();
            LDAPTestAsserts.assertUserImported(session.userLocalStorage(), appRealm, "username5", "John5", "Doel5", "user5@email.org", "125");
            session.users().searchForUserStream(appRealm, "John6 Doel6").count();
            LDAPTestAsserts.assertUserImported(session.userLocalStorage(), appRealm, "username6", "John6", "Doel6", "user6@email.org", "126");
            session.users().searchForUserStream(appRealm, "user7@email.org").count();
            session.users().searchForUserStream(appRealm, "John7 Doel7").count();
            Assert.assertNull((Object)session.userLocalStorage().getUserByUsername(appRealm, "username7"));
            ctx.getLdapModel().getConfig().remove((Object)"customUserSearchFilter");
            appRealm.updateComponent((ComponentModel)ctx.getLdapModel());
        });
        String user5Id = (String)this.testingClient.server().fetch((FetchOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            UserModel testedUser = session.users().getUserByUsername(ctx.getRealm(), "username5");
            return testedUser.getId();
        }, String.class);
        String user7Id = (String)this.testingClient.server().fetch((FetchOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            UserModel testedUser = session.users().getUserByUsername(ctx.getRealm(), "username7");
            return testedUser.getId();
        }, String.class);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            session.userCache().clear();
            ctx.getLdapModel().getConfig().putSingle((Object)"customUserSearchFilter", (Object)"(|(mail=user5@email.org)(mail=user6@email.org))");
            appRealm.updateComponent((ComponentModel)ctx.getLdapModel());
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            session.userCache().clear();
            UserModel testUser5 = session.users().getUserById(appRealm, user5Id);
            Assert.assertNotNull((Object)testUser5);
            UserModel testUser7 = session.users().getUserById(appRealm, user7Id);
            Assert.assertNull((Object)testUser7);
            ctx.getLdapModel().getConfig().remove((Object)"customUserSearchFilter");
            appRealm.updateComponent((ComponentModel)ctx.getLdapModel());
        });
    }

    @Test
    public void testUnsynced() throws Exception {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserStorageProviderModel model = new UserStorageProviderModel((ComponentModel)ctx.getLdapModel());
            model.getConfig().putSingle((Object)"editMode", (Object)UserStorageProvider.EditMode.UNSYNCED.toString());
            appRealm.updateComponent((ComponentModel)model);
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel user = session.users().getUserByUsername(appRealm, "johnkeycloak");
            Assert.assertNotNull((Object)user);
            Assert.assertNotNull((Object)user.getFederationLink());
            Assert.assertEquals((Object)user.getFederationLink(), (Object)ctx.getLdapModel().getId());
            PasswordUserCredentialModel cred = UserCredentialModel.password((String)"Candycand1", (boolean)true);
            session.userCredentialManager().updateCredential(appRealm, user, (CredentialInput)cred);
            CredentialModel userCredentialValueModel = session.userCredentialManager().getStoredCredentialsByTypeStream(appRealm, user, "password").findFirst().orElse(null);
            Assert.assertNotNull((Object)userCredentialValueModel);
            Assert.assertEquals((Object)"password", (Object)userCredentialValueModel.getType());
            Assert.assertTrue((boolean)session.userCredentialManager().isValid(appRealm, user, new CredentialInput[]{cred}));
            try {
                LDAPObject ldapUser = ctx.getLdapProvider().loadLDAPUserByUsername(appRealm, "johnkeycloak");
                ctx.getLdapProvider().getLdapIdentityStore().validatePassword(ldapUser, "Password1");
            }
            catch (AuthenticationException ex) {
                throw new RuntimeException(ex);
            }
        });
        UserResource userResource = ApiUtil.findUserByUsernameId((RealmResource)this.testRealm(), (String)"johnkeycloak");
        List storedCredentials = userResource.credentials().stream().map(CredentialRepresentation::getType).collect(Collectors.toList());
        Assert.assertTrue((boolean)storedCredentials.contains("password"));
        List userStorageCredentials = userResource.getConfiguredUserStorageCredentialTypes();
        Assert.assertTrue((boolean)userStorageCredentials.contains("password"));
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel user = session.users().getUserByUsername(appRealm, "johnkeycloak");
            Assert.assertTrue((boolean)session.users().removeUser(appRealm, user));
            Assert.assertNull((Object)session.userLocalStorage().getUserByUsername(appRealm, "johnkeycloak"));
            Assert.assertNotNull((Object)session.users().getUserByUsername(appRealm, "johnkeycloak"));
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            ctx.getLdapModel().getConfig().putSingle((Object)"editMode", (Object)UserStorageProvider.EditMode.WRITABLE.toString());
            appRealm.updateComponent((ComponentModel)ctx.getLdapModel());
            Assert.assertEquals((Object)UserStorageProvider.EditMode.WRITABLE.toString(), (Object)appRealm.getComponent(ctx.getLdapModel().getId()).getConfig().getFirst((Object)"editMode"));
        });
    }

    @Test
    public void testSearchByAttributes() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            String ATTRIBUTE = "postal_code";
            String ATTRIBUTE_VALUE = "80330340";
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm, (String)"username8", (String)"John8", (String)"Doel8", (String)"user8@email.org", null, (String[])new String[]{"80330340"});
            LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm, (String)"username9", (String)"John9", (String)"Doel9", (String)"user9@email.org", null, (String[])new String[]{"80330340"});
            LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)appRealm, (String)"username10", (String)"John10", (String)"Doel10", (String)"user10@email.org", null, (String[])new String[]{"1210"});
            Assert.assertNull((Object)session.userLocalStorage().getUserByUsername(appRealm, "username8"));
            Assert.assertNull((Object)session.userLocalStorage().getUserByUsername(appRealm, "username9"));
            Assert.assertNull((Object)session.userLocalStorage().getUserByUsername(appRealm, "username10"));
            List users = ctx.getLdapProvider().searchForUserByUserAttributeStream(appRealm, "postal_code", "80330340").collect(Collectors.toList());
            Assert.assertEquals((long)2L, (long)users.size());
            List attrList = ((UserModel)users.get(0)).getAttributeStream("postal_code").collect(Collectors.toList());
            Assert.assertEquals((long)1L, (long)attrList.size());
            Assert.assertEquals((Object)"80330340", attrList.get(0));
            attrList = ((UserModel)users.get(1)).getAttributeStream("postal_code").collect(Collectors.toList());
            Assert.assertEquals((long)1L, (long)attrList.size());
            Assert.assertEquals((Object)"80330340", attrList.get(0));
            LDAPTestAsserts.assertUserImported(session.userLocalStorage(), appRealm, "username8", "John8", "Doel8", "user8@email.org", "80330340");
            LDAPTestAsserts.assertUserImported(session.userLocalStorage(), appRealm, "username9", "John9", "Doel9", "user9@email.org", "80330340");
            Assert.assertNull((Object)session.userLocalStorage().getUserByUsername(appRealm, "username10"));
        });
    }

    @Test
    public void testSearchWithPartiallyCachedUser() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> session.userCache().clear());
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel user = session.users().getUserByUsername(appRealm, "johnkeycloak");
            Assert.assertNotNull((Object)user);
            user.getAttributes();
        });
        this.adminClient.realm("test").users().search(null, Integer.valueOf(0), Integer.valueOf(10), Boolean.valueOf(false));
        List users = this.adminClient.realm("test").users().search("johnkeycloak", Integer.valueOf(0), Integer.valueOf(10), Boolean.valueOf(false));
        Assert.assertTrue((boolean)users.stream().anyMatch(userRepresentation -> "johnkeycloak".equals(userRepresentation.getUsername())));
    }

    @Test
    public void testLDAPUserRefreshCache() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> session.userCache().clear());
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            LDAPStorageProvider ldapProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ctx.getLdapModel());
            LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ldapProvider, (RealmModel)appRealm, (String)"johndirect", (String)"John", (String)"Direct", (String)"johndirect@email.org", null, (String[])new String[]{"1234"});
            UserModel user = session.users().getUserByUsername(appRealm, "johndirect");
            String postalCode = user.getFirstAttribute("postal_code");
            Assert.assertEquals((Object)"1234", (Object)postalCode);
            LDAPTestUtils.removeLDAPUserByUsername((LDAPStorageProvider)ldapProvider, (RealmModel)appRealm, (LDAPConfig)ldapProvider.getLdapIdentityStore().getConfig(), (String)"johndirect");
        });
        this.setTimeOffset(300);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel appRealm = new RealmManager(session).getRealmByName("test");
            CachedUserModel user = (CachedUserModel)session.users().getUserByUsername(appRealm, "johndirect");
            String postalCode = user.getFirstAttribute("postal_code");
            String email = user.getEmail();
            Assert.assertEquals((Object)"1234", (Object)postalCode);
            Assert.assertEquals((Object)"johndirect@email.org", (Object)email);
        });
        this.setTimeOffset(1200);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel appRealm = new RealmManager(session).getRealmByName("test");
            UserModel user = session.users().getUserByUsername(appRealm, "johndirect");
            Assert.assertNull((Object)user);
        });
        this.setTimeOffset(0);
    }

    @Test
    public void testCacheUser() {
        String userId = (String)this.testingClient.server().fetch((FetchOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            ctx.getLdapModel().setCachePolicy(CacheableStorageProviderModel.CachePolicy.NO_CACHE);
            ctx.getRealm().updateComponent((ComponentModel)ctx.getLdapModel());
            LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)ctx.getRealm(), (String)"testCacheUser", (String)"John", (String)"Cached", (String)"johndirect@test.com", null, (String[])new String[]{"1234"});
            UserModel testedUser = session.users().getUserByUsername(ctx.getRealm(), "testCacheUser");
            String usserId = testedUser.getId();
            Assert.assertNotNull((Object)usserId);
            Assert.assertFalse((boolean)usserId.isEmpty());
            return usserId;
        }, String.class);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel appRealm = session.realms().getRealmByName("test");
            UserModel testedUser = session.users().getUserById(appRealm, userId);
            Assert.assertFalse((boolean)(testedUser instanceof CachedUserModel));
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            ctx.getLdapModel().setCachePolicy(CacheableStorageProviderModel.CachePolicy.MAX_LIFESPAN);
            ctx.getLdapModel().setMaxLifespan(600000L);
            ctx.getRealm().updateComponent((ComponentModel)ctx.getLdapModel());
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel appRealm = session.realms().getRealmByName("test");
            UserModel testedUser = session.users().getUserById(appRealm, userId);
            Assert.assertTrue((boolean)(testedUser instanceof CachedUserModel));
        });
        this.setTimeOffset(300);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel appRealm = session.realms().getRealmByName("test");
            UserModel testedUser = session.users().getUserById(appRealm, userId);
            Assert.assertTrue((boolean)(testedUser instanceof CachedUserModel));
        });
        this.setTimeOffset(600);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel appRealm = session.realms().getRealmByName("test");
            UserModel testedUser = session.users().getUserByUsername(appRealm, "thor");
            Assert.assertFalse((boolean)(testedUser instanceof CachedUserModel));
        });
        this.setTimeOffset(0);
    }

    @Test
    public void testEmailVerifiedFromImport() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            ctx.getLdapModel().put("trustEmail", "true");
            ctx.getRealm().updateComponent((ComponentModel)ctx.getLdapModel());
            LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)ctx.getRealm(), (String)"testUserVerified", (String)"John", (String)"Email", (String)"john@test.com", null, (String[])new String[]{"1234"});
        });
        this.loginPage.open();
        this.loginPage.login("testuserVerified", "password");
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel appRealm = session.realms().getRealmByName("test");
            Optional userVerified = session.users().searchForUserStream(appRealm, "john@test.com").findFirst();
            Assert.assertTrue((boolean)((UserModel)userVerified.get()).isEmailVerified());
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            ctx.getLdapModel().put("trustEmail", "false");
            ctx.getRealm().updateComponent((ComponentModel)ctx.getLdapModel());
            LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)ctx.getRealm(), (String)"testUserNotVerified", (String)"John", (String)"Email", (String)"john2@test.com", null, (String[])new String[]{"1234"});
        });
        this.loginPage.open();
        this.loginPage.login("testuserNotVerified", "password");
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel appRealm = session.realms().getRealmByName("test");
            Optional userNotVerified = session.users().searchForUserStream(appRealm, "john2@test.com").findFirst();
            Assert.assertFalse((boolean)((UserModel)userNotVerified.get()).isEmailVerified());
        });
    }

    @Test
    public void testUserAttributeLDAPStorageMapperHandlingUsernameLowercasing() {
        this.setEditingUsernameAllowed(false);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel johnkeycloak = session.users().getUserByUsername(appRealm, "johnkeycloak");
            johnkeycloak.setSingleAttribute("username", "JohnKeycloak");
        });
        this.setEditingUsernameAllowed(true);
    }

    private void setEditingUsernameAllowed(boolean allowed) {
        RealmRepresentation realmRepresentation = this.testRealm().toRepresentation();
        realmRepresentation.setEditUsernameAllowed(Boolean.valueOf(allowed));
        this.testRealm().update(realmRepresentation);
    }

    @Test
    public void updateLDAPUsernameTest() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            LDAPObject becky = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)ctx.getRealm(), (String)"beckybecks", (String)"Becky", (String)"Becks", (String)"becky-becks@email.org", null, (String[])new String[]{"123"});
            LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ctx.getLdapProvider(), (LDAPObject)becky, (String)"Password1");
        });
        this.loginSuccessAndLogout("beckybecks", "Password1");
        String origKeycloakUserId = this.testingClient.server().fetchString((FetchOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel testRealm = ctx.getRealm();
            UserModel importedUser = session.userLocalStorage().getUserByUsername(testRealm, "beckybecks");
            LDAPObject becky = ctx.getLdapProvider().loadLDAPUserByUsername(testRealm, importedUser.getUsername());
            String userNameLdapAttributeName = ctx.getLdapProvider().getLdapIdentityStore().getConfig().getUsernameLdapAttribute();
            becky.setSingleAttribute(userNameLdapAttributeName, "beckyupdated");
            becky.setSingleAttribute("mail", "becky-updated@email.org");
            ctx.getLdapProvider().getLdapIdentityStore().update(becky);
            LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ctx.getLdapProvider(), (LDAPObject)becky, (String)"MyChangedPassword11");
            return importedUser.getId();
        });
        this.loginSuccessAndLogout("beckyupdated", "MyChangedPassword11");
        this.loginPage.open();
        this.loginPage.login("beckybecks", "Password1");
        Assert.assertEquals((Object)"Invalid username or password.", (Object)this.loginPage.getInputError());
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            UserModel user = session.users().getUserByUsername(ctx.getRealm(), "beckybecks");
            Assert.assertNull((Object)user);
            user = session.users().getUserByUsername(ctx.getRealm(), "beckyupdated");
            Assert.assertNotNull((Object)user);
            String newKeycloakUserId = user.getId();
            Assert.assertEquals((Object)origKeycloakUserId.replace("\"", ""), (Object)newKeycloakUserId);
        });
    }
}

