/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.ldap;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.mappers.LDAPStorageMapper;
import org.keycloak.testsuite.federation.ldap.AbstractLDAPTest;
import org.keycloak.testsuite.federation.ldap.LDAPTestContext;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.LDAPRule;
import org.keycloak.testsuite.util.LDAPTestUtils;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class LDAPMSADFullNameTest
extends AbstractLDAPTest {
    @ClassRule
    public static LDAPRule ldapRule = new LDAPRule().assumeTrue(ldapConfig -> {
        String vendor = (String)ldapConfig.getLDAPConfig().get("vendor");
        if (!vendor.equals("ad")) {
            return false;
        }
        String usernameAttr = (String)ldapConfig.getLDAPConfig().get("usernameLDAPAttribute");
        return usernameAttr.equalsIgnoreCase("sAMAccountName");
    });

    @Override
    protected LDAPRule getLDAPRule() {
        return ldapRule;
    }

    @Override
    protected void afterImportTestRealm() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserStorageProviderModel ldapModel = ctx.getLdapModel();
            LDAPTestUtils.addLocalUser((KeycloakSession)session, (RealmModel)appRealm, (String)"marykeycloak", (String)"mary@test.com", (String)"password-app");
            LDAPTestUtils.addZipCodeLDAPMapper((RealmModel)appRealm, (ComponentModel)ldapModel);
            LDAPStorageProvider ldapFedProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ldapModel);
            LDAPTestUtils.removeAllLDAPUsers((LDAPStorageProvider)ldapFedProvider, (RealmModel)appRealm);
            ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)appRealm, (ComponentModel)ldapModel, (String)"username-cn");
            Assert.assertNotNull((Object)mapperModel);
            appRealm.removeComponent(mapperModel);
            mapperModel = KeycloakModelUtils.createComponentModel((String)"fullNameWritable", (String)ldapModel.getId(), (String)"full-name-ldap-mapper", (String)LDAPStorageMapper.class.getName(), (String[])new String[]{"ldap.full.name.attribute", "cn", "read.only", "false", "write.only", "true"});
            appRealm.addComponentModel(mapperModel);
            appRealm.getClientByClientId("test-app").setDirectAccessGrantsEnabled(true);
        });
    }

    @Test
    public void test01_addUserWithoutFullName() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel john = session.users().addUser(appRealm, "johnkeycloak");
            john.setEmail("johnkeycloak@email.cz");
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel john = session.users().getUserByUsername(appRealm, "johnkeycloak");
            Assert.assertNotNull((Object)john.getFederationLink());
            LDAPMSADFullNameTest.assertDnStartsWith(session, ctx, john, "cn=johnkeycloak");
            session.users().removeUser(appRealm, john);
        });
    }

    @Test
    public void test02_registerUserWithFullName() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("Johny", "Anthony", "johnyanth@check.cz", "johnkeycloak", "Password1", "Password1");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel john = session.users().getUserByUsername(appRealm, "johnkeycloak");
            LDAPMSADFullNameTest.assertUser(session, ctx, john, "johnkeycloak", "Johny", "Anthony", true, "cn=Johny Anthony");
            session.users().removeUser(appRealm, john);
        });
    }

    @Test
    public void test03_addUserWithFirstNameOnly() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel john = session.users().addUser(appRealm, "johnkeycloak");
            john.setEmail("johnkeycloak@email.cz");
            john.setFirstName("Johnyyy");
            john.setEnabled(true);
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel john = session.users().getUserByUsername(appRealm, "johnkeycloak");
            LDAPMSADFullNameTest.assertUser(session, ctx, john, "johnkeycloak", "Johnyyy", "", true, "cn=Johnyyy");
            session.users().removeUser(appRealm, john);
        });
    }

    @Test
    public void test04_addUserWithLastNameOnly() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel john = session.users().addUser(appRealm, "johnkeycloak");
            john.setEmail("johnkeycloak@email.cz");
            john.setLastName("Anthonyy");
            john.setEnabled(true);
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel john = session.users().getUserByUsername(appRealm, "johnkeycloak");
            LDAPMSADFullNameTest.assertUser(session, ctx, john, "johnkeycloak", "", "Anthonyy", true, "cn=Anthonyy");
            session.users().removeUser(appRealm, john);
        });
    }

    @Test
    public void test05_registerUserWithFullNameSpecialChars() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("Jo\u017e,o", "Ba\u0159\u00ed\u010d", "johnyanth@check.cz", "johnkeycloak", "Password1", "Password1");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel john = session.users().getUserByUsername(appRealm, "johnkeycloak");
            LDAPMSADFullNameTest.assertUser(session, ctx, john, "johnkeycloak", "Jo\u017e,o", "Ba\u0159\u00ed\u010d", true, "cn=Jo\u017e\\,o Ba\u0159\u00ed\u010d");
            session.users().removeUser(appRealm, john);
        });
    }

    @Test
    public void test06_conflicts() {
        this.driver.manage().timeouts().pageLoadTimeout(100L, TimeUnit.SECONDS);
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel john = session.users().addUser(appRealm, "existingkc");
            john.setFirstName("John");
            john.setLastName("Existing");
            john.setEnabled(true);
            UserModel john2 = session.users().addUser(appRealm, "existingkc1");
            john2.setEnabled(true);
        });
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("John", "Existing", "johnyanth@check.cz", "existingkc", "Password1", "Password1");
        Assert.assertEquals((Object)"Username already exists.", (Object)this.registerPage.getInputAccountErrors().getUsernameError());
        this.registerPage.register("John", "Existing", "johnyanth@check.cz", "existingkc2", "Password1", "Password1");
        this.appPage.logout();
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.assertCurrent();
        this.registerPage.register("John", "Existing", "johnyanth2@check.cz", "existingkc3", "Password1", "Password1");
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel existingKc = session.users().getUserByUsername(appRealm, "existingkc");
            LDAPMSADFullNameTest.assertUser(session, ctx, existingKc, "existingkc", "John", "Existing", true, "cn=John Existing");
            UserModel existingKc1 = session.users().getUserByUsername(appRealm, "existingkc1");
            LDAPMSADFullNameTest.assertUser(session, ctx, existingKc1, "existingkc1", "", "", true, "cn=existingkc1");
            UserModel existingKc2 = session.users().getUserByUsername(appRealm, "existingkc2");
            LDAPMSADFullNameTest.assertUser(session, ctx, existingKc2, "existingkc2", "John", "Existing", true, "cn=John Existing0");
            UserModel existingKc3 = session.users().getUserByUsername(appRealm, "existingkc3");
            LDAPMSADFullNameTest.assertUser(session, ctx, existingKc3, "existingkc3", "John", "Existing", true, "cn=John Existing1");
            session.users().removeUser(appRealm, existingKc);
            session.users().removeUser(appRealm, existingKc1);
            session.users().removeUser(appRealm, existingKc2);
            session.users().removeUser(appRealm, existingKc3);
        });
    }

    private static void assertUser(KeycloakSession session, LDAPTestContext ctx, UserModel user, String expectedUsername, String expectedFirstName, String expectedLastName, boolean expectedEnabled, String expectedDn) {
        Assert.assertNotNull((Object)user);
        Assert.assertNotNull((Object)user.getFederationLink());
        Assert.assertEquals((Object)user.getFederationLink(), (Object)ctx.getLdapModel().getId());
        Assert.assertEquals((Object)expectedUsername, (Object)user.getUsername());
        Assert.assertEquals((Object)expectedFirstName, (Object)user.getFirstName());
        Assert.assertEquals((Object)expectedLastName, (Object)user.getLastName());
        Assert.assertEquals((Object)expectedEnabled, (Object)user.isEnabled());
        LDAPMSADFullNameTest.assertDnStartsWith(session, ctx, user, expectedDn);
    }

    private static void assertDnStartsWith(KeycloakSession session, LDAPTestContext ctx, UserModel user, String expectedRDn) {
        String usersDn = ctx.getLdapProvider().getLdapIdentityStore().getConfig().getUsersDn();
        String userDN = user.getFirstAttribute("LDAP_ENTRY_DN");
        Assert.assertTrue((boolean)userDN.equalsIgnoreCase(expectedRDn + "," + usersDn));
    }
}

