/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.ldap;

import java.io.Serializable;
import java.util.List;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.common.Profile;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.federation.ldap.AbstractLDAPTest;
import org.keycloak.testsuite.federation.ldap.LDAPTestContext;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.LDAPRule;
import org.keycloak.testsuite.util.LDAPTestUtils;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class LDAPLegacyImportTest
extends AbstractLDAPTest {
    @ClassRule
    public static LDAPRule ldapRule = new LDAPRule().assumeTrue(ldapConfig -> ldapConfig.isStartEmbeddedLdapServer());

    @Override
    protected LDAPRule getLDAPRule() {
        return ldapRule;
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation testRealm = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/ldap/fed-provider-export.json"), RealmRepresentation.class);
        testRealms.add(testRealm);
        this.configureTestRealm(testRealm);
    }

    @Override
    protected void createLDAPProvider() {
    }

    @Override
    protected void afterImportTestRealm() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            ComponentModel ldapModel = (ComponentModel)appRealm.getComponentsStream(appRealm.getId(), UserStorageProvider.class.getName()).findFirst().get();
            LDAPTestUtils.addLocalUser((KeycloakSession)session, (RealmModel)appRealm, (String)"marykeycloak", (String)"mary@test.com", (String)"password-app");
            LDAPStorageProvider ldapFedProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ldapModel);
            LDAPTestUtils.removeAllLDAPUsers((LDAPStorageProvider)ldapFedProvider, (RealmModel)appRealm);
            LDAPObject john = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ldapFedProvider, (RealmModel)appRealm, (String)"johnkeycloak", (String)"John", (String)"Doe", (String)"john@email.org", null, (String[])new String[]{"1234"});
            LDAPTestUtils.updateLDAPPassword((LDAPStorageProvider)ldapFedProvider, (LDAPObject)john, (String)"Password1");
            LDAPObject existing = LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ldapFedProvider, (RealmModel)appRealm, (String)"existing", (String)"Existing", (String)"Foo", (String)"existing@email.org", null, (String[])new String[]{"5678"});
            appRealm.getClientByClientId("test-app").setDirectAccessGrantsEnabled(true);
        });
    }

    @Test
    public void loginClassic() {
        this.loginPage.open();
        this.loginPage.login("marykeycloak", "password-app");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
    }

    @Test
    @DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
    public void loginLdap() {
        this.loginPage.open();
        this.loginPage.login("johnkeycloak", "Password1");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        this.profilePage.open();
        Assert.assertEquals((Object)"John", (Object)this.profilePage.getFirstName());
        Assert.assertEquals((Object)"Doe", (Object)this.profilePage.getLastName());
        Assert.assertEquals((Object)"john@email.org", (Object)this.profilePage.getEmail());
    }
}

