/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.ldap;

import java.io.Serializable;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runners.MethodSorters;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.mappers.LDAPStorageMapper;
import org.keycloak.testsuite.federation.ldap.AbstractLDAPTest;
import org.keycloak.testsuite.federation.ldap.LDAPTestContext;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.runonserver.RunOnServerException;
import org.keycloak.testsuite.util.LDAPRule;
import org.keycloak.testsuite.util.LDAPTestUtils;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class LDAPHardcodedAttributeTest
extends AbstractLDAPTest {
    @ClassRule
    public static LDAPRule ldapRule = new LDAPRule();
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();

    @Override
    protected LDAPRule getLDAPRule() {
        return ldapRule;
    }

    @Override
    protected void afterImportTestRealm() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            ComponentModel localeMapperModel = KeycloakModelUtils.createComponentModel((String)"localeMapper", (String)ctx.getLdapModel().getId(), (String)"hardcoded-attribute-mapper", (String)LDAPStorageMapper.class.getName(), (String[])new String[]{"user.model.attribute", "locale", "attribute.value", "en"});
            ComponentModel emailVerifiedMapperModel = KeycloakModelUtils.createComponentModel((String)"emailVerifiedMapper", (String)ctx.getLdapModel().getId(), (String)"hardcoded-attribute-mapper", (String)LDAPStorageMapper.class.getName(), (String[])new String[]{"user.model.attribute", "emailVerified", "attribute.value", "true"});
            appRealm.addComponentModel(localeMapperModel);
            appRealm.addComponentModel(emailVerifiedMapperModel);
            LDAPStorageProvider ldapFedProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ctx.getLdapModel());
            LDAPTestUtils.removeAllLDAPUsers((LDAPStorageProvider)ldapFedProvider, (RealmModel)appRealm);
            LDAPTestUtils.addLDAPUser((LDAPStorageProvider)ldapFedProvider, (RealmModel)appRealm, (String)"johnkeycloak", (String)"John", (String)"Doe", (String)"john@email.org", null, (String[])new String[]{"1234"});
        });
    }

    @Test
    public void testHarcodedMapper() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            UserModel user = session.users().getUserByUsername(appRealm, "johnkeycloak");
            Assert.assertNotNull((Object)user);
            Assert.assertTrue((boolean)user.isEmailVerified());
            Assert.assertEquals((Object)"en", (Object)user.getFirstAttribute("locale"));
        });
    }

    @Test
    public void testConfigInvalid() {
        this.exceptionRule.expect(RunOnServerException.class);
        this.exceptionRule.expectMessage("Attribute Name cannot be set to username or email");
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            ComponentModel usernameMapperModel = KeycloakModelUtils.createComponentModel((String)"usernameMapper", (String)ctx.getLdapModel().getId(), (String)"hardcoded-attribute-mapper", (String)LDAPStorageMapper.class.getName(), (String[])new String[]{"user.model.attribute", "username", "attribute.value", "username"});
            appRealm.addComponentModel(usernameMapperModel);
        });
    }
}

