/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.ldap;

import java.io.Serializable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.mappers.membership.LDAPGroupMapperMode;
import org.keycloak.storage.ldap.mappers.membership.group.GroupLDAPStorageMapperFactory;
import org.keycloak.storage.user.SynchronizationResult;
import org.keycloak.testsuite.federation.ldap.AbstractLDAPTest;
import org.keycloak.testsuite.federation.ldap.LDAPTestAsserts;
import org.keycloak.testsuite.federation.ldap.LDAPTestContext;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.LDAPRule;
import org.keycloak.testsuite.util.LDAPTestUtils;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class LDAPGroupMapper2WaySyncTest
extends AbstractLDAPTest {
    @ClassRule
    public static LDAPRule ldapRule = new LDAPRule();

    @Override
    protected LDAPRule getLDAPRule() {
        return ldapRule;
    }

    @Override
    protected void afterImportTestRealm() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            ctx.getLdapModel().put("batchSizeForSync", "4");
            appRealm.updateComponent((ComponentModel)ctx.getLdapModel());
        });
    }

    @Before
    public void before() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel appRealm = ctx.getRealm();
            String descriptionAttrName = LDAPTestUtils.getGroupDescriptionLDAPAttrName((LDAPStorageProvider)ctx.getLdapProvider());
            LDAPTestUtils.addOrUpdateGroupMapper((RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (LDAPGroupMapperMode)LDAPGroupMapperMode.LDAP_ONLY, (String)descriptionAttrName, (String[])new String[0]);
            LDAPTestUtils.removeAllLDAPGroups((KeycloakSession)session, (RealmModel)appRealm, (ComponentModel)ctx.getLdapModel(), (String)"groupsMapper");
            LDAPGroupMapper2WaySyncTest.removeAllModelGroups(appRealm);
            GroupModel group1 = appRealm.createGroup("group1");
            group1.setSingleAttribute(descriptionAttrName, "group1 - description1");
            GroupModel group11 = appRealm.createGroup("group11", group1);
            GroupModel group12 = appRealm.createGroup("group12", group1);
            group12.setSingleAttribute(descriptionAttrName, "group12 - description12");
            GroupModel group2 = appRealm.createGroup("group2");
        });
    }

    @Test
    public void test01_syncNoPreserveGroupInheritance() throws Exception {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel realm = ctx.getRealm();
            ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)realm, (ComponentModel)ctx.getLdapModel(), (String)"groupsMapper");
            LDAPStorageProvider ldapProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ctx.getLdapModel());
            LDAPTestUtils.updateGroupMapperConfigOptions((ComponentModel)mapperModel, (String[])new String[]{"preserve.group.inheritance", "false"});
            realm.updateComponent(mapperModel);
            SynchronizationResult syncResult = new GroupLDAPStorageMapperFactory().create(session, mapperModel).syncDataFromKeycloakToFederationProvider(realm);
            LDAPTestAsserts.assertSyncEquals(syncResult, 4, 0, 0, 0);
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel realm = ctx.getRealm();
            LDAPGroupMapper2WaySyncTest.removeAllModelGroups(realm);
            Assert.assertNull((Object)KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group1"));
            Assert.assertNull((Object)KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group11"));
            Assert.assertNull((Object)KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group2"));
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel realm = ctx.getRealm();
            ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)realm, (ComponentModel)ctx.getLdapModel(), (String)"groupsMapper");
            SynchronizationResult syncResult = new GroupLDAPStorageMapperFactory().create(session, mapperModel).syncDataFromFederationProviderToKeycloak(realm);
            LDAPTestAsserts.assertSyncEquals(syncResult, 4, 0, 0, 0);
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel realm = ctx.getRealm();
            String descriptionAttrName = LDAPTestUtils.getGroupDescriptionLDAPAttrName((LDAPStorageProvider)ctx.getLdapProvider());
            ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)realm, (ComponentModel)ctx.getLdapModel(), (String)"groupsMapper");
            GroupModel kcGroup1 = KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group1");
            GroupModel kcGroup11 = KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group11");
            GroupModel kcGroup12 = KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group12");
            GroupModel kcGroup2 = KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group2");
            Assert.assertEquals((long)0L, (long)kcGroup1.getSubGroupsStream().count());
            Assert.assertEquals((Object)"group1 - description1", (Object)kcGroup1.getFirstAttribute(descriptionAttrName));
            Assert.assertNull((Object)kcGroup11.getFirstAttribute(descriptionAttrName));
            Assert.assertEquals((Object)"group12 - description12", (Object)kcGroup12.getFirstAttribute(descriptionAttrName));
            Assert.assertNull((Object)kcGroup2.getFirstAttribute(descriptionAttrName));
            LDAPGroupMapper2WaySyncTest.testDropNonExisting(session, ctx, mapperModel);
        });
    }

    @Test
    public void test02_syncWithGroupInheritance() throws Exception {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel realm = ctx.getRealm();
            ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)realm, (ComponentModel)ctx.getLdapModel(), (String)"groupsMapper");
            LDAPStorageProvider ldapProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ctx.getLdapModel());
            LDAPTestUtils.updateGroupMapperConfigOptions((ComponentModel)mapperModel, (String[])new String[]{"preserve.group.inheritance", "true"});
            LDAPTestUtils.updateGroupMapperConfigOptions((ComponentModel)mapperModel, (String[])new String[]{"drop.non.existing.groups.during.sync", "false"});
            realm.updateComponent(mapperModel);
            SynchronizationResult syncResult = new GroupLDAPStorageMapperFactory().create(session, mapperModel).syncDataFromKeycloakToFederationProvider(realm);
            LDAPTestAsserts.assertSyncEquals(syncResult, 4, 0, 0, 0);
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel realm = ctx.getRealm();
            LDAPGroupMapper2WaySyncTest.removeAllModelGroups(realm);
            Assert.assertNull((Object)KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group1"));
            Assert.assertNull((Object)KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group11"));
            Assert.assertNull((Object)KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group2"));
        });
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            LDAPTestContext ctx = LDAPTestContext.init(session);
            RealmModel realm = ctx.getRealm();
            ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName((RealmModel)realm, (ComponentModel)ctx.getLdapModel(), (String)"groupsMapper");
            LDAPStorageProvider ldapProvider = LDAPTestUtils.getLdapProvider((KeycloakSession)session, (ComponentModel)ctx.getLdapModel());
            String descriptionAttrName = LDAPTestUtils.getGroupDescriptionLDAPAttrName((LDAPStorageProvider)ctx.getLdapProvider());
            SynchronizationResult syncResult = new GroupLDAPStorageMapperFactory().create(session, mapperModel).syncDataFromFederationProviderToKeycloak(realm);
            LDAPTestAsserts.assertSyncEquals(syncResult, 4, 0, 0, 0);
            GroupModel kcGroup1 = KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group1");
            GroupModel kcGroup11 = KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group1/group11");
            GroupModel kcGroup12 = KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group1/group12");
            GroupModel kcGroup2 = KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"/group2");
            Assert.assertEquals((long)2L, (long)kcGroup1.getSubGroupsStream().count());
            Assert.assertEquals((Object)"group1 - description1", (Object)kcGroup1.getFirstAttribute(descriptionAttrName));
            Assert.assertNull((Object)kcGroup11.getFirstAttribute(descriptionAttrName));
            Assert.assertEquals((Object)"group12 - description12", (Object)kcGroup12.getFirstAttribute(descriptionAttrName));
            Assert.assertNull((Object)kcGroup2.getFirstAttribute(descriptionAttrName));
            LDAPGroupMapper2WaySyncTest.testDropNonExisting(session, ctx, mapperModel);
        });
    }

    private static void removeAllModelGroups(RealmModel appRealm) {
        appRealm.getTopLevelGroupsStream().forEach(arg_0 -> ((RealmModel)appRealm).removeGroup(arg_0));
    }

    private static void testDropNonExisting(KeycloakSession session, LDAPTestContext ctx, ComponentModel mapperModel) {
        RealmModel realm = ctx.getRealm();
        LDAPTestUtils.createLDAPGroup((KeycloakSession)session, (RealmModel)realm, (ComponentModel)ctx.getLdapModel(), (String)"group3", (String[])new String[0]);
        SynchronizationResult syncResult = new GroupLDAPStorageMapperFactory().create(session, mapperModel).syncDataFromKeycloakToFederationProvider(realm);
        LDAPTestAsserts.assertSyncEquals(syncResult, 0, 4, 0, 0);
        Assert.assertNotNull((Object)LDAPTestUtils.getGroupMapper((ComponentModel)mapperModel, (LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)realm).loadLDAPGroupByName("group3"));
        LDAPTestUtils.updateGroupMapperConfigOptions((ComponentModel)mapperModel, (String[])new String[]{"drop.non.existing.groups.during.sync", "true"});
        realm.updateComponent(mapperModel);
        syncResult = new GroupLDAPStorageMapperFactory().create(session, mapperModel).syncDataFromKeycloakToFederationProvider(realm);
        LDAPTestAsserts.assertSyncEquals(syncResult, 0, 4, 1, 0);
        Assert.assertNull((Object)LDAPTestUtils.getGroupMapper((ComponentModel)mapperModel, (LDAPStorageProvider)ctx.getLdapProvider(), (RealmModel)realm).loadLDAPGroupByName("group3"));
    }
}

